# Specimen Collection Procedure - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Collection Procedure**

## Logical Model: Specimen Collection Procedure 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SpecimenCollectionProcedure |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.415:2018-09-01 | |

 
This template represents clinical information about the specimen including when it was collected, the type and source of specimen, as well as related observations regarding the specimen. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[SpecimenConditionObservation](StructureDefinition-SpecimenConditionObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Result Organizer](StructureDefinition-ResultOrganizer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SpecimenCollectionProcedure)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SpecimenCollectionProcedure.csv), [Excel](StructureDefinition-SpecimenCollectionProcedure.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SpecimenCollectionProcedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "procedure"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.415:2018-09-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SpecimenCollectionProcedure",
  "title" : "Specimen Collection Procedure",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents clinical information about the specimen including when it was collected, the type and source of specimen, as well as related observations regarding the specimen.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [SpecimenConditionObservation](StructureDefinition-SpecimenConditionObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
          },
          {
            "key" : "should-targetSiteCode",
            "severity" : "warning",
            "human" : "SHOULD contain targetSiteCode",
            "expression" : "targetSiteCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.templateId",
        "path" : "Procedure.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Procedure.templateId:specimen-collection-proc",
        "path" : "Procedure.templateId",
        "sliceName" : "specimen-collection-proc",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.templateId:specimen-collection-proc.root",
        "path" : "Procedure.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.415"
      },
      {
        "id" : "Procedure.templateId:specimen-collection-proc.extension",
        "path" : "Procedure.templateId.extension",
        "min" : 1,
        "patternString" : "2018-09-01"
      },
      {
        "id" : "Procedure.moodCode",
        "path" : "Procedure.moodCode",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "short" : "Specimen collection (procedure)",
        "min" : 1
      },
      {
        "id" : "Procedure.code.code",
        "path" : "Procedure.code.code",
        "min" : 1,
        "patternCode" : "17636008"
      },
      {
        "id" : "Procedure.code.codeSystem",
        "path" : "Procedure.code.codeSystem",
        "short" : "SNOMED CT",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "Procedure.text",
        "path" : "Procedure.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Procedure.text.reference",
        "path" : "Procedure.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.effectiveTime",
        "path" : "Procedure.effectiveTime",
        "short" : "SHOULD have effectiveTime",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Procedure.targetSiteCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.targetSiteCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Specimen Source Site",
        "condition" : ["should-targetSiteCode"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "Procedure.specimen",
        "path" : "Procedure.specimen",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.specimen.specimenRole.id",
        "path" : "Procedure.specimen.specimenRole.id",
        "short" : "This id is used to match the specimen listed in the containing Results Organizer.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.entryRelationship",
        "path" : "Procedure.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.entryRelationship:condition",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "condition",
        "comment" : "SHOULD contain at least one [0..*] entryRelationship such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:condition.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Procedure.entryRelationship:condition.observation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.entryRelationship.observation",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Specimen Condition Acceptability",
        "comment" : "SHOULD contain exactly one [0..1] Specimen Condition Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.421:2018-09-01).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenConditionObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
