# Social History Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Social History Section**

## Logical Model: Social History Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SocialHistorySection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2015-08-01 | |

 
This section contains social history data that influence a patient's physical, psychological or emotional health (e.g., smoking status, pregnancy). Demographic data, such as marital status, race, ethnicity, and religious affiliation, is captured in the header. Mental/behavioral health assessments such as PHQ-9 (Patient Health Questionnaire-9) for depression screening are captured in the Mental Status section. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Recommended Entries**:[SmokingStatus](StructureDefinition-SmokingStatus.md) 
**Optional Entries**:[CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.md),[CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.md),[CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.md),[PregnancyIntentionInNextYear](StructureDefinition-PregnancyIntentionInNextYear.md),[PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md), [History and Physical](StructureDefinition-HistoryandPhysical.md)...Show 3 more,[Procedure Note](StructureDefinition-ProcedureNote.md),[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SocialHistorySection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SocialHistorySection.csv), [Excel](StructureDefinition-SocialHistorySection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SocialHistorySection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SocialHistorySection",
  "title" : "Social History Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section contains social history data that influence a patient's physical, psychological or emotional health (e.g., smoking status, pregnancy). Demographic data, such as marital status, race, ethnicity, and religious affiliation, is captured in the header. Mental/behavioral health assessments such as PHQ-9 (Patient Health Questionnaire-9) for depression screening are captured in the Mental Status section.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Recommended Entries**: [SmokingStatus](StructureDefinition-SmokingStatus.html)\n\n**Optional Entries**: [CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.html), [CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.html), [CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.html), [PregnancyIntentionInNextYear](StructureDefinition-PregnancyIntentionInNextYear.html), [PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.html), [SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-smoking-status",
            "severity" : "warning",
            "human" : "SHOULD contain Smoking Status",
            "expression" : "entry.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.17"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Social history Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "29762-2"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:socialHistory",
        "path" : "Section.entry",
        "sliceName" : "socialHistory",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-7953) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:socialHistory.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Social History Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.38:2015-08-01) (CONF:1198-14821).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:pregnancyPregnancy",
        "path" : "Section.entry",
        "sliceName" : "pregnancyPregnancy",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-9132) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:pregnancyPregnancy.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Pregnancy Status Observation (identifier: urn:oid:2.16.840.1.113883.10.20.15.3.8) (CONF:1198-14822).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:smokingStatus",
        "path" : "Section.entry",
        "sliceName" : "smokingStatus",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1198-14823) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-smoking-status"]
      },
      {
        "id" : "Section.entry:smokingStatus.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Smoking Status(identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.511:2024-05-01) (CONF:1198-14824).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:caregiver",
        "path" : "Section.entry",
        "sliceName" : "caregiver",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-28361) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:caregiver.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Caregiver Characteristics (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.72) (CONF:1198-28362).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:culturalReligious",
        "path" : "Section.entry",
        "sliceName" : "culturalReligious",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-28366) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:culturalReligious.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Cultural and Religious Observation (identifier: urn:oi\n                d:2.16.840.1.113883.10.20.22.4.111) (CONF:1198-28367).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CulturalandReligiousObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:homeCharacteristics",
        "path" : "Section.entry",
        "sliceName" : "homeCharacteristics",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-28825) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:homeCharacteristics.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Characteristics of Home Environment (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.109) (CONF:1198-28826).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CharacteristicsofHomeEnvironment"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:pregnancyIntention",
        "path" : "Section.entry",
        "sliceName" : "pregnancyIntention",
        "comment" : "MAY contain zero or more [0..*] entry such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:pregnancyIntention.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Pregnancy Intention In Next Year (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.281:2023-05-01).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyIntentionInNextYear"
            ]
          }
        ]
      }
    ]
  }
}

```
