# Sex Parameter For Clinical Use Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sex Parameter For Clinical Use Observation**

## Logical Model: Sex Parameter For Clinical Use Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SexParameterForClinicalUseObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SexParameterForClinicalUseObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.513:2025-05-01 | |

 
The Sex Parameter for Clinical Use (SPCU) observation is a clinical classification indicating which sex-related information is needed to evaluate how a patient's body may respond or has responded to treatments or diagnostic tests. Rather than relying solely on a patient's gender identity or assigned sex at birth, SPCU considers observable physiological characteristics (such as hormone levels, organ inventories, or genetic data) or medical interventions (such as hormone therapy). This template may be included in, referenced by, or contain a reference to, the relevant template. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[EntryReference](StructureDefinition-EntryReference.md) 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SexParameterForClinicalUseObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SexParameterForClinicalUseObservation.csv), [Excel](StructureDefinition-SexParameterForClinicalUseObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SexParameterForClinicalUseObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexParameterForClinicalUseObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.513:2025-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SexParameterForClinicalUseObservation",
  "title" : "Sex Parameter For Clinical Use Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Sex Parameter for Clinical Use (SPCU) observation is a clinical classification indicating which sex-related information is needed to evaluate how a patient's body may respond or has responded to treatments or diagnostic tests. Rather than relying solely on a patient's gender identity or assigned sex at birth, SPCU considers observable physiological characteristics (such as hormone levels, organ inventories, or genetic data) or medical interventions (such as hormone therapy). This template may be included in, referenced by, or contain a reference to, the relevant template.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [EntryReference](StructureDefinition-EntryReference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexParameterForClinicalUseObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:sex-parameter-clinical-use-obs",
        "path" : "Observation.templateId",
        "sliceName" : "sex-parameter-clinical-use-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:sex-parameter-clinical-use-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.513"
      },
      {
        "id" : "Observation.templateId:sex-parameter-clinical-use-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2025-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id.",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Sex parameter for clinical use"
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "min" : 1,
        "patternCode" : "99501-9"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexParameterForClinicalUseObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode.",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "Note: This template represents a \"snapshot in time\" observation. As a result, the effectiveTime is constrained to just a time stamp.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-only",
            "severity" : "error",
            "human" : "Interval fields SHALL NOT be present",
            "expression" : "(low | high | width | center).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexParameterForClinicalUseObservation"
          }
        ]
      },
      {
        "id" : "Observation.effectiveTime.value",
        "path" : "Observation.effectiveTime.value",
        "short" : "value should be used instead of low/high"
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ]
      },
      {
        "id" : "Observation.value.nullFlavor",
        "path" : "Observation.value.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Observation.value.code",
        "path" : "Observation.value.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/sex-parameter-for-clinical-use"
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "comment" : "SHALL contain exactly [1..1] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "short" : "This Entry Reference links the Sex Parameter for Clinical Use Observation to the template containing the relevant clinical data, such as Observations, Procedures, Substance Administrations, or Orders (Planned Procedures).",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32996) such that it"
      },
      {
        "id" : "Observation.entryRelationship.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" Has support.",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Observation.entryRelationship.act",
        "path" : "Observation.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32997).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      }
    ]
  }
}

```
