# Result Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Result Organizer**

## Logical Model: Result Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ResultOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.1:2023-05-01 | |

 
This template provides a mechanism for grouping result observations. It contains information applicable to all of the contained result observations. The Result Organizer code categorizes the contained results into one of several commonly accepted values (e.g., Hematology, Chemistry, Nuclear Medicine). 
If any Result Observation within the organizer has a statusCode of "active", the Result Organizer must also have a statusCode of "active". 
A specimen linked to a Result Organizer applies to all Result Observations. Centralizing specimen details within the Organizer is advised for clarity and consistency, as Result Observations typically relate to a single specimen collection, like using a purple top tube for CBCs. In cases of poor-quality specimens, a specimen reject reason is logically associated with the procedure, not the result, as there may be no result. The Result Organizer includes the specimen collection procedure, which may contain information about specimen condition acceptability. The Specimen Colection Procedure includes representation of the USCDI data element "Specimen Condition Acceptability". 
The Result Organizer template is a versatile template designed to represent any type of finding resulting from various types of tests. Value set bindings for Observation.code have been created to support implementers, covering three categories: 1) Common Laboratory Tests, 2) Radiology Tests, and 3) Clinical Tests. If a suitable code is not available within these value sets, first use another LOINC code. If no LOINC code is appropriate, a local code may be used. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Components**:[ResultObservation](StructureDefinition-ResultObservation.md) 
**Optional Components**:[SpecimenCollectionProcedure](StructureDefinition-SpecimenCollectionProcedure.md) 

**Usages:**

* Use this Logical Model Profile: [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Results Section](StructureDefinition-ResultsSection.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ResultOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ResultOrganizer.csv), [Excel](StructureDefinition-ResultOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ResultOrganizer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.1:2023-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ResultOrganizer",
  "title" : "Result Organizer",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template provides a mechanism for grouping result observations. It contains information applicable to all of the contained result observations. The Result Organizer code categorizes the contained results into one of several commonly accepted values (e.g., Hematology, Chemistry, Nuclear Medicine). \n\nIf any Result Observation within the organizer has a statusCode of \"active\", the Result Organizer must also have a statusCode of \"active\". \n\nA specimen linked to a Result Organizer applies to all Result Observations. Centralizing specimen details within the Organizer is advised for clarity and consistency, as Result Observations typically relate to a single specimen collection, like using a purple top tube for CBCs. In cases of poor-quality specimens, a specimen reject reason is logically associated with the procedure, not the result, as there may be no result. The Result Organizer includes the specimen collection procedure, which may contain information about specimen condition acceptability. The Specimen Colection Procedure includes representation of the USCDI data element \"Specimen Condition Acceptability\".\n\nThe Result Organizer template is a versatile template designed to represent any type of finding resulting from various types of tests. Value set bindings for Observation.code have been created to support implementers, covering three categories: 1) Common Laboratory Tests, 2) Radiology Tests, and 3) Clinical Tests. If a suitable code is not available within these value sets, first use another LOINC code. If no LOINC code is appropriate, a local code may be used.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Components**: [ResultObservation](StructureDefinition-ResultObservation.html)\n\n**Optional Components**: [SpecimenCollectionProcedure](StructureDefinition-SpecimenCollectionProcedure.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
          },
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:result-org",
        "path" : "Organizer.templateId",
        "sliceName" : "result-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:result-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.1"
      },
      {
        "id" : "Organizer.templateId:result-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2023-05-01"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4537-7121)."
      },
      {
        "id" : "Organizer.moodCode",
        "path" : "Organizer.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4537-7122)."
      },
      {
        "id" : "Organizer.id",
        "path" : "Organizer.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4537-7127).",
        "min" : 1
      },
      {
        "id" : "Organizer.sdtcCategory",
        "path" : "Organizer.sdtcCategory",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-service-sections"
        }
      },
      {
        "id" : "Organizer.code",
        "path" : "Organizer.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4537-7128).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "4537-19218",
            "severity" : "warning",
            "human" : "**SHOULD** be selected from LOINC (codeSystem 2.16.840.1.113883.6.1) **OR** SNOMED CT (codeSystem 2.16.840.1.113883.6.96), and **MAY** be selected from CPT (codeSystem 2.16.840.1.113883.6.12) (CONF:4537-19218).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.1' or codeSystem = '2.16.840.1.113883.6.96'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActCode",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.17",
              "documentation" : "IFor common lab tests.",
              "shortDoco" : "Common Lab Tests"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.18",
              "documentation" : "For radiology.",
              "shortDoco" : "Radiology"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.19",
              "documentation" : "For clinical tests.",
              "shortDoco" : "Clinical Test"
            }
          ]
        }
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode",
        "path" : "Organizer.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-7123)."
      },
      {
        "id" : "Organizer.statusCode.nullFlavor",
        "path" : "Organizer.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.39"
        }
      },
      {
        "id" : "Organizer.effectiveTime",
        "path" : "Organizer.effectiveTime",
        "short" : "The effectiveTime is an interval that spans the effectiveTimes of the contained result observations. Because all contained result observations have a required time stamp, it is not required that this effectiveTime be populated.",
        "comment" : "MAY contain zero or one [0..1] effectiveTime (CONF:4537-31865)."
      },
      {
        "id" : "Organizer.effectiveTime.low",
        "path" : "Organizer.effectiveTime.low",
        "comment" : "The effectiveTime, if present, SHALL contain exactly one [1..1] low (CONF:4537-32488).",
        "min" : 1
      },
      {
        "id" : "Organizer.effectiveTime.high",
        "path" : "Organizer.effectiveTime.high",
        "comment" : "The effectiveTime, if present, SHALL contain exactly one [1..1] high (CONF:4537-32489).",
        "min" : 1
      },
      {
        "id" : "Organizer.specimen",
        "path" : "Organizer.specimen",
        "short" : "When an organizer is for laboratory,  observations are expected to include the specimen participant. The specimen included at specimenPlayingEntity/code must be consistent with the observation/code.",
        "comment" : "MAY contain zero or more [0..*] specimen (CONF:4537-32615)."
      },
      {
        "id" : "Organizer.specimen.specimenRole",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organizer.specimen.specimenRole",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Specimen Identifier",
        "comment" : "The specimen, if present, SHALL contain exactly one [1..1] specimenRole (CONF:4537-32616)."
      },
      {
        "id" : "Organizer.specimen.specimenRole.id",
        "path" : "Organizer.specimen.specimenRole.id",
        "min" : 1
      },
      {
        "id" : "Organizer.specimen.specimenRole.specimenPlayingEntity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organizer.specimen.specimenRole.specimenPlayingEntity",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Specimen Type",
        "comment" : "This specimenRole SHALL contain exactly one [1..1] specimenPlayingEntity (CONF:4537-32617).",
        "min" : 1
      },
      {
        "id" : "Organizer.specimen.specimenRole.specimenPlayingEntity.code",
        "path" : "Organizer.specimen.specimenRole.specimenPlayingEntity.code",
        "comment" : "This specimenPlayingEntity SHALL contain exactly one [1..1] code, which SHOULD be selected from ValueSet Specimen type urn:oid:2.16.840.1.113762.1.4.1099.54 DYNAMIC (CONF:4537-32618).",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.54"
        }
      },
      {
        "id" : "Organizer.author",
        "path" : "Organizer.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4537-31149).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "procedure"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHALL contain at least one [1..*] component (CONF:4537-7124) such that it",
        "min" : 1
      },
      {
        "id" : "Organizer.component:resultObs",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organizer.component",
        "sliceName" : "resultObs",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Values/Results",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:resultObs.observation",
        "path" : "Organizer.component.observation",
        "comment" : "SHALL contain exactly one [1..1] Result Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.2:2015-08-01) (CONF:4537-14850).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:specimenProc",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organizer.component",
        "sliceName" : "specimenProc",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Specimen Condition Acceptability",
        "comment" : "SHALL contain at least one [1..*] component such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:specimenProc.procedure",
        "path" : "Organizer.component.procedure",
        "comment" : "SHALL contain exactly one [1..1] Specimen Collection Procedure.",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
            ]
          }
        ]
      }
    ]
  }
}

```
