# Result Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Result Observation**

## Logical Model: Result Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ResultObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.2:2023-05-01 | |

 
This template represents the results of a laboratory, radiology, or other study performed on a patient. 
The result observation includes a statusCode to allow recording the status of an observation. Pending results (e.g., a test has been run but results have not been reported yet) should be represented as active ActStatus. 
If code contains a valid non-null LOINC then the xsi:type value SHOULD match the LOINC Scale Part based on the table below: 

| | |
| :--- | :--- |
| Qn - Quantitative | INT, IVL_INT, MO, IVL_MO, REAL, IVL_REAL, PQ, IVL_PQ, RTO, TS, IVL_TS |
| Ord - Ordinal | CD |
| Nom - Nominal | CD |
| Nar - Narrative | ED, ST |
| OrdQn - Quantitative or Ordinal | CD, INT, IVL_INT, MO, IVL_MO, REAL, IVL_REAL, PQ, IVL_PQ, RTO, TS, IVL_TS |
| Multi - Multi | ED |
| Doc - Document | ED |

 
The Result Observation template is a versatile template designed to represent any type of finding resulting from various types of tests. Value set bindings for Observation.code have been created to support implementers, covering three categories: 1) Common Laboratory Tests, 2) Radiology Tests, and 3) Clinical Tests. If a suitable code is not available within these value sets, first use another LOINC code. If no LOINC code is appropriate, a local code may be used. 

**Usages:**

* Use this Logical Model Profile: [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Result Organizer](StructureDefinition-ResultOrganizer.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ResultObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ResultObservation.csv), [Excel](StructureDefinition-ResultObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ResultObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.2:2023-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ResultObservation",
  "title" : "Result Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the results of a laboratory, radiology, or other study performed on a patient.\n\nThe result observation includes a statusCode to allow recording the status of an observation. Pending results (e.g., a test has been run but results have not been reported yet) should be represented as active ActStatus.\n\nIf code contains a valid non-null LOINC then the xsi:type value SHOULD match the LOINC Scale Part based on the table below:\n\n| LOINC Scale Part     | Value xsi:type |\n| -------- | ------- |\n| Qn - Quantitative | INT, IVL_INT, MO, IVL_MO, REAL, IVL_REAL, PQ, IVL_PQ, RTO, TS, IVL_TS |\n| Ord - Ordinal | CD |\n| Nom - Nominal | CD |\n| Nar - Narrative | ED, ST |\n| OrdQn - Quantitative or Ordinal | CD, INT, IVL_INT, MO, IVL_MO, REAL, IVL_REAL, PQ, IVL_PQ, RTO, TS, IVL_TS |\n| Multi - Multi | ED |\n| Doc - Document | ED |\n\nThe Result Observation template is a versatile template designed to represent any type of finding resulting from various types of tests. Value set bindings for Observation.code have been created to support implementers, covering three categories: 1) Common Laboratory Tests, 2) Radiology Tests, and 3) Clinical Tests. If a suitable code is not available within these value sets, first use another LOINC code. If no LOINC code is appropriate, a local code may be used.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          },
          {
            "key" : "should-interpretationCode",
            "severity" : "warning",
            "human" : "SHOULD contain interpretationCode",
            "expression" : "interpretationCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          },
          {
            "key" : "should-referenceRange",
            "severity" : "warning",
            "human" : "SHOULD contain referenceRange",
            "expression" : "referenceRange.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:result-obs",
        "path" : "Observation.templateId",
        "sliceName" : "result-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:result-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.2"
      },
      {
        "id" : "Observation.templateId:result-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2023-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4537-7130).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4537-7131).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4537-7137).",
        "min" : 1
      },
      {
        "id" : "Observation.sdtcCategory",
        "path" : "Observation.sdtcCategory",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-result-observation-category"
        }
      },
      {
        "id" : "Observation.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Tests",
        "comment" : "SHALL contain exactly one [1..1] code, which SHOULD be selected from CodeSystem LOINC (urn:oid:2.16.840.1.113883.6.1) (CONF:4537-7133).",
        "constraint" : [
          {
            "key" : "shall-code-or-nullflavor",
            "severity" : "error",
            "human" : "SHALL contain either a @code attribute or a @nullFlavor attribute, but not both.",
            "expression" : "(code | nullFlavor).count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          },
          {
            "key" : "4537-19212",
            "severity" : "warning",
            "human" : "This code **SHOULD** be a code from the LOINC that identifies the result observation. If an appropriate LOINC code does not exist, then the local code for this result **SHALL** be sent (CONF:4537-19212).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.1'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ObservationType",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.17",
              "documentation" : "IFor common lab tests.",
              "shortDoco" : "Common Lab Tests"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.18",
              "documentation" : "For radiology.",
              "shortDoco" : "Radiology"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.19",
              "documentation" : "For clinical tests.",
              "shortDoco" : "Clinical Test"
            }
          ]
        }
      },
      {
        "id" : "Observation.code.nullFlavor",
        "path" : "Observation.code.nullFlavor",
        "comment" : "Either code or nullFlavor MUST be present"
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "Either code or nullFlavor MUST be present"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.statusCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Result Status",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-7134).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.nullFlavor",
        "path" : "Observation.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.39"
        }
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "Represents the clinically relevant time of the measurement (e.g., the time a blood pressure reading is obtained, the time the blood sample was obtained for a chemistry test).",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4537-7140).",
        "min" : 1
      },
      {
        "id" : "Observation.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "𝗨𝗦𝗖𝗗𝗜: Values/Results - Value can be any type, but certain types have additional rules.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.value:physical-quantity",
        "path" : "Observation.value",
        "sliceName" : "physical-quantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PQ"
          }
        ]
      },
      {
        "id" : "Observation.value:physical-quantity.unit",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value.unit",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Result Unit of Measure - if null flavor is sent, the unit SHALL be set to '1'",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "Observation.value:physical-quantity.translation",
        "path" : "Observation.value.translation",
        "short" : "Can be used to represent the original results as output by the lab",
        "max" : "1"
      },
      {
        "id" : "Observation.value:coded",
        "path" : "Observation.value",
        "sliceName" : "coded",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "constraint" : [
          {
            "key" : "4537-32610",
            "severity" : "warning",
            "human" : "If Observation/value is a CD (**xsi:type=\"CD\"**) the value **SHOULD** be SNOMED-CT or LOINC (CONF:4537-32610).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.96' or codeSystem = '2.16.840.1.113883.6.1'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          }
        ]
      },
      {
        "id" : "Observation.value:coded.translation",
        "path" : "Observation.value.translation",
        "short" : "Can be used to represent the original results as output by the lab",
        "max" : "1"
      },
      {
        "id" : "Observation.interpretationCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.interpretationCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Result Interpretation",
        "comment" : "SHOULD contain zero or more [0..*] interpretationCode, which SHALL be selected from ValueSet Observation Interpretation (HL7) urn:oid:2.16.840.1.113883.1.11.78 DYNAMIC (CONF:4537-7147).",
        "condition" : ["should-interpretationCode"],
        "binding" : {
          "strength" : "required",
          "description" : "Bound in CDA core to CDAObservationInterpretation value set (subset of HL7 v3 ObservationInterpretation), a USCDI Result Interpretation vocabulary",
          "valueSet" : "http://hl7.org/cda/stds/core/ValueSet/CDAObservationInterpretation"
        }
      },
      {
        "id" : "Observation.methodCode",
        "path" : "Observation.methodCode",
        "comment" : "MAY contain zero or one [0..1] methodCode (CONF:4537-7148).",
        "max" : "1"
      },
      {
        "id" : "Observation.targetSiteCode",
        "path" : "Observation.targetSiteCode",
        "comment" : "MAY contain zero or one [0..1] targetSiteCode (CONF:4537-7153).",
        "max" : "1"
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4537-7149).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Observation.referenceRange",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.referenceRange",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Result Reference Range",
        "comment" : "SHOULD contain zero or more [0..*] referenceRange (CONF:4537-7150).",
        "condition" : ["should-referenceRange"]
      },
      {
        "id" : "Observation.referenceRange.observationRange",
        "path" : "Observation.referenceRange.observationRange",
        "comment" : "The referenceRange, if present, SHALL contain exactly one [1..1] observationRange (CONF:4537-7151)."
      },
      {
        "id" : "Observation.referenceRange.observationRange.value",
        "path" : "Observation.referenceRange.observationRange.value",
        "short" : "When the value is a quantity, then the unit SHOULD be selected from ValueSet UnitsOfMeasureCaseSensitive.",
        "comment" : "This observationRange SHALL contain exactly one [1..1] value (CONF:4537-32175).",
        "min" : 1
      }
    ]
  }
}

```
