# Referral Note - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Referral Note**

## Logical Model: Referral Note 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:ReferralNote |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.14:2024-05-01 | |

 
A Referral Note communicates pertinent information from a provider who is requesting services of another provider of clinical or non-clinical services. The information in this document includes the reason for the referral and additional information that would augment decision making and care delivery. 
Examples of referral situations are when a patient is referred from a family physician to a cardiologist for cardiac evaluation or when patient is sent by a cardiologist to an emergency department for angina or when a patient is referred by a nurse practitioner to an audiologist for hearing screening or when a patient is referred by a hospitalist to social services. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.md) or both [AssessmentSection](StructureDefinition-AssessmentSection.md) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [ProblemSection](StructureDefinition-ProblemSection.md)
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [MedicationsSection](StructureDefinition-MedicationsSection.md)
* [ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.md)
 
**Recommended Sections** 
* [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [ResultsSection](StructureDefinition-ResultsSection.md)
* [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.md)
* [MentalStatusSection](StructureDefinition-MentalStatusSection.md)
* [NutritionSection](StructureDefinition-NutritionSection.md)
 
**Additional Sections** 
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
* [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [ImmunizationsSection](StructureDefinition-ImmunizationsSection.md)
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [VitalSignsSection](StructureDefinition-VitalSignsSection.md)
* [PhysicalExamSection](StructureDefinition-PhysicalExamSection.md)
* [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.md)
* [PastMedicalHistory](StructureDefinition-PastMedicalHistory.md)
* [GeneralStatusSection](StructureDefinition-GeneralStatusSection.md)
* [PayersSection](StructureDefinition-PayersSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ReferralNote)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ReferralNote.csv), [Excel](StructureDefinition-ReferralNote.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ReferralNote",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.14:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ReferralNote",
  "title" : "Referral Note",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A Referral Note communicates pertinent information from a provider who is requesting services of another provider of clinical or non-clinical services. The information in this document includes the reason for the referral and additional information that would augment decision making and care delivery. \n\nExamples of referral situations are when a patient is referred from a family physician to a cardiologist for cardiac evaluation or when patient is sent by a cardiologist to an emergency department for angina or when a patient is referred by a nurse practitioner to an audiologist for hearing screening or when a patient is referred by a hospitalist to social services.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.html) or both [AssessmentSection](StructureDefinition-AssessmentSection.html) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [ProblemSection](StructureDefinition-ProblemSection.html)\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [MedicationsSection](StructureDefinition-MedicationsSection.html)\n- [ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.html)\n\n**Recommended Sections**\n- [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [ResultsSection](StructureDefinition-ResultsSection.html)\n- [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.html)\n- [MentalStatusSection](StructureDefinition-MentalStatusSection.html)\n- [NutritionSection](StructureDefinition-NutritionSection.html)\n\n**Additional Sections**\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)\n- [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [ImmunizationsSection](StructureDefinition-ImmunizationsSection.html)\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [VitalSignsSection](StructureDefinition-VitalSignsSection.html)\n- [PhysicalExamSection](StructureDefinition-PhysicalExamSection.html)\n- [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.html)\n- [PastMedicalHistory](StructureDefinition-PastMedicalHistory.html)\n- [GeneralStatusSection](StructureDefinition-GeneralStatusSection.html)\n- [PayersSection](StructureDefinition-PayersSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "category-57133-1",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '57133-1'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '57133-1' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-participant-indirect",
            "severity" : "warning",
            "human" : "SHOULD contain zero or more [0..*] participant such that it SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC)",
            "expression" : "participant.where(typeCode = 'IND').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-participant-callback",
            "severity" : "warning",
            "human" : "SHOULD contain zero or more [0..*] participant such that it SHALL contain exactly one [1..1] @typeCode=\"CALLBCK\" call back contact (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC)",
            "expression" : "participant.where(typeCode = 'CALLBCK').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:referral-note",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "referral-note",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:referral-note.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.14"
      },
      {
        "id" : "ClinicalDocument.templateId:referral-note.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a Referral Note. If present, there SHALL be a category of 57133-1 (Referral note).",
        "condition" : ["should-sdtcCategory", "category-57133-1"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Referral note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "57133-1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The Referral Note recommends use of the document type code 57133-1 \"Referral note\", with further specification provided by author or performer, setting, or specialty. When pre-coordinated codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type. For example, an Obstetrics and Gynecology Referral note would not be authored by a Pediatric Cardiologist.  The type of referral and the target of the referral are specified via the participant (and not via the author).",
        "comment" : "SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet ReferralDocumentType http://hl7.org/fhir/ccda/ValueSet/2.16.840.1.113883.1.11.20.2.3 DYNAMIC (CONF:1198-28949).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.20.2.3"
        }
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "comment" : "SHALL contain exactly one [1..1] informationRecipient (CONF:1198-31589).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "comment" : "This informationRecipient SHALL contain exactly one [1..1] intendedRecipient (CONF:1198-31590).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.addr",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.addr",
        "comment" : "This intendedRecipient SHOULD contain zero or more [0..*] addr (CONF:1198-31591).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.telecom",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.telecom",
        "comment" : "This intendedRecipient SHOULD contain zero or more [0..*] telecom (CONF:1198-31592)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "comment" : "This intendedRecipient SHALL contain exactly one [1..1] informationRecipient (CONF:1198-31593).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "comment" : "This informationRecipient SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:1198-31594)."
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalDocument.participant:indirect",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "indirect",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31642) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:indirect.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-31924).",
        "fixedCode" : "IND"
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31643)."
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode, which SHALL be selected from ValueSet INDRoleclassCodes urn:oid:2.16.840.1.113883.11.20.9.33 DYNAMIC (CONF:1198-31925).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.33"
        }
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:1198-31644).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.associatedPerson.name",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson.name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] US Realm Person Name .",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "callback",
        "short" : "This participant represents the clinician to contact for questions about the referral note.  This call back contact individual may be a different person than the individual(s) identified in the author or legalAuthenticator participant.",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31647) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:callback.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CALLBCK\" call back contact (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC) (CONF:1198-31648).",
        "fixedCode" : "CALLBCK"
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31649).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode=\"ASSIGNED\" assigned entity (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110) (CONF:1198-32419).",
        "fixedCode" : "ASSIGNED"
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.id",
        "path" : "ClinicalDocument.participant.associatedEntity.id",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] id (CONF:1198-31650).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.addr",
        "path" : "ClinicalDocument.participant.associatedEntity.addr",
        "comment" : "This associatedEntity SHOULD contain zero or more [0..*] addr (CONF:1198-31651).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.telecom",
        "path" : "ClinicalDocument.participant.associatedEntity.telecom",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] telecom (CONF:1198-31652).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:1198-31653).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.associatedPerson.name",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson.name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] name (CONF:1198-31654).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.scopingOrganization",
        "path" : "ClinicalDocument.participant.associatedEntity.scopingOrganization",
        "comment" : "This associatedEntity MAY contain zero or one [0..1] scopingOrganization (CONF:1198-31655)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-29063).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ap-or-a-and-p",
            "severity" : "error",
            "human" : "**SHALL** include an Assessment and Plan Section, or both an Assessment Section and a Plan of Treatment Section.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() or (component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).count() = 2)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "ap-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain an Assessment and Plan Section (2.16.840.1.113883.10.20.22.2.9:2014-06-09) when either an Assessment Section (2.16.840.1.113883.10.20.22.2.8) or a Plan of Treatment Section (2.16.840.1.113883.10.20.22.2.10:2014-06-09) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-section-plan-of-treatment",
            "severity" : "warning",
            "human" : "SHOULD contain a Plan of Treatment Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-section-results",
            "severity" : "warning",
            "human" : "SHOULD contain a Results Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-section-functional-status",
            "severity" : "warning",
            "human" : "SHOULD contain a Functional Status Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-section-mental-status",
            "severity" : "warning",
            "human" : "SHOULD contain a Mental Status Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "key" : "should-section-nutrition",
            "severity" : "warning",
            "human" : "SHOULD contain a Nutrition Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 4
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-29066) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo", "should-section-plan-of-treatment"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "The component, if present, SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-29067).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advanceDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advanceDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29068) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advanceDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01) (CONF:1198-29069).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hpi",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "hpi",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29074) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hpi.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] History of Present Illness Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.4) (CONF:1198-29075).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "familyHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29076) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-29077).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "immunizations",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29082) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Immunizations Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2024-05-01) (CONF:1198-29083).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problem",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "problem",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-29086) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problem.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Problem Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.5.1:2024-05-01) (CONF:1198-29087).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29088) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-29089).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "results",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-29090) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-results"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Results Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.3.1:2024-05-01) (CONF:1198-29091).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reviewOfSystems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29092) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Review of Systems Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.18) (CONF:1198-29093).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29094) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-29095).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "vitalSigns",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29096) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Vital Signs Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.4.1:2024-05-01) (CONF:1198-29097).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "functionalStatus",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-29098) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-functional-status"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.14:2014-06-09) (CONF:1198-29099).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "physicalExam",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-29100) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Physical Exam Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.2.10:2024-05-01) (CONF:1198-29101).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "nutrition",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30780) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-nutrition"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.57) (CONF:1198-30781).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "mentalStatus",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30796) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-mental-status"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.56:2024-05-01) (CONF:1198-30926).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalEquip",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medicalEquip",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30798) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalEquip.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medical Equipment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.23:2014-06-09) (CONF:1198-30799).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30911) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-30912).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30913) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.8) (CONF:1198-30914).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessmentAndPlan",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30915) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment and Plan Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.9:2014-06-09) (CONF:1198-30916).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medicalHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30917) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Past Medical History (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.20:2024-05-01) (CONF:1198-30918).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "generalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30919) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] General Status Section (identifier: urn:oid:2.16.840.1.113883.10.20.2.5) (CONF:1198-30920).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GeneralStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30922) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.1.1:2014-06-09) (CONF:1198-30923).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForReferral",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reasonForReferral",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30924) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForReferral.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Reason for Referral Section (identifier: urn:hl7ii:1.3.6.1.4.1.19376.1.5.3.1.3.1:2014-06-09) (CONF:1198-30925).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforReferralSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "payers",
        "comment" : "This structuredBody SHOULD contain exactly one [0..1] component (CONF:1198-309240) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHOULD contain exactly one [0..1] Payers Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.18:2024-05-01) (CONF:1198-309250).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PayersSection"
            ]
          }
        ]
      }
    ]
  }
}

```
