# Referral Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Referral Act**

## Logical Model: Referral Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ReferralAct |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.140 | |

 
This template represents the type of referral (e.g., for dental care, to a specialist, for aging problems) and represents whether the referral is for full care or shared care. It may contain a reference to another act in the document instance representing the clinical reason for the referral (e.g., problem, concern, procedure). 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[Indication](StructureDefinition-Indication.md) 

**Usages:**

* Use this Logical Model Profile: [Reason for Referral Section](StructureDefinition-ReasonforReferralSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ReferralAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ReferralAct.csv), [Excel](StructureDefinition-ReferralAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ReferralAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.140"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ReferralAct",
  "title" : "Referral Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the type of referral (e.g., for dental care, to a specialist, for aging problems) and represents whether the referral is for full care or shared care. It may contain a reference to another act in the document instance representing the clinical reason for the referral (e.g., problem, concern, procedure).\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [Indication](StructureDefinition-Indication.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"
          },
          {
            "key" : "should-priorityCode",
            "severity" : "warning",
            "human" : "SHOULD contain priorityCode",
            "expression" : "priorityCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:referral-act",
        "path" : "Act.templateId",
        "sliceName" : "referral-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:referral-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.140"
      },
      {
        "id" : "Act.templateId:referral-act.extension",
        "path" : "Act.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"PCPR\" provision of care (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-30884).",
        "fixedCode" : "PCPR"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Referral Act moodCode urn:oid:2.16.840.1.113883.11.20.9.66 STATIC 2014-09-01 (CONF:1098-30885).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.66"
        }
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "short" : "In the case of a Consultation Note where this referral is being fulfilled by this consultation, this id would be referenced in the inFullfilmentOf/order/id of the Consultation Note.",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-30888).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet Referral Types urn:oid:2.16.840.1.113883.11.20.9.56 DYNAMIC (CONF:1098-30889).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.56"
        }
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-30892).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.nullFlavor",
        "path" : "Act.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActStatus"
        }
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "short" : "The effectiveTime represents the time when the future referral is intended to take place.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-30893).",
        "min" : 1
      },
      {
        "id" : "Act.priorityCode",
        "path" : "Act.priorityCode",
        "short" : "SHOULD contain priorityCode",
        "comment" : "SHOULD contain zero or one [0..1] priorityCode (CONF:1098-32623).",
        "condition" : ["should-priorityCode"]
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31612).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Act.participant",
        "path" : "Act.participant",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1098-32635)."
      },
      {
        "id" : "Act.participant.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "The participant, if present, SHALL contain exactly one [1..1] @typeCode. Use REFT to represent the referred-to provider."
      },
      {
        "id" : "Act.participant.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "The participant, if present, SHALL contain exactly one [1..1] participantRole (CONF:1098-32636)."
      },
      {
        "id" : "Act.participant.participantRole.code",
        "path" : "Act.participant.participantRole.code",
        "comment" : "This participantRole MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1098-32637).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "The following entryRelationship represents a reference to another act in the document instance representing the clinical reason for the referral (e.g., problem, concern, procedure)."
      },
      {
        "id" : "Act.entryRelationship:careModel",
        "path" : "Act.entryRelationship",
        "sliceName" : "careModel",
        "short" : "The following entryRelationship represents whether the referral is for full or shared care.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-31604) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:careModel.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" has subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31613).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Act.entryRelationship:careModel.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] observation (CONF:1098-31605).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-priorityCode",
            "severity" : "warning",
            "human" : "SHOULD contain priorityCode",
            "expression" : "priorityCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.classCode",
        "path" : "Act.entryRelationship.observation.classCode",
        "comment" : "This observation SHALL contain exactly one [1..1] @classCode=\"OBS\" observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-31606).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.moodCode",
        "path" : "Act.entryRelationship.observation.moodCode",
        "comment" : "This observation SHALL contain exactly one [1..1] @moodCode=\"RQO\" request (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31607).",
        "fixedCode" : "RQO"
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.code",
        "path" : "Act.entryRelationship.observation.code",
        "comment" : "This observation SHALL contain exactly one [1..1] code (CONF:1098-31608)."
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.code.code",
        "path" : "Act.entryRelationship.observation.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"ASSERTION\" assertion (CONF:1098-31619).",
        "min" : 1,
        "patternCode" : "ASSERTION"
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.code.codeSystem",
        "path" : "Act.entryRelationship.observation.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.4 \" (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1098-31620).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.4"
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.statusCode",
        "path" : "Act.entryRelationship.observation.statusCode",
        "comment" : "This observation SHALL contain exactly one [1..1] statusCode (CONF:1098-31614).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.statusCode.code",
        "path" : "Act.entryRelationship.observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31615).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.priorityCode",
        "path" : "Act.entryRelationship.observation.priorityCode",
        "short" : "SHOULD contain priorityCode",
        "comment" : "This observation SHOULD contain zero or one [0..1] priorityCode, which SHOULD be selected from ValueSet ActPriority urn:oid:2.16.840.1.113883.1.11.16866 DYNAMIC (CONF:1098-32443).",
        "condition" : ["should-priorityCode"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActPriority"
        }
      },
      {
        "id" : "Act.entryRelationship:careModel.observation.value",
        "path" : "Act.entryRelationship.observation.value",
        "comment" : "This observation SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", where the code SHOULD be selected from ValueSet Care Model urn:oid:2.16.840.1.113883.11.20.9.61 DYNAMIC (CONF:1098-31611).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.61"
        }
      },
      {
        "id" : "Act.entryRelationship:indication",
        "path" : "Act.entryRelationship",
        "sliceName" : "indication",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-31635) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:indication.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" has reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31636).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Act.entryRelationship:indication.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1098-32634).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      }
    ]
  }
}

```
