# Provenance - Author Participation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provenance - Author Participation**

## Logical Model: Provenance - Author Participation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProvenanceAuthorParticipation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.5.6:2019-10-01 | |

 
This template represents the key information to record Provenance in an Author Participation. 
This Participation is appropriate at any place CDA allows an author. For example, at the CDA Header, CDA Section, CDA Entry, or within a CDA entry (e.g. Organizer and contained Observation(s)). 
This template is consistent with the C-CDA Author Participation, however, it doesnt use a formal conforms to relationship. All constraints for conformance are defined in this template which specializes the Author Participation (2.16.840.1.113883.10.20.22.4.119). 
This template is used to identify primary authorship for an entry. An entry may have many authors, but recipients need a single authoritative point of contact for resolving issues. This is typically the last provider to make substantive changes to the entry If two providers are simultaneously involved in that activity, the implementer must choose one, ideally in a repeatable way. 
The`assignedAuthor/id`may be set equal to (a pointer to) an id on a participant elsewhere in the document (header or entries) or a new author participant can be described here. 
Note: The Provenance template title includes a version 2 to support moving from the 'Basic Provenance' guide to the this Companion Guide, so the templateId has not changed. 

**Usages:**

* Use this Logical Model Profile: [Advance Directive Existence Observation](StructureDefinition-AdvanceDirectiveExistenceObservation.md) and [Sex Parameter For Clinical Use Observation](StructureDefinition-SexParameterForClinicalUseObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProvenanceAuthorParticipation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProvenanceAuthorParticipation.csv), [Excel](StructureDefinition-ProvenanceAuthorParticipation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProvenanceAuthorParticipation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "author"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.5.6:2019-10-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProvenanceAuthorParticipation",
  "title" : "Provenance - Author Participation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the key information to record Provenance in an Author Participation.\n\nThis Participation is appropriate at any place CDA allows an author. For example, at the CDA Header, CDA Section, CDA Entry, or within a CDA entry (e.g. Organizer and contained Observation(s)).\n\nThis template is consistent with the C-CDA Author Participation, however, it doesnt use a formal conforms to relationship. All constraints for conformance are defined in this template which specializes the Author Participation (2.16.840.1.113883.10.20.22.4.119).\n\nThis template is used to identify primary authorship for an entry. An entry may have many authors, but recipients need a single authoritative point of contact for resolving issues. This is typically the last provider to make substantive changes to the entry If two providers are simultaneously involved in that activity, the implementer must choose one, ideally in a repeatable way.\n\nThe `assignedAuthor/id` may be set equal to (a pointer to) an id on a participant elsewhere in the document (header or entries) or a new author participant can be described here.\n\nNote: The Provenance template title includes a version 2 to support moving from the 'Basic Provenance' guide to the this Companion Guide, so the templateId has not changed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Author.templateId",
        "path" : "Author.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Author.templateId:provenance-author",
        "path" : "Author.templateId",
        "sliceName" : "provenance-author",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Author.templateId:provenance-author.root",
        "path" : "Author.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.5.6"
      },
      {
        "id" : "Author.templateId:provenance-author.extension",
        "path" : "Author.templateId.extension",
        "min" : 1,
        "patternString" : "2019-10-01"
      },
      {
        "id" : "Author.time",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Author.time",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Author Time Stamp",
        "comment" : "SHALL contain exactly one [1..1] time (CONF:4515-32983)."
      },
      {
        "id" : "Author.assignedAuthor",
        "path" : "Author.assignedAuthor",
        "comment" : "SHALL contain exactly one [1..1] assignedAuthor (CONF:4515-32975).",
        "constraint" : [
          {
            "key" : "author-details",
            "severity" : "error",
            "human" : "Authors require addr, telecom, and either assignedPerson/name or assignedAuthoringDevice/manufacturerModelName. These may be present on this author or on another instance of an Author Participation in the document that has an id that matches the first id of this author.",
            "expression" : "nullFlavor.exists() or (addr.exists() and telecom.exists() and (assignedPerson.name.exists() or assignedAuthoringDevice.manufacturerModelName.exists())) or (%resource.descendants().ofType(CDA.AssignedAuthor).where(id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension) and addr.exists() and telecom.exists() and (assignedPerson.name.exists() or assignedAuthoringDevice.manufacturerModelName.exists())))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
          },
          {
            "key" : "4515-64",
            "severity" : "error",
            "human" : "If the assignedAuthor/id is not referencing a Provenance Author described elsewhere in the document with a representedOrganization populated, this assignedAuthor SHALL contain exactly one [1..1] representedOrganization (CONF:4515-64).",
            "expression" : "representedOrganization.exists() or (%resource.descendants().ofType(CDA.Author).where(templateId.exists($this.root = '2.16.840.1.113883.10.20.22.5.6' and $this.extension = '2019-10-01') and assignedAuthor.representedOrganization.exists() and assignedAuthor.id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension)))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
          },
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
          }
        ]
      },
      {
        "id" : "Author.assignedAuthor.id",
        "path" : "Author.assignedAuthor.id",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "comment" : "This assignedAuthor SHALL contain exactly one [1..1] id (CONF:4515-20) such that. it This assignedAuthor SHALL contain at least one [1..*] id (CONF:4515-2)."
      },
      {
        "id" : "Author.assignedAuthor.id:npi",
        "path" : "Author.assignedAuthor.id",
        "sliceName" : "npi",
        "comment" : "This assignedAuthor SHALL contain exactly one [1..1] id (CONF:4515-20) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Author.assignedAuthor.id:npi.nullFlavor",
        "path" : "Author.assignedAuthor.id.nullFlavor",
        "short" : "If NPI is unknown, set @nullFlavor to UNK"
      },
      {
        "id" : "Author.assignedAuthor.id:npi.root",
        "path" : "Author.assignedAuthor.id.root",
        "comment" : "SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4515-22).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.6"
      },
      {
        "id" : "Author.assignedAuthor.id:npi.extension",
        "path" : "Author.assignedAuthor.id.extension",
        "comment" : "SHOULD contain zero or one [0..1] @extension (CONF:4515-23)."
      },
      {
        "id" : "Author.assignedAuthor.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Author.assignedAuthor.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Author Role - When the author is a person who is not acting in the role of a clinician, this code encodes the personal or legal relationship between author and the patient.",
        "comment" : "This assignedAuthor SHOULD contain zero or one [0..1] code (CONF:4515-32979).",
        "binding" : {
          "strength" : "example",
          "description" : "See additional bindings",
          "valueSet" : "http://hl7.org/cda/stds/core/ValueSet/CDARoleCode",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066",
              "documentation" : "If the content is provider authored, the code SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4515-56).",
              "shortDoco" : "Providers"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1",
              "documentation" : "If the author is a person who is not acting in the role of a clinician, the code SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:4515-57).",
              "shortDoco" : "Non-clinicians"
            }
          ]
        }
      },
      {
        "id" : "Author.assignedAuthor.sdtcSpecialty",
        "path" : "Author.assignedAuthor.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Author.assignedAuthor.addr",
        "path" : "Author.assignedAuthor.addr",
        "short" : "Required on at least one instance of this author in the document",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Author.assignedAuthor.telecom",
        "path" : "Author.assignedAuthor.telecom",
        "short" : "Required on at least one instance of this author in the document"
      },
      {
        "id" : "Author.assignedAuthor.assignedPerson",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Author.assignedAuthor.assignedPerson",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Author - assignedPerson/name or assignedAuthoringDevice/manufacturerModelName is required on at least one instance of this author in the document"
      },
      {
        "id" : "Author.assignedAuthor.assignedPerson.name",
        "path" : "Author.assignedAuthor.assignedPerson.name",
        "comment" : "The assignedPerson, if present, SHALL contain at least one [1..*] name (CONF:4515-32977).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "shall-family",
            "severity" : "error",
            "human" : "SHALL contain exactly one [1..1] family (CONF:81-7159).",
            "expression" : "nullFlavor.exists() or item.family.count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
          },
          {
            "key" : "should-given",
            "severity" : "warning",
            "human" : "SHOULD contain given",
            "expression" : "item.given.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
          }
        ]
      },
      {
        "id" : "Author.assignedAuthor.assignedPerson.name.item.family",
        "path" : "Author.assignedAuthor.assignedPerson.name.item.family",
        "short" : "Family required",
        "comment" : "Such names SHALL contain exactly one [1..1] family (CONF:4515-17)."
      },
      {
        "id" : "Author.assignedAuthor.assignedPerson.name.item.given",
        "path" : "Author.assignedAuthor.assignedPerson.name.item.given",
        "short" : "SHOULD contain given",
        "comment" : "Such names SHOULD contain zero or more [0..*] given (CONF:4515-18)."
      },
      {
        "id" : "Author.assignedAuthor.assignedAuthoringDevice",
        "path" : "Author.assignedAuthor.assignedAuthoringDevice",
        "comment" : "This assignedAuthor MAY contain zero or one [0..1] assignedAuthoringDevice (CONF:4515-32)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Author.assignedAuthor.representedOrganization",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Author Organization",
        "comment" : "If the assignedAuthor/id is not referencing a Provenance Author described elsewhere in the document with a representedOrganization populated, this assignedAuthor SHALL contain exactly one [1..1] representedOrganization (See - CONF:4440-64).  This assignedAuthor MAY contain zero or one [0..1] representedOrganization (CONF:4515-32978).",
        "constraint" : [
          {
            "key" : "provenance-org-details",
            "severity" : "error",
            "human" : "If the author is not a clinician, set nullFlavor='NA'. Otherwise, the taxId, npi, and name are required.",
            "expression" : "nullFlavor = 'NA' or (id.where(root='2.16.840.1.113883.4.2').exists() and id.where(root='2.16.840.1.113883.4.6').exists() and name.exists())",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
          }
        ]
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.nullFlavor",
        "path" : "Author.assignedAuthor.representedOrganization.nullFlavor",
        "short" : "A nullFlavor of \"NA\" is allowed If the assignedAuthor is not a clinician",
        "comment" : "The representedOrganization, if present, MAY contain zero or one [0..1] @nullFlavor (CONF:4515-35)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id",
        "path" : "Author.assignedAuthor.representedOrganization.id",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "comment" : "The representedOrganization, if present, SHALL contain exactly one [1..1] id (CONF:4515-28) such that it. The representedOrganization, if present, SHALL contain at least one [1..*] id (CONF:4515-32981)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:taxId",
        "path" : "Author.assignedAuthor.representedOrganization.id",
        "sliceName" : "taxId",
        "comment" : "The representedOrganization, if present, SHALL contain exactly one [1..1] id (CONF:4515-24) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:taxId.nullFlavor",
        "path" : "Author.assignedAuthor.representedOrganization.id.nullFlavor",
        "short" : "If Tax ID Number is unknown, set @nullFlavor to UNK"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:taxId.root",
        "path" : "Author.assignedAuthor.representedOrganization.id.root",
        "comment" : "SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.4.2\" Tax ID Number (CONF:4515-26).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.2"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:taxId.extension",
        "path" : "Author.assignedAuthor.representedOrganization.id.extension",
        "comment" : "SHOULD contain zero or one [0..1] @extension (CONF:4515-32982)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:npi",
        "path" : "Author.assignedAuthor.representedOrganization.id",
        "sliceName" : "npi",
        "comment" : "The representedOrganization, if present, SHALL contain exactly one [1..1] id (CONF:4515-28) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:npi.nullFlavor",
        "path" : "Author.assignedAuthor.representedOrganization.id.nullFlavor",
        "short" : "If NPI is unknown, set @nullFlavor to UNK"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:npi.root",
        "path" : "Author.assignedAuthor.representedOrganization.id.root",
        "comment" : "SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier  (CONF:4515-30).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.6"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id:npi.extension",
        "path" : "Author.assignedAuthor.representedOrganization.id.extension",
        "comment" : "SHOULD contain zero or one [0..1] @extension (CONF:4515-31)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.name",
        "path" : "Author.assignedAuthor.representedOrganization.name",
        "comment" : "The representedOrganization, if present, SHALL contain exactly one [1..1] name (CONF:4515-11).",
        "max" : "1"
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.telecom",
        "path" : "Author.assignedAuthor.representedOrganization.telecom",
        "comment" : "The representedOrganization, if present, SHOULD contain zero or more [0..*] telecom (CONF:4515-12)."
      }
    ]
  }
}

```
