# Provenance - Assembler Participation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provenance - Assembler Participation**

## Logical Model: Provenance - Assembler Participation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAssemblerParticipation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProvenanceAssemblerParticipation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.5.7:2020-05-19 | |

 
This template represents the organization that supported generation of a CDA document. The Assembler Organization may be different than the Author Organization, and may be different from the Organization that developed the software used to generate the document. 
This Participation is only for use in the CDA Header because it applies to the entire content in the document. 
This template is consistent with the prior Assembler Document Participant (2.16.840.1.113883.3.5019.1.1) in the 2016 HL7 Data Provenance guide, however, makes no claim about representing the software organization. All constraints for conformance are defined in this template. 
Note: The CDA Participant does not support a software device or the organization that created the software. The Assembler role can only be expressed at the level of organization. This is a known issue with the current CDA R2 model. Note: The Provenance template title includes a version 2 to support moving from the 'Basic Provenance' guide to the this Companion Guide, so the templateId has not changed. 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProvenanceAssemblerParticipation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProvenanceAssemblerParticipation.csv), [Excel](StructureDefinition-ProvenanceAssemblerParticipation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProvenanceAssemblerParticipation",
  "meta" : {
    "versionId" : "4",
    "lastUpdated" : "2023-07-11T23:42:05.979Z"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "participant"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAssemblerParticipation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.5.7:2020-05-19"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProvenanceAssemblerParticipation",
  "title" : "Provenance - Assembler Participation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the organization that supported generation of a CDA document. The Assembler Organization may be different than the Author Organization, and may be different from the Organization that developed the software used to generate the document. \n\nThis Participation is only for use in the CDA Header because it applies to the entire content in the document.\n\nThis template is consistent with the prior Assembler Document Participant  (2.16.840.1.113883.3.5019.1.1) in the 2016 HL7 Data Provenance guide, however, makes no claim about representing the software organization. All constraints for conformance are defined in this template.\n\nNote: The CDA Participant does not support a software device or the organization that created the software. The Assembler role can only be expressed at the level of organization. This is a known issue with the current CDA R2 model.\nNote: The Provenance template title includes a version 2 to support moving from the 'Basic Provenance' guide to the this Companion Guide, so the templateId has not changed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Participant1",
        "path" : "Participant1"
      },
      {
        "id" : "Participant1.templateId",
        "path" : "Participant1.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Participant1.templateId:provenance-assembler",
        "path" : "Participant1.templateId",
        "sliceName" : "provenance-assembler",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Participant1.templateId:provenance-assembler.root",
        "path" : "Participant1.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.5.7"
      },
      {
        "id" : "Participant1.templateId:provenance-assembler.extension",
        "path" : "Participant1.templateId.extension",
        "min" : 1,
        "patternString" : "2020-05-19"
      },
      {
        "id" : "Participant1.typeCode",
        "path" : "Participant1.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"DEV\" Device (CONF:4537-55).",
        "fixedCode" : "DEV"
      },
      {
        "id" : "Participant1.functionCode",
        "path" : "Participant1.functionCode",
        "comment" : "SHALL contain exactly one [1..1] functionCode (CONF:4537-38).",
        "min" : 1
      },
      {
        "id" : "Participant1.functionCode.code",
        "path" : "Participant1.functionCode.code",
        "comment" : "This functionCode SHALL contain exactly one [1..1] @code=\"assembler\" Assembler (CONF:4537-32972).",
        "min" : 1,
        "patternCode" : "assembler"
      },
      {
        "id" : "Participant1.functionCode.codeSystem",
        "path" : "Participant1.functionCode.codeSystem",
        "comment" : "This functionCode SHALL contain exactly one [1..1] @codeSystem (CodeSystem: ProvenanceParticipantType urn:oid:2.16.840.1.113883.4.642.4.1131) (CONF:4537-41).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.642.4.1131"
      },
      {
        "id" : "Participant1.time",
        "path" : "Participant1.time",
        "comment" : "SHALL contain exactly one [1..1] time (CONF:4537-42).",
        "min" : 1
      },
      {
        "id" : "Participant1.associatedEntity",
        "path" : "Participant1.associatedEntity",
        "short" : "The template does not require any elements from the associatedEntity since the information is recorded in the scopingOrganization.",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:4537-39)."
      },
      {
        "id" : "Participant1.associatedEntity.classCode",
        "path" : "Participant1.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode=\"OWN\" Owned Entity (CONF:4537-32973).",
        "fixedCode" : "OWN"
      },
      {
        "id" : "Participant1.associatedEntity.scopingOrganization",
        "path" : "Participant1.associatedEntity.scopingOrganization",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] scopingOrganization (CONF:4537-43).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAssemblerParticipation"
          },
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAssemblerParticipation"
          }
        ]
      },
      {
        "id" : "Participant1.associatedEntity.scopingOrganization.id",
        "path" : "Participant1.associatedEntity.scopingOrganization.id",
        "comment" : "This scopingOrganization SHALL contain at least one [1..*] id (CONF:4537-50).",
        "min" : 1
      },
      {
        "id" : "Participant1.associatedEntity.scopingOrganization.name",
        "path" : "Participant1.associatedEntity.scopingOrganization.name",
        "comment" : "This scopingOrganization SHALL contain at least one [1..*] name (CONF:4537-51).",
        "min" : 1
      },
      {
        "id" : "Participant1.associatedEntity.scopingOrganization.telecom",
        "path" : "Participant1.associatedEntity.scopingOrganization.telecom",
        "comment" : "This scopingOrganization SHOULD contain zero or more [0..*] telecom (CONF:4537-52)."
      },
      {
        "id" : "Participant1.associatedEntity.scopingOrganization.addr",
        "path" : "Participant1.associatedEntity.scopingOrganization.addr",
        "comment" : "This scopingOrganization SHOULD contain zero or more [0..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-47).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      }
    ]
  }
}

```
