# Progress Toward Goal Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Progress Toward Goal Observation**

## Logical Model: Progress Toward Goal Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProgressTowardGoalObservation |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.110 | |

 
This template represents a patient's progress toward a goal. It can describe whether a goal has been achieved or not and can also describe movement a patient is making toward the achievement of a goal (e.g., "Goal not achieved - no discernible change", "Goal not achieved - progressing toward goal", "Goal not achieved - declining from goal"). 
In the Care Planning workflow, the judgment about how well the person is progressing towards the goal is based on the observations made about the status of the patient with respect to interventions performed in the pursuit of achieving that goal. 
For example, an observation outcome of a blood oxygen saturation level of 95% is related to the goal of "Maintain Pulse Ox greater than 92" and in this case the Progress Toward Goal Observation template would record that the related goal has been achieved. 

**Usages:**

* Use this Logical Model Profile: [Goal Observation](StructureDefinition-GoalObservation.md) and [Outcome Observation](StructureDefinition-OutcomeObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProgressTowardGoalObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProgressTowardGoalObservation.csv), [Excel](StructureDefinition-ProgressTowardGoalObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProgressTowardGoalObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.110"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProgressTowardGoalObservation",
  "title" : "Progress Toward Goal Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a patient's progress toward a goal. It can describe whether a goal has been achieved or not and can also describe movement a patient is making toward the achievement of a goal (e.g., \"Goal not achieved - no discernible change\", \"Goal not achieved - progressing toward goal\", \"Goal not achieved - declining from goal\").\n\nIn the Care Planning workflow, the judgment about how well the person is progressing towards the goal is based on the observations made about the status of the patient with respect to interventions performed in the pursuit of achieving that goal.\n\nFor example, an observation outcome of a blood oxygen saturation level of 95% is related to the goal of \"Maintain Pulse Ox greater than 92\" and in this case the Progress Toward Goal Observation template would record that the related goal has been achieved.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:progress-toward-goal-obs",
        "path" : "Observation.templateId",
        "sliceName" : "progress-toward-goal-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:progress-toward-goal-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.110"
      },
      {
        "id" : "Observation.templateId:progress-toward-goal-obs.extension",
        "path" : "Observation.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-31418).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31419).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-31422).",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-31423)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"ASSERTION\" Assertion (CONF:1098-31424).",
        "min" : 1,
        "patternCode" : "ASSERTION"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.4\" (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1098-31425).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.4"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-31609).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31610).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-only",
            "severity" : "error",
            "human" : "Interval fields SHALL NOT be present",
            "expression" : "(low | high | width | center).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation"
          }
        ]
      },
      {
        "id" : "Observation.effectiveTime.value",
        "path" : "Observation.effectiveTime.value",
        "short" : "value should be used instead of low/high"
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", where the code SHALL be selected from ValueSet Goal Achievement urn:oid:2.16.840.1.113883.11.20.9.55 DYNAMIC (CONF:1098-31426).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.55"
        }
      }
    ]
  }
}

```
