# Procedures Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedures Section**

## Logical Model: Procedures Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProceduresSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09 | |

 
This section describes all historical or current interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient at the time the document is generated. The section should include notable procedures, but can contain all procedures for the period of time being summarized. 
Subsections MAY be used to partition the entries into different categories. For example, a subsection with the Loinc code of 18748-4 (Diagnostic Imaging) MAY be used to group DI procedures. Similarly 11502-2 (Clinical Laboratory) MAY be used to group laboratory procedures. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Entries**:[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md), [History and Physical](StructureDefinition-HistoryandPhysical.md)...Show 3 more,[Procedure Note](StructureDefinition-ProcedureNote.md),[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProceduresSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProceduresSection.csv), [Excel](StructureDefinition-ProceduresSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProceduresSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProceduresSection",
  "title" : "Procedures Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section describes all historical or current interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient at the time the document is generated. The section should include notable procedures, but can contain all procedures for the period of time being summarized.\n\nSubsections MAY be used to partition the entries into different categories. For example, a subsection with the Loinc code of 18748-4 (Diagnostic Imaging) MAY be used to group DI procedures. Similarly 11502-2 (Clinical Laboratory) MAY be used to group laboratory procedures.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Entries**: [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "shall-procedure-act-procedure",
            "severity" : "error",
            "human" : "If section/@nullFlavor is not present, SHALL contain at least one Procedure Activity Procedure",
            "expression" : "nullFlavor.exists() or entry.where(procedure.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure')).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
          }
        ]
      },
      {
        "id" : "Section.nullFlavor",
        "path" : "Section.nullFlavor",
        "short" : "If a required section contains no information, the @nullFlavor MAY be set to NI"
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.7.1"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "History of Procedures Document",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "47519-4"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "procedure"
            }
          ],
          "rules" : "open"
        },
        "short" : "If section/@nullFlavor is not present there SHALL be at least one entry conformant to Procedure Activity Procedure (templateId: 2.16.840.1.113883.10.20.22.4.14:2014-06-09)",
        "comment" : "SHALL contain at least one [1..*] entry (CONF:1098-7895) such that it"
      },
      {
        "id" : "Section.entry:entryProcedure",
        "path" : "Section.entry",
        "sliceName" : "entryProcedure",
        "comment" : "SHALL contain exactly one [1..1] Procedure Activity Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.14:2014-06-09) (CONF:1098-15509).",
        "min" : 0,
        "max" : "*",
        "condition" : ["shall-procedure-act-procedure"]
      },
      {
        "id" : "Section.entry:entryProcedure.procedure",
        "path" : "Section.entry.procedure",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
            ]
          }
        ]
      }
    ]
  }
}

```
