# Procedure Note - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure Note**

## Logical Model: Procedure Note 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:ProcedureNote |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.6:2024-05-01 | |

 
A Procedure Note encompasses many types of non-operative procedures including interventional cardiology, gastrointestinal endoscopy, osteopathic manipulation, and many other specialty fields. Procedure Notes are differentiated from Operative Notes because they do not involve incision or excision as the primary act. 
The Procedure Note is created immediately following a non-operative procedure. It records the indications for the procedure and, when applicable, postprocedure diagnosis, pertinent events of the procedure, and the patient's tolerance for the procedure. It should be detailed enough to justify the procedure, describe the course of the procedure, and provide continuity of care. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.md) or both [AssessmentSection](StructureDefinition-AssessmentSection.md) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [ComplicationsSection](StructureDefinition-ComplicationsSection.md)
* [ProcedureDescriptionSection](StructureDefinition-ProcedureDescriptionSection.md)
* [ProcedureIndicationsSection](StructureDefinition-ProcedureIndicationsSection.md)
* [PostprocedureDiagnosisSection](StructureDefinition-PostprocedureDiagnosisSection.md)
 
**Additional Sections** 
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [AnesthesiaSection](StructureDefinition-AnesthesiaSection.md)
* [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.md)
* [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [PastMedicalHistory](StructureDefinition-PastMedicalHistory.md)
* [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md)
* [MedicalGeneralHistorySection](StructureDefinition-MedicalGeneralHistorySection.md)
* [MedicationsSection](StructureDefinition-MedicationsSection.md)
* [MedicationsAdministeredSection](StructureDefinition-MedicationsAdministeredSection.md)
* [PhysicalExamSection](StructureDefinition-PhysicalExamSection.md)
* [PlannedProcedureSection](StructureDefinition-PlannedProcedureSection.md)
* [ProcedureDispositionSection](StructureDefinition-ProcedureDispositionSection.md)
* [ProcedureEstimatedBloodLossSection](StructureDefinition-ProcedureEstimatedBloodLossSection.md)
* [ProcedureFindingsSection](StructureDefinition-ProcedureFindingsSection.md)
* [ProcedureImplantsSection](StructureDefinition-ProcedureImplantsSection.md)
* [ProcedureSpecimensTakenSection](StructureDefinition-ProcedureSpecimensTakenSection.md)
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.md)
* [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProcedureNote)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProcedureNote.csv), [Excel](StructureDefinition-ProcedureNote.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProcedureNote",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.6:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProcedureNote",
  "title" : "Procedure Note",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A Procedure Note encompasses many types of non-operative procedures including interventional cardiology, gastrointestinal endoscopy, osteopathic manipulation, and many other specialty fields. Procedure Notes are differentiated from Operative Notes because they do not involve incision or excision as the primary act.\n\nThe Procedure Note is created immediately following a non-operative procedure. It records the indications for the procedure and, when applicable, postprocedure diagnosis, pertinent events of the procedure, and the patient's tolerance for the procedure. It should be detailed enough to justify the procedure, describe the course of the procedure, and provide continuity of care.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.html) or both [AssessmentSection](StructureDefinition-AssessmentSection.html) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [ComplicationsSection](StructureDefinition-ComplicationsSection.html)\n- [ProcedureDescriptionSection](StructureDefinition-ProcedureDescriptionSection.html)\n- [ProcedureIndicationsSection](StructureDefinition-ProcedureIndicationsSection.html)\n- [PostprocedureDiagnosisSection](StructureDefinition-PostprocedureDiagnosisSection.html)\n\n**Additional Sections**\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [AnesthesiaSection](StructureDefinition-AnesthesiaSection.html)\n- [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.html)\n- [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [PastMedicalHistory](StructureDefinition-PastMedicalHistory.html)\n- [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.html)\n- [MedicalGeneralHistorySection](StructureDefinition-MedicalGeneralHistorySection.html)\n- [MedicationsSection](StructureDefinition-MedicationsSection.html)\n- [MedicationsAdministeredSection](StructureDefinition-MedicationsAdministeredSection.html)\n- [PhysicalExamSection](StructureDefinition-PhysicalExamSection.html)\n- [PlannedProcedureSection](StructureDefinition-PlannedProcedureSection.html)\n- [ProcedureDispositionSection](StructureDefinition-ProcedureDispositionSection.html)\n- [ProcedureEstimatedBloodLossSection](StructureDefinition-ProcedureEstimatedBloodLossSection.html)\n- [ProcedureFindingsSection](StructureDefinition-ProcedureFindingsSection.html)\n- [ProcedureImplantsSection](StructureDefinition-ProcedureImplantsSection.html)\n- [ProcedureSpecimensTakenSection](StructureDefinition-ProcedureSpecimensTakenSection.html)\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.html)\n- [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          },
          {
            "key" : "category-28570-0",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '28570-0'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '28570-0' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          },
          {
            "key" : "should-componentOf",
            "severity" : "warning",
            "human" : "SHOULD contain componentOf",
            "expression" : "componentOf.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:procedure-note",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "procedure-note",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:procedure-note.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.6"
      },
      {
        "id" : "ClinicalDocument.templateId:procedure-note.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a Procedure Note. If present, there SHALL be a category of 28570-0 (Procedure note).",
        "condition" : ["should-sdtcCategory", "category-28570-0"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Procedure note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "28570-0"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The Procedure Note recommends use of a single document type code, 28570-0 \"Procedure note\", with further specification provided by author or performer, setting, or specialty. When pre-coordinated codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type.",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-17182).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.6.1"
        }
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            },
            {
              "type" : "value",
              "path" : "functionCode.code"
            }
          ],
          "rules" : "open"
        },
        "short" : "The participant element in the Procedure Note header follows the General Header Constraints for participants."
      },
      {
        "id" : "ClinicalDocument.participant:participant1",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "participant1",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1198-8504) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:participant1.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8505).",
        "fixedCode" : "IND"
      },
      {
        "id" : "ClinicalDocument.participant:participant1.functionCode",
        "path" : "ClinicalDocument.participant.functionCode",
        "comment" : "SHALL contain exactly one [1..1] functionCode=\"PCP\" Primary Care Physician (CodeSystem: HL7ParticipationFunction urn:oid:2.16.840.1.113883.5.88 STATIC) (CONF:1198-8506).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:participant1.functionCode.code",
        "path" : "ClinicalDocument.participant.functionCode.code",
        "min" : 1,
        "patternCode" : "PCP"
      },
      {
        "id" : "ClinicalDocument.participant:participant1.functionCode.codeSystem",
        "path" : "ClinicalDocument.participant.functionCode.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.88"
      },
      {
        "id" : "ClinicalDocument.participant:participant1.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity/@classCode=\"PROV\" Provider (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8507).",
        "fixedCode" : "PROV"
      },
      {
        "id" : "ClinicalDocument.participant:participant1.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity/@classCode SHALL contain exactly one [1..1] associatedPerson (CONF:1198-8508).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "short" : "A serviceEvent is required in the Procedure Note to represent the main act, such as a colonoscopy or a cardiac stress study, being documented. It must be equivalent to or further specialize the value inherent in the ClinicalDocument/@code (such as where the ClinicalDocument/@code is simply \"Procedure Note\" and the procedure is \"colonoscopy\"), and it shall not conflict with the value inherent in the ClinicalDocument/@code, as such a conflict would create ambiguity. A serviceEvent/effectiveTime element indicates the time the actual event (as opposed to the encounter surrounding the event) took place. serviceEvent/effectiveTime may be represented two different ways in the Procedure Note. For accuracy to the second, the best method is effectiveTime/low together with effectiveTime/high. If a more general time, such as minutes or hours, is acceptable OR if the duration is unknown, an effectiveTime/low with a width element may be used. If the duration is unknown, the appropriate HL7 null value such as \"NI\" or \"NA\" must be used for the width element.",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "comment" : "SHALL contain exactly one [1..1] serviceEvent (CONF:1198-10061)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "constraint" : [
          {
            "key" : "1198-8511",
            "severity" : "error",
            "human" : "The value of Clinical Document /documentationOf/serviceEvent/code **SHALL** be from ICD9 CM Procedures (codeSystem 2.16.840.1.113883.6.104), ICD-10-PCS (codeSystem 2.16.840.1.113883.6.4), CPT (codeSystem 2.16.840.1.113883.6.12), HCPCS (codeSystem 2.16.840.1.113883.6.285), or values descending from 71388002 (Procedure) from the SNOMED CT (codeSystem 2.16.840.1.113883.6.96) ValueSet 2.16.840.1.113883.3.88.12.80.28 Procedure *DYNAMIC* (CONF:1198-8511).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.104' or codeSystem = '2.16.840.1.113883.6.4' or codeSystem = '2.16.840.1.113883.6.12' or codeSystem = '2.16.840.1.113883.6.285' or (codeSystem = '2.16.840.1.113883.6.96' and code.memberOf('http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.28'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "The value of Clinical Document /documentationOf/serviceEvent/code **SHALL** be from ICD9 CM Procedures (codeSystem 2.16.840.1.113883.6.104), ICD-10-PCS (codeSystem 2.16.840.1.113883.6.4), CPT (codeSystem 2.16.840.1.113883.6.12), HCPCS (codeSystem 2.16.840.1.113883.6.285), or values descending from 71388002 (Procedure) from the SNOMED CT (codeSystem 2.16.840.1.113883.6.96) ValueSet 2.16.840.1.113883.3.88.12.80.28 Procedure *DYNAMIC* (CONF:1198-8511).",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.28",
              "documentation" : "The value of Clinical Document /documentationOf/serviceEvent/code **SHALL** be from ICD9 CM Procedures (codeSystem 2.16.840.1.113883.6.104), ICD-10-PCS (codeSystem 2.16.840.1.113883.6.4), CPT (codeSystem 2.16.840.1.113883.6.12), HCPCS (codeSystem 2.16.840.1.113883.6.285), or values descending from 71388002 (Procedure) from the SNOMED CT (codeSystem 2.16.840.1.113883.6.96) ValueSet 2.16.840.1.113883.3.88.12.80.28 Procedure *DYNAMIC* (CONF:1198-8511).",
              "shortDoco" : "Allowed SNOMED Codes"
            }
          ]
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:1198-10062).",
        "constraint" : [
          {
            "key" : "width-or-high",
            "severity" : "error",
            "human" : "Width and high are mutually exclusive. If width is known, high **SHALL NOT** be present. If with is not present, **SHALL** include high.",
            "expression" : "(width | high).count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "short" : "Low is required",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-26449) / (CONF:1198-8513)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.width",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.width",
        "short" : "Represents the duration",
        "comment" : "When only the date and the length of the procedure are known a width element **SHALL** be present and the serviceEvent/effectiveTime/high **SHALL NOT** be present (CONF:1198-8515)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "short" : "Equals low if only the date is known",
        "comment" : "If a width is not present, the serviceEvent/effectiveTime **SHALL** include effectiveTime/high (CONF:1198-8514)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "sliceName" : "primary",
        "short" : "This performer participant represents clinicians who actually and principally carry out the serviceEvent. Typically, these are clinicians who have the appropriate privileges in their institutions such as gastroenterologists, interventional radiologists, and family practice physicians. Performers may also be non-physician providers (NPPs) who have other significant roles in the procedure such as a radiology technician, dental assistant, or nurse. Any assistants are identified as a secondary performer (SPRF) in a second performer participant.",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] performer (CONF:1198-8520) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"PPRF\" Primary Performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8521).",
        "fixedCode" : "PPRF"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1198-14911).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code, which SHALL be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-14912).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "sliceName" : "secondary",
        "comment" : "This serviceEvent MAY contain zero or more [0..*] performer (CONF:1198-32732) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRF\" Secondary Performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-32734).",
        "fixedCode" : "SPRF"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32733).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code, which SHALL be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-32735).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.authorization",
        "path" : "ClinicalDocument.authorization",
        "short" : "Authorization represents consent. Consent, if present, shall be represented by authorization/consent.",
        "comment" : "MAY contain zero or one [0..1] authorization (CONF:1198-32412).",
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.authorization.consent",
        "path" : "ClinicalDocument.authorization.consent",
        "comment" : "The authorization, if present, SHALL contain exactly one [1..1] consent (CONF:1198-32414)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.classCode",
        "path" : "ClinicalDocument.authorization.consent.classCode",
        "comment" : "This consent SHALL contain exactly one [1..1] @classCode=\"CONS\" consent (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-32415).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authorization.consent.moodCode",
        "path" : "ClinicalDocument.authorization.consent.moodCode",
        "comment" : "This consent SHALL contain exactly one [1..1] @moodCode=\"EVN\" event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1198-32416).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authorization.consent.statusCode",
        "path" : "ClinicalDocument.authorization.consent.statusCode",
        "comment" : "This consent SHALL contain exactly one [1..1] statusCode (CONF:1198-32417)."
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "SHOULD contain componentOf",
        "comment" : "SHOULD contain zero or one [0..1] componentOf (CONF:1198-30871).",
        "condition" : ["should-componentOf"]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "The componentOf, if present, SHALL contain exactly one [1..1] encompassingEncounter (CONF:1198-30872)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.code",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.code",
        "comment" : "This encompassingEncounter SHALL contain exactly one [1..1] code, which SHOULD be selected from ValueSet Act Encounter Codes urn:oid:2.16.840.1.113762.1.4.1240.5 (CONF:1198-30873).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant:referrer",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "sliceName" : "referrer",
        "comment" : "This encompassingEncounter MAY contain zero or one [0..1] encounterParticipant (CONF:1198-30874) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant:referrer.typeCode",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REF\" Referrer (CONF:1198-30875).",
        "fixedCode" : "REF"
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.location",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.location",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.location.healthCareFacility",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.location.healthCareFacility",
        "comment" : "Such locations SHALL contain exactly one [1..1] healthCareFacility (CONF:1198-30877)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.location.healthCareFacility.id",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.location.healthCareFacility.id",
        "comment" : "This healthCareFacility SHALL contain at least one [1..*] id (CONF:1198-30878).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-9588)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-30352).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ap-or-a-and-p",
            "severity" : "error",
            "human" : "**SHALL** include an Assessment and Plan Section, or both an Assessment Section and a Plan of Treatment Section.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() or (component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).count() = 2)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          },
          {
            "key" : "ap-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain an Assessment and Plan Section (2.16.840.1.113883.10.20.22.2.9:2014-06-09) when either an Assessment Section (2.16.840.1.113883.10.20.22.2.8) or a Plan of Treatment Section (2.16.840.1.113883.10.20.22.2.10:2014-06-09) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          },
          {
            "key" : "cc-rfv-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain a Chief Complaint and Reason for Visit Section (2.16.840.1.113883.10.20.22.2.13) when either a Chief Complaint Section (1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) or a Reason for Visit Section (2.16.840.1.113883.10.20.22.2.12) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 5
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:complications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "complications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30353).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:complications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "This component SHALL contain exactly one [1..1] Complications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.37:2024-05-01) (CONF:1198-30387).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ComplicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedureDescription",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedureDescription",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30355) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedureDescription.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Description Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.27) (CONF:1198-30356).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDescriptionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:indications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "indications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30357) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:indications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Indications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.29:2014-06-09) (CONF:1198-30358).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureIndicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:postProcedureDx",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "postProcedureDx",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30359) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:postProcedureDx.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Postprocedure Diagnosis Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.36:2024-05-01) (CONF:1198-30360).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30361) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.8) (CONF:1198-30362).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessmentAndPlan",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30363) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment and Plan Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.9:2014-06-09) (CONF:1198-30364).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30365) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-30366).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30367) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-30368).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:anesthesia",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "anesthesia",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30369) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:anesthesia.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Anesthesia Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.25:2014-06-09) (CONF:1198-30370).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AnesthesiaSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaint",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30371) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) (CONF:1198-30372).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaintRFV",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30373) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint and Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.13) (CONF:1198-30374).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "familyHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30375) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-30376).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "pastMedicalHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30377) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Past Medical History (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.20:2024-05-01) (CONF:1198-30378).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:historyPresentIllness",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "historyPresentIllness",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30379) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:historyPresentIllness.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] History of Present Illness Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.4) (CONF:1198-30380).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medicalHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30381) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medical (General) History Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.39) (CONF:1198-30382).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalGeneralHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medications",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30383) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.1.1:2014-06-09) (CONF:1198-30384).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medsAdministered",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medsAdministered",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30388) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medsAdministered.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Administered Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.38:2014-06-09) (CONF:1198-30389).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsAdministeredSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "physicalExam",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30390) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Physical Exam Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.2.10:2024-05-01) (CONF:1198-30391).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:plannedProcedure",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "plannedProcedure",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30392) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:plannedProcedure.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Planned Procedure Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.30:2014-06-09) (CONF:1198-30393).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedureSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedureDisposition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedureDisposition",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30394) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedureDisposition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Disposition Section (identifier: urn:oid:2.16.840.1.113883.10.20.18.2.12) (CONF:1198-30395).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDispositionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:estBloodLoss",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "estBloodLoss",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30396) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:estBloodLoss.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Estimated Blood Loss Section (identifier: urn:oid:2.16.840.1.113883.10.20.18.2.9) (CONF:1198-30397).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureEstimatedBloodLossSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:findings",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "findings",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30398) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:findings.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Findings Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.28:2024-05-01) (CONF:1198-30399).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureFindingsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:implants",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "implants",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30400) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:implants.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Implants Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.40) (CONF:1198-30401).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureImplantsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:specimensTaken",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "specimensTaken",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30402) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:specimensTaken.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Specimens Taken Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.31) (CONF:1198-30403).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureSpecimensTakenSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30404) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-30405).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reasonForVisit",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30406) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.12) (CONF:1198-30407).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reviewOfSystems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30408) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Review of Systems Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.18) (CONF:1198-30409).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30410) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-30411).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28942) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      }
    ]
  }
}

```
