# Procedure Activity Procedure - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure Activity Procedure**

## Logical Model: Procedure Activity Procedure 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProcedureActivityProcedure |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.14:2024-05-01 | |

 
This template is used to represent the details of current and historical procedures performed on or for a patient. A procedure is an activity that is performed on, with, or for a patient as part of the provision of care. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise, etc. Procedures may be performed by a healthcare professional, a service provider, a friend or relative or in some cases by the patient themselves. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[EntryReference](StructureDefinition-EntryReference.md),[Indication](StructureDefinition-Indication.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[UDIOrganizer](StructureDefinition-UDIOrganizer.md) 

**Usages:**

* Use this Logical Model Profile: [Anesthesia Section](StructureDefinition-AnesthesiaSection.md), [Intervention Act](StructureDefinition-InterventionAct.md), [Medical Equipment Organizer](StructureDefinition-MedicalEquipmentOrganizer.md), [Medical Equipment Section](StructureDefinition-MedicalEquipmentSection.md)...Show 2 more,[Procedures Section](StructureDefinition-ProceduresSection.md)and[Reaction Observation](StructureDefinition-ReactionObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProcedureActivityProcedure)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProcedureActivityProcedure.csv), [Excel](StructureDefinition-ProcedureActivityProcedure.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProcedureActivityProcedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "procedure"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.14:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProcedureActivityProcedure",
  "title" : "Procedure Activity Procedure",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template is used to represent the details of current and historical procedures performed on or for a patient. A procedure is an activity that is performed on, with, or for a patient as part of the provision of care. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise, etc. Procedures may be performed by a healthcare professional, a service provider, a friend or relative or in some cases by the patient themselves.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html), [EntryReference](StructureDefinition-EntryReference.html), [Indication](StructureDefinition-Indication.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [MedicationActivity](StructureDefinition-MedicationActivity.html), [ReactionObservation](StructureDefinition-ReactionObservation.html), [UDIOrganizer](StructureDefinition-UDIOrganizer.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "key" : "active-high-ts-after-document",
            "severity" : "error",
            "human" : "If the procedure is active and contains a high effectiveTime, this time SHALL be after the ClinicalDocument/effectiveTime",
            "expression" : "(statusCode.code = 'active' and effectiveTime.high.value.exists()) implies (effectiveTime.high.value > %resource.effectiveTime.value).allTrue()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "key" : "should-targetSiteCode",
            "severity" : "warning",
            "human" : "SHOULD contain targetSiteCode",
            "expression" : "targetSiteCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "key" : "should-performer",
            "severity" : "warning",
            "human" : "SHOULD contain performer",
            "expression" : "performer.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.templateId",
        "path" : "Procedure.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Procedure.templateId:procedure",
        "path" : "Procedure.templateId",
        "sliceName" : "procedure",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.templateId:procedure.root",
        "path" : "Procedure.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.14"
      },
      {
        "id" : "Procedure.templateId:procedure.extension",
        "path" : "Procedure.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Procedure.classCode",
        "path" : "Procedure.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"PROC\" Procedure (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4515-7652)."
      },
      {
        "id" : "Procedure.moodCode",
        "path" : "Procedure.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4515-7653).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Procedure.id",
        "path" : "Procedure.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4515-7655).",
        "min" : 1
      },
      {
        "id" : "Procedure.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: SDOH Interventions",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4515-7656).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-otext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain originalText/reference/@value",
            "expression" : "originalText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1196.789",
              "documentation" : "If the Intervention Procedure is a Social Determinant of Health Intervention, the procedure code **SHOULD** be selected from ValueSet [Social Determinant of Health Procedures](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.789/expansion) **DYNAMIC** (CONF:4515-32984).",
              "shortDoco" : "For Social Determinant of Health Interventions"
            }
          ]
        }
      },
      {
        "id" : "Procedure.code.originalText",
        "path" : "Procedure.code.originalText",
        "short" : "SHOULD reference the portion of narrative corresponding to this code",
        "condition" : ["should-otext-ref-value"]
      },
      {
        "id" : "Procedure.code.originalText.reference",
        "path" : "Procedure.code.originalText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.text",
        "path" : "Procedure.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Procedure.text.reference",
        "path" : "Procedure.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.statusCode",
        "path" : "Procedure.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-7661).",
        "min" : 1,
        "condition" : ["active-high-ts-after-document"]
      },
      {
        "id" : "Procedure.statusCode.nullFlavor",
        "path" : "Procedure.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Procedure.statusCode.code",
        "path" : "Procedure.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.22"
        }
      },
      {
        "id" : "Procedure.effectiveTime",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.effectiveTime",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Performance Time",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-value",
            "severity" : "warning",
            "human" : "SHOULD contain value",
            "expression" : "value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "key" : "ts-value-before-document",
            "severity" : "error",
            "human" : "Time value must be equal to or before ClinicalDocument/effectiveTime",
            "expression" : "value.exists() implies (value <= %resource.effectiveTime.value).allTrue()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.effectiveTime.value",
        "path" : "Procedure.effectiveTime.value",
        "short" : "Indicates historical procedure or an instance of a procedure where precision may be only a date or even a year."
      },
      {
        "id" : "Procedure.effectiveTime.low",
        "path" : "Procedure.effectiveTime.low",
        "short" : "Indicates when a procedure started",
        "comment" : "MAY contain zero or one [0..1] low",
        "constraint" : [
          {
            "key" : "ts-value-before-document",
            "severity" : "error",
            "human" : "Time value must be equal to or before ClinicalDocument/effectiveTime",
            "expression" : "value.exists() implies (value <= %resource.effectiveTime.value).allTrue()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.effectiveTime.high",
        "path" : "Procedure.effectiveTime.high",
        "short" : "Indicates when a procedure ended. If the statusCode='active', this must be after the ClinicalDcument/effectiveTime",
        "comment" : "MAY contain zero or one [0..1] high",
        "condition" : ["active-high-ts-after-document"]
      },
      {
        "id" : "Procedure.priorityCode",
        "path" : "Procedure.priorityCode",
        "comment" : "MAY contain zero or one [0..1] priorityCode, which SHALL be selected from ValueSet ActPriority urn:oid:2.16.840.1.113883.1.11.16866 DYNAMIC (CONF:4515-7668).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActPriority"
        }
      },
      {
        "id" : "Procedure.methodCode",
        "path" : "Procedure.methodCode",
        "short" : "MethodCode **SHALL NOT** conflict with the method inherent in Procedure / code (CONF:4515-7890).",
        "comment" : "MAY contain zero or one [0..1] methodCode (CONF:4515-7670).",
        "max" : "1"
      },
      {
        "id" : "Procedure.targetSiteCode",
        "path" : "Procedure.targetSiteCode",
        "short" : "In the case of an implanted medical device, targetSiteCode is used to record the location of the device, in or on the patient's body.",
        "comment" : "SHOULD contain zero or more [0..*] targetSiteCode, which SHALL be selected from ValueSet Body Site Value Set urn:oid:2.16.840.1.113883.3.88.12.3221.8.9 DYNAMIC (CONF:4515-7683).",
        "condition" : ["should-targetSiteCode"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "Procedure.specimen",
        "path" : "Procedure.specimen",
        "short" : "This specimen is for representing specimens obtained from a procedure (CONF:4515-16842).",
        "comment" : "MAY contain zero or more [0..*] specimen (CONF:4515-7697)."
      },
      {
        "id" : "Procedure.specimen.specimenRole",
        "path" : "Procedure.specimen.specimenRole",
        "comment" : "The specimen, if present, SHALL contain exactly one [1..1] specimenRole (CONF:4515-7704).",
        "constraint" : [
          {
            "key" : "should-id",
            "severity" : "warning",
            "human" : "SHOULD contain id",
            "expression" : "id.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.specimen.specimenRole.id",
        "path" : "Procedure.specimen.specimenRole.id",
        "short" : "If you want to indicate that the Procedure and the Results are referring to the same specimen, the Procedure/specimen/specimenRole/id **SHOULD** be set to equal an Organizer/specimen/specimenRole/id (CONF:4515-29744).",
        "comment" : "This specimenRole SHOULD contain zero or more [0..*] id (CONF:4515-7716)."
      },
      {
        "id" : "Procedure.performer",
        "path" : "Procedure.performer",
        "short" : "SHOULD contain performer",
        "comment" : "SHOULD contain zero or more [0..*] performer (CONF:4515-7718) such that it",
        "condition" : ["should-performer"]
      },
      {
        "id" : "Procedure.performer.assignedEntity",
        "path" : "Procedure.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4515-7720).",
        "constraint" : [
          {
            "key" : "should-assignedPerson",
            "severity" : "warning",
            "human" : "SHOULD contain assignedPerson",
            "expression" : "assignedPerson.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "key" : "should-representedOrganization",
            "severity" : "warning",
            "human" : "SHOULD contain representedOrganization",
            "expression" : "representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.performer.assignedEntity.id",
        "path" : "Procedure.performer.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4515-7722)."
      },
      {
        "id" : "Procedure.performer.assignedEntity.sdtcSpecialty",
        "path" : "Procedure.performer.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Procedure.performer.assignedEntity.addr",
        "path" : "Procedure.performer.assignedEntity.addr",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] addr (CONF:4515-7731).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.assignedEntity.telecom",
        "path" : "Procedure.performer.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4515-7732).",
        "min" : 1
      },
      {
        "id" : "Procedure.performer.assignedEntity.assignedPerson",
        "path" : "Procedure.performer.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] assignedPerson."
      },
      {
        "id" : "Procedure.performer.assignedEntity.assignedPerson.name",
        "path" : "Procedure.performer.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.assignedEntity.representedOrganization",
        "path" : "Procedure.performer.assignedEntity.representedOrganization",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] representedOrganization (CONF:4515-7733).",
        "constraint" : [
          {
            "key" : "should-id",
            "severity" : "warning",
            "human" : "SHOULD contain id",
            "expression" : "id.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.performer.assignedEntity.representedOrganization.id",
        "path" : "Procedure.performer.assignedEntity.representedOrganization.id",
        "comment" : "The representedOrganization, if present, SHOULD contain zero or more [0..*] id (CONF:4515-7734)."
      },
      {
        "id" : "Procedure.performer.assignedEntity.representedOrganization.name",
        "path" : "Procedure.performer.assignedEntity.representedOrganization.name",
        "comment" : "The representedOrganization, if present, MAY contain zero or more [0..*] name (CONF:4515-7735)."
      },
      {
        "id" : "Procedure.performer.assignedEntity.representedOrganization.telecom",
        "path" : "Procedure.performer.assignedEntity.representedOrganization.telecom",
        "comment" : "The representedOrganization, if present, SHALL contain at least one [1..*] telecom (CONF:4515-7737).",
        "min" : 1
      },
      {
        "id" : "Procedure.performer.assignedEntity.representedOrganization.addr",
        "path" : "Procedure.performer.assignedEntity.representedOrganization.addr",
        "comment" : "The representedOrganization, if present, SHALL contain at least one [1..*] addr (CONF:4515-7736).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.author",
        "path" : "Procedure.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4515-32479).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Procedure.participant",
        "path" : "Procedure.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] participant (CONF:4515-7765) such that it"
      },
      {
        "id" : "Procedure.participant:serviceDeliveryLocation",
        "path" : "Procedure.participant",
        "sliceName" : "serviceDeliveryLocation",
        "short" : "participant",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.participant:serviceDeliveryLocation.typeCode",
        "path" : "Procedure.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"LOC\" Location (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:4515-7766).",
        "fixedCode" : "LOC"
      },
      {
        "id" : "Procedure.participant:serviceDeliveryLocation.participantRole",
        "path" : "Procedure.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Service Delivery Location (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.32) (CONF:4515-15912).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.participant:productInstance",
        "path" : "Procedure.participant",
        "sliceName" : "productInstance",
        "short" : "participant",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:4515-7751) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.participant:productInstance.typeCode",
        "path" : "Procedure.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"DEV\" Device (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4515-7752).",
        "fixedCode" : "DEV"
      },
      {
        "id" : "Procedure.participant:productInstance.participantRole",
        "path" : "Procedure.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Product Instance (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.37) (CONF:4515-15911).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship",
        "path" : "Procedure.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            },
            {
              "type" : "exists",
              "path" : "encounter"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32988) such that it"
      },
      {
        "id" : "Procedure.entryRelationship:udiOrganizer",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "udiOrganizer",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-7768) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:udiOrganizer.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4515-7769).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Procedure.entryRelationship:udiOrganizer.inversionInd",
        "path" : "Procedure.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" true (CONF:4515-8009).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Procedure.entryRelationship:udiOrganizer.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Procedure.entryRelationship:udiOrganizer.organizer",
        "path" : "Procedure.entryRelationship.organizer",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:encounter",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "encounter",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-7768) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:encounter.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4515-7769).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Procedure.entryRelationship:encounter.inversionInd",
        "path" : "Procedure.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" true (CONF:4515-8009).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Procedure.entryRelationship:encounter.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "comment" : "SHALL contain exactly one [1..1] encounter (CONF:4515-7770).",
        "min" : 1
      },
      {
        "id" : "Procedure.entryRelationship:encounter.encounter.classCode",
        "path" : "Procedure.entryRelationship.encounter.classCode",
        "comment" : "This encounter SHALL contain exactly one [1..1] @classCode=\"ENC\" Encounter (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4515-7771)."
      },
      {
        "id" : "Procedure.entryRelationship:encounter.encounter.moodCode",
        "path" : "Procedure.entryRelationship.encounter.moodCode",
        "comment" : "This encounter SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4515-7772).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Procedure.entryRelationship:encounter.encounter.id",
        "path" : "Procedure.entryRelationship.encounter.id",
        "short" : "Set the encounter ID to the ID of an encounter in another section to signify they are the same encounter (CONF:4515-16843).",
        "comment" : "This encounter SHALL contain exactly one [1..1] id (CONF:4515-7773).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.entryRelationship:instruction",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "instruction",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:4515-7775) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Procedure.entryRelationship:instruction.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4515-7776).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Procedure.entryRelationship:instruction.inversionInd",
        "path" : "Procedure.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" true (CONF:4515-7777).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Procedure.entryRelationship:instruction.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Procedure.entryRelationship:instruction.observation",
        "path" : "Procedure.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:indication",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "indication",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-7779) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:indication.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has Reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4515-7780).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Procedure.entryRelationship:indication.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Procedure.entryRelationship:indication.observation",
        "path" : "Procedure.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:4515-15914).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:medication",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "medication",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-7886) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:medication.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4515-7887).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Procedure.entryRelationship:medication.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Procedure.entryRelationship:medication.substanceAdministration",
        "path" : "Procedure.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Medication Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.16:2014-06-09) (CONF:4515-15915).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:reaction",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "reaction",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32473) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:reaction.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32474).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Procedure.entryRelationship:reaction.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Procedure.entryRelationship:reaction.observation",
        "path" : "Procedure.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Reaction Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.9:2014-06-09) (CONF:4515-32475).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScaleObs",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "assessmentScaleObs",
        "short" : "When an Assessment Scale Observation is contained in a Procedure Template instance that is a Social Determinant of Health intervention procedure, that Assessment scale **MAY** contain Assessment Scale observations that represent LOINC question and answer pairs from SDOH screening instruments.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32985) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScaleObs.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32987).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScaleObs.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScaleObs.observation",
        "path" : "Procedure.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.69) (CONF:4515-32986).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:entryReference",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "entryReference",
        "short" : "When an Entry Reference Template is contained in a Procedure Template instance that is a Social Determinant of Health procedure, that Entry Reference **MAY** refer to Assessment Scale Observation in the same document that represent LOINC question and answer pairs from SDOH screening instruments.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:entryReference.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32990).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Procedure.entryRelationship:entryReference.act",
        "path" : "Procedure.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32989).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:entryReference.encounter",
        "path" : "Procedure.entryRelationship.encounter",
        "max" : "0"
      }
    ]
  }
}

```
