# Problem Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problem Observation**

## Logical Model: Problem Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProblemObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.4:2024-05-01 | |

 
This template reflects a discrete observation about a patient's problem. Because it is a discrete observation, it will have a statusCode of "completed". The effectiveTime, also referred to as the "biologically relevant time" is the time at which the observation holds for the patient. For a provider seeing a patient in the clinic today, observing a history of heart attack that occurred five years ago, the effectiveTime is five years ago. 
The effectiveTime of the Problem Observation is the definitive indication of whether or not the underlying condition is inactive. If the problem is known to be resolved, in remission, or otherwise inactive, then an effectiveTime/high would be present. If the date of resolution is not known, then effectiveTime/high will be present with a nullFlavor of "UNK". 
The onset date (Problem Observation.effectiveTime.low), diagnosis date (Date of Diagnosis Act), and recorded date (Problem Observation.author/time) represent distinct concepts that have long been supported in C-CDA. However, in practice, these timestamps are often not distinctly or reliably captured in EHR systems. Even when all fields are available, clinicians may not enter separate dates for each event. As a result, implementations should expect variability in the availability and precision of these values. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AgeObservation](StructureDefinition-AgeObservation.md),[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[DateOfDiagnosisAct](StructureDefinition-DateOfDiagnosisAct.md),[EntryReference](StructureDefinition-EntryReference.md),[PriorityPreference](StructureDefinition-PriorityPreference.md),[ProblemStatus](StructureDefinition-ProblemStatus.md),[PrognosisObservation](StructureDefinition-PrognosisObservation.md) 

**Usages:**

* Derived from this Logical Model Profile: [Longitudinal Care Wound Observation](StructureDefinition-LongitudinalCareWoundObservation.md)
* Use this Logical Model Profile: [Care Plan Act](StructureDefinition-CarePlanAct.md), [Complications Section](StructureDefinition-ComplicationsSection.md), [Deceased Observation](StructureDefinition-DeceasedObservation.md), [Encounter Diagnosis](StructureDefinition-EncounterDiagnosis.md)...Show 9 more,[Health Concern Act](StructureDefinition-HealthConcernAct.md),[Hospital Admission Diagnosis](StructureDefinition-HospitalAdmissionDiagnosis.md),[Hospital Discharge Diagnosis](StructureDefinition-HospitalDischargeDiagnosis.md),[Past Medical History](StructureDefinition-PastMedicalHistory.md),[Postprocedure Diagnosis](StructureDefinition-PostprocedureDiagnosis.md),[Preoperative Diagnosis](StructureDefinition-PreoperativeDiagnosis.md),[Problem Concern Act](StructureDefinition-ProblemConcernAct.md),[Procedure Findings Section](StructureDefinition-ProcedureFindingsSection.md)and[Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProblemObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProblemObservation.csv), [Excel](StructureDefinition-ProblemObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProblemObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.4:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProblemObservation",
  "title" : "Problem Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template reflects a discrete observation about a patient's problem. Because it is a discrete observation, it will have a statusCode of \"completed\". The effectiveTime, also referred to as the \"biologically relevant time\" is the time at which the observation holds for the patient. For a provider seeing a patient in the clinic today, observing a history of heart attack that occurred five years ago, the effectiveTime is five years ago. \n\nThe effectiveTime of the Problem Observation is the definitive indication of whether or not the underlying condition is inactive. If the problem is known to be resolved, in remission, or otherwise inactive, then an effectiveTime/high would be present. If the date of resolution is not known, then effectiveTime/high will be present with a nullFlavor of \"UNK\".\n\nThe onset date (Problem Observation.effectiveTime.low), diagnosis date (Date of Diagnosis Act), and recorded date (Problem Observation.author/time) represent distinct concepts that have long been supported in C-CDA. However, in practice, these timestamps are often not distinctly or reliably captured in EHR systems. Even when all fields are available, clinicians may not enter separate dates for each event. As a result, implementations should expect variability in the availability and precision of these values.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AgeObservation](StructureDefinition-AgeObservation.html), [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html), [DateOfDiagnosisAct](StructureDefinition-DateOfDiagnosisAct.html), [EntryReference](StructureDefinition-EntryReference.html), [PriorityPreference](StructureDefinition-PriorityPreference.html), [ProblemStatus](StructureDefinition-ProblemStatus.html), [PrognosisObservation](StructureDefinition-PrognosisObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:problem-obs",
        "path" : "Observation.templateId",
        "sliceName" : "problem-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:problem-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.4"
      },
      {
        "id" : "Observation.templateId:problem-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-9041).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-9042).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.negationInd",
        "path" : "Observation.negationInd",
        "short" : "The negationInd is used to indicate the absence of the condition in observation/value. A negationInd of \"true\" coupled with an observation/value of SNOMED code 64572001 \"Disease (disorder)\" indicates that the patient has no known conditions.",
        "comment" : "MAY contain zero or one [0..1] @negationInd (CONF:1198-10139)."
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-9043).",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.1"
        }
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-9049).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1198-19112).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "If the problem is known to be resolved, but the date of resolution is not known, then the high element **SHALL** be present, and the nullFlavor attribute **SHALL** be set to 'UNK'. Therefore, the existence of a high element within a problem does indicate that the problem has been resolved.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1198-9050).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.low",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.effectiveTime.low",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Date of Onset = When the problem began for the patient.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-15603).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.high",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.effectiveTime.high",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Date of Resolution - The effectiveTime/high (a.k.a. resolution date) asserts when the condition became biologically resolved.",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:1198-15604)."
      },
      {
        "id" : "Observation.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value",
        "short" : "𝗨𝗦𝗖𝗗𝗜: SDOH Problems/Health Concerns",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", where the code SHOULD be selected from ValueSet US Core Condition Codes.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code"
        }
      },
      {
        "id" : "Observation.value.code",
        "path" : "Observation.value.code",
        "short" : "A negationInd of \"true\" coupled with an observation/value/@code of SNOMED code 64572001 \"Disease (disorder)\" indicates that the patient has no known conditions.  When the Problem is Social Determinant of Health Observation, the observation/value SHOULD be a SNOMED code selected from ValueSet Social Determinant of Health Conditions 2.16.840.1.113762.1.4.1196.788 DYNAMIC (CONF:4515-32951).",
        "comment" : "This value MAY contain zero or one [0..1] @code (CONF:1198-31871).",
        "binding" : {
          "strength" : "example",
          "description" : "See additional binding",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1196.788",
              "documentation" : "If the Social History Observation is a Social Determinant of Health Observation, the observation/value code **SHOULD** be selected from ValueSet [Social Determinant of Health Conditions 2.16.840.1.113762.1.4.1196.788](http://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.788/expansion) **DYNAMIC** (CONF:4515-32957).",
              "shortDoco" : "Social Determinant of Health Observations"
            }
          ]
        }
      },
      {
        "id" : "Observation.value.qualifier",
        "path" : "Observation.value.qualifier",
        "short" : "The observation/value and all the qualifiers together (often referred to as a post-coordinated expression) make up one concept. Qualifiers constrain the meaning of the primary code, and cannot negate it or change its meaning. Qualifiers can only be used according to well-defined rules of post-coordination and only if the underlying code system defines the use of such qualifiers or if there is a third code system that specifies how other code systems may be combined.\n\n In cases where SNOMED CT does not have a precoordinated code that would be appropriate for the problem list, concept post coordination may be used in CDA following the principles outlined in HL7 Version 3 Implementation Guide: TermInfo -\nUsing SNOMED CT in CDA R2 Models, Release 1 using the V3 CD Data type 1 style.  This is shown in the sample XML.",
        "comment" : "This value MAY contain zero or more [0..*] qualifier (CONF:1198-31870)."
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-31147).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.entryRelationship:age",
        "path" : "Observation.entryRelationship",
        "sliceName" : "age",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-9059) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:age.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-9060).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Observation.entryRelationship:age.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1198-9069).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Observation.entryRelationship:age.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Age Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.31) (CONF:1198-15590).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AgeObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:prognosis",
        "path" : "Observation.entryRelationship",
        "sliceName" : "prognosis",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-29951) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:prognosis.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31531).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship:prognosis.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Prognosis Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.113) (CONF:1198-29952).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PrognosisObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:priority",
        "path" : "Observation.entryRelationship",
        "sliceName" : "priority",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31063) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:priority.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31532).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship:priority.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1198-31064).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:status",
        "path" : "Observation.entryRelationship",
        "sliceName" : "status",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-9063) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:status.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-9068).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship:status.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Problem Status (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.6:2019-06-20) (CONF:1198-15591).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemStatus"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:reference",
        "path" : "Observation.entryRelationship",
        "sliceName" : "reference",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32968) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:reference.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" Has Support (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32968).",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Observation.entryRelationship:reference.act",
        "path" : "Observation.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: 2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32966).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:assessment",
        "path" : "Observation.entryRelationship",
        "sliceName" : "assessment",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32953) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:assessment.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" Has Support (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32955).",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Observation.entryRelationship:assessment.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: 2.16.840.1.113883.10.20.22.4.69) (CONF:4515-32954).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:dateOfDiagnosis",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.entryRelationship",
        "sliceName" : "dateOfDiagnosis",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Date of Diagnosis",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-33012) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:dateOfDiagnosis.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" has Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-33014).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Observation.entryRelationship:dateOfDiagnosis.act",
        "path" : "Observation.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Date of Diagnosis Act (identifier: 2.16.840.1.113883.10.20.22.4.502) (CONF:4515-33013).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
            ]
          }
        ]
      }
    ]
  }
}

```
