# Policy Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Policy Activity**

## Logical Model: Policy Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PolicyActivity |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.61:2024-05-01 | |

 
A policy activity represents the policy or program providing the coverage. The person for whom payment is being provided (i.e., the patient) is the covered party. The subscriber of the policy or program is represented as a participant that is the holder of the coverage. The payer is represented as the performer of the policy activity. Note that the absence of a Policy Activity Act is not confirmation the patient does not have coverage. A Patient's coverage may not have been documented yet or not known to the healthcare provider. 
* Absence of a Policy Activity Act may mean that the patient has no coverage or the healthcare provider may not know it.
* A self pay payer type MAY be used to imply that the patient has no coverage or that an individual or organization other than an insurer is taking responsibility for payment for a portion of the health care costs.
 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AuthorizationActivity](StructureDefinition-AuthorizationActivity.md) 

**Usages:**

* Use this Logical Model Profile: [Coverage Activity](StructureDefinition-CoverageActivity.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PolicyActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PolicyActivity.csv), [Excel](StructureDefinition-PolicyActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PolicyActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.61:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PolicyActivity",
  "title" : "Policy Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A policy activity represents the policy or program providing the coverage. The person for whom payment is being provided (i.e., the patient) is the covered party. The subscriber of the policy or program is represented as a participant that is the holder of the coverage. The payer is represented as the performer of the policy activity.\nNote that the absence of a Policy Activity Act is not confirmation the patient does not have coverage. A Patient's coverage may not have been documented yet or not known to the healthcare provider. \n*    Absence of a Policy Activity Act may mean that the patient has no coverage or the healthcare provider may not know it.\n*    A self pay payer type MAY be used to imply that the patient has no coverage or that an individual or organization other than an insurer is taking responsibility for payment for a portion of the health care costs.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AuthorizationActivity](StructureDefinition-AuthorizationActivity.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "key" : "4537-17139",
            "severity" : "error",
            "human" : "When the Subscriber is the patient (COV participant code = 'SELF'), the participant element describing the subscriber **SHALL NOT** be present. This information will be recorded instead in the data elements used to record member information (CONF:4537-17139).",
            "expression" : "participant.where(typeCode='COV').participantRole.code.where(code = 'SELF').exists() implies participant.where(typeCode='HLD').empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:policy-activity",
        "path" : "Act.templateId",
        "sliceName" : "policy-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:policy-activity.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.61"
      },
      {
        "id" : "Act.templateId:policy-activity.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4537-8898).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4537-8899).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.id",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Group Identifier: This is the identifier (sent in the @extension attribute) used to uniquely refer to a specific health insurance plan.",
        "comment" : "If the root OID of Payer that assigned the group identifier is unknown, a local OID can be assigned or a nullFlavor of UNK",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Coverage Type: Records the category of health care payers, insurance products, or benefits.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
        }
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-8902).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:4537-19109).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.performer",
        "path" : "Act.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "templateId.root"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or more [0..*] performer (CONF:4537-8961) such that it",
        "min" : 1
      },
      {
        "id" : "Act.performer:payer",
        "path" : "Act.performer",
        "sliceName" : "payer",
        "short" : "This performer represents the Payer.",
        "comment" : "SHALL contain exactly one [1..1] performer (CONF:4537-8906) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.performer:payer.templateId",
        "path" : "Act.performer.templateId",
        "comment" : "SHALL contain exactly one [1..1] templateId (CONF:4537-16808), SHALL not contain [0..0] extension..",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.performer:payer.templateId.root",
        "path" : "Act.performer.templateId.root",
        "comment" : "This templateId SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.10.20.22.4.87\" Payer Performer (CONF:4537-16809).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.87"
      },
      {
        "id" : "Act.performer:payer.templateId.extension",
        "path" : "Act.performer.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.performer:payer.typeCode",
        "path" : "Act.performer.typeCode",
        "min" : 1
      },
      {
        "id" : "Act.performer:payer.assignedEntity",
        "path" : "Act.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-8908).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "key" : "should-representedOrganization",
            "severity" : "warning",
            "human" : "SHOULD contain representedOrganization",
            "expression" : "representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.performer.assignedEntity.id",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Payer Identifier: This is the Payer id. The root is a unique identifier to an openly available assigning authority, such as National Association of Insurance Commissioners (NAIC) (2.16.840.1.113883.6.300), and the extension identifiers the payer within that authority.",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-8909)."
      },
      {
        "id" : "Act.performer:payer.assignedEntity.code",
        "path" : "Act.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code (CONF:4537-8914)."
      },
      {
        "id" : "Act.performer:payer.assignedEntity.code.nullFlavor",
        "path" : "Act.performer.assignedEntity.code.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.performer:payer.assignedEntity.code.code",
        "path" : "Act.performer.assignedEntity.code.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10416"
        }
      },
      {
        "id" : "Act.performer:payer.assignedEntity.addr",
        "path" : "Act.performer.assignedEntity.addr",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-8910).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.telecom",
        "path" : "Act.performer.assignedEntity.telecom",
        "comment" : "This assignedEntity MAY contain zero or more [0..*] telecom (CONF:4537-8911)."
      },
      {
        "id" : "Act.performer:payer.assignedEntity.representedOrganization",
        "path" : "Act.performer.assignedEntity.representedOrganization",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] representedOrganization (CONF:4537-8912).",
        "constraint" : [
          {
            "key" : "should-name",
            "severity" : "warning",
            "human" : "SHOULD contain name",
            "expression" : "name.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.representedOrganization.name",
        "path" : "Act.performer.assignedEntity.representedOrganization.name",
        "comment" : "The representedOrganization, if present, SHOULD contain zero or one [0..1] name (CONF:4537-8913).",
        "max" : "1"
      },
      {
        "id" : "Act.performer:guarantor",
        "path" : "Act.performer",
        "sliceName" : "guarantor",
        "short" : "This performer represents the Guarantor.",
        "min" : 0,
        "max" : "*",
        "constraint" : [
          {
            "key" : "should-time",
            "severity" : "warning",
            "human" : "SHOULD contain time",
            "expression" : "time.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.templateId",
        "path" : "Act.performer.templateId",
        "comment" : "SHALL contain exactly one [1..1] templateId (CONF:4537-16810), SHALL not contain [0..0] extension.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.performer:guarantor.templateId.root",
        "path" : "Act.performer.templateId.root",
        "comment" : "This templateId SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.10.20.22.4.88\" Guarantor Performer (CONF:4537-16811).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.88"
      },
      {
        "id" : "Act.performer:guarantor.templateId.extension",
        "path" : "Act.performer.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.performer:guarantor.typeCode",
        "path" : "Act.performer.typeCode",
        "min" : 1
      },
      {
        "id" : "Act.performer:guarantor.time",
        "path" : "Act.performer.time",
        "comment" : "SHOULD contain zero or one [0..1] time (CONF:4537-8963)."
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity",
        "path" : "Act.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-8962).",
        "constraint" : [
          {
            "key" : "4537-8967",
            "severity" : "warning",
            "human" : "**SHOULD** include assignedEntity/assignedPerson/name AND/OR assignedEntity/representedOrganization/name (CONF:4537-8967).",
            "expression" : "assignedPerson.name.exists() or representedOrganization.name.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.code",
        "path" : "Act.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] code (CONF:4537-8968).",
        "min" : 1
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.code.code",
        "path" : "Act.performer.assignedEntity.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"GUAR\" Guarantor (CONF:4537-16096).",
        "min" : 1,
        "patternCode" : "GUAR"
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.code.codeSystem",
        "path" : "Act.performer.assignedEntity.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.110\" (CONF:4537-32165).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.110"
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.addr",
        "path" : "Act.performer.assignedEntity.addr",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-8964).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.telecom",
        "path" : "Act.performer.assignedEntity.telecom",
        "comment" : "This assignedEntity SHOULD contain zero or more [0..*] telecom (CONF:4537-8965)."
      },
      {
        "id" : "Act.participant",
        "path" : "Act.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or one [0..1] participant (CONF:4537-8934) such that it",
        "min" : 1
      },
      {
        "id" : "Act.participant:coverage-target",
        "path" : "Act.participant",
        "sliceName" : "coverage-target",
        "short" : "participant",
        "comment" : "SHALL contain exactly one [1..1] participant (CONF:4537-8916) such that it",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-time",
            "severity" : "warning",
            "human" : "SHOULD contain time",
            "expression" : "time.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.participant:coverage-target.templateId",
        "path" : "Act.participant.templateId",
        "comment" : "SHALL contain exactly one [1..1] templateId (CONF:4537-16812), SHALL not contain [0..0] extension.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.participant:coverage-target.templateId.root",
        "path" : "Act.participant.templateId.root",
        "comment" : "This templateId SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.10.20.22.4.89\" Covered Party Participant (CONF:4537-16814).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.89"
      },
      {
        "id" : "Act.participant:coverage-target.templateId.extension",
        "path" : "Act.participant.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.participant:coverage-target.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COV\" Coverage target (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:4537-8917).",
        "fixedCode" : "COV"
      },
      {
        "id" : "Act.participant:coverage-target.time",
        "path" : "Act.participant.time",
        "short" : "This records the policy coverage period or self-pay period.",
        "comment" : "SHOULD contain zero or one [0..1] time (CONF:4537-8918).",
        "constraint" : [
          {
            "key" : "should-low",
            "severity" : "warning",
            "human" : "SHOULD contain low",
            "expression" : "low.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "key" : "should-high",
            "severity" : "warning",
            "human" : "SHOULD contain high",
            "expression" : "high.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.participant:coverage-target.time.low",
        "path" : "Act.participant.time.low",
        "comment" : "The time, if present, SHOULD contain zero or one [0..1] low (CONF:4537-8919)."
      },
      {
        "id" : "Act.participant:coverage-target.time.high",
        "path" : "Act.participant.time.high",
        "short" : "SHOULD contain high",
        "comment" : "The time, if present, SHOULD contain zero or one [0..1] high (CONF:4537-8920)."
      },
      {
        "id" : "Act.participant:coverage-target.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4537-8921).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "key" : "should-playingEntity",
            "severity" : "warning",
            "human" : "SHOULD contain playingEntity",
            "expression" : "playingEntity.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.participant.participantRole.id",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Member Identifier: This id is a unique identifier for  the covered party member. Implementers **SHOULD** use the same GUID for each instance of a member identifier from the same health plan (CONF:4537-8984).",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:4537-8922).",
        "min" : 1
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.participant.participantRole.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Relationship to Subscriber: Records the relationship of a patient to the primary insured person.",
        "comment" : "This participantRole SHALL contain exactly one [1..1] code (CONF:4537-8923).",
        "min" : 1,
        "condition" : ["4537-17139"],
        "constraint" : [
          {
            "key" : "should-code-attr",
            "severity" : "warning",
            "human" : "SHOULD contain @code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.code.code",
        "path" : "Act.participant.participantRole.code.code",
        "comment" : "This code SHOULD contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Coverage Role Type Value Set urn:oid:2.16.840.1.113883.1.11.18877 DYNAMIC (CONF:4537-16078).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.18877"
        }
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.addr",
        "path" : "Act.participant.participantRole.addr",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-8956).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.playingEntity",
        "path" : "Act.participant.participantRole.playingEntity",
        "short" : "This playingEntity records the covered party name and birthTime as represented by the health plan. This could match the information in recordTarget, or be different due to marriage or other reasons.",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] playingEntity (CONF:4537-8932)."
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.playingEntity.name",
        "path" : "Act.participant.participantRole.playingEntity.name",
        "comment" : "The playingEntity, if present, SHALL contain exactly one [1..1] name (CONF:4537-8930).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.participant:coverage-target.participantRole.playingEntity.sdtcBirthTime",
        "path" : "Act.participant.participantRole.playingEntity.sdtcBirthTime",
        "short" : "sdtc:birthTime",
        "comment" : "The playingEntity, if present, SHALL contain exactly one [1..1] sdtc:birthTime (CONF:4537-31344).",
        "min" : 1
      },
      {
        "id" : "Act.participant:subscriber",
        "path" : "Act.participant",
        "sliceName" : "subscriber",
        "short" : "When the Subscriber is the patient, the participant element describing the subscriber *SHALL NOT* be present. This information will be recorded instead in the data elements used to record member information.",
        "min" : 0,
        "max" : "1",
        "condition" : ["4537-17139"]
      },
      {
        "id" : "Act.participant:subscriber.templateId",
        "path" : "Act.participant.templateId",
        "comment" : "SHALL contain exactly one [1..1] templateId (CONF:4537-16813), SHALL not contain [0..0] extension.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.participant:subscriber.templateId.root",
        "path" : "Act.participant.templateId.root",
        "comment" : "This templateId SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.10.20.22.4.90\" Policy Holder Participant (CONF:4537-16815).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.90"
      },
      {
        "id" : "Act.participant:subscriber.templateId.extension",
        "path" : "Act.participant.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.participant:subscriber.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"HLD\" Holder (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:4537-8935).",
        "fixedCode" : "HLD"
      },
      {
        "id" : "Act.participant:subscriber.time",
        "path" : "Act.participant.time",
        "comment" : "MAY contain zero or one [0..1] time (CONF:4537-8938)."
      },
      {
        "id" : "Act.participant:subscriber.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4537-8936).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          }
        ]
      },
      {
        "id" : "Act.participant:subscriber.participantRole.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.participant.participantRole.id",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Subscriber Id: This id is a unique identifier for the subscriber of the coverage (CONF:4537-10120).",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:4537-8937).",
        "min" : 1
      },
      {
        "id" : "Act.participant:subscriber.participantRole.addr",
        "path" : "Act.participant.participantRole.addr",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-8925).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "act.moodCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Act.entryRelationship:authorization",
        "path" : "Act.entryRelationship",
        "sliceName" : "authorization",
        "short" : "entryRelationship",
        "comment" : "MAY contain one [0..*] entryRelationship (CONF:4537-8939) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:authorization.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4537-8940).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:authorization.act",
        "path" : "Act.entryRelationship.act",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:authorization.act.moodCode",
        "path" : "Act.entryRelationship.act.moodCode",
        "short" : "EVN"
      },
      {
        "id" : "Act.entryRelationship:plan",
        "path" : "Act.entryRelationship",
        "sliceName" : "plan",
        "short" : "Represents the Coverage Plan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plan.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plan.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "A description of the coverage plan **SHALL** contain one or more act/id, to represent the plan identifier, and an act/text with the name of the plan (CONF:4537-8943).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:plan.act.classCode",
        "path" : "Act.entryRelationship.act.classCode",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.entryRelationship:plan.act.moodCode",
        "path" : "Act.entryRelationship.act.moodCode",
        "fixedCode" : "DEF"
      },
      {
        "id" : "Act.entryRelationship:plan.act.id",
        "path" : "Act.entryRelationship.act.id",
        "short" : "Plan identifier",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:plan.act.text",
        "path" : "Act.entryRelationship.act.text",
        "short" : "Name of the plan",
        "min" : 1
      }
    ]
  }
}

```
