# Planned Supply - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Supply**

## Logical Model: Planned Supply 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedSupply |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.43:2024-05-01 | |

 
This template represents both medicinal and non-medicinal supplies ordered, requested, or intended for the patient (e.g., medication prescription, order for wheelchair). The importance of the supply order or request to the patient and provider may be indicated in the Priority Preference. The effectiveTime indicates the time when the supply is intended to take place and author time indicates when the documentation of the plan occurred. The Planned Supply template may also indicate the potential insurance coverage for the procedure. Depending on the type of supply, the product or participant will be either a Medication Information product (medication), an Immunization Medication Information product (immunization), or a Product Instance participant (device/equipment). 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[Indication](StructureDefinition-Indication.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[PlannedCoverage](StructureDefinition-PlannedCoverage.md),[PriorityPreference](StructureDefinition-PriorityPreference.md) 

**Usages:**

* Use this Logical Model Profile: [Nutrition Recommendation](StructureDefinition-NutritionRecommendation.md), [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md) and [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedSupply)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedSupply.csv), [Excel](StructureDefinition-PlannedSupply.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedSupply",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "supply"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.43:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedSupply",
  "title" : "Planned Supply",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents both medicinal and non-medicinal supplies ordered, requested, or intended for the patient (e.g., medication prescription, order for wheelchair). The importance of the supply order or request to the patient and provider may be indicated in the Priority Preference. \nThe effectiveTime indicates the time when the supply is intended to take place and author time indicates when the documentation of the plan occurred. The Planned Supply template may also indicate the potential insurance coverage for the procedure. \nDepending on the type of supply, the product or participant will be either a Medication Information product (medication), an Immunization Medication Information product (immunization), or a Product Instance participant (device/equipment).\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [Indication](StructureDefinition-Indication.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [PlannedCoverage](StructureDefinition-PlannedCoverage.html), [PriorityPreference](StructureDefinition-PriorityPreference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Supply",
        "path" : "Supply",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
          },
          {
            "key" : "shall-product-or-device",
            "severity" : "error",
            "human" : "The supply SHALL contain either 1 product or 1 device participant (@typeCode='DEV')",
            "expression" : "(product | participant.where(typeCode='DEV')).count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
          }
        ]
      },
      {
        "id" : "Supply.templateId",
        "path" : "Supply.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Supply.templateId:planned-supply",
        "path" : "Supply.templateId",
        "sliceName" : "planned-supply",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Supply.templateId:planned-supply.root",
        "path" : "Supply.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.43"
      },
      {
        "id" : "Supply.templateId:planned-supply.extension",
        "path" : "Supply.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Supply.classCode",
        "path" : "Supply.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SPLY\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-8577)."
      },
      {
        "id" : "Supply.moodCode",
        "path" : "Supply.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Planned moodCode (SubstanceAdministration/Supply) urn:oid:2.16.840.1.113883.11.20.9.24 STATIC 2011-09-30 (CONF:1098-8578).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.24"
        }
      },
      {
        "id" : "Supply.id",
        "path" : "Supply.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-8580).",
        "min" : 1
      },
      {
        "id" : "Supply.text",
        "path" : "Supply.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Supply.text.reference",
        "path" : "Supply.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
          }
        ]
      },
      {
        "id" : "Supply.statusCode",
        "path" : "Supply.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-30458).",
        "min" : 1
      },
      {
        "id" : "Supply.statusCode.code",
        "path" : "Supply.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-32047).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "Supply.effectiveTime",
        "path" : "Supply.effectiveTime",
        "short" : "The effectiveTime in a planned supply represents the time that the supply should occur.",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1098-30459).",
        "max" : "1",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Supply.repeatNumber",
        "path" : "Supply.repeatNumber",
        "short" : "In a Planned Supply, repeatNumber indicates the number of times the supply event can occur. For example, if a medication is filled at a pharmacy and the prescription may be refilled 3 more times, the supply RepeatNumber equals 4.",
        "comment" : "MAY contain zero or one [0..1] repeatNumber (CONF:1098-32063)."
      },
      {
        "id" : "Supply.quantity",
        "path" : "Supply.quantity",
        "comment" : "MAY contain zero or one [0..1] quantity (CONF:1098-32064)."
      },
      {
        "id" : "Supply.product",
        "path" : "Supply.product",
        "short" : "Represents either a medication or an immunization supply",
        "condition" : ["shall-product-or-device"]
      },
      {
        "id" : "Supply.product.manufacturedProduct",
        "path" : "Supply.product.manufacturedProduct",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
            ]
          }
        ]
      },
      {
        "id" : "Supply.performer",
        "path" : "Supply.performer",
        "short" : "The clinician who is expected to perform the supply could be identified using supply/performer.",
        "comment" : "MAY contain zero or more [0..*] performer (CONF:1098-32048)."
      },
      {
        "id" : "Supply.author",
        "path" : "Supply.author",
        "short" : "The author in a supply represents the clinician who is requesting or planning the supply.",
        "comment" : "SHOULD contain zero or one [0..1] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31129).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Supply.participant",
        "path" : "Supply.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "This participant represents a device that is ordered, requested or intended for the patient."
      },
      {
        "id" : "Supply.participant:productInstance",
        "path" : "Supply.participant",
        "sliceName" : "productInstance",
        "comment" : "MAY contain zero or one [0..1] participant (CONF:1098-32094) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["shall-product-or-device"]
      },
      {
        "id" : "Supply.participant:productInstance.typeCode",
        "path" : "Supply.participant.typeCode",
        "patternCode" : "DEV"
      },
      {
        "id" : "Supply.participant:productInstance.participantRole",
        "path" : "Supply.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Product Instance (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.37) (CONF:1098-32095).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance"
            ]
          }
        ]
      },
      {
        "id" : "Supply.entryRelationship",
        "path" : "Supply.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "The following entryRelationship represents the insurance coverage the patient may have for the supply."
      },
      {
        "id" : "Supply.entryRelationship:priorityPreference",
        "path" : "Supply.entryRelationship",
        "sliceName" : "priorityPreference",
        "short" : "The following entryRelationship represents the priority that a patient or a provider places on the supply.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-31110) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Supply.entryRelationship:priorityPreference.typeCode",
        "path" : "Supply.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31111).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Supply.entryRelationship:priorityPreference.observation",
        "path" : "Supply.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1098-31112).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Supply.entryRelationship:indication",
        "path" : "Supply.entryRelationship",
        "sliceName" : "indication",
        "short" : "The following entryRelationship represents the indication for the supply.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32054) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Supply.entryRelationship:indication.typeCode",
        "path" : "Supply.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has Reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32055).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Supply.entryRelationship:indication.observation",
        "path" : "Supply.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1098-32056).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "Supply.entryRelationship:instruction",
        "path" : "Supply.entryRelationship",
        "sliceName" : "instruction",
        "short" : "The following entryRelationship captures any instructions associated with the planned supply.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32057) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Supply.entryRelationship:instruction.typeCode",
        "path" : "Supply.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32058).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Supply.entryRelationship:instruction.observation",
        "path" : "Supply.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Supply.entryRelationship:plannedCoverage",
        "path" : "Supply.entryRelationship",
        "sliceName" : "plannedCoverage",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32060) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Supply.entryRelationship:plannedCoverage.typeCode",
        "path" : "Supply.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32061).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Supply.entryRelationship:plannedCoverage.act",
        "path" : "Supply.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Planned Coverage (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.129) (CONF:1098-32062).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage"
            ]
          }
        ]
      }
    ]
  }
}

```
