# Planned Procedure Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Procedure Section**

## Logical Model: Planned Procedure Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedureSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedProcedureSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.30:2014-06-09 | |

 
This section contains the procedure(s) that a clinician planned based on the preoperative assessment. 

**Usages:**

* Use this Logical Model Profile: [Operative Note](StructureDefinition-OperativeNote.md) and [Procedure Note](StructureDefinition-ProcedureNote.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedProcedureSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedProcedureSection.csv), [Excel](StructureDefinition-PlannedProcedureSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedProcedureSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedureSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.30:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedProcedureSection",
  "title" : "Planned Procedure Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section contains the procedure(s) that a clinician planned based on the preoperative assessment.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.30"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Planned procedure Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "59772-4"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "procedure"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:plannedProcedure",
        "path" : "Section.entry",
        "sliceName" : "plannedProcedure",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-8744) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:plannedProcedure.procedure",
        "path" : "Section.entry.procedure",
        "comment" : "SHALL contain exactly one [1..1] Planned Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.41:2014-06-09) (CONF:1098-15502).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
            ]
          }
        ]
      }
    ]
  }
}

```
