# Planned Procedure - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Procedure**

## Logical Model: Planned Procedure 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedProcedure |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.41:2022-06-01 | |

 
This template is used to represent ordered procedures for a patient. A procedure is an activity that is performed on, with, or for a patient as part of the provision of care. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise, etc. Procedures may be performed by a healthcare professional, a service provider, a friend or relative or in some cases by the patient themselves. 
Planned Procedure Usage Note: Common practice in the industry has shown that Planned Procedure is the usually implemented CDA template for any type of intervention or procedure regardless of if the "immediate and primary outcome (post-condition) is the alteration of the physical condition of the patient", or not. As a result, it is recommended to use Planned Procedure when sending procedures also thought of as "interventions" such as "Home Environment Evaluation" or "Assessment of nutritional status". 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[EntryReference](StructureDefinition-EntryReference.md),[Indication](StructureDefinition-Indication.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[PlannedCoverage](StructureDefinition-PlannedCoverage.md),[PriorityPreference](StructureDefinition-PriorityPreference.md) 

**Usages:**

* Use this Logical Model Profile: [Assessment and Plan Section](StructureDefinition-AssessmentandPlanSection.md), [Nutrition Recommendation](StructureDefinition-NutritionRecommendation.md), [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md), [Planned Procedure Section](StructureDefinition-PlannedProcedureSection.md) and [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedProcedure)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedProcedure.csv), [Excel](StructureDefinition-PlannedProcedure.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedProcedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "procedure"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.41:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedProcedure",
  "title" : "Planned Procedure",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template is used to represent ordered procedures for a patient. A procedure is an activity that is performed on, with, or for a patient as part of the provision of care. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise, etc. Procedures may be performed by a healthcare professional, a service provider, a friend or relative or in some cases by the patient themselves. \n\nPlanned Procedure Usage Note: Common practice in the industry has shown that Planned Procedure is the usually implemented CDA template for any type of intervention or procedure regardless of if the \"immediate and primary outcome (post-condition) is the alteration of the physical condition of the patient\", or not. As a result, it is recommended to use Planned Procedure when sending procedures also thought of as \"interventions\" such as \"Home Environment Evaluation\" or \"Assessment of nutritional status\".\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html), [EntryReference](StructureDefinition-EntryReference.html), [Indication](StructureDefinition-Indication.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [PlannedCoverage](StructureDefinition-PlannedCoverage.html), [PriorityPreference](StructureDefinition-PriorityPreference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
          },
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.templateId",
        "path" : "Procedure.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Procedure.templateId:planned-proc",
        "path" : "Procedure.templateId",
        "sliceName" : "planned-proc",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Procedure.templateId:planned-proc.root",
        "path" : "Procedure.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.41"
      },
      {
        "id" : "Procedure.templateId:planned-proc.extension",
        "path" : "Procedure.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Procedure.classCode",
        "path" : "Procedure.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"PROC\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4515-8568)."
      },
      {
        "id" : "Procedure.moodCode",
        "path" : "Procedure.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Planned moodCode (Act/Encounter/Procedure) urn:oid:2.16.840.1.113883.11.20.9.23 STATIC 2011-09-30 (CONF:4515-8569).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.23"
        }
      },
      {
        "id" : "Procedure.id",
        "path" : "Procedure.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4515-8571).",
        "min" : 1
      },
      {
        "id" : "Procedure.sdtcCategory",
        "path" : "Procedure.sdtcCategory",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-servicerequest-category"
        }
      },
      {
        "id" : "Procedure.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: SDOH Interventions",
        "comment" : "This code SHALL contain exactly one [1..1] @code, which SHOULD be selected from ValueSet US Core Procedure Codes urn:oid:2.16.840.1.113883.4.642.40.48.31 .",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1196.790",
              "documentation" : "If the Planned Intervention Procedure is a Social Determinant of Health Planned Intervention Procedure, the procedure code **SHOULD** be selected from ValueSet [Social Determinant of Health Service Request](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.790/expansion) **DYNAMIC** (CONF:4515-32993).",
              "shortDoco" : "For Social Determinant of Planned Intervention Procedure"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.17",
              "documentation" : "For common lab tests.",
              "shortDoco" : "Common Lab Tests"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.18",
              "documentation" : "For radiology.",
              "shortDoco" : "Radiology"
            },
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.19",
              "documentation" : "For clinical tests.",
              "shortDoco" : "Clinical Test"
            }
          ]
        }
      },
      {
        "id" : "Procedure.text",
        "path" : "Procedure.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Procedure.text.reference",
        "path" : "Procedure.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
          }
        ]
      },
      {
        "id" : "Procedure.statusCode",
        "path" : "Procedure.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-30446).",
        "min" : 1
      },
      {
        "id" : "Procedure.statusCode.code",
        "path" : "Procedure.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:4515-31978).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "Procedure.effectiveTime",
        "path" : "Procedure.effectiveTime",
        "short" : "The effectiveTime in a planned procedure represents the time that the procedure should occur.",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:4515-30447).",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Procedure.methodCode",
        "path" : "Procedure.methodCode",
        "short" : "In a planned procedure the provider may suggest that a procedure should be performed using a particular method. MethodCode *SHALL NOT* conflict with the method inherent in Procedure/code.",
        "comment" : "MAY contain zero or more [0..*] methodCode (CONF:4515-31980)."
      },
      {
        "id" : "Procedure.targetSiteCode",
        "path" : "Procedure.targetSiteCode",
        "short" : "The targetSiteCode is used to identify the part of the body of concern for the planned procedure.",
        "comment" : "MAY contain zero or more [0..*] targetSiteCode, which SHALL be selected from ValueSet Body Site Value Set urn:oid:2.16.840.1.113883.3.88.12.3221.8.9 DYNAMIC (CONF:4515-31981).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "Procedure.performer",
        "path" : "Procedure.performer",
        "short" : "The clinician who is expected to perform the procedure could be identified using procedure/performer.",
        "comment" : "MAY contain zero or more [0..*] performer (CONF:4515-30449)."
      },
      {
        "id" : "Procedure.author",
        "path" : "Procedure.author",
        "short" : "The author in a planned procedure represents the clinician who is requesting or planning the procedure.",
        "comment" : "SHOULD contain zero or one [0..1] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4515-31979).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Procedure.entryRelationship",
        "path" : "Procedure.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32996) such that it"
      },
      {
        "id" : "Procedure.entryRelationship:priorityPreference",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "priorityPreference",
        "short" : "The following entryRelationship represents the priority that a patient or a provider places on the procedure.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31079) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:priorityPreference.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-31080).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Procedure.entryRelationship:priorityPreference.observation",
        "path" : "Procedure.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:4515-31081).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:indication",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "indication",
        "short" : "The following entryRelationship represents the indication for the procedure.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31982) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:indication.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has Reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-31983).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Procedure.entryRelationship:indication.observation",
        "path" : "Procedure.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:4515-31984).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:instruction",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "instruction",
        "short" : "The following entryRelationship captures any instructions associated with the planned procedure.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31985) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:instruction.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-31986).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Procedure.entryRelationship:instruction.inversionInd",
        "path" : "Procedure.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:4515-31987).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Procedure.entryRelationship:instruction.observation",
        "path" : "Procedure.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:coverage",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "coverage",
        "short" : "The following entryRelationship represents the insurance coverage the patient may have for the procedure.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31990) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:coverage.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CONF:4515-31991).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Procedure.entryRelationship:coverage.act",
        "path" : "Procedure.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Planned Coverage (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.129) (CONF:4515-31992).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScale",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "assessmentScale",
        "short" : "When an Assessment Scale Observation is contained in a Procedure Template instance that is a Social Determinant of Health procedure, that Assessment scale **MAY** contain Assessment Scale observations that represent LOINC question and answer pairs from SDOH screening instruments.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32994) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScale.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32998).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Procedure.entryRelationship:assessmentScale.observation",
        "path" : "Procedure.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.69) (CONF:4515-32995).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.entryRelationship:entryReference",
        "path" : "Procedure.entryRelationship",
        "sliceName" : "entryReference",
        "short" : "When an Entry Reference Template is contained in a Procedure Template instance that is a Social Determinant of Health procedure, that Entry Reference **MAY** refer to Assessment Scale Observation in the same document that represent LOINC question and answer pairs from SDOH screening instruments.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Procedure.entryRelationship:entryReference.typeCode",
        "path" : "Procedure.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has reason (CONF:4515-32999).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Procedure.entryRelationship:entryReference.act",
        "path" : "Procedure.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32997).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      }
    ]
  }
}

```
