# Planned Encounter - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Encounter**

## Logical Model: Planned Encounter 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedEncounter |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.40:2014-06-09 | |

 
This template represents a planned or ordered encounter. The type of encounter (e.g., comprehensive outpatient visit) is represented. Clinicians participating in the encounter and the location of the planned encounter may be captured. The priority that the patient and providers place on the encounter may be represented. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[Indication](StructureDefinition-Indication.md),[InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.md),[PriorityPreference](StructureDefinition-PriorityPreference.md) 

**Usages:**

* Use this Logical Model Profile: [Nutrition Recommendation](StructureDefinition-NutritionRecommendation.md), [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md) and [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedEncounter)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedEncounter.csv), [Excel](StructureDefinition-PlannedEncounter.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedEncounter",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "encounter"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.40:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedEncounter",
  "title" : "Planned Encounter",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a planned or ordered encounter. The type of encounter (e.g., comprehensive outpatient visit) is represented. Clinicians participating in the encounter and the location of the planned encounter may be captured. The priority that the patient and providers place on the encounter may be represented.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [Indication](StructureDefinition-Indication.html), [InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.html), [PriorityPreference](StructureDefinition-PriorityPreference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
          },
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
          }
        ]
      },
      {
        "id" : "Encounter.templateId",
        "path" : "Encounter.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Encounter.templateId:planned-enc",
        "path" : "Encounter.templateId",
        "sliceName" : "planned-enc",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Encounter.templateId:planned-enc.root",
        "path" : "Encounter.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.40"
      },
      {
        "id" : "Encounter.templateId:planned-enc.extension",
        "path" : "Encounter.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Encounter.classCode",
        "path" : "Encounter.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ENC\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-8564)."
      },
      {
        "id" : "Encounter.moodCode",
        "path" : "Encounter.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Planned moodCode (Act/Encounter/Procedure) urn:oid:2.16.840.1.113883.11.20.9.23 STATIC 2014-09-01 (CONF:1098-8565).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.23"
        }
      },
      {
        "id" : "Encounter.id",
        "path" : "Encounter.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-8567).",
        "min" : 1
      },
      {
        "id" : "Encounter.code",
        "path" : "Encounter.code",
        "short" : "Records the type of encounter ordered or recommended.",
        "comment" : "SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Encounter Planned urn:oid:2.16.840.1.113883.11.20.9.52 DYNAMIC (CONF:1098-31032).",
        "condition" : ["should-code"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.23"
        }
      },
      {
        "id" : "Encounter.text",
        "path" : "Encounter.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Encounter.text.reference",
        "path" : "Encounter.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
          }
        ]
      },
      {
        "id" : "Encounter.statusCode",
        "path" : "Encounter.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-30439).",
        "min" : 1
      },
      {
        "id" : "Encounter.statusCode.code",
        "path" : "Encounter.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31880).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "Encounter.effectiveTime",
        "path" : "Encounter.effectiveTime",
        "short" : "SHOULD contain effectiveTime",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1098-30440).",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Encounter.performer",
        "path" : "Encounter.performer",
        "short" : "Performers represent clinicians who are responsible for assessing and treating the patient.",
        "comment" : "MAY contain zero or more [0..*] performer (CONF:1098-30442) such that it"
      },
      {
        "id" : "Encounter.performer.assignedEntity",
        "path" : "Encounter.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1098-31874)."
      },
      {
        "id" : "Encounter.author",
        "path" : "Encounter.author",
        "short" : "The author in a planned encounter represents the clinician who is requesting or planning the encounter.",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-32045).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "This location participation captures where the planned or ordered encounter may take place."
      },
      {
        "id" : "Encounter.participant:location",
        "path" : "Encounter.participant",
        "sliceName" : "location",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1098-30443) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:location.typeCode",
        "path" : "Encounter.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"LOC\" Location (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1098-31875).",
        "fixedCode" : "LOC"
      },
      {
        "id" : "Encounter.participant:location.participantRole",
        "path" : "Encounter.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Service Delivery Location (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.32) (CONF:1098-31876).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.entryRelationship",
        "path" : "Encounter.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "The following entryRelationship captures the reason for the planned or ordered encounter"
      },
      {
        "id" : "Encounter.entryRelationship:priorityPreference",
        "path" : "Encounter.entryRelationship",
        "sliceName" : "priorityPreference",
        "short" : "The following entryRelationship represents the priority that a patient or a provider places on the encounter.",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1098-31033) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Encounter.entryRelationship:priorityPreference.typeCode",
        "path" : "Encounter.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31034).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Encounter.entryRelationship:priorityPreference.observation",
        "path" : "Encounter.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1098-31035).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.entryRelationship:indication",
        "path" : "Encounter.entryRelationship",
        "sliceName" : "indication",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-31877) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.entryRelationship:indication.typeCode",
        "path" : "Encounter.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has Reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31878).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Encounter.entryRelationship:indication.observation",
        "path" : "Encounter.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1098-31879).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "Encounter.entryRelationship:observation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.entryRelationship",
        "sliceName" : "observation",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Interpreter Needed Observation",
        "comment" : "SHALL contain exactly one [1..1] Interpreter Needed Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.515:2025-05-01).",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.entryRelationship:observation.observation",
        "path" : "Encounter.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
