# Physical Exam Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Physical Exam Section**

## Logical Model: Physical Exam Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PhysicalExamSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.2.10:2015-08-01 | |

 
The section includes direct observations made by a clinician. The examination may include the use of simple instruments and may also describe simple maneuvers performed directly on the patient's body. 
It also includes observations made by the examining clinician using only inspection, palpation, auscultation, and percussion. It does not include laboratory or imaging findings. 
The exam may be limited to pertinent body systems based on the patient's chief complaint or it may include a comprehensive examination. The examination may be reported as a collection of random clinical statements or it may be reported categorically. 
The Physical Exam Section may contain multiple nested subsections. 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [History and Physical](StructureDefinition-HistoryandPhysical.md), [Procedure Note](StructureDefinition-ProcedureNote.md), [Progress Note](StructureDefinition-ProgressNote.md)...Show 2 more,[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PhysicalExamSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PhysicalExamSection.csv), [Excel](StructureDefinition-PhysicalExamSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PhysicalExamSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.2.10:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PhysicalExamSection",
  "title" : "Physical Exam Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The section includes direct observations made by a clinician. The examination may include the use of simple instruments and may also describe simple maneuvers performed directly on the patient's body.\n\nIt also includes observations made by the examining clinician using only inspection, palpation, auscultation, and percussion. It does not include laboratory or imaging findings.\n\nThe exam may be limited to pertinent body systems based on the patient's chief complaint or it may include a comprehensive examination. The examination may be reported as a collection of random clinical statements or it may be reported categorically.\n\nThe Physical Exam Section may contain multiple nested subsections.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.2.10"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Physical findings Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "29545-1"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:longCareWound",
        "path" : "Section.entry",
        "sliceName" : "longCareWound",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-31926) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:longCareWound.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Longitudinal Care Wound Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.114:2015-08-01) (CONF:1198-31927).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.component",
        "path" : "Section.component",
        "comment" : "MAY contain zero or more [0..*] component (CONF:1198-32434) such that it"
      },
      {
        "id" : "Section.component.section",
        "path" : "Section.component.section",
        "comment" : "SHALL contain exactly one [1..1] section (CONF:1198-32435)."
      },
      {
        "id" : "Section.component.section.code",
        "path" : "Section.component.section.code",
        "comment" : "This section SHALL contain exactly one [1..1] code, which SHOULD be selected from ValueSet Physical Exam Type urn:oid:2.16.840.1.113883.11.20.9.65 DYNAMIC (CONF:1198-32436).",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.65"
        }
      },
      {
        "id" : "Section.component.section.title",
        "path" : "Section.component.section.title",
        "comment" : "This section SHALL contain exactly one [1..1] title (CONF:1198-32437).",
        "min" : 1
      },
      {
        "id" : "Section.component.section.text",
        "path" : "Section.component.section.text",
        "comment" : "This section SHALL contain exactly one [1..1] text (CONF:1198-32438).",
        "min" : 1
      }
    ]
  }
}

```
