# Operative Note - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Operative Note**

## Logical Model: Operative Note 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:OperativeNote |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.7:2024-05-01 | |

 
The Operative Note is a frequently used type of procedure note with specific requirements set forth by regulatory agencies. 
The Operative Note is created immediately following a surgical or other high-risk procedure. It records the pre- and post-surgical diagnosis, pertinent events of the procedure, as well as the condition of the patient following the procedure. The report should be sufficiently detailed to support the diagnoses, justify the treatment, document the course of the procedure, and provide continuity of care. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [AnesthesiaSection](StructureDefinition-AnesthesiaSection.md)
* [ComplicationsSection](StructureDefinition-ComplicationsSection.md)
* [PreoperativeDiagnosisSection](StructureDefinition-PreoperativeDiagnosisSection.md)
* [ProcedureEstimatedBloodLossSection](StructureDefinition-ProcedureEstimatedBloodLossSection.md)
* [ProcedureFindingsSection](StructureDefinition-ProcedureFindingsSection.md)
* [ProcedureSpecimensTakenSection](StructureDefinition-ProcedureSpecimensTakenSection.md)
* [ProcedureDescriptionSection](StructureDefinition-ProcedureDescriptionSection.md)
* [PostoperativeDiagnosisSection](StructureDefinition-PostoperativeDiagnosisSection.md)
 
**Additional Sections** 
* [ProcedureImplantsSection](StructureDefinition-ProcedureImplantsSection.md)
* [OperativeNoteFluidsSection](StructureDefinition-OperativeNoteFluidsSection.md)
* [OperativeNoteSurgicalProcedureSection](StructureDefinition-OperativeNoteSurgicalProcedureSection.md)
* [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [PlannedProcedureSection](StructureDefinition-PlannedProcedureSection.md)
* [ProcedureDispositionSection](StructureDefinition-ProcedureDispositionSection.md)
* [ProcedureIndicationsSection](StructureDefinition-ProcedureIndicationsSection.md)
* [SurgicalDrainsSection](StructureDefinition-SurgicalDrainsSection.md)
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/OperativeNote)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-OperativeNote.csv), [Excel](StructureDefinition-OperativeNote.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OperativeNote",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.7:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "OperativeNote",
  "title" : "Operative Note",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Operative Note is a frequently used type of procedure note with specific requirements set forth by regulatory agencies. \n\nThe Operative Note is created immediately following a surgical or other high-risk procedure. It records the pre- and post-surgical diagnosis, pertinent events of the procedure, as well as the condition of the patient following the procedure. The report should be sufficiently detailed to support the diagnoses, justify the treatment, document the course of the procedure, and provide continuity of care.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [AnesthesiaSection](StructureDefinition-AnesthesiaSection.html)\n- [ComplicationsSection](StructureDefinition-ComplicationsSection.html)\n- [PreoperativeDiagnosisSection](StructureDefinition-PreoperativeDiagnosisSection.html)\n- [ProcedureEstimatedBloodLossSection](StructureDefinition-ProcedureEstimatedBloodLossSection.html)\n- [ProcedureFindingsSection](StructureDefinition-ProcedureFindingsSection.html)\n- [ProcedureSpecimensTakenSection](StructureDefinition-ProcedureSpecimensTakenSection.html)\n- [ProcedureDescriptionSection](StructureDefinition-ProcedureDescriptionSection.html)\n- [PostoperativeDiagnosisSection](StructureDefinition-PostoperativeDiagnosisSection.html)\n\n**Additional Sections**\n- [ProcedureImplantsSection](StructureDefinition-ProcedureImplantsSection.html)\n- [OperativeNoteFluidsSection](StructureDefinition-OperativeNoteFluidsSection.html)\n- [OperativeNoteSurgicalProcedureSection](StructureDefinition-OperativeNoteSurgicalProcedureSection.html)\n- [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [PlannedProcedureSection](StructureDefinition-PlannedProcedureSection.html)\n- [ProcedureDispositionSection](StructureDefinition-ProcedureDispositionSection.html)\n- [ProcedureIndicationsSection](StructureDefinition-ProcedureIndicationsSection.html)\n- [SurgicalDrainsSection](StructureDefinition-SurgicalDrainsSection.html)\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          },
          {
            "key" : "category-11504-8",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '11504-8'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '11504-8' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:operative-note",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "operative-note",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:operative-note.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.7"
      },
      {
        "id" : "ClinicalDocument.templateId:operative-note.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as an Operative Note. If present, there SHALL be a category of 11504-8 (Surgical operation note).",
        "condition" : ["should-sdtcCategory", "category-11504-8"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Surgical operation note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "11504-8"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The Operative Note recommends use of a single document type code, 11504-8 \"Surgical operation note\", with further specification provided by author or performer, setting, or specialty data in the CDA header. Some of the LOINC codes in the Surgical Operation Note Document Type Code table are pre-coordinated with the practice setting or the training or professional level of the author. Use of pre-coordinated codes is not recommended because of potential conflict with other information in the header. When these codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type.",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-17187).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.1.1"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "short" : "A serviceEvent represents the main act, such as a colonoscopy or an appendectomy, being documented. A serviceEvent can further specialize the act inherent in the ClinicalDocument/code, such as where the ClinicalDocument/code is simply \"Surgical Operation Note\" and the procedure is \"Appendectomy.\" serviceEvent is required in the Operative Note and it must be equivalent to or further specialize the value inherent in the ClinicalDocument/code; it shall not conflict with the value inherent in the ClinicalDocument/code, as such a conflict would create ambiguity. serviceEvent/effectiveTime can be used to indicate the time the actual event (as opposed to the encounter surrounding the event) took place. If the date and the duration of the procedure is known, serviceEvent/effectiveTime/low is used with a width element that describes the duration; no high element is used. However, if only the date is known, the date is placed in both the low and high elements.",
        "comment" : "SHALL contain at least one [1..*] documentationOf (CONF:1198-8486).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "comment" : "Such documentationOfs SHALL contain exactly one [1..1] serviceEvent (CONF:1198-8493)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.code",
        "comment" : "SHALL contain exactly one [1..1] code.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "1198-8487",
            "severity" : "error",
            "human" : "The value of Clinical Document /documentationOf/serviceEvent/code SHALL be from ICD-9-CM Procedures (codeSystem 2.16.840.1.113883.6.104), ICD-10-PCS (codeSystem 2.16.840.1.113883.6.4), CPT (codeSystem 2.16.840.1.113883.6.12), or values descending from 71388002 (Procedure) from the SNOMED CT (codeSystem 2.16.840.1.113883.6.96) ValueSet 2.16.840.1.113883.3.88.12.80.28 Procedure DYNAMIC (CONF:1198-8487).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.104' or codeSystem = '2.16.840.1.113883.6.4' or codeSystem = '2.16.840.1.113883.6.12' or (codeSystem = '2.16.840.1.113883.6.96' and code.memberOf('http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.28'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "The value of Clinical Document /documentationOf/serviceEvent/code SHALL be from ICD-9-CM Procedures (codeSystem 2.16.840.1.113883.6.104), ICD-10-PCS (codeSystem 2.16.840.1.113883.6.4), CPT (codeSystem 2.16.840.1.113883.6.12), or values descending from 71388002 (Procedure) from the SNOMED CT (codeSystem 2.16.840.1.113883.6.96) ValueSet 2.16.840.1.113883.3.88.12.80.28 Procedure DYNAMIC (CONF:1198-8487).",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.28",
              "documentation" : "The value of Clinical Document /documentationOf/serviceEvent/code SHALL be from ICD-9-CM Procedures (codeSystem 2.16.840.1.113883.6.104), ICD-10-PCS (codeSystem 2.16.840.1.113883.6.4), CPT (codeSystem 2.16.840.1.113883.6.12), or values descending from 71388002 (Procedure) from the SNOMED CT (codeSystem 2.16.840.1.113883.6.96) ValueSet 2.16.840.1.113883.3.88.12.80.28 Procedure DYNAMIC (CONF:1198-8487).",
              "shortDoco" : "Allowed SNOMED Codes"
            }
          ]
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:1198-8494).",
        "constraint" : [
          {
            "key" : "width-or-high",
            "severity" : "error",
            "human" : "Width and high are mutually exclusive. If width is known, high **SHALL NOT** be present. If with is not present, **SHALL** include high.",
            "expression" : "(width | high).count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "short" : "Low is required",
        "comment" : "The serviceEvent/effectiveTime **SHALL** be present with effectiveTime/low (CONF:1198-8488)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.width",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.width",
        "short" : "Represents the duration",
        "comment" : "When only the date and the length of the procedure are known a width element **SHALL** be present and the serviceEvent/effectiveTime/high **SHALL NOT** be present (CONF:1198-10060)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "short" : "Equals low if only the date is known",
        "comment" : "If a width is not present, the serviceEvent/effectiveTime **SHALL** include effectiveTime/high (CONF:1198-10058)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "sliceName" : "primary",
        "short" : "This performer represents clinicians who actually and principally carry out the serviceEvent. Typically, these are clinicians who have surgical privileges in their institutions such as Surgeons, Obstetrician/Gynecologists, and Family Practice Physicians. The performer may also be non-physician providers (NPPs) who have surgical privileges. There may be more than one primary performer in the case of complicated surgeries. There are occasionally co-surgeons. Usually they will be billing separately and will each dictate their own notes. An example may be spinal surgery , where a general surgeon and an orthopedic surgeon both are present and billing off the same Current Procedural Terminology (CPT) codes. Typically two Operative Notes are generated; however, each will list the other as a co-surgeon. Any assistants are identified as a secondary performer (SPRF) in a second performer participant.",
        "comment" : "This serviceEvent SHALL contain one or more [1..*] performer (CONF:1198-8489) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"PPRF\" Primary performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8495).",
        "fixedCode" : "PPRF"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.functionCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "comment" : "MAY contain zero or one [0..1] functionCode, which SHOULD be selected from ValueSet Care Team Member Function urn:oid:2.16.840.1.113762.1.4.1099.30 DYNAMIC (CONF:1198-32963).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1198-10917).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:primary.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code, which SHALL be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-8490).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "sliceName" : "secondary",
        "short" : "This performer represents any assistants",
        "comment" : "This serviceEvent MAY contain zero or more [0..*] performer (CONF:1198-32736) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRF\" Secondary performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-32738).",
        "fixedCode" : "SPRF"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.functionCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "comment" : "MAY contain zero or one [0..1] functionCode, which SHOULD be selected from ValueSet Care Team Member Function urn:oid:2.16.840.1.113762.1.4.1099.30 DYNAMIC (CONF:1198-32964).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32737).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer:secondary.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code, which SHALL be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-32739).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.authorization",
        "path" : "ClinicalDocument.authorization",
        "short" : "Authorization represents consent. Consent, if present, shall be represented by authorization/consent.",
        "comment" : "MAY contain zero or one [0..1] authorization (CONF:1198-32404).",
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.authorization.typeCode",
        "path" : "ClinicalDocument.authorization.typeCode",
        "comment" : "The authorization, if present, SHALL contain exactly one [1..1] @typeCode=\"AUTH\" authorized by (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32408).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authorization.consent",
        "path" : "ClinicalDocument.authorization.consent",
        "comment" : "The authorization, if present, SHALL contain exactly one [1..1] consent (CONF:1198-32405)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.classCode",
        "path" : "ClinicalDocument.authorization.consent.classCode",
        "comment" : "This consent SHALL contain exactly one [1..1] @classCode=\"CONS\" consent (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-32409).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authorization.consent.moodCode",
        "path" : "ClinicalDocument.authorization.consent.moodCode",
        "comment" : "This consent SHALL contain exactly one [1..1] @moodCode=\"EVN\" event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1198-32410).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authorization.consent.statusCode",
        "path" : "ClinicalDocument.authorization.consent.statusCode",
        "comment" : "This consent SHALL contain exactly one [1..1] statusCode (CONF:1198-32411)."
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-9585)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-30485).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 8
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:anesthesia",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "anesthesia",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30486).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:anesthesia.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "This component SHALL contain exactly one [1..1] Anesthesia Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.25:2014-06-09) (CONF:1198-30487).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AnesthesiaSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:complications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "complications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30488) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:complications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Complications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.37:2024-05-01) (CONF:1198-30489).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ComplicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:preopDx",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "preopDx",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30490) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:preopDx.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Preoperative Diagnosis Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.34:2024-05-01) (CONF:1198-30491).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:estBloodLoss",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "estBloodLoss",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30492) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:estBloodLoss.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Estimated Blood Loss Section (identifier: urn:oid:2.16.840.1.113883.10.20.18.2.9) (CONF:1198-30493).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureEstimatedBloodLossSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:findings",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "findings",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30494) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:findings.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Findings Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.28:2024-05-01) (CONF:1198-30495).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureFindingsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:specimensTaken",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "specimensTaken",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30496) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:specimensTaken.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Specimens Taken Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.31) (CONF:1198-30497).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureSpecimensTakenSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedureDescription",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedureDescription",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30498) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedureDescription.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Description Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.27) (CONF:1198-30499).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDescriptionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:postopDx",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "postopDx",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30500) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:postopDx.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Postoperative Diagnosis Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.35) (CONF:1198-30501).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PostoperativeDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:implants",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "implants",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30502) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:implants.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Implants Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.40) (CONF:1198-30503).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureImplantsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:fluids",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "fluids",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30504) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:fluids.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Operative Note Fluids Section (identifier: urn:oid:2.16.840.1.113883.10.20.7.12) (CONF:1198-30505).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNoteFluidsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:surgicalProcedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "surgicalProcedures",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30506) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:surgicalProcedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Operative Note Surgical Procedure Section (identifier: urn:oid:2.16.840.1.113883.10.20.7.14) (CONF:1198-30507).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNoteSurgicalProcedureSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30508) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-30509).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:plannedProcedure",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "plannedProcedure",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30510) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:plannedProcedure.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Planned Procedure Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.30:2014-06-09) (CONF:1198-30511).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedureSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:disposition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "disposition",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30512) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:disposition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Disposition Section (identifier: urn:oid:2.16.840.1.113883.10.20.18.2.12) (CONF:1198-30513).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDispositionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:indications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "indications",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30514) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:indications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedure Indications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.29:2014-06-09) (CONF:1198-30515).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureIndicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:surgicalDrains",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "surgicalDrains",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30516) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:surgicalDrains.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Surgical Drains Section (identifier: urn:oid:2.16.840.1.113883.10.20.7.13) (CONF:1198-30517).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SurgicalDrainsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28942) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      }
    ]
  }
}

```
