# Mental Status Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mental Status Section**

## Logical Model: Mental Status Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MentalStatusSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.56:2015-08-01 | |

 
The Mental Status Section contains observations and evaluations related to a patient's psychological and mental competency and deficits. These may include, but are not limited to any of the following types of information: 
* Appearance (e.g., unusual grooming, clothing or body modifications)
* Attitude (e.g., cooperative, guarded, hostile)
* Behavior/psychomotor (e.g., abnormal movements, eye contact, tics)
* Mood and affect (e.g., anxious, angry, euphoric)
* Speech and Language (e.g., pressured speech, perseveration)
* Thought process (e.g., logic, coherence)
* Thought content (e.g., delusions, phobias)
* Perception (e.g., voices, hallucinations)
* Cognition (e.g., memory, alertness/consciousness, attention, orientation) which were included in Cognitive Status Observation in earlier publications of C-CDA.
* Insight and judgment (e.g., understanding of condition, decision making)
 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Progress Note](StructureDefinition-ProgressNote.md), [Referral Note](StructureDefinition-ReferralNote.md) and [Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MentalStatusSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MentalStatusSection.csv), [Excel](StructureDefinition-MentalStatusSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MentalStatusSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.56:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MentalStatusSection",
  "title" : "Mental Status Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Mental Status Section contains observations and evaluations related to a patient's psychological and mental competency and deficits. These may include, but are not limited to any of the following types of information:\n*  Appearance (e.g., unusual grooming, clothing or body modifications)\n*  Attitude (e.g., cooperative, guarded, hostile)\n*  Behavior/psychomotor (e.g., abnormal movements, eye contact, tics)\n*  Mood and affect (e.g., anxious, angry, euphoric)\n*  Speech and Language (e.g., pressured speech, perseveration)\n*  Thought process (e.g., logic, coherence)\n*  Thought content (e.g., delusions, phobias)\n*  Perception (e.g., voices, hallucinations)\n*  Cognition (e.g., memory, alertness/consciousness, attention, orientation)  which were included in Cognitive Status Observation in earlier publications of C-CDA.\n*  Insight and judgment (e.g., understanding of condition, decision making)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.56"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Mental status Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "10190-7"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "organizer"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:mentalStatusOrganizer",
        "path" : "Section.entry",
        "sliceName" : "mentalStatusOrganizer",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-28301) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:mentalStatusOrganizer.organizer",
        "path" : "Section.entry.organizer",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Organizer (identifier: urn:hl7ii:2.\n                16.840.1.113883.10.20.22.4.75:2015-08-01) (CONF:1198-28302).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusOrganizer"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:mentalStatusObs",
        "path" : "Section.entry",
        "sliceName" : "mentalStatusObs",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-28305) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:mentalStatusObs.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Observation (identifier: urn:hl7ii:\n                2.16.840.1.113883.10.20.22.4.74:2015-08-01) (CONF:1198-28306).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:assessmentScale",
        "path" : "Section.entry",
        "sliceName" : "assessmentScale",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-28313) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:assessmentScale.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: urn:oid:2.16\n                .840.1.113883.10.20.22.4.69) (CONF:1198-28314).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
