# Medication Free Text Sig - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Free Text Sig**

## Logical Model: Medication Free Text Sig 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MedicationFreeTextSig |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.147 | |

 
The template is available to explicitly identify the free text Sig within each medication. 
An example free text sig: Thyroxin 150 ug, take one tab by mouth every morning. 
NOTE: This is a Closed template so only the elements needed for the template are allowed. All other elements are not allowed. 

**Usages:**

* Use this Logical Model Profile: [Medication Activity](StructureDefinition-MedicationActivity.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MedicationFreeTextSig)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationFreeTextSig.csv), [Excel](StructureDefinition-MedicationFreeTextSig.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationFreeTextSig",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "substanceAdministration"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.147"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MedicationFreeTextSig",
  "title" : "Medication Free Text Sig",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The template is available to explicitly identify the free text Sig within each medication. \n\nAn example free text sig: Thyroxin 150 ug, take one tab by mouth every morning.\n\nNOTE: This is a Closed template so only the elements needed for the template are allowed.  All other elements are not allowed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "SubstanceAdministration",
        "path" : "SubstanceAdministration",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.typeId",
        "path" : "SubstanceAdministration.typeId",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.templateId",
        "path" : "SubstanceAdministration.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.templateId:med-freeTextSig",
        "path" : "SubstanceAdministration.templateId",
        "sliceName" : "med-freeTextSig",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.templateId:med-freeTextSig.root",
        "path" : "SubstanceAdministration.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.147"
      },
      {
        "id" : "SubstanceAdministration.templateId:med-freeTextSig.extension",
        "path" : "SubstanceAdministration.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.classCode",
        "path" : "SubstanceAdministration.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SBADM\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:81-32770)."
      },
      {
        "id" : "SubstanceAdministration.moodCode",
        "path" : "SubstanceAdministration.moodCode",
        "short" : "moodCode must match the parent substanceAdministration EVN or INT",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet MoodCodeEvnInt urn:oid:2.16.840.1.113883.11.20.9.18 STATIC 2011-04-03 (CONF:81-32771).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.18"
        }
      },
      {
        "id" : "SubstanceAdministration.code",
        "path" : "SubstanceAdministration.code",
        "short" : "Instructions Medication Narrative",
        "comment" : "SHALL contain exactly one [1..1] code (CodeSystem: LOINC urn:oid:2.16.840.1.113883.6.1) (CONF:81-32775).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.code.code",
        "path" : "SubstanceAdministration.code.code",
        "min" : 1,
        "patternCode" : "76662-6"
      },
      {
        "id" : "SubstanceAdministration.code.codeSystem",
        "path" : "SubstanceAdministration.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "SubstanceAdministration.text",
        "path" : "SubstanceAdministration.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "comment" : "SHALL contain exactly one [1..1] text (CONF:81-32754).",
        "min" : 1,
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "SubstanceAdministration.text.reference",
        "path" : "SubstanceAdministration.text.reference",
        "short" : "Reference into the section/text to a tag that only contains free text sig.",
        "comment" : "This text SHALL contain exactly one [1..1] reference (CONF:81-32755).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.text.reference.value",
        "path" : "SubstanceAdministration.text.reference.value",
        "comment" : "This reference SHOULD contain zero or one [0..1] @value (CONF:81-32756)."
      },
      {
        "id" : "SubstanceAdministration.statusCode",
        "path" : "SubstanceAdministration.statusCode",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.effectiveTime",
        "path" : "SubstanceAdministration.effectiveTime",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.priorityCode",
        "path" : "SubstanceAdministration.priorityCode",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.repeatNumber",
        "path" : "SubstanceAdministration.repeatNumber",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.routeCode",
        "path" : "SubstanceAdministration.routeCode",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.approachSiteCode",
        "path" : "SubstanceAdministration.approachSiteCode",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.doseQuantity",
        "path" : "SubstanceAdministration.doseQuantity",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.rateQuantity",
        "path" : "SubstanceAdministration.rateQuantity",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.maxDoseQuantity",
        "path" : "SubstanceAdministration.maxDoseQuantity",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.administrationUnitCode",
        "path" : "SubstanceAdministration.administrationUnitCode",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.consumable",
        "path" : "SubstanceAdministration.consumable",
        "comment" : "SHALL contain exactly one [1..1] consumable (CONF:81-32776)."
      },
      {
        "id" : "SubstanceAdministration.consumable.manufacturedProduct",
        "path" : "SubstanceAdministration.consumable.manufacturedProduct",
        "comment" : "This consumable SHALL contain exactly one [1..1] manufacturedProduct (CONF:81-32777)."
      },
      {
        "id" : "SubstanceAdministration.consumable.manufacturedProduct.manufacturedLabeledDrug",
        "path" : "SubstanceAdministration.consumable.manufacturedProduct.manufacturedLabeledDrug",
        "comment" : "This manufacturedProduct SHALL contain exactly one [1..1] manufacturedLabeledDrug (CONF:81-32778).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.consumable.manufacturedProduct.manufacturedLabeledDrug.nullFlavor",
        "path" : "SubstanceAdministration.consumable.manufacturedProduct.manufacturedLabeledDrug.nullFlavor",
        "comment" : "This manufacturedLabeledDrug SHALL contain exactly one [1..1] @nullFlavor=\"NA\" Not Applicable (CONF:81-32779).",
        "min" : 1,
        "fixedCode" : "NA"
      },
      {
        "id" : "SubstanceAdministration.subject",
        "path" : "SubstanceAdministration.subject",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.specimen",
        "path" : "SubstanceAdministration.specimen",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.performer",
        "path" : "SubstanceAdministration.performer",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.informant",
        "path" : "SubstanceAdministration.informant",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.participant",
        "path" : "SubstanceAdministration.participant",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship",
        "path" : "SubstanceAdministration.entryRelationship",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.precondition",
        "path" : "SubstanceAdministration.precondition",
        "max" : "0"
      }
    ]
  }
}

```
