# Medical Equipment Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medical Equipment Section**

## Logical Model: Medical Equipment Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MedicalEquipmentSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.23:2014-06-09 | |

 
This section defines a patient's implanted and external health and medical devices and equipment. This section lists any pertinent durable medical equipment (DME) used to help maintain the patient's health status. All equipment relevant to the diagnosis, care, or treatment of a patient should be included. 
Devices applied to, or placed in, the patient are represented with the Procedure Activity Procedure template. Equipment supplied to the patient (e.g., pumps, inhalers, wheelchairs) is represented by the Non-Medicinal Supply Activity template. 
These devices may be grouped together within a Medical Equipment Organizer. The organizer would probably not be used with devices applied in or on the patient but rather to organize a group of medical supplies the patient has been supplied with. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Recommended Entries**:[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) 
**Optional Entries**:[MedicalEquipmentOrganizer](StructureDefinition-MedicalEquipmentOrganizer.md) 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Referral Note](StructureDefinition-ReferralNote.md) and [Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MedicalEquipmentSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MedicalEquipmentSection.csv), [Excel](StructureDefinition-MedicalEquipmentSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicalEquipmentSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.23:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MedicalEquipmentSection",
  "title" : "Medical Equipment Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section defines a patient's implanted and external health and medical devices and equipment. This section lists any pertinent durable medical equipment (DME) used to help maintain the patient's health status. All equipment relevant to the diagnosis, care, or treatment of a patient should be included. \n\nDevices applied to, or placed in, the patient are represented with the Procedure Activity Procedure template. Equipment supplied to the patient (e.g., pumps, inhalers, wheelchairs) is represented by the Non-Medicinal Supply Activity template. \n\nThese devices may be grouped together within a Medical Equipment Organizer. The organizer would probably not be used with devices applied in or on the patient but rather to organize a group of medical supplies the patient has been supplied with.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Recommended Entries**: [NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.html), [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.html)\n\n**Optional Entries**: [MedicalEquipmentOrganizer](StructureDefinition-MedicalEquipmentOrganizer.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-non-med-supply",
            "severity" : "warning",
            "human" : "SHOULD contain Non-Medicinal Supply Activity",
            "expression" : "entry.where(supply.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/NonMedicinalSupplyActivity'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
          },
          {
            "key" : "should-procedure-act-procedure",
            "severity" : "warning",
            "human" : "SHOULD contain Procedure Activity Procedure",
            "expression" : "entry.where(procedure.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.23"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "History of medical device use",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "46264-8"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "organizer"
            },
            {
              "type" : "profile",
              "path" : "procedure"
            },
            {
              "type" : "profile",
              "path" : "supply"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:medicalEquip",
        "path" : "Section.entry",
        "sliceName" : "medicalEquip",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-7948) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:medicalEquip.organizer",
        "path" : "Section.entry.organizer",
        "comment" : "SHALL contain exactly one [1..1] Medical Equipment Organizer (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.135) (CONF:1098-30351).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentOrganizer"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:nonMedSupply",
        "path" : "Section.entry",
        "sliceName" : "nonMedSupply",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1098-31125) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-non-med-supply"]
      },
      {
        "id" : "Section.entry:nonMedSupply.supply",
        "path" : "Section.entry.supply",
        "comment" : "SHALL contain exactly one [1..1] Non-Medicinal Supply Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.50:2014-06-09) (CONF:1098-31861).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NonMedicinalSupplyActivity"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:procedure",
        "path" : "Section.entry",
        "sliceName" : "procedure",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1098-31885) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-procedure-act-procedure"]
      },
      {
        "id" : "Section.entry:procedure.procedure",
        "path" : "Section.entry.procedure",
        "comment" : "SHALL contain exactly one [1..1] Procedure Activity Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.14:2014-06-09) (CONF:1098-31886).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
            ]
          }
        ]
      }
    ]
  }
}

```
