# Intervention Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Intervention Act**

## Logical Model: Intervention Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:InterventionAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.131:2015-08-01 | |

 
This template represents an Intervention Act. It is a wrapper for intervention-type activities considered to be parts of the same intervention. For example, an activity such as "elevate head of bed" combined with "provide humidified O2 per nasal cannula" may be the interventions performed for a health concern of "respiratory insufficiency" to achieve a goal of "pulse oximetry greater than 92%". These intervention activities may be newly described or derived from a variety of sources within an EHR. 
Interventions are actions taken to increase the likelihood of achieving the patient's or providers' goals. An Intervention Act should contain a reference to a Goal Observation representing the reason for the intervention. 
Intervention Acts can be related to each other, or to Planned Intervention Acts. (E.g., a Planned Intervention Act with moodCode of INT could be related to a series of Intervention Acts with moodCode of EVN, each having an effectiveTime containing the time of the intervention.) 
All interventions referenced in an Intervention Act must have a moodCode of EVN, indicating that they have occurred. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md),[EncounterActivity](StructureDefinition-EncounterActivity.md),[EntryReference](StructureDefinition-EntryReference.md),[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md),[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[InterventionAct](StructureDefinition-InterventionAct.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[NutritionRecommendation](StructureDefinition-NutritionRecommendation.md),[PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.md),[ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.md) 

**Usages:**

* Use this Logical Model Profile: [Activities Section](StructureDefinition-ActivitiesSection.md), [Care Plan Act](StructureDefinition-CarePlanAct.md) and [Intervention Act](StructureDefinition-InterventionAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/InterventionAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-InterventionAct.csv), [Excel](StructureDefinition-InterventionAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "InterventionAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.131:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "InterventionAct",
  "title" : "Intervention Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents an Intervention Act. It is a wrapper for intervention-type activities considered to be parts of the same intervention. For example, an activity such as \"elevate head of bed\" combined with \"provide humidified O2 per nasal cannula\" may be the interventions performed for a health concern of \"respiratory insufficiency\" to achieve a goal of \"pulse oximetry greater than 92%\". These intervention activities may be newly described or derived from a variety of sources within an EHR.\n\nInterventions are actions taken to increase the likelihood of achieving the patient's or providers' goals. An Intervention Act should contain a reference to a Goal Observation representing the reason for the intervention.\n\nIntervention Acts can be related to each other, or to Planned Intervention Acts. (E.g., a Planned Intervention Act with moodCode of INT could be related to a series of Intervention Acts with moodCode of EVN, each having an effectiveTime containing the time of the intervention.) \n\nAll interventions referenced in an Intervention Act must have a moodCode of EVN, indicating that they have occurred.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.html), [EncounterActivity](StructureDefinition-EncounterActivity.html), [EntryReference](StructureDefinition-EntryReference.html), [HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.html), [ImmunizationActivity](StructureDefinition-ImmunizationActivity.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [InterventionAct](StructureDefinition-InterventionAct.html), [MedicationActivity](StructureDefinition-MedicationActivity.html), [NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.html), [NutritionRecommendation](StructureDefinition-NutritionRecommendation.html), [PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.html), [ProcedureActivityProcedure](StructureDefinition-ProcedureActivityProcedure.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:intervention-act",
        "path" : "Act.templateId",
        "sliceName" : "intervention-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:intervention-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.131"
      },
      {
        "id" : "Act.templateId:intervention-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-30971).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-30972).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-30975).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-30976)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"362956003\" procedure / intervention (navigational concept) (CONF:1198-30977).",
        "min" : 1,
        "patternCode" : "362956003"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.96\" (CodeSystem: SNOMED CT urn:oid:2.16.840.1.113883.6.96) (CONF:1198-30978).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-30979).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1198-32316).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "short" : "SHOULD contain effectiveTime",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1198-31624).",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-31552).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            },
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "procedure"
            },
            {
              "type" : "profile",
              "path" : "encounter"
            },
            {
              "type" : "profile",
              "path" : "supply"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Act.entryRelationship:advanceDirectiveObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "advanceDirectiveObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-30980) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:advanceDirectiveObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-30981).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:advanceDirectiveObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Advance Directive Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.48:2015-08-01) (CONF:1198-30982).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:immunizationActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "immunizationActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-30984) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:immunizationActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-30985).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:immunizationActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Immunization Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.52:2015-08-01) (CONF:1198-30986).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:medicationActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "medicationActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-30988) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:medicationActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-30989).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:medicationActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Medication Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.16:2014-06-09) (CONF:1198-30990).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:interventionAct",
        "path" : "Act.entryRelationship",
        "sliceName" : "interventionAct",
        "short" : "The following entryRelationship represents the relationship between two Intervention Acts (Intervention RELATES TO Intervention).",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31154) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:interventionAct.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31155).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:interventionAct.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Intervention Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.131:2015-08-01) (CONF:1198-32460).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:procedureActivityProcedure",
        "path" : "Act.entryRelationship",
        "sliceName" : "procedureActivityProcedure",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31168) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:procedureActivityProcedure.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31169).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:procedureActivityProcedure.procedure",
        "path" : "Act.entryRelationship.procedure",
        "comment" : "SHALL contain exactly one [1..1] Procedure Activity Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.14:2014-06-09) (CONF:1198-31170).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:encounterActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "encounterActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31171) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:encounterActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31172).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:encounterActivity.encounter",
        "path" : "Act.entryRelationship.encounter",
        "comment" : "SHALL contain exactly one [1..1] Encounter Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.49:2015-08-01) (CONF:1198-31173).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:instruction",
        "path" : "Act.entryRelationship",
        "sliceName" : "instruction",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31174) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:instruction.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32956).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:instruction.observation",
        "path" : "Act.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:nonMedSupply",
        "path" : "Act.entryRelationship",
        "sliceName" : "nonMedSupply",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31177) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:nonMedSupply.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31178).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:nonMedSupply.supply",
        "path" : "Act.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Non-Medicinal Supply Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.50:2014-06-09) (CONF:1198-31179).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NonMedicinalSupplyActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:nutritionRecommendation",
        "path" : "Act.entryRelationship",
        "sliceName" : "nutritionRecommendation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31413) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:nutritionRecommendation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:nutritionRecommendation.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Recommendation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.130) (CONF:1198-31414).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRefr",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryReferenceRefr",
        "short" : "Where an Intervention needs to reference another entry already described in the CDA document instance, rather than repeating the full content of the entry, the Entry Reference template may be used to reference this entry.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31545) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRefr.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31554).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRefr.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:1198-31555).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRson",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryReferenceRson",
        "short" : "An Intervention Act should reference a Goal Observation. Because the Goal Observation is already described in the CDA document instance's Goals section, rather than repeating the full content of the Goal Observation, the Entry Reference template can be used to reference this entry. The following entryRelationship represents an Entry Reference to Goal Observation.",
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:1198-31621) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRson.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31622).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRson.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:1198-31623).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ],
        "constraint" : [
          {
            "key" : "entry-ref-goal",
            "severity" : "error",
            "human" : "This entryReference template **SHALL** reference an instance of a Goal Observation template.",
            "expression" : "%resource.descendants().ofType(CDA.Observation).where(templateId.exists($this.root = '2.16.840.1.113883.10.20.22.4.121' and $this.extension = '2022-06-01') and id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:handoffCommunicationParticipants",
        "path" : "Act.entryRelationship",
        "sliceName" : "handoffCommunicationParticipants",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32317) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:handoffCommunicationParticipants.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32318).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:handoffCommunicationParticipants.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Handoff Communication Participants (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.141) (CONF:1198-32319).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedInterventionAct",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedInterventionAct",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32914) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedInterventionAct.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32773).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedInterventionAct.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Planned Intervention Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.146:2015-08-01) (CONF:1198-32915).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
            ]
          }
        ]
      },
      {
        "id" : "Act.reference",
        "path" : "Act.reference",
        "comment" : "MAY contain zero or more [0..*] reference (CONF:1198-32760)."
      },
      {
        "id" : "Act.reference.typeCode",
        "path" : "Act.reference.typeCode",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32761).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.reference.externalDocument",
        "path" : "Act.reference.externalDocument",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] External Document Reference (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.115:2014-06-09) (CONF:1198-32762).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ExternalDocument",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
            ]
          }
        ]
      }
    ]
  }
}

```
