# Interpreter Needed Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Interpreter Needed Observation**

## Logical Model: Interpreter Needed Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:InterpreterNeededObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.515:2025-05-01 | |

 
The interpreter needed observation represents an indication of whether a person needs language interpretation services. 

**Usages:**

* Use this Logical Model Profile: [Encounter Activity](StructureDefinition-EncounterActivity.md) and [Planned Encounter](StructureDefinition-PlannedEncounter.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/InterpreterNeededObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-InterpreterNeededObservation.csv), [Excel](StructureDefinition-InterpreterNeededObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "InterpreterNeededObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.515:2025-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "InterpreterNeededObservation",
  "title" : "Interpreter Needed Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The interpreter needed observation represents an indication of whether a person needs language interpretation services.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:interpreter-needed-obs",
        "path" : "Observation.templateId",
        "sliceName" : "interpreter-needed-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:interpreter-needed-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.515"
      },
      {
        "id" : "Observation.templateId:interpreter-needed-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2025-05-01"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Interpreter needed"
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "min" : 1,
        "patternCode" : "54588-9"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation"
          }
        ]
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "comment" : "This observation SHALL contain exactly one [1..1] effectiveTime (CONF:1198-31904).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-high",
            "severity" : "warning",
            "human" : "SHOULD contain high",
            "expression" : "high.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation"
          }
        ]
      },
      {
        "id" : "Observation.effectiveTime.low",
        "path" : "Observation.effectiveTime.low",
        "short" : "The effectiveTime/@low represents when an interpreter is needed",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-32330).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.high",
        "path" : "Observation.effectiveTime.high",
        "short" : "SHOULD contain high",
        "comment" : "This effectiveTime SHOULD contain zero or one [0..1] high (CONF:1198-32331)."
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.16"
        }
      }
    ]
  }
}

```
