# Immunizations Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunizations Section**

## Logical Model: Immunizations Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ImmunizationsSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2015-08-01 | |

 
The Immunizations Section defines a patient's current immunization status and pertinent immunization history. The primary use case for the Immunization Section is to enable communication of a patient's immunization status. The section should include current immunization status, and may contain the entire immunization history that is relevant to the period of time being summarized. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Entries**:[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md) 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md), [History and Physical](StructureDefinition-HistoryandPhysical.md)...Show 2 more,[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ImmunizationsSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ImmunizationsSection.csv), [Excel](StructureDefinition-ImmunizationsSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImmunizationsSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ImmunizationsSection",
  "title" : "Immunizations Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Immunizations Section defines a patient's current immunization status and pertinent immunization history. The primary use case for the Immunization Section is to enable communication of a patient's immunization status. The section should include current immunization status, and may contain the entire immunization history that is relevant to the period of time being summarized.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Entries**: [ImmunizationActivity](StructureDefinition-ImmunizationActivity.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "shall-immunization-activity",
            "severity" : "error",
            "human" : "If section/@nullFlavor is not present, SHALL contain at least one Immunization Activity",
            "expression" : "nullFlavor.exists() or entry.where(substanceAdministration.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity')).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
          }
        ]
      },
      {
        "id" : "Section.nullFlavor",
        "path" : "Section.nullFlavor",
        "short" : "If a required section contains no information, the @nullFlavor MAY be set to NI"
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.2.1"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "History of Immunization Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "11369-6"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            }
          ],
          "rules" : "open"
        },
        "short" : "If section/@nullFlavor is not present..."
      },
      {
        "id" : "Section.entry:activity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Section.entry",
        "sliceName" : "activity",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Immunizations",
        "comment" : "SHALL contain at least one [1..*] entry (CONF:1198-9019) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["shall-immunization-activity"]
      },
      {
        "id" : "Section.entry:activity.substanceAdministration",
        "path" : "Section.entry.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Immunization Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.52:2015-08-01) (CONF:1198-15494).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
            ]
          }
        ]
      }
    ]
  }
}

```
