# Immunization Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Activity**

## Logical Model: Immunization Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ImmunizationActivity |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.52:2015-08-01 | |

 
An Immunization Activity describes immunization substance administrations that have actually occurred or are intended to occur. Immunization Activities in "INT" mood are reflections of immunizations a clinician intends a patient to receive. Immunization Activities in "EVN" mood reflect immunizations actually received. 
An Immunization Activity is very similar to a Medication Activity with some key differentiators. The drug code system is constrained to CVX codes. Administration timing is less complex. Patient refusal reasons should be captured. All vaccines administered should be fully documented in the patient's permanent medical record. Healthcare providers who administer vaccines covered by the National Childhood Vaccine Injury Act are required to ensure that the permanent medical record of the recipient indicates: 
1. Date of administration
1. Vaccine manufacturer
1. Vaccine lot number
1. Name and title of the person who administered the vaccine and the address of the clinic or facility where the permanent record will reside
1. Vaccine information statement (VIS)
1. Date printed on the VIS
1. Date VIS given to patient or parent/guardian.

 
This information should be included in an Immunization Activity when available. Reference:[CDC Instructions](https://www.cdc.gov/vaccines/pubs/pinkbook/downloads/appendices/c/vis-instruct.pdf) 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[ImmunizationNotGivenReason](StructureDefinition-ImmunizationNotGivenReason.md),[Indication](StructureDefinition-Indication.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[MedicationDispense](StructureDefinition-MedicationDispense.md),[MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[SubstanceAdministeredAct](StructureDefinition-SubstanceAdministeredAct.md) 

**Usages:**

* Use this Logical Model Profile: [Immunizations Section](StructureDefinition-ImmunizationsSection.md), [Intervention Act](StructureDefinition-InterventionAct.md) and [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ImmunizationActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ImmunizationActivity.csv), [Excel](StructureDefinition-ImmunizationActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImmunizationActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "substanceAdministration"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.52:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ImmunizationActivity",
  "title" : "Immunization Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "An Immunization Activity describes immunization substance administrations that have actually occurred or are intended to occur. Immunization Activities in \"INT\" mood are reflections of immunizations a clinician intends a patient to receive. Immunization Activities in \"EVN\" mood reflect immunizations actually received.\n\nAn Immunization Activity is very similar to a Medication Activity with some key differentiators. The drug code system is constrained to CVX codes. Administration timing is less complex. Patient refusal reasons should be captured. All vaccines administered should be fully documented in the patient's permanent medical record. Healthcare providers who administer vaccines covered by the National Childhood Vaccine Injury Act are required to ensure that the permanent medical record of the recipient indicates: \n\n1. Date of administration\n2. Vaccine manufacturer\n3. Vaccine lot number\n4. Name and title of the person who administered the vaccine and the address of the clinic or facility where the permanent record will reside\n5. Vaccine information statement (VIS)\n    1. Date printed on the VIS\n    2. Date VIS given to patient or parent/guardian.\n\nThis information should be included in an Immunization Activity when available. Reference: [CDC Instructions](https://www.cdc.gov/vaccines/pubs/pinkbook/downloads/appendices/c/vis-instruct.pdf)\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [ImmunizationNotGivenReason](StructureDefinition-ImmunizationNotGivenReason.html), [Indication](StructureDefinition-Indication.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [MedicationDispense](StructureDefinition-MedicationDispense.html), [MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.html), [ReactionObservation](StructureDefinition-ReactionObservation.html), [SubstanceAdministeredAct](StructureDefinition-SubstanceAdministeredAct.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "SubstanceAdministration",
        "path" : "SubstanceAdministration",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          },
          {
            "key" : "should-doseQuantity",
            "severity" : "warning",
            "human" : "SHOULD contain doseQuantity",
            "expression" : "doseQuantity.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          },
          {
            "key" : "dose-unit-or-admin-unit",
            "severity" : "error",
            "human" : "If doseQuantity/@unit is present, then administrationUnitCode SHALL NOT be present.",
            "expression" : "doseQuantity.unit.exists() implies administrationUnitCode.empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          },
          {
            "key" : "should-performer",
            "severity" : "warning",
            "human" : "SHOULD contain performer",
            "expression" : "performer.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.templateId",
        "path" : "SubstanceAdministration.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.templateId:immunization-activity",
        "path" : "SubstanceAdministration.templateId",
        "sliceName" : "immunization-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.templateId:immunization-activity.root",
        "path" : "SubstanceAdministration.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.52"
      },
      {
        "id" : "SubstanceAdministration.templateId:immunization-activity.extension",
        "path" : "SubstanceAdministration.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "SubstanceAdministration.classCode",
        "path" : "SubstanceAdministration.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SBADM\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-8826)."
      },
      {
        "id" : "SubstanceAdministration.moodCode",
        "path" : "SubstanceAdministration.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet MoodCodeEvnInt urn:oid:2.16.840.1.113883.11.20.9.18 STATIC (CONF:1198-8827).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.18"
        }
      },
      {
        "id" : "SubstanceAdministration.id",
        "path" : "SubstanceAdministration.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-8829).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.code",
        "path" : "SubstanceAdministration.code",
        "short" : "SubstanceAdministration.code is an optional field. Per HL7 Pharmacy Committee, \"this is intended to further specify the nature of the substance administration act. To date the committee has made no use of this attribute\". Because the type of substance administration is generally implicit in the routeCode, in the consumable participant, etc., the field is generally not used and there is no defined value set.",
        "comment" : "MAY contain zero or one [0..1] code (CONF:1198-8830)."
      },
      {
        "id" : "SubstanceAdministration.negationInd",
        "path" : "SubstanceAdministration.negationInd",
        "short" : "Use negationInd=\"true\" to indicate that the immunization was not given.",
        "comment" : "SHALL contain exactly one [1..1] @negationInd (CONF:1198-8985).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.text",
        "path" : "SubstanceAdministration.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "SubstanceAdministration.text.reference",
        "path" : "SubstanceAdministration.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.statusCode",
        "path" : "SubstanceAdministration.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-8833).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.statusCode.nullFlavor",
        "path" : "SubstanceAdministration.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.statusCode.code",
        "path" : "SubstanceAdministration.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActStatus"
        }
      },
      {
        "id" : "SubstanceAdministration.effectiveTime",
        "path" : "SubstanceAdministration.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1198-8834).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.repeatNumber",
        "path" : "SubstanceAdministration.repeatNumber",
        "short" : "In \"INT\" (intent) mood, the repeatNumber defines the number of allowed administrations. For example, a repeatNumber of \"3\" means that the substance can be administered up to 3 times. In \"EVN\" (event) mood, the repeatNumber is the number of occurrences. For example, a repeatNumber of \"3\" in a substance administration event means that the current administration is the 3rd in a series.",
        "constraint" : [
          {
            "key" : "value-only",
            "severity" : "error",
            "human" : "Interval fields SHALL NOT be present",
            "expression" : "(low | high | width | center).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.repeatNumber.value",
        "path" : "SubstanceAdministration.repeatNumber.value",
        "short" : "value should be used instead of low/high"
      },
      {
        "id" : "SubstanceAdministration.routeCode",
        "path" : "SubstanceAdministration.routeCode",
        "comment" : "MAY contain zero or one [0..1] routeCode, which SHALL be selected from ValueSet SPL Drug Route of Administration Terminology urn:oid:2.16.840.1.113883.3.88.12.3221.8.7 DYNAMIC (CONF:1198-8839).",
        "constraint" : [
          {
            "key" : "should-translation",
            "severity" : "warning",
            "human" : "SHOULD contain translation",
            "expression" : "translation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.7"
        }
      },
      {
        "id" : "SubstanceAdministration.routeCode.translation",
        "path" : "SubstanceAdministration.routeCode.translation",
        "comment" : "The routeCode, if present, SHOULD contain zero or more [0..*] translation, which SHOULD be selected from ValueSet Medication Route urn:oid:2.16.840.1.113762.1.4.1099.12 DYNAMIC (CONF:1198-32960).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.12"
        }
      },
      {
        "id" : "SubstanceAdministration.approachSiteCode",
        "path" : "SubstanceAdministration.approachSiteCode",
        "comment" : "MAY contain zero or one [0..1] approachSiteCode, where the code SHALL be selected from ValueSet Body Site Value Set urn:oid:2.16.840.1.113883.3.88.12.3221.8.9 DYNAMIC (CONF:1198-8840).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "SubstanceAdministration.doseQuantity",
        "path" : "SubstanceAdministration.doseQuantity",
        "comment" : "SHOULD contain zero or one [0..1] doseQuantity (CONF:1198-8841).",
        "constraint" : [
          {
            "key" : "should-unit",
            "severity" : "warning",
            "human" : "SHOULD contain @unit",
            "expression" : "nullFlavor.exists() or unit.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.doseQuantity.unit",
        "path" : "SubstanceAdministration.doseQuantity.unit",
        "short" : "NOTE: The base CDA R2.0 standard requires @unit to be drawn from UCUM, and best practice is to use case sensitive UCUM units",
        "comment" : "The doseQuantity, if present, SHOULD contain zero or one [0..1] @unit, which SHOULD be selected from ValueSet UnitsOfMeasureCaseSensitive urn:oid:2.16.840.1.113883.1.11.12839 DYNAMIC (CONF:1198-8842).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "SubstanceAdministration.administrationUnitCode",
        "path" : "SubstanceAdministration.administrationUnitCode",
        "comment" : "MAY contain zero or one [0..1] administrationUnitCode, which SHALL be selected from ValueSet AdministrationUnitDoseForm urn:oid:2.16.840.1.113762.1.4.1021.30 DYNAMIC (CONF:1198-8846).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.30"
        }
      },
      {
        "id" : "SubstanceAdministration.consumable",
        "path" : "SubstanceAdministration.consumable",
        "comment" : "SHALL contain exactly one [1..1] consumable (CONF:1198-8847)."
      },
      {
        "id" : "SubstanceAdministration.consumable.manufacturedProduct",
        "path" : "SubstanceAdministration.consumable.manufacturedProduct",
        "comment" : "This consumable SHALL contain exactly one [1..1] Immunization Medication Information (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.54:2014-06-09) (CONF:1198-15546).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.performer",
        "path" : "SubstanceAdministration.performer",
        "short" : "SHOULD contain performer",
        "comment" : "SHOULD contain zero or one [0..1] performer (CONF:1198-8849).",
        "max" : "1",
        "condition" : ["should-performer"]
      },
      {
        "id" : "SubstanceAdministration.author",
        "path" : "SubstanceAdministration.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-31151).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "SubstanceAdministration.participant",
        "path" : "SubstanceAdministration.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "SubstanceAdministration.participant:drugVehicle",
        "path" : "SubstanceAdministration.participant",
        "sliceName" : "drugVehicle",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1198-8850) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.participant:drugVehicle.typeCode",
        "path" : "SubstanceAdministration.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CSM\" (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8851).",
        "fixedCode" : "CSM"
      },
      {
        "id" : "SubstanceAdministration.participant:drugVehicle.participantRole",
        "path" : "SubstanceAdministration.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Drug Vehicle (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.24) (CONF:1198-15547).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/DrugVehicle"]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship",
        "path" : "SubstanceAdministration.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "supply"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "indication",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-8853) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8854).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1198-15537).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.observation.code",
        "path" : "SubstanceAdministration.entryRelationship.observation.code",
        "short" : "Indication for Immunization"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.observation.code.code",
        "path" : "SubstanceAdministration.entryRelationship.observation.code.code",
        "min" : 1,
        "patternCode" : "59785-6"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.observation.code.codeSystem",
        "path" : "SubstanceAdministration.entryRelationship.observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "instruction",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-8856) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8857).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.inversionInd",
        "path" : "SubstanceAdministration.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1198-8858).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medSupplyOrder",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "medSupplyOrder",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-8860) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medSupplyOrder.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8861).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medSupplyOrder.supply",
        "path" : "SubstanceAdministration.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Medication Supply Order (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.17:2014-06-09) (CONF:1198-15539).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medDispense",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "medDispense",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-8863) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medDispense.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8864).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medDispense.supply",
        "path" : "SubstanceAdministration.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Medication Dispense (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.18:2014-06-09) (CONF:1198-15540).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:reactionObs",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "reactionObs",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-8866) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:reactionObs.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CAUS\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8867).",
        "fixedCode" : "CAUS"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:reactionObs.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Reaction Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.9:2014-06-09) (CONF:1198-15541).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:immunizationNotGiven",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "immunizationNotGiven",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-8988) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:immunizationNotGiven.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8989).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:immunizationNotGiven.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Immunization Not Given Reason (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.53:2024-05-01) (CONF:1198-15542).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationNotGivenReason"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdmin",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "substanceAdmin",
        "short" : "The following entryRelationship is used to indicate a given immunization's order in a series. The nested Substance Administered Act identifies an administration in the series. The entryRelationship/sequenceNumber shows the order of this particular administration in that series.",
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:1198-31510) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdmin.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31511).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdmin.inversionInd",
        "path" : "SubstanceAdministration.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" (CONF:1198-31512).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdmin.sequenceNumber",
        "path" : "SubstanceAdministration.entryRelationship.sequenceNumber",
        "comment" : "MAY contain zero or one [0..1] sequenceNumber (CONF:1198-31513)."
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdmin.act",
        "path" : "SubstanceAdministration.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Substance Administered Act (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.118) (CONF:1198-31514).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceAdministeredAct"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.precondition",
        "path" : "SubstanceAdministration.precondition",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "criterion"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "SubstanceAdministration.precondition:substanceAdmin",
        "path" : "SubstanceAdministration.precondition",
        "sliceName" : "substanceAdmin",
        "comment" : "MAY contain zero or more [0..*] precondition (CONF:1198-8869) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.precondition:substanceAdmin.typeCode",
        "path" : "SubstanceAdministration.precondition.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"PRCN\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8870).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.precondition:substanceAdmin.criterion",
        "path" : "SubstanceAdministration.precondition.criterion",
        "comment" : "SHALL contain exactly one [1..1] Precondition for Substance Administration (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.25:2014-06-09) (CONF:1198-15548).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Criterion",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration"
            ]
          }
        ]
      }
    ]
  }
}

```
