# Hospital Discharge Studies Summary Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hospital Discharge Studies Summary Section**

## Logical Model: Hospital Discharge Studies Summary Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeStudiesSummarySection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:HospitalDischargeStudiesSummarySection |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.2.16 | |

 
This section records the results of observations generated by laboratories, imaging procedures, and other procedures. The scope includes hematology, chemistry, serology, virology, toxicology, microbiology, plain x-ray, ultrasound, CT, MRI, angiography, echocardiography, nuclear medicine, pathology, and procedure observations. This section often includes notable results such as abnormal values or relevant trends, and could record all results for the period of time being documented. 
Laboratory results are typically generated by laboratories providing analytic services in areas such as chemistry, hematology, serology, histology, cytology, anatomic pathology, microbiology, and/or virology. These observations are based on analysis of specimens obtained from the patient and submitted to the laboratory. 
Imaging results are typically generated by a clinician reviewing the output of an imaging procedure, such as when a cardiologist reports the left ventricular ejection fraction based on the review of an echocardiogram. 
Procedure results are typically generated by a clinician wanting to provide more granular information about component observations made during the performance of a procedure, such as when a gastroenterologist reports the size of a polyp observed during a colonoscopy. 
Note that there are discrepancies between CCD and the lab domain model, such as the effectiveTime in specimen collection. 

**Usages:**

* Use this Logical Model Profile: [Discharge Summary](StructureDefinition-DischargeSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/HospitalDischargeStudiesSummarySection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-HospitalDischargeStudiesSummarySection.csv), [Excel](StructureDefinition-HospitalDischargeStudiesSummarySection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HospitalDischargeStudiesSummarySection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeStudiesSummarySection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.2.16"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "HospitalDischargeStudiesSummarySection",
  "title" : "Hospital Discharge Studies Summary Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section records the results of observations generated by laboratories, imaging procedures, and other procedures. The scope includes hematology, chemistry, serology, virology, toxicology, microbiology, plain x-ray, ultrasound, CT, MRI, angiography, echocardiography, nuclear medicine, pathology, and procedure observations. This section often includes notable results such as abnormal values or relevant trends, and could record all results for the period of time being documented.\n\nLaboratory results are typically generated by laboratories providing analytic services in areas such as chemistry, hematology, serology, histology, cytology, anatomic pathology, microbiology, and/or virology. These observations are based on analysis of specimens obtained from the patient and submitted to the laboratory.\n\nImaging results are typically generated by a clinician reviewing the output of an imaging procedure, such as when a cardiologist reports the left ventricular ejection fraction based on the review of an echocardiogram.\n\nProcedure results are typically generated by a clinician wanting to provide more granular information about component observations made during the performance of a procedure, such as when a gastroenterologist reports the size of a polyp observed during a colonoscopy.\n\nNote that there are discrepancies between CCD and the lab domain model, such as the effectiveTime in specimen collection.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.16"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Hospital discharge studies summary Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "11493-4"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      }
    ]
  }
}

```
