# Health Concerns Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Concerns Section**

## Logical Model: Health Concerns Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:HealthConcernsSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.58:2015-08-01 | |

 
This section contains data describing an interest or worry about a health state or process that could possibly require attention, intervention, or management. A Health Concern is a health related matter that is of interest, importance or worry to someone, who may be the patient, patient's family or patient's health care provider. Health concerns are derived from a variety of sources within an EHR (such as Problem List, Family History, Social History, Social Worker Note, etc.). Health concerns can be medical, surgical, nursing, allied health or patient-reported concerns. 
Problem Concerns are a subset of Health Concerns that have risen to the level of importance that they typically would belong on a classic "Problem List", such as "Diabetes Mellitus" or "Family History of Melanoma" or "Tobacco abuse". These are of broad interest to multiple members of the care team. Examples of other Health Concerns that might not typically be considered a Problem Concern include "Risk of Hyperkalemia" for a patient taking an ACE-inhibitor medication, or "Transportation difficulties" for someone who doesn't drive and has trouble getting to appointments, or "Under-insured" for someone who doesn't have sufficient insurance to properly cover their medical needs such as medications. These are typically most important to just a limited number of care team members. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Entries**:[HealthConcernAct](StructureDefinition-HealthConcernAct.md) 
**Recommended Entries**:[HealthStatusObservation](StructureDefinition-HealthStatusObservation.md) 
**Optional Entries**:[RiskConcernAct](StructureDefinition-RiskConcernAct.md) 

**Usages:**

* Use this Logical Model Profile: [Care Plan](StructureDefinition-CarePlan.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/HealthConcernsSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-HealthConcernsSection.csv), [Excel](StructureDefinition-HealthConcernsSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HealthConcernsSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.58:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "HealthConcernsSection",
  "title" : "Health Concerns Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section contains data describing an interest or worry about a health state or process that could possibly require attention, intervention, or management. A Health Concern is a health related matter that is of interest, importance or worry to someone, who may be the patient, patient's family or patient's health care provider. Health concerns are derived from a variety of sources within an EHR (such as Problem List, Family History, Social History, Social Worker Note, etc.). Health concerns can be medical, surgical, nursing, allied health or patient-reported concerns.\n\nProblem Concerns are a subset of Health Concerns that have risen to the level of importance that they typically would belong on a classic \"Problem List\", such as \"Diabetes Mellitus\" or \"Family History of Melanoma\" or \"Tobacco abuse\". These are of broad interest to multiple members of the care team. Examples of other Health Concerns that might not typically be considered a Problem Concern include \"Risk of Hyperkalemia\" for a patient taking an ACE-inhibitor medication, or \"Transportation difficulties\" for someone who doesn't drive and has trouble getting to appointments, or \"Under-insured\" for someone who doesn't have sufficient insurance to properly cover their medical needs such as medications. These are typically most important to just a limited number of care team members.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Entries**: [HealthConcernAct](StructureDefinition-HealthConcernAct.html)\n\n**Recommended Entries**: [HealthStatusObservation](StructureDefinition-HealthStatusObservation.html)\n\n**Optional Entries**: [RiskConcernAct](StructureDefinition-RiskConcernAct.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-health-status-obs",
            "severity" : "warning",
            "human" : "SHOULD contain Health Status Observation",
            "expression" : "entry.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/HealthStatusObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection"
          },
          {
            "key" : "shall-health-concern-act",
            "severity" : "error",
            "human" : "If section/@nullFlavor is not present, SHALL contain at least one Health Concern Act",
            "expression" : "nullFlavor.exists() or entry.where(act.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct')).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection"
          }
        ]
      },
      {
        "id" : "Section.nullFlavor",
        "path" : "Section.nullFlavor",
        "short" : "If a required section contains no information, the @nullFlavor MAY be set to NI"
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.58"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Health concerns Document",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "75310-3"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:healthStatus",
        "path" : "Section.entry",
        "sliceName" : "healthStatus",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1198-30483) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-health-status-obs"]
      },
      {
        "id" : "Section.entry:healthStatus.observation",
        "path" : "Section.entry.observation",
        "comment" : "The entry, if present, SHALL contain exactly one [1..1] Health Status Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.5:2014-06-09) (CONF:1198-30484).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HealthStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:healthConcern",
        "path" : "Section.entry",
        "sliceName" : "healthConcern",
        "short" : "If section/@nullFlavor is not present:",
        "comment" : "SHALL contain at least one [1..*] entry (CONF:1198-30768)",
        "min" : 0,
        "max" : "*",
        "condition" : ["shall-health-concern-act"]
      },
      {
        "id" : "Section.entry:healthConcern.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Health Concern Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.132:2015-08-01) (CONF:1198-30769).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:riskConcern",
        "path" : "Section.entry",
        "sliceName" : "riskConcern",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-32308)",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:riskConcern.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Risk Concern Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.136:2015-08-01) (CONF:1198-32309).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct"
            ]
          }
        ]
      }
    ]
  }
}

```
