# Family History Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Family History Organizer**

## Logical Model: Family History Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:FamilyHistoryOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.45:2026-05-01 | |

 
The Family History Organizer associates a set of observations with a family member. For example, the Family History Organizer can group a set of observations about the patient's father. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Components**:[FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Family History Section](StructureDefinition-FamilyHistorySection.md), [Health Concern Act](StructureDefinition-HealthConcernAct.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/FamilyHistoryOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-FamilyHistoryOrganizer.csv), [Excel](StructureDefinition-FamilyHistoryOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "FamilyHistoryOrganizer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.45:2026-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "FamilyHistoryOrganizer",
  "title" : "Family History Organizer",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Family History Organizer associates a set of observations with a family member. For example, the Family History Organizer can group a set of observations about the patient's father.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Components**: [FamilyHistoryObservation](StructureDefinition-FamilyHistoryObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:family-history-org",
        "path" : "Organizer.templateId",
        "sliceName" : "family-history-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:family-history-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.45"
      },
      {
        "id" : "Organizer.templateId:family-history-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2026-05-01"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"CLUSTER\" Cluster (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-8600).",
        "fixedCode" : "CLUSTER"
      },
      {
        "id" : "Organizer.moodCode",
        "path" : "Organizer.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-8601)."
      },
      {
        "id" : "Organizer.id",
        "path" : "Organizer.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-32485).",
        "min" : 1
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode",
        "path" : "Organizer.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-8602)."
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1198-19099).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Organizer.subject",
        "path" : "Organizer.subject",
        "comment" : "SHALL contain exactly one [1..1] subject (CONF:1198-8609).",
        "min" : 1
      },
      {
        "id" : "Organizer.subject.relatedSubject",
        "path" : "Organizer.subject.relatedSubject",
        "comment" : "This subject SHALL contain exactly one [1..1] relatedSubject (CONF:1198-15244).",
        "constraint" : [
          {
            "key" : "should-subject",
            "severity" : "warning",
            "human" : "SHOULD contain subject",
            "expression" : "subject.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.subject.relatedSubject.classCode",
        "path" : "Organizer.subject.relatedSubject.classCode",
        "comment" : "This relatedSubject SHALL contain exactly one [1..1] @classCode=\"PRS\" Person (CodeSystem: HL7EntityClass urn:oid:2.16.840.1.113883.5.41 STATIC) (CONF:1198-15245).",
        "min" : 1,
        "fixedCode" : "PRS"
      },
      {
        "id" : "Organizer.subject.relatedSubject.code",
        "path" : "Organizer.subject.relatedSubject.code",
        "comment" : "This relatedSubject SHALL contain exactly one [1..1] code, which SHOULD be selected from ValueSet Family Member Value urn:oid:2.16.840.1.113883.1.11.19579 DYNAMIC (CONF:1198-15246).",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.19579"
        }
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject",
        "path" : "Organizer.subject.relatedSubject.subject",
        "comment" : "This relatedSubject SHOULD contain zero or one [0..1] subject (CONF:1198-15248).",
        "constraint" : [
          {
            "key" : "should-birthTime",
            "severity" : "warning",
            "human" : "SHOULD contain birthTime",
            "expression" : "birthTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
          },
          {
            "key" : "should-sdtcId",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcId",
            "expression" : "sdtcId.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.sdtcId",
        "path" : "Organizer.subject.relatedSubject.subject.sdtcId",
        "short" : "SHOULD contain sdtc:id",
        "max" : "1",
        "condition" : ["should-sdtcId"]
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.administrativeGenderCode",
        "path" : "Organizer.subject.relatedSubject.subject.administrativeGenderCode",
        "min" : 1
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.administrativeGenderCode.nullFlavor",
        "path" : "Organizer.subject.relatedSubject.subject.administrativeGenderCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.administrativeGenderCode.code",
        "path" : "Organizer.subject.relatedSubject.subject.administrativeGenderCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.121"
        }
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.birthTime",
        "path" : "Organizer.subject.relatedSubject.subject.birthTime",
        "short" : "The age of a relative at the time of a family history observation **SHOULD** be inferred by comparing RelatedSubject/subject/birthTime with Observation/effectiveTime (CONF:1198-15983).",
        "comment" : "The subject, if present, SHOULD contain zero or one [0..1] birthTime (CONF:1198-15976).",
        "condition" : ["should-birthTime"]
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.sdtcDeceasedInd",
        "path" : "Organizer.subject.relatedSubject.subject.sdtcDeceasedInd",
        "short" : "MAY contain sdtc:deceasedInd"
      },
      {
        "id" : "Organizer.subject.relatedSubject.subject.sdtcDeceasedTime",
        "path" : "Organizer.subject.relatedSubject.subject.sdtcDeceasedTime",
        "short" : "MAY contain sdtc:deceasedTime"
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "comment" : "SHALL contain at least one [1..*] component (CONF:1198-32428).",
        "min" : 1
      },
      {
        "id" : "Organizer.component.observation",
        "path" : "Organizer.component.observation",
        "comment" : "Such components SHALL contain exactly one [1..1] Family History Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.46:2015-08-01) (CONF:1198-32429).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
