# Entry Reference - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Entry Reference**

## Logical Model: Entry Reference 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:EntryReference |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.122 | |

 
This template represents the act of referencing another entry in the same CDA document instance. Its purpose is to remove the need to repeat the complete XML representation of the referred entry when relating one entry to another. This template can be used to reference many types of Act class derivations, such as encounters, observations, procedures etc., as it is often necessary when authoring CDA documents to repeatedly reference other Acts of these types. For example, in a Care Plan it is necessary to repeatedly relate Health Concerns, Goals, Activities and Outcomes. 
The id is required and must be the same id as the entry/id it is referencing. The id cannot be a null value. Act/Code is set to nullFlavor="NP" (Not Present). This means the value is not present in the message (in act/Code). 

**Usages:**

* Use this Logical Model Profile: [Care Plan Act](StructureDefinition-CarePlanAct.md), [Care Team Organizer](StructureDefinition-CareTeamOrganizer.md), [Goal Observation](StructureDefinition-GoalObservation.md), [Health Concern Act](StructureDefinition-HealthConcernAct.md)...Show 9 more,[Intervention Act](StructureDefinition-InterventionAct.md),[Outcome Observation](StructureDefinition-OutcomeObservation.md),[Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md),[Planned Procedure](StructureDefinition-PlannedProcedure.md),[Problem Observation](StructureDefinition-ProblemObservation.md),[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md),[Risk Concern Act](StructureDefinition-RiskConcernAct.md),[Sex Parameter For Clinical Use Observation](StructureDefinition-SexParameterForClinicalUseObservation.md)and[Social History Observation](StructureDefinition-SocialHistoryObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/EntryReference)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-EntryReference.csv), [Excel](StructureDefinition-EntryReference.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EntryReference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.122"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "EntryReference",
  "title" : "Entry Reference",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the act of referencing another entry in the same CDA document instance. Its purpose is to remove the need to repeat the complete XML representation of the referred entry when relating one entry to another. This template can be used to reference many types of Act class derivations, such as encounters, observations, procedures etc., as it is often necessary when authoring CDA documents to repeatedly reference other Acts of these types. For example, in a Care Plan it is necessary to repeatedly relate Health Concerns, Goals, Activities and Outcomes.\n\nThe id is required and must be the same id as the entry/id it is referencing. The id cannot be a null value. Act/Code is set to nullFlavor=\"NP\" (Not Present). This means the value is not present in the message (in act/Code).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:entry-reference",
        "path" : "Act.templateId",
        "sliceName" : "entry-reference",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:entry-reference.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.122"
      },
      {
        "id" : "Act.templateId:entry-reference.extension",
        "path" : "Act.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-31485).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31486).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "short" : "The ID must equal another entry/id in the same document instance. Application Software must be responsible for resolving the identifier back to its original object and then rendering the information in the correct place in the containing section's narrative text. The ID cannot have Null value (e.g., nullFlavor is not allowed).",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-31489).",
        "min" : 1
      },
      {
        "id" : "Act.id.nullFlavor",
        "path" : "Act.id.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-31490)."
      },
      {
        "id" : "Act.code.nullFlavor",
        "path" : "Act.code.nullFlavor",
        "comment" : "This code SHALL contain exactly one [1..1] @nullFlavor=\"NP\" Not Present (CodeSystem: HL7NullFlavor urn:oid:2.16.840.1.113883.5.1008) (CONF:1098-31491).",
        "min" : 1,
        "fixedCode" : "NP"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-31498).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "short" : "MAY be set to \"completed\"",
        "comment" : "This statusCode MAY contain zero or one [0..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31499)."
      }
    ]
  }
}

```
