# Encounter Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Activity**

## Logical Model: Encounter Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:EncounterActivity |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.49:2015-08-01 | |

 
This clinical statement describes an interaction between a patient and clinician. Interactions may include in-person encounters, telephone conversations, and email exchanges. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.md),[Indication](StructureDefinition-Indication.md),[InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Encounters Section](StructureDefinition-EncountersSection.md) and [Intervention Act](StructureDefinition-InterventionAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/EncounterActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-EncounterActivity.csv), [Excel](StructureDefinition-EncounterActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EncounterActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "encounter"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.49:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "EncounterActivity",
  "title" : "Encounter Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This clinical statement describes an interaction between a patient and clinician. Interactions may include in-person encounters, telephone conversations, and email exchanges.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.html), [Indication](StructureDefinition-Indication.html), [InterpreterNeededObservation](StructureDefinition-InterpreterNeededObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
          }
        ]
      },
      {
        "id" : "Encounter.templateId",
        "path" : "Encounter.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Encounter.templateId:encounter-activity",
        "path" : "Encounter.templateId",
        "sliceName" : "encounter-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Encounter.templateId:encounter-activity.root",
        "path" : "Encounter.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.49"
      },
      {
        "id" : "Encounter.templateId:encounter-activity.extension",
        "path" : "Encounter.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Encounter.classCode",
        "path" : "Encounter.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ENC\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-8710)."
      },
      {
        "id" : "Encounter.moodCode",
        "path" : "Encounter.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-8711).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Encounter.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.id",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Identifier",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-8713).",
        "min" : 1
      },
      {
        "id" : "Encounter.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Type",
        "comment" : "In Encounter Summaries the Encounter Type will also be present in the document header at componentOf/encompassingEncounter/code, but for Patient Summaries, componentOf/encompassingEncounter SHALL NOT be present.  Implementers should note that only conveying Encounter Type in the document header at componentOf/encompassingEncounter/code is insufficient.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-otext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain originalText/reference/@value",
            "expression" : "originalText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.23"
        }
      },
      {
        "id" : "Encounter.code.originalText",
        "path" : "Encounter.code.originalText",
        "short" : "SHOULD reference the portion of narrative corresponding to this code",
        "condition" : ["should-otext-ref-value"]
      },
      {
        "id" : "Encounter.code.originalText.reference",
        "path" : "Encounter.code.originalText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
          }
        ]
      },
      {
        "id" : "Encounter.text",
        "path" : "Encounter.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Encounter.text.reference",
        "path" : "Encounter.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
          }
        ]
      },
      {
        "id" : "Encounter.effectiveTime",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.effectiveTime",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Time",
        "comment" : "In Encounter Summaries the Encounter Time will also be present in the document header at componentOf/encompassingEncounter/effectiveTime, but for Patient Summaries, componentOf/encompassingEncounter SHALL NOT be present.",
        "min" : 1
      },
      {
        "id" : "Encounter.sdtcDischargeDispositionCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "dischargeDispositionCode"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.sdtcDischargeDispositionCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Disposition",
        "comment" : "Implementers should note that a Discharge Disposition is not appropriate for all document types. Hospital Discharge Summary documents SHOULD have a discharge disposition. Progress Notes, or H&P, typically won’t have a discharge disposition. In Encounter Summaries, the Encounter Disposition will also be present in the document header at componentOf/encompassingEncounter/dischargeDispositionCode, but in Patient Summaries, componentOf/encompassingEncounter SHALL NOT be present. While an Encounter Summary provides a snapshot of the patient’s condition at the time of the encounter as authored by the clinician, a Patient summary provides the most current information available from the sending system across multiple encounters. [CodeSystem-AHANUBCPatientDischargeStatus](https://terminology.hl7.org/CodeSystem-AHANUBCPatientDischargeStatus.html)",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-USEncounterDischargeDisposition"
        }
      },
      {
        "id" : "Encounter.performer",
        "path" : "Encounter.performer",
        "comment" : "MAY contain zero or more [0..*] performer (CONF:1198-8725)."
      },
      {
        "id" : "Encounter.performer.assignedEntity",
        "path" : "Encounter.performer.assignedEntity",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-8726)."
      },
      {
        "id" : "Encounter.performer.assignedEntity.code",
        "path" : "Encounter.performer.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-8727).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "Encounter.performer.assignedEntity.sdtcSpecialty",
        "path" : "Encounter.performer.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "participantRole"
            },
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Encounter.participant:location",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.participant",
        "sliceName" : "location",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Location",
        "comment" : "In Encounter Summaries the Encounter Location will also be present in the document header at componentOf/encompassingEncounter/location, but in Patient Summaries, componentOf/encompassingEncounter SHALL NOT be present.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:location.typeCode",
        "path" : "Encounter.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"LOC\" Location (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8740).",
        "fixedCode" : "LOC"
      },
      {
        "id" : "Encounter.participant:location.participantRole",
        "path" : "Encounter.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Service Delivery Location (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.32) (CONF:1198-14903).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.entryRelationship",
        "path" : "Encounter.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Encounter.entryRelationship:indication",
        "path" : "Encounter.entryRelationship",
        "sliceName" : "indication",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-8722) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.entryRelationship:indication.typeCode",
        "path" : "Encounter.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has Reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8723).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Encounter.entryRelationship:indication.observation",
        "path" : "Encounter.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1198-14899).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "Encounter.entryRelationship:diagnosis",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.entryRelationship",
        "sliceName" : "diagnosis",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Diagnosis",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-15492) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.entryRelationship:diagnosis.act",
        "path" : "Encounter.entryRelationship.act",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterDiagnosis"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.entryRelationship:observation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.entryRelationship",
        "sliceName" : "observation",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Interpreter Needed Observation",
        "comment" : "SHALL contain exactly one [1..1] Interpreter Needed Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.515:2025-05-01).",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.entryRelationship:observation.observation",
        "path" : "Encounter.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InterpreterNeededObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
