# Continuity of Care Document (CCD) - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Continuity of Care Document (CCD)**

## Logical Model: Continuity of Care Document (CCD) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:ContinuityofCareDocumentCCD |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.2:2024-05-01 | |

 
The Continuity of Care Document (CCD) represents a core data set of the most relevant administrative, demographic, and clinical information facts about a patient's healthcare, covering one or more healthcare encounters. It provides a means for one healthcare practitioner, system, or setting to aggregate all of the pertinent data about a patient and forward it to another to support the continuity of care. 
The primary use case for the CCD is to provide a snapshot in time containing the germane clinical, demographic, and administrative data for a specific patient. The key characteristic of a CCD is that the ServiceEvent is constrained to "PCPR". This means it does not function to report new ServiceEvents associated with performing care. It reports on care that has already been provided. The CCD provides a historical tally of the care over a range of time and is not a record of new services delivered. 
More specific use cases, such as a Discharge Summary, Transfer Summary, Referral Note, Consultation Note, or Progress Note, are available as alternative documents in this guide. 
This document type was originally based on the Continuity of Care Document (CCD) Release 1.1 which itself was derived from HITSP C32 and CCD Release 1.0. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [MedicationsSection](StructureDefinition-MedicationsSection.md)
* [ProblemSection](StructureDefinition-ProblemSection.md)
* [ResultsSection](StructureDefinition-ResultsSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [VitalSignsSection](StructureDefinition-VitalSignsSection.md)
 
**Recommended Sections** 
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
 
**Additional Sections** 
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
* [EncountersSection](StructureDefinition-EncountersSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.md)
* [ImmunizationsSection](StructureDefinition-ImmunizationsSection.md)
* [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.md)
* [PayersSection](StructureDefinition-PayersSection.md)
* [MentalStatusSection](StructureDefinition-MentalStatusSection.md)
* [NutritionSection](StructureDefinition-NutritionSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ContinuityofCareDocumentCCD)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ContinuityofCareDocumentCCD.csv), [Excel](StructureDefinition-ContinuityofCareDocumentCCD.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ContinuityofCareDocumentCCD",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.2:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ContinuityofCareDocumentCCD",
  "title" : "Continuity of Care Document (CCD)",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Continuity of Care Document (CCD) represents a core data set of the most relevant administrative, demographic, and clinical information facts about a patient's healthcare, covering one or more healthcare encounters. It provides a means for one healthcare practitioner, system, or setting to aggregate all of the pertinent data about a patient and forward it to another to support the continuity of care.  \n\nThe primary use case for the CCD is to provide a snapshot in time containing the germane clinical, demographic, and administrative data for a specific patient. The key characteristic of a CCD is that the ServiceEvent is constrained to \"PCPR\". This means it does not function to report new ServiceEvents associated with performing care. It reports on care that has already been provided. The CCD provides a historical tally of the care over a range of time and is not a record of new services delivered.\n\nMore specific use cases, such as a Discharge Summary, Transfer Summary, Referral Note, Consultation Note, or Progress Note, are available as alternative documents in this guide.\n\nThis document type was originally based on the Continuity of Care Document (CCD) Release 1.1 which itself was derived from HITSP C32 and CCD Release 1.0.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [MedicationsSection](StructureDefinition-MedicationsSection.html)\n- [ProblemSection](StructureDefinition-ProblemSection.html)\n- [ResultsSection](StructureDefinition-ResultsSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [VitalSignsSection](StructureDefinition-VitalSignsSection.html)\n\n**Recommended Sections**\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n\n**Additional Sections**\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)\n- [EncountersSection](StructureDefinition-EncountersSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.html)\n- [ImmunizationsSection](StructureDefinition-ImmunizationsSection.html)\n- [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.html)\n- [PayersSection](StructureDefinition-PayersSection.html)\n- [MentalStatusSection](StructureDefinition-MentalStatusSection.html)\n- [NutritionSection](StructureDefinition-NutritionSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument"
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:CCD",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "CCD",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:CCD.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.2"
      },
      {
        "id" : "ClinicalDocument.templateId:CCD.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "Summary of episode note",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"34133-9\" Summarization of Episode Note (CONF:1198-17181)."
      },
      {
        "id" : "ClinicalDocument.code.code",
        "path" : "ClinicalDocument.code.code",
        "patternCode" : "34133-9"
      },
      {
        "id" : "ClinicalDocument.code.codeSystem",
        "path" : "ClinicalDocument.code.codeSystem",
        "short" : "LOINC"
      },
      {
        "id" : "ClinicalDocument.author",
        "path" : "ClinicalDocument.author",
        "comment" : "SHALL contain at least one [1..*] author (CONF:1198-9442)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor",
        "path" : "ClinicalDocument.author.assignedAuthor",
        "comment" : "Such authors SHALL contain exactly one [1..1] assignedAuthor (CONF:1198-9443).",
        "constraint" : [
          {
            "key" : "1198-8456",
            "severity" : "error",
            "human" : "Such assignedAuthors **SHALL** contain (exactly one [1..1] assignedPerson) or (exactly one [1..1] assignedAuthoringDevice and exactly one [1..1] representedOrganization) (CONF:1198-8456).",
            "expression" : "assignedPerson.exists() or (assignedAuthoringDevice.exists() and representedOrganization.exists())",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "short" : "The documentationOf relationship in a Continuity Care Document contains the representation of providers who are wholly or partially responsible for the safety and well-being of a subject of care.",
        "comment" : "SHALL contain exactly one [1..1] documentationOf (CONF:1198-8452).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "short" : "The main activity being described by a CCD is the provision of healthcare over a period of time. This is shown by setting the value of serviceEvent/@classCode to 'PCPR' (care provision) and indicating the duration over which care was provided in serviceEvent/effectiveTime. Additional data from outside this duration may also be included if it is relevant to care provided during that time range (e.g., reviewed during the stated time range). \n\nNOTE: Implementations originating a CCD should take care to discover what the episode of care being summarized is. For example, when a patient fills out a form providing relevant health history, the episode of care being documented might be from birth to the present.",
        "comment" : "This documentationOf SHALL contain exactly one [1..1] serviceEvent (CONF:1198-8480).",
        "constraint" : [
          {
            "key" : "should-performer",
            "severity" : "warning",
            "human" : "SHOULD contain performer",
            "expression" : "performer.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.classCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.classCode",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] @classCode=\"PCPR\" Care Provision (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-8453).",
        "min" : 1,
        "fixedCode" : "PCPR"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] effectiveTime (CONF:1198-8481)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-8454)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] high (CONF:1198-8455).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "short" : "The serviceEvent/performer represents the healthcare providers involved in the current or pertinent historical care of the patient. Preferably, the patient's key healthcare providers would be listed, particularly their primary physician and any active consulting physicians, therapists, and counselors.",
        "comment" : "This serviceEvent SHOULD contain zero or more [0..*] performer (CONF:1198-8482).",
        "condition" : ["should-performer"]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] @typeCode=\"PRF\" Participation physical performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8458).",
        "fixedCode" : "PRF"
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "The performer, if present, MAY contain zero or one [0..1] assignedEntity (CONF:1198-8459).",
        "constraint" : [
          {
            "key" : "1198-32466",
            "severity" : "warning",
            "human" : "If this assignedEntity is an assignedPerson, the assignedEntity/id SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:1198-32466).",
            "expression" : "assignedPerson.exists() implies id.where(root = '2.16.840.1.113883.4.6')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "comment" : "The assignedEntity, if present, SHALL contain at least one [1..*] id (CONF:1198-30882)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.assignedPerson",
        "comment" : "The assignedEntity, if present, MAY contain zero or one [0..1] assignedPerson (CONF:1198-32467)."
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-30659)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-30660).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-section-procedures",
            "severity" : "warning",
            "human" : "SHOULD contain a Procedures Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
          },
          {
            "key" : "should-section-plan-of-treatment",
            "severity" : "warning",
            "human" : "SHOULD contain a Plan of Treatment Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 6
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30661).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "This component SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-30662).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30663) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.1.1:2014-06-09) (CONF:1198-30664).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "problems",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30665) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Problem Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.5.1:2024-05-01) (CONF:1198-30666).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30667) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-procedures"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-30668).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "results",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30669) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Results Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.3.1:2024-05-01) (CONF:1198-30670).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30671) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01) (CONF:1198-30672).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:encounters",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "encounters",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30673) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:encounters.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Encounters Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.22.1:2024-05-01) (CONF:1198-30674).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EncountersSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:famHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "famHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30675) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:famHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-30676).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "functionalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30677) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.14:2014-06-09) (CONF:1198-30678).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "immunizations",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30679) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Immunizations Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2024-05-01) (CONF:1198-30680).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medEquipment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medEquipment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30681) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medEquipment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medical Equipment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.23:2014-06-09) (CONF:1198-30682).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "payers",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30683) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Payers Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.18:2024-05-01) (CONF:1198-30684).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PayersSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30685) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-plan-of-treatment"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-30686).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHist",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHist",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30687) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHist.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-30688).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "vitalSigns",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30689) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Vital Signs Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.4.1:2024-05-01) (CONF:1198-30690).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "mentalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-32143) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.56:2024-05-01) (CONF:1198-32144).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "nutrition",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-32624) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.57) (CONF:1198-32625).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
            ]
          }
        ]
      }
    ]
  }
}

```
