# Consultation Note - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consultation Note**

## Logical Model: Consultation Note 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:ConsultationNote |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.4:2024-05-01 | |

 
The Consultation Note is generated by a request from a clinician for an opinion or advice from another clinician. Consultations may involve face-to-face time with the patient or may fall under the auspices of telemedicine visits. Consultations may occur while the patient is inpatient or ambulatory. The Consultation Note should also be used to summarize an Emergency Room or Urgent Care encounter. 
A Consultation Note includes the reason for the referral, history of present illness, physical examination, and decision-making components (Assessment and Plan). 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.md) or [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.md)
* [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.md) or both [AssessmentSection](StructureDefinition-AssessmentSection.md) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md)
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [ProblemSection](StructureDefinition-ProblemSection.md)
 
**Recommended Sections** 
* [MedicationsSection](StructureDefinition-MedicationsSection.md)
* [PhysicalExamSection](StructureDefinition-PhysicalExamSection.md)
* [ResultsSection](StructureDefinition-ResultsSection.md)
 
**Additional Sections** 
* [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.md)
* [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [GeneralStatusSection](StructureDefinition-GeneralStatusSection.md)
* [PastMedicalHistory](StructureDefinition-PastMedicalHistory.md)
* [ImmunizationsSection](StructureDefinition-ImmunizationsSection.md)
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [VitalSignsSection](StructureDefinition-VitalSignsSection.md)
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
* [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.md)
* [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md)
* [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.md)
* [MentalStatusSection](StructureDefinition-MentalStatusSection.md)
* [NutritionSection](StructureDefinition-NutritionSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ConsultationNote)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ConsultationNote.csv), [Excel](StructureDefinition-ConsultationNote.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ConsultationNote",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.4:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ConsultationNote",
  "title" : "Consultation Note",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Consultation Note is generated by a request from a clinician for an opinion or advice from another clinician. Consultations may involve face-to-face time with the patient or may fall under the auspices of telemedicine visits. Consultations may occur while the patient is inpatient or ambulatory. The Consultation Note should also be used to summarize an Emergency Room or Urgent Care encounter.\n\nA Consultation Note includes the reason for the referral, history of present illness, physical examination, and decision-making components (Assessment and Plan).\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [ReasonforReferralSection](StructureDefinition-ReasonforReferralSection.html) or [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.html)\n- [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.html) or both [AssessmentSection](StructureDefinition-AssessmentSection.html) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.html)\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [ProblemSection](StructureDefinition-ProblemSection.html)\n\n**Recommended Sections**\n- [MedicationsSection](StructureDefinition-MedicationsSection.html)\n- [PhysicalExamSection](StructureDefinition-PhysicalExamSection.html)\n- [ResultsSection](StructureDefinition-ResultsSection.html)\n\n**Additional Sections**\n- [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.html)\n- [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [GeneralStatusSection](StructureDefinition-GeneralStatusSection.html)\n- [PastMedicalHistory](StructureDefinition-PastMedicalHistory.html)\n- [ImmunizationsSection](StructureDefinition-ImmunizationsSection.html)\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [VitalSignsSection](StructureDefinition-VitalSignsSection.html)\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)\n- [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.html)\n- [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.html)\n- [MedicalEquipmentSection](StructureDefinition-MedicalEquipmentSection.html)\n- [MentalStatusSection](StructureDefinition-MentalStatusSection.html)\n- [NutritionSection](StructureDefinition-NutritionSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "category-11488-4",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '11488-4'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '11488-4' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "should-participant-callback",
            "severity" : "warning",
            "human" : "SHOULD contain zero or more [0..*] participant such that it SHALL contain exactly one [1..1] @typeCode=\"CALLBCK\" call back contact (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC)",
            "expression" : "participant.where(typeCode = 'CALLBCK').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:consult-note",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "consult-note",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:consult-note.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.4"
      },
      {
        "id" : "ClinicalDocument.templateId:consult-note.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a Consult Note. If present, there SHALL be a category of 11488-4 (Consult note).",
        "condition" : ["should-sdtcCategory", "category-11488-4"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Consult note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "11488-4"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The Consultation Note recommends use of  the document type code 11488-4 \"Consult note\", with further specification provided by author or performer, setting, or specialty. When pre-coordinated codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type.",
        "comment" : "SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet ConsultDocumentType http://hl7.org/fhir/ccda/ValueSet/2.16.840.1.113883.11.20.9.31 DYNAMIC (CONF:1198-17176).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.31"
        }
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "This participant represents the person to contact for questions about the consult summary. This call back contact individual may be a different person than the individual(s) identified in the author or legalAuthenticator participant."
      },
      {
        "id" : "ClinicalDocument.participant:callback",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "callback",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31656) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:callback.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CALLBCK\" call back contact (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 DYNAMIC) (CONF:1198-31657).",
        "fixedCode" : "CALLBCK"
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31658).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode=\"ASSIGNED\" assigned entity (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 DYNAMIC) (CONF:1198-31659).",
        "fixedCode" : "ASSIGNED"
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.id",
        "path" : "ClinicalDocument.participant.associatedEntity.id",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] id (CONF:1198-31660).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.addr",
        "path" : "ClinicalDocument.participant.associatedEntity.addr",
        "comment" : "This associatedEntity SHOULD contain zero or more [0..*] addr (CONF:1198-31661).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.telecom",
        "path" : "ClinicalDocument.participant.associatedEntity.telecom",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] telecom (CONF:1198-31662).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:1198-31663).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.associatedPerson.name",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson.name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] name (CONF:1198-31664).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:callback.associatedEntity.scopingOrganization",
        "path" : "ClinicalDocument.participant.associatedEntity.scopingOrganization",
        "comment" : "This associatedEntity MAY contain zero or one [0..1] scopingOrganization (CONF:1198-31665)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf",
        "path" : "ClinicalDocument.inFulfillmentOf",
        "short" : "The inFulfillmentOf element describes prior orders that are fulfilled (in whole or part) by the service events described in the Consultation Note. For example, a prior order might be the consultation that is being reported in the note.",
        "comment" : "SHALL contain at least one [1..*] inFulfillmentOf (CONF:1198-8382).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order",
        "path" : "ClinicalDocument.inFulfillmentOf.order",
        "comment" : "Such inFulfillmentOfs SHALL contain exactly one [1..1] order (CONF:1198-29923)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order.id",
        "path" : "ClinicalDocument.inFulfillmentOf.order.id",
        "short" : "Where a referral is being fulfilled by this consultation, this id would be the same as the id in the Referral Act template.",
        "comment" : "This order SHALL contain at least one [1..*] id (CONF:1198-29924)."
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "A Consultation Note is always associated with an encounter; the id element of the encompassingEncounter is required to be present and represents the identifier for the encounter.",
        "comment" : "SHALL contain exactly one [1..1] componentOf (CONF:1198-8386).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "This componentOf SHALL contain exactly one [1..1] encompassingEncounter (CONF:1198-8387)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "comment" : "This encompassingEncounter SHALL contain at least one [1..*] id (CONF:1198-8388)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "comment" : "This encompassingEncounter SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:1198-8389)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "short" : "The encounterParticipant element represents persons who participated in the encounter and not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter MAY contain zero or more [0..*] encounterParticipant (CONF:1198-8392)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant.assignedEntity",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant.assignedEntity",
        "comment" : "The encounterParticipant, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32902).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "1198-32906",
            "severity" : "error",
            "human" : "This assignedEntity SHALL contain an assignedPerson or a representedOrganization or both (CONF:1198-32906).",
            "expression" : "assignedPerson.exists() or representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-8397)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-28895).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ap-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain an Assessment and Plan Section (2.16.840.1.113883.10.20.22.2.9:2014-06-09) when either an Assessment Section (2.16.840.1.113883.10.20.22.2.8) or a Plan of Treatment Section (2.16.840.1.113883.10.20.22.2.10:2014-06-09) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "cc-rfv-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain a Chief Complaint and Reason for Visit Section (2.16.840.1.113883.10.20.22.2.13) when either a Chief Complaint Section (1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) or a Reason for Visit Section (2.16.840.1.113883.10.20.22.2.12) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "rfr-or-rfv",
            "severity" : "error",
            "human" : "**SHALL** include a Reason for Referral or Reason for Visit section (CONF:1198-9504).",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforReferralSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection')).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "ap-or-a-and-p",
            "severity" : "error",
            "human" : "**SHALL** include an Assessment and Plan Section, or both an Assessment Section and a Plan of Treatment Section.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() or (component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).count() = 2)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "should-section-medications",
            "severity" : "warning",
            "human" : "SHOULD contain a Medications Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "should-section-physical-exam",
            "severity" : "warning",
            "human" : "SHOULD contain a Physical Exam Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "key" : "should-section-results",
            "severity" : "warning",
            "human" : "SHOULD contain a Results Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 5
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28896) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "The component, if present, SHALL contain exactly one [1..1] Assessment Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.8) (CONF:1198-28897).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessmentAndPlan",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28898) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment and Plan Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.9:2014-06-09) (CONF:1198-28899).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28900) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-28901).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reasonForVisit",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28904) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo", "rfr-or-rfv"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.12) (CONF:1198-28905).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hpi",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "hpi",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28906) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hpi.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] History of Present Illness Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.4) (CONF:1198-28907).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "physicalExam",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28908) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-physical-exam"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Physical Exam Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.2.10:2024-05-01) (CONF:1198-28909).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28910) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-28911).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaint",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28912) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) (CONF:1198-28913).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaintRFV",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28915) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint and Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.13) (CONF:1198-28916).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "familyHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28917) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-28918).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "generalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28919) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] General Status Section (identifier: urn:oid:2.16.840.1.113883.10.20.2.5) (CONF:1198-28920).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GeneralStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "pastMedicalHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28921) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Past Medical History (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.20:2024-05-01) (CONF:1198-28922).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "immunizations",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28923) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Immunizations Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2024-05-01) (CONF:1198-28924).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medications",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28925) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-medications"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.1.1:2014-06-09) (CONF:1198-28926).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "problems",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28928) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Problem Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.5.1:2024-05-01) (CONF:1198-28929).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28930) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-28931).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "results",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28932) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-results"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Results Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.3.1:2024-05-01) (CONF:1198-28933).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHist",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHist",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28934) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHist.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-28935).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "vitalSigns",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28936) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Vital Signs Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.4.1:2024-05-01) (CONF:1198-28937).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28942) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01) (CONF:1198-28943).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "functionalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28944) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.14:2014-06-09) (CONF:1198-28945).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reviewOfSystems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30237) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Review of Systems Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.18) (CONF:1198-30238).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalEquipment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medicalEquipment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30904) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medicalEquipment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medical Equipment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.23:2014-06-09) (CONF:1198-30905).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "mentalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30906) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:mentalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.56:2024-05-01) (CONF:1198-30907).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "nutrition",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30909) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.57) (CONF:1198-30910).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
            ]
          }
        ]
      }
    ]
  }
}

```
