# Care Teams Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Teams Section**

## Logical Model: Care Teams Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamsSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:CareTeamsSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.500:2022-06-01 | |

 
The Care Teams Section is used to share historical and current Care Team information. 
The Care Team Section may be included in any type of C-CDA structured document that is an open template. 
An individual can have more than one Care Team. A Care Team can exist over time such as a longitudinal care team which includes historical members that may be active or inactive on the care team as needed. Or a Care Team, such as a rehabilitation team, may exist to address a person's needs associated with a particular care event, or a team can be based on addressing a specific condition. 
The Care Team Organizer entry template used in the C-CDA Care Teams Section is meant to support the foundation of effective communication, interaction channels and maintenance of current clinical context awareness for the patient, caregivers and care providers to promote care coordination. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Recommended Entries**:[CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.md) 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/CareTeamsSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-CareTeamsSection.csv), [Excel](StructureDefinition-CareTeamsSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CareTeamsSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamsSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.500:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "CareTeamsSection",
  "title" : "Care Teams Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Care Teams Section is used to share historical and current Care Team information. \n\nThe Care Team Section may be included in any type of C-CDA structured document that is an open template.\n\nAn individual can have more than one Care Team.  A Care Team can exist over time such as a longitudinal care team which includes historical members that may be active or inactive on the care team as needed. Or a Care Team, such as a rehabilitation team, may exist to address a person's needs associated with a particular care event, or a team can be based on addressing a specific condition. \n\nThe Care Team Organizer entry template used in the C-CDA Care Teams Section is meant to support the foundation of effective communication, interaction channels and maintenance of current clinical context awareness for the patient, caregivers and care providers to promote care coordination. \n\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Recommended Entries**: [CareTeamOrganizer](StructureDefinition-CareTeamOrganizer.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-care-team-org",
            "severity" : "warning",
            "human" : "SHOULD contain Care Team Organizer",
            "expression" : "entry.where(organizer.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamsSection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.500"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Patient Care team information",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "85847-2"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "organizer"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:4515-1) such that it"
      },
      {
        "id" : "Section.entry:primary",
        "path" : "Section.entry",
        "sliceName" : "primary",
        "short" : "entry",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-care-team-org"]
      },
      {
        "id" : "Section.entry:primary.organizer",
        "path" : "Section.entry.organizer",
        "comment" : "SHALL contain exactly one [1..1] Care Team Organizer (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.500:2022-06-01) (CONF:4515-159).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
            ]
          }
        ]
      }
    ]
  }
}

```
