# Care Team Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Team Organizer**

## Logical Model: Care Team Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:CareTeamOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.500:2022-06-01 | |

 
This organizer template contains information about a single care team. The author of the organizer is the person who documented the care team information. The participants of the organizer are the care team lead(s) and the care team organization. 
The components of the organizer contain the following information: 
* The encounter that caused the care team to be formed
* Narrative information about the care team
* The care team members
* Reasons for the care team
* The care team type(s) - a care team can have multiple care team types
 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Components**:[CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.md) 
**Optional Components**:[CareTeamTypeObservation](StructureDefinition-CareTeamTypeObservation.md),[EntryReference](StructureDefinition-EntryReference.md),[NoteActivity](StructureDefinition-NoteActivity.md) 

**Usages:**

* Use this Logical Model Profile: [Care Teams Section](StructureDefinition-CareTeamsSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/CareTeamOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-CareTeamOrganizer.csv), [Excel](StructureDefinition-CareTeamOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CareTeamOrganizer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.500:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "CareTeamOrganizer",
  "title" : "Care Team Organizer",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This organizer template contains information about a single care team. \nThe author of the organizer is the person who documented the care team information.\nThe participants of the organizer are the care team lead(s) and the care team organization.\n\nThe components of the organizer contain the following information:\n* The encounter that caused the care team to be formed\n* Narrative information about the care team\n* The care team members\n* Reasons for the care team\n* The care team type(s) - a care team can have multiple care team types \n\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Components**: [CareTeamMemberAct](StructureDefinition-CareTeamMemberAct.html)\n\n**Optional Components**: [CareTeamTypeObservation](StructureDefinition-CareTeamTypeObservation.html), [EntryReference](StructureDefinition-EntryReference.html), [NoteActivity](StructureDefinition-NoteActivity.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:care-team-org",
        "path" : "Organizer.templateId",
        "sliceName" : "care-team-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:care-team-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.500"
      },
      {
        "id" : "Organizer.templateId:care-team-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"CLUSTER\" CLUSTER (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4515-124).",
        "fixedCode" : "CLUSTER"
      },
      {
        "id" : "Organizer.moodCode",
        "path" : "Organizer.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4515-125)."
      },
      {
        "id" : "Organizer.id",
        "path" : "Organizer.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4515-126).",
        "min" : 1
      },
      {
        "id" : "Organizer.code",
        "path" : "Organizer.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4515-114).",
        "min" : 1
      },
      {
        "id" : "Organizer.code.code",
        "path" : "Organizer.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"86744-0\" Care Team (CONF:4515-120).",
        "min" : 1,
        "patternCode" : "86744-0"
      },
      {
        "id" : "Organizer.code.codeSystem",
        "path" : "Organizer.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.1\" LOINC (CodeSystem: LOINC urn:oid:2.16.840.1.113883.6.1) (CONF:4515-121).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Organizer.code.originalText",
        "path" : "Organizer.code.originalText",
        "comment" : "This code SHOULD contain zero or one [0..1] originalText (CONF:4515-154) such that it"
      },
      {
        "id" : "Organizer.code.originalText.reference",
        "path" : "Organizer.code.originalText.reference",
        "comment" : "SHALL contain exactly one [1..1] reference (CONF:4515-155).",
        "min" : 1
      },
      {
        "id" : "Organizer.code.originalText.reference.value",
        "path" : "Organizer.code.originalText.reference.value",
        "short" : "The value attribute references the narrative in section.text where the care team name is rendered. The intention of this reference is to clarify which care team this Organizer refers to.",
        "comment" : "This reference SHALL contain exactly one [1..1] @value (CONF:4515-156).",
        "min" : 1
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode",
        "path" : "Organizer.statusCode",
        "short" : "When statusCode has a value set, its value MAY be rendered in the narrative.",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-113)."
      },
      {
        "id" : "Organizer.statusCode.nullFlavor",
        "path" : "Organizer.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActStatus"
        }
      },
      {
        "id" : "Organizer.effectiveTime",
        "path" : "Organizer.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4515-127).",
        "min" : 1
      },
      {
        "id" : "Organizer.effectiveTime.low",
        "path" : "Organizer.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:4515-157).",
        "min" : 1
      },
      {
        "id" : "Organizer.effectiveTime.high",
        "path" : "Organizer.effectiveTime.high",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:4515-158)."
      },
      {
        "id" : "Organizer.author",
        "path" : "Organizer.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4515-116).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Organizer.participant",
        "path" : "Organizer.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Organizer.participant:lead",
        "path" : "Organizer.participant",
        "sliceName" : "lead",
        "short" : "This Participant represents the Care Team lead.",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:4515-128) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organizer.participant:lead.typeCode",
        "path" : "Organizer.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"PPRF\" Primary Performer (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:4515-129).",
        "fixedCode" : "PPRF"
      },
      {
        "id" : "Organizer.participant:lead.sdtcFunctionCode",
        "path" : "Organizer.participant.sdtcFunctionCode",
        "short" : "Describes the person's, caregiver's or health care provider's functional role on the care team.",
        "comment" : "MAY contain zero or one [0..1] sdtc:functionCode, which SHOULD be selected from ValueSet Care Team Member Function urn:oid:2.16.840.1.113762.1.4.1099.30 DYNAMIC (CONF:4515-130).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "Organizer.participant:lead.participantRole",
        "path" : "Organizer.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4515-131)."
      },
      {
        "id" : "Organizer.participant:lead.participantRole.id",
        "path" : "Organizer.participant.participantRole.id",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:4515-132).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "4515-133",
            "severity" : "error",
            "human" : "This id **SHALL** match a performer/assignedEntity/id of at least one Care Team Member described in component/act (CONF:4515-133).",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.participant:lead.participantRole.sdtcSpecialty",
        "path" : "Organizer.participant.participantRole.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Organizer.participant:location",
        "path" : "Organizer.participant",
        "sliceName" : "location",
        "short" : "participant",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:4515-134) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organizer.participant:location.typeCode",
        "path" : "Organizer.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"LOC\" Location (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:4515-137).",
        "fixedCode" : "LOC"
      },
      {
        "id" : "Organizer.participant:location.participantRole",
        "path" : "Organizer.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4515-135).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.participant:location.participantRole.id",
        "path" : "Organizer.participant.participantRole.id",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:4515-138).",
        "min" : 1
      },
      {
        "id" : "Organizer.participant:location.participantRole.addr",
        "path" : "Organizer.participant.participantRole.addr",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] addr (CONF:4515-139).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.participant:location.participantRole.telecom",
        "path" : "Organizer.participant.participantRole.telecom",
        "comment" : "This participantRole SHOULD contain zero or more [0..*] telecom (CONF:4515-140)."
      },
      {
        "id" : "Organizer.participant:location.participantRole.playingEntity",
        "path" : "Organizer.participant.participantRole.playingEntity",
        "comment" : "This participantRole SHALL contain exactly one [1..1] playingEntity (CONF:4515-136).",
        "min" : 1
      },
      {
        "id" : "Organizer.participant:location.participantRole.playingEntity.classCode",
        "path" : "Organizer.participant.participantRole.playingEntity.classCode",
        "comment" : "This playingEntity SHALL contain exactly one [1..1] @classCode=\"PLC\" Place (CodeSystem: HL7EntityClass urn:oid:2.16.840.1.113883.5.41) (CONF:4515-141).",
        "min" : 1,
        "fixedCode" : "PLC"
      },
      {
        "id" : "Organizer.participant:location.participantRole.playingEntity.name",
        "path" : "Organizer.participant.participantRole.playingEntity.name",
        "comment" : "This playingEntity SHALL contain exactly one [1..1] name (CONF:4515-142).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "exists",
              "path" : "encounter"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHALL contain at least one [1..*] component (CONF:4515-152) such that it",
        "min" : 1
      },
      {
        "id" : "Organizer.component:type",
        "path" : "Organizer.component",
        "sliceName" : "type",
        "short" : "component",
        "comment" : "MAY contain zero or more [0..*] component (CONF:4515-110) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:type.act",
        "path" : "Organizer.component.act",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:type.encounter",
        "path" : "Organizer.component.encounter",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:type.observation",
        "path" : "Organizer.component.observation",
        "comment" : "SHALL contain exactly one [1..1] Care Team Type Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.500.2:2019-07-01) (CONF:4515-163).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamTypeObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:entryReference",
        "path" : "Organizer.component",
        "sliceName" : "entryReference",
        "short" : "The following components represent the reasons for the existence of the care team. These entry references are typically a health concern, risk concern or problem but can also be some other entry present in the document.",
        "comment" : "MAY contain zero or more [0..*] component (CONF:4515-146) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:entryReference.act",
        "path" : "Organizer.component.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-147).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:entryReference.encounter",
        "path" : "Organizer.component.encounter",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:entryReference.observation",
        "path" : "Organizer.component.observation",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:encounter",
        "path" : "Organizer.component",
        "sliceName" : "encounter",
        "short" : "component",
        "comment" : "MAY contain zero or more [0..*] component (CONF:4515-148) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:encounter.act",
        "path" : "Organizer.component.act",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:encounter.encounter",
        "path" : "Organizer.component.encounter",
        "comment" : "SHALL contain exactly one [1..1] encounter (CONF:4515-164).",
        "min" : 1
      },
      {
        "id" : "Organizer.component:encounter.encounter.id",
        "path" : "Organizer.component.encounter.id",
        "short" : "1. If the id does not match an encounter/id from an encounter elsewhere within the same document and the id does not contain @nullFlavor=NA, then this entry SHALL conform to the Encounter Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.49:2015-08-01) (CONF:4435-145).",
        "comment" : "This encounter SHALL contain at least one [1..*] id (CONF:4515-165).",
        "min" : 1
      },
      {
        "id" : "Organizer.component:encounter.observation",
        "path" : "Organizer.component.observation",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:note",
        "path" : "Organizer.component",
        "sliceName" : "note",
        "short" : "component",
        "comment" : "MAY contain zero or one [0..1] component (CONF:4515-150) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:note.act",
        "path" : "Organizer.component.act",
        "comment" : "SHALL contain exactly one [1..1] Note Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.202:2016-11-01) (CONF:4515-151).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:note.encounter",
        "path" : "Organizer.component.encounter",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:note.observation",
        "path" : "Organizer.component.observation",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:member",
        "path" : "Organizer.component",
        "sliceName" : "member",
        "short" : "component",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:member.act",
        "path" : "Organizer.component.act",
        "comment" : "SHALL contain exactly one [1..1] Care Team Member Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.500.1:2022-06-01) (CONF:4515-166).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:member.encounter",
        "path" : "Organizer.component.encounter",
        "max" : "0"
      },
      {
        "id" : "Organizer.component:member.observation",
        "path" : "Organizer.component.observation",
        "max" : "0"
      }
    ]
  }
}

```
