# Care Team Member Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Team Member Act**

## Logical Model: Care Team Member Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:CareTeamMemberAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.500.1:2024-05-01 | |

 
This template is used to represent a member of the care team. Care team members can include healthcare and community services providers, caregivers, relatives, the patient themselves, etc. A care team member can be another care team or an organization. Care team member attributes include the following: Care team member status on the care team Care team member time (e.g. duration, point-in-time, etc.) on the care team Schedule of the care team member describing when the care team member usually participates on the care team Care team member function on the care team such as the care team member specialty, relationship to the patient, and also role on the care team Care team member name, address, telecom, organization, etc. Care team member information (narrative description about the care team member) 
The performer/assignedEntity/id may be set equal to (a pointer to) an id on a performer elsewhere in the document (header or entries) or a new performer can be described here. If the id is pointing to a performer already described elsewhere in the document, assignedEntity/id is sufficient to identify this performer and none of the remaining details of assignedEntity are required to be set. Application Software must be responsible for resolving the identifier back to its original object and then rendering the information in the correct place in the containing section's narrative text. 
This id must be a pointer to another Performer. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[CareTeamMemberScheduleObservation](StructureDefinition-CareTeamMemberScheduleObservation.md),[NoteActivity](StructureDefinition-NoteActivity.md) 

**Usages:**

* Use this Logical Model Profile: [Care Team Organizer](StructureDefinition-CareTeamOrganizer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/CareTeamMemberAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-CareTeamMemberAct.csv), [Excel](StructureDefinition-CareTeamMemberAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CareTeamMemberAct",
  "meta" : {
    "versionId" : "5",
    "lastUpdated" : "2023-07-11T23:41:50.227Z"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.500.1:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "CareTeamMemberAct",
  "title" : "Care Team Member Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template is used to represent a member of the care team. Care team members can include healthcare and community services providers, caregivers, relatives, the patient themselves, etc. A care team member can be another care team or an organization. \nCare team member attributes include the following:\n Care team member status on the care team\n Care team member time (e.g. duration, point-in-time, etc.) on the care team\n Schedule of the care team member describing when the care team member usually participates on the care team\n Care team member function on the care team such as the care team member specialty, relationship to the patient, and also role on the care team\n Care team member name, address, telecom, organization, etc. \n Care team member information (narrative description about the care team member)\n\nThe performer/assignedEntity/id may be set equal to (a pointer to) an id on a performer elsewhere in the document (header or entries) or a new performer can be described here. If the id is pointing to a performer already described elsewhere in the document, assignedEntity/id is sufficient to identify this performer and none of the remaining details of assignedEntity are required to be set. Application Software must be responsible for resolving the identifier back to its original object and then rendering the information in the correct place in the containing section's narrative text.\n\nThis id must be a pointer to another Performer.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [CareTeamMemberScheduleObservation](StructureDefinition-CareTeamMemberScheduleObservation.html), [NoteActivity](StructureDefinition-NoteActivity.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:care-team-member-act",
        "path" : "Act.templateId",
        "sliceName" : "care-team-member-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:care-team-member-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.500.1"
      },
      {
        "id" : "Act.templateId:care-team-member-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"PCPR\" Provision of Care (CONF:4515-53).",
        "fixedCode" : "PCPR"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CONF:4515-54).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "short" : "Care team information panel",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4515-27)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "min" : 1,
        "patternCode" : "92707-9"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-62).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.nullFlavor",
        "path" : "Act.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActStatus"
        }
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4515-33).",
        "min" : 1
      },
      {
        "id" : "Act.effectiveTime.low",
        "path" : "Act.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:4515-167).",
        "min" : 1
      },
      {
        "id" : "Act.effectiveTime.high",
        "path" : "Act.effectiveTime.high",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:4515-168)."
      },
      {
        "id" : "Act.performer",
        "path" : "Act.performer",
        "comment" : "SHALL contain exactly one [1..1] performer (CONF:4515-160)",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.performer.sdtcFunctionCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "functionCode"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.performer.sdtcFunctionCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Care Team Member Role - This sdtc:functionCode represents the function or role of the member on the care team. For example, the care team member roles on the care team can be a caregiver and a professional nurse or a primary care provider and the care coordinator.",
        "comment" : "MAY contain zero or one [0..1] sdtc:functionCode, which SHOULD be selected from ValueSet Care Team Member Function urn:oid:2.16.840.1.113762.1.4.1099.30 DYNAMIC (CONF:4515-161).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "Act.performer.assignedEntity",
        "path" : "Act.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4515-175).",
        "constraint" : [
          {
            "key" : "4515-180",
            "severity" : "error",
            "human" : "If the assignedEntity/id is not referencing a Performer elsewhere in the document with an assignedPerson populated, this assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4515-180).",
            "expression" : "assignedPerson.exists() or (%resource.descendants().ofType(CDA.Performer2).where(assignedEntity.assignedPerson.exists() and assignedEntity.id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension)))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          },
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          },
          {
            "key" : "should-assignedPerson",
            "severity" : "warning",
            "human" : "SHOULD contain assignedPerson",
            "expression" : "assignedPerson.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          }
        ]
      },
      {
        "id" : "Act.performer.assignedEntity.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.performer.assignedEntity.id",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Care Team Member Identifier",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4515-176)."
      },
      {
        "id" : "Act.performer.assignedEntity.id.root",
        "path" : "Act.performer.assignedEntity.id.root",
        "comment" : "Such ids SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4515-177).",
        "constraint" : [
          {
            "key" : "should-npi",
            "severity" : "warning",
            "human" : "SHOULD be NPI",
            "expression" : "$this = '2.16.840.1.113883.4.6'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          }
        ]
      },
      {
        "id" : "Act.performer.assignedEntity.sdtcSpecialty",
        "path" : "Act.performer.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Act.performer.assignedEntity.addr",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.performer.assignedEntity.addr",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Care Team Member Location",
        "comment" : "This assignedEntity SHOULD contain zero or more [0..*] addr (CONF:4515-182).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.performer.assignedEntity.telecom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.performer.assignedEntity.telecom",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Care Team Member Telecom",
        "comment" : "This assignedEntity SHOULD contain zero or more [0..*] telecom (CONF:4515-183)."
      },
      {
        "id" : "Act.performer.assignedEntity.assignedPerson",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.performer.assignedEntity.assignedPerson",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Care Team Member Name",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] assignedPerson (CONF:4515-178)."
      },
      {
        "id" : "Act.performer.assignedEntity.assignedPerson.name",
        "path" : "Act.performer.assignedEntity.assignedPerson.name",
        "comment" : "The assignedPerson, if present, SHALL contain exactly one [1..1] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4515-179).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "Act.performer.assignedEntity.representedOrganization",
        "path" : "Act.performer.assignedEntity.representedOrganization",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] representedOrganization (CONF:4515-181)."
      },
      {
        "id" : "Act.performer.assignedEntity.representedOrganization.telecom",
        "path" : "Act.performer.assignedEntity.representedOrganization.telecom",
        "min" : 1
      },
      {
        "id" : "Act.performer.assignedEntity.representedOrganization.addr",
        "path" : "Act.performer.assignedEntity.representedOrganization.addr",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.participant",
        "path" : "Act.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] participant (CONF:4515-171) such that it"
      },
      {
        "id" : "Act.participant:location",
        "path" : "Act.participant",
        "sliceName" : "location",
        "short" : "This participant represents the location where the care team member provides the service.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.participant:location.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"LOC\" Location (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:4515-174).",
        "fixedCode" : "LOC"
      },
      {
        "id" : "Act.participant:location.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4515-173)."
      },
      {
        "id" : "Act.participant:addl-functions",
        "path" : "Act.participant",
        "sliceName" : "addl-functions",
        "short" : "This participant is used to express additional care team functions performed by this member of the team. Include additional participant to record additional roles (functionCode) this Care Team member plays.",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:4515-76) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.participant:addl-functions.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect Target (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:4515-78).",
        "fixedCode" : "IND"
      },
      {
        "id" : "Act.participant:addl-functions.sdtcFunctionCode",
        "path" : "Act.participant.sdtcFunctionCode",
        "short" : "sdtc:functionCode",
        "comment" : "SHALL contain exactly one [1..1] sdtc:functionCode, which SHALL be selected from ValueSet Care Team Member Function urn:oid:2.16.840.1.113762.1.4.1099.30 DYNAMIC (CONF:4515-169).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "Act.participant:addl-functions.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "required element with fixed nullFlavor"
      },
      {
        "id" : "Act.participant:addl-functions.participantRole.nullFlavor",
        "path" : "Act.participant.participantRole.nullFlavor",
        "comment" : "This participantRole SHALL contain exactly one [1..1] @nullFlavor=\"NI\" No Information. (CONF:4515-172).",
        "min" : 1,
        "patternCode" : "NA"
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "exists",
              "path" : "encounter"
            },
            {
              "type" : "exists",
              "path" : "observation"
            },
            {
              "type" : "exists",
              "path" : "act"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:4515-94) such that it"
      },
      {
        "id" : "Act.entryRelationship:encounter",
        "path" : "Act.entryRelationship",
        "sliceName" : "encounter",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-86) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:encounter.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-87).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:encounter.act",
        "path" : "Act.entryRelationship.act",
        "max" : "0"
      },
      {
        "id" : "Act.entryRelationship:encounter.encounter",
        "path" : "Act.entryRelationship.encounter",
        "comment" : "SHALL contain exactly one [1..1] encounter (CONF:4515-88).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "4515-90",
            "severity" : "error",
            "human" : "If the first id does not match an encounter/id from an encounter elsewhere within the same document and the id does not contain @nullFlavor=\"NA\", then this entry SHALL conform to the Encounter Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.49:2015-08-01) (CONF:4515-90).",
            "expression" : "id.first().nullFlavor = 'NA' or (%resource.descendants().ofType(CDA.Encounter).where(hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity') and id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension)))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:encounter.encounter.id",
        "path" : "Act.entryRelationship.encounter.id",
        "comment" : "This encounter SHALL contain exactly one [1..1] id (CONF:4515-89).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.entryRelationship:encounter.observation",
        "path" : "Act.entryRelationship.observation",
        "max" : "0"
      },
      {
        "id" : "Act.entryRelationship:note",
        "path" : "Act.entryRelationship",
        "sliceName" : "note",
        "short" : "This is the note activity to narratively describe information about the member on the care team.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-91) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:note.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-92).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:note.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Note Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.202:2016-11-01) (CONF:4515-93).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:note.encounter",
        "path" : "Act.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Act.entryRelationship:note.observation",
        "path" : "Act.entryRelationship.observation",
        "max" : "0"
      },
      {
        "id" : "Act.entryRelationship:schedule",
        "path" : "Act.entryRelationship",
        "sliceName" : "schedule",
        "short" : "This is the schedule of when or how frequently the care team member participates (or provides care to the patient) on the care team.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Act.entryRelationship:schedule.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-96).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:schedule.act",
        "path" : "Act.entryRelationship.act",
        "max" : "0"
      },
      {
        "id" : "Act.entryRelationship:schedule.encounter",
        "path" : "Act.entryRelationship.encounter",
        "max" : "0"
      },
      {
        "id" : "Act.entryRelationship:schedule.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Care Team Member Schedule Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.500.3:2022-06-01) (CONF:4515-95).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberScheduleObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
