# Care Plan - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Plan**

## Logical Model: Care Plan 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:CarePlan |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.15:2024-05-01 | |

 
A Care Plan is a consensus-driven dynamic plan that represents a patient's and Care Team Member's prioritized concerns, goals, and planned interventions. It serves as a blueprint shared by all Care Team Members (including the patient, their caregivers and providers), to guide the patient'ss care. A Care Plan integrates multiple interventions proposed by multiple providers and disciplines for multiple conditions. 
A Care Plan represents one or more Plan(s) of Care and serves to reconcile and resolve conflicts between the various Plans of Care developed for a specific patient by different providers. While both a plan of care and a care plan include the patients life goals and require Care Team Members (including patients) to prioritize goals and interventions, the reconciliation process becomes more complex as the number of plans of care increases. The Care Plan also serves to enable longitudinal coordination of care. 
The CDA Care Plan represents an instance of this dynamic Care Plan at a point in time. The CDA document itself is NOT dynamic. 
Key differentiators between a Care Plan CDA and CCD (another snapshot in time document): 
* There are 2 required sections: ** Health Concerns ** Goals
* There are 2 optional sections: ** Activities ** Outcomes
* Provides the ability to identify patient and provider priorities with each act
* Provides a header participant to indicate occurrences of Care Plan review
 
A care plan document can include entry references from the information in these sections to the information (entries) in other sections. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [HealthConcernsSection](StructureDefinition-HealthConcernsSection.md)
* [GoalsSection](StructureDefinition-GoalsSection.md)
 
**Recommended Sections** 
* [OutcomesSection](StructureDefinition-OutcomesSection.md)
 
**Additional Sections** 
* [ActivitiesSection](StructureDefinition-ActivitiesSection.md)
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/CarePlan)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-CarePlan.csv), [Excel](StructureDefinition-CarePlan.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarePlan",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.15:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "CarePlan",
  "title" : "Care Plan",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A Care Plan is a consensus-driven dynamic plan that represents a patient's and Care Team Member's prioritized concerns, goals, and planned interventions. It serves as a blueprint shared by all Care Team Members (including the patient, their caregivers and providers), to guide the patient'ss care. A Care Plan integrates multiple interventions proposed by multiple providers and disciplines for multiple conditions.\n\nA Care Plan represents one or more Plan(s) of Care and serves to reconcile and resolve conflicts between the various Plans of Care developed for a specific patient by different providers. While both a plan of care and a care plan include the patients life goals and require Care Team Members (including patients) to prioritize goals and interventions, the reconciliation process becomes more complex as the number of plans of care increases. The Care Plan also serves to enable longitudinal coordination of care.\n\nThe CDA Care Plan represents an instance of this dynamic Care Plan at a point in time. The CDA document itself is NOT dynamic.\n\nKey differentiators between a Care Plan CDA and CCD (another snapshot in time document):\n* There are 2 required sections:\n** Health Concerns\n** Goals\n* There are 2 optional sections:\n** Activities\n** Outcomes\n* Provides the ability to identify patient and provider priorities with each act\n* Provides a header participant to indicate occurrences of Care Plan review\n\nA care plan document can include entry references from the information in these sections to the information (entries) in other sections.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [HealthConcernsSection](StructureDefinition-HealthConcernsSection.html)\n- [GoalsSection](StructureDefinition-GoalsSection.html)\n\n**Recommended Sections**\n- [OutcomesSection](StructureDefinition-OutcomesSection.html)\n\n**Additional Sections**\n- [ActivitiesSection](StructureDefinition-ActivitiesSection.html)\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "category-18776-5",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '18776-5'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '18776-5' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-setId",
            "severity" : "warning",
            "human" : "SHOULD contain setId",
            "expression" : "setId.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-versionNumber",
            "severity" : "warning",
            "human" : "SHOULD contain versionNumber",
            "expression" : "versionNumber.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-informationRecipient",
            "severity" : "warning",
            "human" : "SHOULD contain informationRecipient",
            "expression" : "informationRecipient.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-componentOf",
            "severity" : "warning",
            "human" : "SHOULD contain componentOf",
            "expression" : "componentOf.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:care-plan",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "care-plan",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:care-plan.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.15"
      },
      {
        "id" : "ClinicalDocument.templateId:care-plan.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a Care Plan. If present, there SHALL be a category of 18776-5 (Plan of care note).",
        "condition" : ["should-sdtcCategory", "category-18776-5"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Plan of care note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "18776-5"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.10"
        }
      },
      {
        "id" : "ClinicalDocument.setId",
        "path" : "ClinicalDocument.setId",
        "short" : "SHOULD contain setId",
        "comment" : "SHOULD contain zero or one [0..1] setId (CONF:1198-32321).",
        "condition" : ["should-setId", "4537-6380", "4537-6387"]
      },
      {
        "id" : "ClinicalDocument.versionNumber",
        "path" : "ClinicalDocument.versionNumber",
        "short" : "SHOULD contain versionNumber",
        "comment" : "SHOULD contain zero or one [0..1] versionNumber (CONF:1198-32322).",
        "condition" : ["should-versionNumber", "4537-6380", "4537-6387"]
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "short" : "SHOULD contain informationRecipient",
        "condition" : ["should-informationRecipient"]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "comment" : "SHALL contain exactly one [1..1] intendedRecipient (CONF:1198-31994).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-informationRecipient",
            "severity" : "warning",
            "human" : "SHOULD contain informationRecipient",
            "expression" : "informationRecipient.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-receivedOrganization",
            "severity" : "warning",
            "human" : "SHOULD contain receivedOrganization",
            "expression" : "receivedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "comment" : "This intendedRecipient SHALL contain at least one [1..*] id (CONF:1198-31996).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.addr",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.addr",
        "comment" : "This intendedRecipient SHOULD contain zero or more [0..*] addr (CONF:1198-31997).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.telecom",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.telecom",
        "comment" : "This intendedRecipient SHOULD contain zero or more [0..*] telecom (CONF:1198-31998)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "short" : "SHOULD contain informationRecipient",
        "comment" : "This intendedRecipient SHOULD contain zero or one [0..1] informationRecipient (CONF:1198-31999).",
        "condition" : ["should-informationRecipient"]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "comment" : "The informationRecipient, if present, SHALL contain exactly one [1..1] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:1198-32320).",
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization",
        "comment" : "This intendedRecipient SHOULD contain zero or one [0..1] receivedOrganization (CONF:1198-32000).",
        "constraint" : [
          {
            "key" : "should-id",
            "severity" : "warning",
            "human" : "SHOULD contain id",
            "expression" : "id.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-standardIndustryClassCode",
            "severity" : "warning",
            "human" : "SHOULD contain standardIndustryClassCode",
            "expression" : "standardIndustryClassCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.id",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.id",
        "comment" : "The receivedOrganization, if present, SHOULD contain zero or more [0..*] id (CONF:1198-32001)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.standardIndustryClassCode",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.standardIndustryClassCode",
        "comment" : "The receivedOrganization, if present, SHOULD contain zero or one [0..1] standardIndustryClassCode, which SHALL be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-32003).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.authenticator.time",
        "path" : "ClinicalDocument.authenticator.time",
        "comment" : "SHALL contain exactly one [1..1] time (CONF:1198-31911)."
      },
      {
        "id" : "ClinicalDocument.authenticator.signatureCode",
        "path" : "ClinicalDocument.authenticator.signatureCode",
        "comment" : "SHALL contain exactly one [1..1] signatureCode (CONF:1198-31912)."
      },
      {
        "id" : "ClinicalDocument.authenticator.sdtcSignatureText",
        "path" : "ClinicalDocument.authenticator.sdtcSignatureText",
        "short" : "The prefix sdtc: SHALL be bound to the namespace “urn:hl7-org:sdtc”. The use of the namespace provides a necessary extension to CDA R2 for the use of the signatureText element",
        "comment" : "MAY contain zero or one [0..1] sdtc:signatureText (CONF:1198-31913)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity",
        "path" : "ClinicalDocument.authenticator.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1198-31914)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.id",
        "path" : "ClinicalDocument.authenticator.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:1198-31915)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] code (CONF:1198-31916).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code.code",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"ONESELF\" Self (CONF:1198-31917).",
        "min" : 1,
        "patternCode" : "ONESELF"
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code.codeSystem",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.111\" (CodeSystem: HL7RoleCode urn:oid:2.16.840.1.113883.5.111) (CONF:1198-31918).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.111"
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalDocument.participant:verifier",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "verifier",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31677) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:verifier.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"VRF\" Verifier (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-31678).",
        "fixedCode" : "VRF"
      },
      {
        "id" : "ClinicalDocument.participant:verifier.functionCode",
        "path" : "ClinicalDocument.participant.functionCode",
        "comment" : "SHALL contain exactly one [1..1] functionCode (CONF:1198-31679).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:verifier.functionCode.code",
        "path" : "ClinicalDocument.participant.functionCode.code",
        "comment" : "This functionCode SHALL contain exactly one [1..1] @code=\"425268008\" Review of Care Plan (CONF:1198-31680).",
        "min" : 1,
        "patternCode" : "425268008"
      },
      {
        "id" : "ClinicalDocument.participant:verifier.functionCode.codeSystem",
        "path" : "ClinicalDocument.participant.functionCode.codeSystem",
        "comment" : "This functionCode SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.96\" (CodeSystem: SNOMED CT urn:oid:2.16.840.1.113883.6.96) (CONF:1198-31681).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "ClinicalDocument.participant:verifier.time",
        "path" : "ClinicalDocument.participant.time",
        "comment" : "SHALL contain exactly one [1..1] time (CONF:1198-31682).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:verifier.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31683).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant:verifier.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode=\"ASSIGNED\" (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110) (CONF:1198-31686).",
        "fixedCode" : "ASSIGNED"
      },
      {
        "id" : "ClinicalDocument.participant:verifier.associatedEntity.id",
        "path" : "ClinicalDocument.participant.associatedEntity.id",
        "comment" : "This associatedEntity SHALL contain at least one [1..*] id (CONF:1198-31684).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:verifier.associatedEntity.code",
        "path" : "ClinicalDocument.participant.associatedEntity.code",
        "comment" : "This associatedEntity SHOULD contain zero or one [0..1] code (CONF:1198-31685)."
      },
      {
        "id" : "ClinicalDocument.participant:verifier.associatedEntity.code.code",
        "path" : "ClinicalDocument.participant.associatedEntity.code.code",
        "comment" : "The code SHOULD be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:1198-32367).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.participant:indirect",
        "path" : "ClinicalDocument.participant",
        "sliceName" : "indirect",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-31895) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.participant:indirect.typeCode",
        "path" : "ClinicalDocument.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:1198-31896).",
        "fixedCode" : "IND"
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity",
        "path" : "ClinicalDocument.participant.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:1198-31897)."
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] @classCode, which SHALL be selected from ValueSet INDRoleclassCodes urn:oid:2.16.840.1.113883.11.20.9.33 STATIC (CONF:1198-31898).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.33"
        }
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.associatedPerson",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:1198-31899).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.participant:indirect.associatedEntity.associatedPerson.name",
        "path" : "ClinicalDocument.participant.associatedEntity.associatedPerson.name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] name (CONF:1198-31900).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "serviceEvent.classCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "The serviceEvent describes the provision of healthcare over a period of time. The duration over which care was provided is indicated in serviceEvent/effectiveTime. Additional data from outside this duration may also be included if it is relevant to care provided during that time range (e.g., reviewed during the stated time range).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision",
        "path" : "ClinicalDocument.documentationOf",
        "sliceName" : "care-provision",
        "comment" : "SHALL contain exactly one [1..1] documentationOf (CONF:1198-31901) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "short" : "The serviceEvent describes the provision of healthcare over a period of time. The duration over which care was provided is indicated in serviceEvent/effectiveTime. Additional data from outside this duration may also be included if it is relevant to care provided during that time range (e.g., reviewed during the stated time range).",
        "comment" : "SHALL contain exactly one [1..1] serviceEvent (CONF:1198-31902)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.classCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.classCode",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] @classCode=\"PCPR\" Care Provision (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-31903).",
        "min" : 1,
        "fixedCode" : "PCPR"
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.effectiveTime",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] effectiveTime (CONF:1198-31904)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.effectiveTime.low",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-32330)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.effectiveTime.high",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.high",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:1198-32331)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.performer.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:1198-31907)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.performer.assignedEntity.id",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:1198-31908)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.performer.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code (CONF:1198-31909)."
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.performer.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:1198-32328).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf:care-provision.serviceEvent.performer.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain exactly one [1..1] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:1198-32329).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.relatedDocument",
        "path" : "ClinicalDocument.relatedDocument",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "parentDocument"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalDocument.relatedDocument:relatedDocument1",
        "path" : "ClinicalDocument.relatedDocument",
        "sliceName" : "relatedDocument1",
        "comment" : "MAY contain zero or more [0..*] relatedDocument (CONF:1198-29893) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.relatedDocument:relatedDocument1.typeCode",
        "path" : "ClinicalDocument.relatedDocument.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode, which SHALL be selected from ValueSet x_ActRelationshipDocument urn:oid:2.16.840.1.113883.1.11.11610 STATIC (CONF:1198-31889).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.11610"
        }
      },
      {
        "id" : "ClinicalDocument.relatedDocument:relatedDocument1.parentDocument",
        "path" : "ClinicalDocument.relatedDocument.parentDocument",
        "comment" : "SHALL contain exactly one [1..1] parentDocument (CONF:1198-29894)."
      },
      {
        "id" : "ClinicalDocument.relatedDocument:relatedDocument1.parentDocument.id",
        "path" : "ClinicalDocument.relatedDocument.parentDocument.id",
        "comment" : "This parentDocument SHALL contain at least one [1..*] id (CONF:1198-32949)."
      },
      {
        "id" : "ClinicalDocument.relatedDocument:relatedDocument1.parentDocument.setId",
        "path" : "ClinicalDocument.relatedDocument.parentDocument.setId",
        "comment" : "This parentDocument SHALL contain exactly one [1..1] setId (CONF:1198-29895).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.relatedDocument:relatedDocument1.parentDocument.versionNumber",
        "path" : "ClinicalDocument.relatedDocument.parentDocument.versionNumber",
        "comment" : "This parentDocument SHALL contain exactly one [1..1] versionNumber (CONF:1198-29896).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "SHOULD contain componentOf",
        "comment" : "SHOULD contain zero or one [0..1] componentOf (CONF:1198-32004) such that it",
        "condition" : ["should-componentOf"]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "SHALL contain exactly one [1..1] encompassingEncounter (CONF:1198-32005)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "comment" : "This encompassingEncounter SHALL contain exactly one [1..1] effectiveTime (CONF:1198-32007)."
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-28753)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-28754).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "1198-31044",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain a Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-31044).",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "key" : "should-section-outcomes",
            "severity" : "warning",
            "human" : "SHOULD contain an Outcomes Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/OutcomesSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:healthConcerns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "healthConcerns",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28755).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:healthConcerns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:goals",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "goals",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-28761) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:goals.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Goals Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.60) (CONF:1198-28762).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GoalsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:activities",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "activities",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-28763) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:activities.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Activities Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.21.2.3:2024-05-01) (CONF:1198-28764).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ActivitiesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:outcomes",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "outcomes",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-29596) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-outcomes"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:outcomes.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Outcomes Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.61) (CONF:1198-29597).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/OutcomesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28942) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      }
    ]
  }
}

```
