# Basic Occupation Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Basic Occupation Observation**

## Logical Model: Basic Occupation Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/BasicOccupationObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:BasicOccupationObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.503:2023-05-01 | |

 
This template represents a simple observation about the type of work (e.g., infantry, business analyst, social worker) of a person. The effectiveTime low and high represent the start and end times of a particular observation about an occupation. Multiple occupation observation instances in a single document or derived from multiple documents, represent a basic historical occupation record. Implementers should use the Basic Occupation Observation template for conveying occupation information in support of USCDI. It is recommended systems include the Basic Industry Observation in the Social History section. 
Implementers wishing to convey more advanced Occupation detail, such as employer, usual work (longest held), or other work related observations may consider using[HL7 CDA R2 Implementation Guide: C-CDA R2.1 Supplemental Templates for Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522)in addition to this Observation. 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/BasicOccupationObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-BasicOccupationObservation.csv), [Excel](StructureDefinition-BasicOccupationObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BasicOccupationObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/BasicOccupationObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.503:2023-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "BasicOccupationObservation",
  "title" : "Basic Occupation Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a simple observation about the type of work (e.g., infantry, business analyst, social worker) of a person. The effectiveTime low and high represent the start and end times of a particular observation about an occupation. Multiple occupation observation instances in a single document or derived from multiple documents, represent a basic historical occupation record. Implementers should use the Basic Occupation Observation template for conveying occupation information in support of USCDI.  It is recommended systems include the Basic Industry Observation in the Social History section.\n\nImplementers wishing to convey more advanced Occupation detail, such as employer, usual work (longest held), or other work related observations may consider using [HL7 CDA R2 Implementation Guide: C-CDA R2.1 Supplemental Templates for Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522)  in addition to this Observation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "min" : 2
      },
      {
        "id" : "Observation.templateId:basic-occupation-obs",
        "path" : "Observation.templateId",
        "sliceName" : "basic-occupation-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:basic-occupation-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.503"
      },
      {
        "id" : "Observation.templateId:basic-occupation-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2023-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:4537-33000)."
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:4537-33001)."
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "History of Occupation",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"11341-5\" History of Occupation (CONF:4537-33002)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "min" : 1,
        "patternCode" : "11341-5"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-32997)."
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:4537-33004)."
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4537-33005)."
      },
      {
        "id" : "Observation.effectiveTime.low",
        "path" : "Observation.effectiveTime.low",
        "short" : "The low value reflects the start date of the recorded occupation.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:4537-33007).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.high",
        "path" : "Observation.effectiveTime.high",
        "short" : "The high value reflects the end date of the recorded occupation. An absent high value means the occupation was current at the time the document was generated.",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:4537-33008)."
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "min" : 1
      },
      {
        "id" : "Observation.value:physical-quantity",
        "path" : "Observation.value",
        "sliceName" : "physical-quantity",
        "max" : "0"
      },
      {
        "id" : "Observation.value:coded",
        "path" : "Observation.value",
        "sliceName" : "coded",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", which SHALL be selected from ValueSet Occupation ONETSOC Detail (ODH) urn:oid:2.16.840.1.114222.4.11.7901 DYNAMIC (CONF:4537-33006).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7901"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "Indicates that this observation is for a related person whose occupation may affect the patient.",
        "comment" : "MAY contain zero or one [0..1] subject (CONF:4537-33058)."
      },
      {
        "id" : "Observation.subject.relatedSubject",
        "path" : "Observation.subject.relatedSubject",
        "comment" : "The subject, if present, SHALL contain exactly one [1..1] relatedSubject (CONF:4537-33059)."
      },
      {
        "id" : "Observation.entryRelationship:basic-industry",
        "path" : "Observation.entryRelationship",
        "sliceName" : "basic-industry",
        "short" : "entryRelationship",
        "comment" : "SHOULD contain zero or one [0..1] entryRelationship (CONF:4537-33060) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:basic-industry.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4537-33062).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship:basic-industry.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Basic Industry Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.504:2023-05-01) (CONF:4537-33063).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/BasicIndustryObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
