# Average Blood Pressure Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Average Blood Pressure Organizer**

## Logical Model: Average Blood Pressure Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AverageBloodPressureOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.512:2024-05-01 | |

 
This template represents a single instance of an Average Blood Pressure reading. Average (mean) Blood Pressure (systolic and diastolic) is the average of two or more blood pressure (BP) readings in a specified time period or according to a specified algorithm or protocol determined by the organization collecting the data. This template contains two Vital Sign Observation components for the two parts of the reading. 

**Usages:**

* Use this Logical Model Profile: [Vital Signs Section](StructureDefinition-VitalSignsSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AverageBloodPressureOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AverageBloodPressureOrganizer.csv), [Excel](StructureDefinition-AverageBloodPressureOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AverageBloodPressureOrganizer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.512:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AverageBloodPressureOrganizer",
  "title" : "Average Blood Pressure Organizer",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a single instance of an Average Blood Pressure reading. Average (mean) Blood Pressure (systolic and diastolic) is the average of two or more blood pressure (BP) readings in a specified time period or according to a specified algorithm or protocol determined by the organization collecting the data. This template contains two Vital Sign Observation components for the two parts of the reading.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:avg-bp-org",
        "path" : "Organizer.templateId",
        "sliceName" : "avg-bp-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:avg-bp-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.512"
      },
      {
        "id" : "Organizer.templateId:avg-bp-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "patternCode" : "BATTERY"
      },
      {
        "id" : "Organizer.code",
        "path" : "Organizer.code",
        "short" : "Blood pressure panel mean systolic and mean diastolic",
        "min" : 1
      },
      {
        "id" : "Organizer.code.code",
        "path" : "Organizer.code.code",
        "min" : 1,
        "patternCode" : "96607-7"
      },
      {
        "id" : "Organizer.code.codeSystem",
        "path" : "Organizer.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "min" : 1,
        "patternCode" : "completed"
      },
      {
        "id" : "Organizer.effectiveTime",
        "path" : "Organizer.effectiveTime",
        "short" : "Shall match the time of the individual components"
      },
      {
        "id" : "Organizer.author",
        "path" : "Organizer.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or many [0..*] Author Participation.",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "observation.code.code"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Organizer.component:systolic",
        "path" : "Organizer.component",
        "sliceName" : "systolic",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:systolic.observation",
        "path" : "Organizer.component.observation",
        "min" : 1
      },
      {
        "id" : "Organizer.component:systolic.observation.code",
        "path" : "Organizer.component.observation.code",
        "short" : "Systolic blood pressure mean"
      },
      {
        "id" : "Organizer.component:systolic.observation.code.code",
        "path" : "Organizer.component.observation.code.code",
        "min" : 1,
        "patternCode" : "96608-5"
      },
      {
        "id" : "Organizer.component:systolic.observation.code.codeSystem",
        "path" : "Organizer.component.observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Organizer.component:systolic.observation.value",
        "path" : "Organizer.component.observation.value",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PQ"
          }
        ]
      },
      {
        "id" : "Organizer.component:systolic.observation.value.unit",
        "path" : "Organizer.component.observation.value.unit",
        "patternCode" : "mm[Hg]"
      },
      {
        "id" : "Organizer.component:diastolic",
        "path" : "Organizer.component",
        "sliceName" : "diastolic",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:diastolic.observation",
        "path" : "Organizer.component.observation",
        "min" : 1
      },
      {
        "id" : "Organizer.component:diastolic.observation.code",
        "path" : "Organizer.component.observation.code",
        "short" : "Diastolic blood pressure mean"
      },
      {
        "id" : "Organizer.component:diastolic.observation.code.code",
        "path" : "Organizer.component.observation.code.code",
        "min" : 1,
        "patternCode" : "96609-3"
      },
      {
        "id" : "Organizer.component:diastolic.observation.code.codeSystem",
        "path" : "Organizer.component.observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Organizer.component:diastolic.observation.value",
        "path" : "Organizer.component.observation.value",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PQ"
          }
        ]
      },
      {
        "id" : "Organizer.component:diastolic.observation.value.unit",
        "path" : "Organizer.component.observation.value.unit",
        "patternCode" : "mm[Hg]"
      }
    ]
  }
}

```
