# Authorization Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Authorization Activity**

## Logical Model: Authorization Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AuthorizationActivity |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.1.19 | |

 
An Authorization Activity represents authorizations or pre-authorizations currently active for the patient for the particular payer. 
Authorizations are represented using an act subordinate to the policy or program that provided it. The authorization refers to the policy or program. Authorized treatments can be grouped into an organizer class, where common properties, such as the reason for the authorization, can be expressed. Subordinate acts represent what was authorized. 

**Usages:**

* Use this Logical Model Profile: [Policy Activity](StructureDefinition-PolicyActivity.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AuthorizationActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AuthorizationActivity.csv), [Excel](StructureDefinition-AuthorizationActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AuthorizationActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.1.19"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AuthorizationActivity",
  "title" : "Authorization Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "An Authorization Activity represents authorizations or pre-authorizations currently active for the patient for the particular payer. \n\nAuthorizations are represented using an act subordinate to the policy or program that provided it. The authorization refers to the policy or program. Authorized treatments can be grouped into an organizer class, where common properties, such as the reason for the authorization, can be expressed. Subordinate acts represent what was authorized.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:authorization-activity",
        "path" : "Act.templateId",
        "sliceName" : "authorization-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:authorization-activity.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.19"
      },
      {
        "id" : "Act.templateId:authorization-activity.extension",
        "path" : "Act.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:81-8944).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:81-8945).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain exactly one [1..1] id (CONF:81-8947).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:target",
        "path" : "Act.entryRelationship",
        "sliceName" : "target",
        "short" : "The target of an authorization activity MAY contain one or more performer, to indicate the providers that have been authorized to provide treatment (CONF:81-8952).",
        "comment" : "SHALL contain at least one [1..*] entryRelationship (CONF:81-8948) such that it",
        "min" : 1,
        "max" : "*",
        "constraint" : [
          {
            "key" : "81-8951",
            "severity" : "error",
            "human" : "The target of an authorization activity with act/entryRelationship/@typeCode=\"SUBJ\" SHALL be a clinical statement with moodCode=\"PRMS\" Promise (CONF:81-8951).",
            "expression" : "(act | encounter | observation | observationMedia | organizer | procedure | regionOfInterest | substanceAdministration | supply).where(moodCode='PRMS').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:target.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:81-8949).",
        "fixedCode" : "SUBJ"
      }
    ]
  }
}

```
