# Author Participation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Author Participation**

## Logical Model: Author Participation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AuthorParticipation |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.119 | |

 
This template represents the Author Participation (including the author timestamp). CDA R2 requires that Author and Author timestamp be asserted in the document header. From there, authorship propagates to contained sections and contained entries, unless explicitly overridden. 
The Author Participation template was added to those templates in scope for analysis in R2. Although it is not explicitly stated in all templates the Author Participation template can be used in any template. 

**Usages:**

* Use this Logical Model Profile: [Advance Directive Observation](StructureDefinition-AdvanceDirectiveObservation.md), [Advance Directive Organizer (deprecated)](StructureDefinition-AdvanceDirectiveOrganizer.md), [Allergy Concern Act](StructureDefinition-AllergyConcernAct.md), [Average Blood Pressure Organizer](StructureDefinition-AverageBloodPressureOrganizer.md)...Show 39 more,[Care Plan Act](StructureDefinition-CarePlanAct.md),[Care Team Organizer](StructureDefinition-CareTeamOrganizer.md),[Comment Activity](StructureDefinition-CommentActivity.md),[Disability Status Observation](StructureDefinition-DisabilityStatusObservation.md),[Functional Status Observation](StructureDefinition-FunctionalStatusObservation.md),[Functional Status Organizer](StructureDefinition-FunctionalStatusOrganizer.md),[Goal Observation](StructureDefinition-GoalObservation.md),[Handoff Communication Participants](StructureDefinition-HandoffCommunicationParticipants.md),[Health Concern Act](StructureDefinition-HealthConcernAct.md),[Immunization Activity](StructureDefinition-ImmunizationActivity.md),[Intervention Act](StructureDefinition-InterventionAct.md),[Medication Activity](StructureDefinition-MedicationActivity.md),[Mental Status Observation](StructureDefinition-MentalStatusObservation.md),[Note Activity](StructureDefinition-NoteActivity.md),[Nutrition Assessment](StructureDefinition-NutritionAssessment.md),[Outcome Observation](StructureDefinition-OutcomeObservation.md),[Planned Coverage](StructureDefinition-PlannedCoverage.md),[Planned Encounter](StructureDefinition-PlannedEncounter.md),[Planned Immunization Activity](StructureDefinition-PlannedImmunizationActivity.md),[Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md),[Planned Medication Activity](StructureDefinition-PlannedMedicationActivity.md),[Planned Procedure](StructureDefinition-PlannedProcedure.md),[Planned Supply](StructureDefinition-PlannedSupply.md),[Priority Preference](StructureDefinition-PriorityPreference.md),[Problem Concern Act](StructureDefinition-ProblemConcernAct.md),[Problem Observation](StructureDefinition-ProblemObservation.md),[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md),[Referral Act](StructureDefinition-ReferralAct.md),[Result Observation](StructureDefinition-ResultObservation.md),[Result Organizer](StructureDefinition-ResultOrganizer.md),[Risk Concern Act](StructureDefinition-RiskConcernAct.md),[Self-Care Activities (ADL and IADL)](StructureDefinition-SelfCareActivitiesADLandIADL.md),[Sensory Status](StructureDefinition-SensoryStatus.md),[Smoking Status - Meaningful Use (Deprecated)](StructureDefinition-SmokingStatusMeaningfulUse.md),[Social History Observation](StructureDefinition-SocialHistoryObservation.md),[Substance or Device Allergy - Intolerance Observation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md),[Tobacco Use (Deprecated)](StructureDefinition-TobaccoUse.md),[Vital Sign Observation](StructureDefinition-VitalSignObservation.md)and[Vital Signs Organizer](StructureDefinition-VitalSignsOrganizer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AuthorParticipation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AuthorParticipation.csv), [Excel](StructureDefinition-AuthorParticipation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AuthorParticipation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "author"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.119"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AuthorParticipation",
  "title" : "Author Participation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the Author Participation (including the author timestamp). CDA R2 requires that Author and Author timestamp be asserted in the document header. From there, authorship propagates to contained sections and contained entries, unless explicitly overridden.\n\nThe Author Participation template was added to those templates in scope for analysis in R2. Although it is not explicitly stated in all templates the Author Participation template can be used in any template.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Author.templateId",
        "path" : "Author.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Author.templateId:author",
        "path" : "Author.templateId",
        "sliceName" : "author",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Author.templateId:author.root",
        "path" : "Author.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.119"
      },
      {
        "id" : "Author.templateId:author.extension",
        "path" : "Author.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Author.time",
        "path" : "Author.time",
        "comment" : "SHALL contain exactly one [1..1] time (CONF:1098-31471)."
      },
      {
        "id" : "Author.assignedAuthor",
        "path" : "Author.assignedAuthor",
        "comment" : "SHALL contain exactly one [1..1] assignedAuthor (CONF:1098-31472).",
        "constraint" : [
          {
            "key" : "author-details",
            "severity" : "error",
            "human" : "Authors require addr, telecom, and either assignedPerson/name or assignedAuthoringDevice/manufacturerModelName. These may be present on this author or on another instance of an Author Participation in the document that has an id that matches the first id of this author.",
            "expression" : "nullFlavor.exists() or (addr.exists() and telecom.exists() and (assignedPerson.name.exists() or assignedAuthoringDevice.manufacturerModelName.exists())) or (%resource.descendants().ofType(CDA.AssignedAuthor).where(id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension) and addr.exists() and telecom.exists() and (assignedPerson.name.exists() or assignedAuthoringDevice.manufacturerModelName.exists())))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
          }
        ]
      },
      {
        "id" : "Author.assignedAuthor.id",
        "path" : "Author.assignedAuthor.id",
        "short" : "The first id may be set equal to (a pointer to) an id on a participant elsewhere in the document (header or entries) or a new author participant can be described here. If the id is pointing to a participant already described elsewhere in the document, assignedAuthor/id is sufficient to identify this participant and none of the remaining details of assignedAuthor are required to be set. Application Software must be responsible for resolving the identifier back to its original object and then rendering the information in the correct place in the containing section's narrative text. This id must be a pointer to another author participant.",
        "comment" : "This assignedAuthor SHALL contain at least one [1..*] id (CONF:1098-31473)."
      },
      {
        "id" : "Author.assignedAuthor.code",
        "path" : "Author.assignedAuthor.code",
        "comment" : "This assignedAuthor SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1098-31671).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1",
              "documentation" : "If the content is patient authored the code **SHOULD** be selected from Personal And Legal Relationship Role Type (2.16.840.1.113883.11.20.12.1) (CONF:1098-32315).",
              "shortDoco" : "Patient-authored content"
            }
          ]
        }
      },
      {
        "id" : "Author.assignedAuthor.sdtcSpecialty",
        "path" : "Author.assignedAuthor.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Author.assignedAuthor.addr",
        "path" : "Author.assignedAuthor.addr",
        "short" : "Required on at least one instance of this author in the document",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Author.assignedAuthor.telecom",
        "path" : "Author.assignedAuthor.telecom",
        "short" : "Required on at least one instance of this author in the document"
      },
      {
        "id" : "Author.assignedAuthor.assignedPerson",
        "path" : "Author.assignedAuthor.assignedPerson",
        "short" : "assignedPerson/name or assignedAuthoringDevice/manufacturerModelName is required on at least one instance of this author in the document",
        "comment" : "This assignedAuthor MAY contain zero or one [0..1] assignedPerson (CONF:1098-31474)."
      },
      {
        "id" : "Author.assignedAuthor.assignedPerson.name",
        "path" : "Author.assignedAuthor.assignedPerson.name",
        "comment" : "The assignedPerson, if present, MAY contain zero or more [0..*] name (CONF:1098-31475)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization",
        "path" : "Author.assignedAuthor.representedOrganization",
        "short" : "assignedPerson/name or representedOrganization/name is required on at least one instance of this author in the document",
        "comment" : "This assignedAuthor MAY contain zero or one [0..1] representedOrganization (CONF:1098-31476)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.id",
        "path" : "Author.assignedAuthor.representedOrganization.id",
        "comment" : "The representedOrganization, if present, MAY contain zero or more [0..*] id (CONF:1098-31478)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.name",
        "path" : "Author.assignedAuthor.representedOrganization.name",
        "comment" : "The representedOrganization, if present, MAY contain zero or more [0..*] name (CONF:1098-31479)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.telecom",
        "path" : "Author.assignedAuthor.representedOrganization.telecom",
        "comment" : "The representedOrganization, if present, MAY contain zero or more [0..*] telecom (CONF:1098-31480)."
      },
      {
        "id" : "Author.assignedAuthor.representedOrganization.addr",
        "path" : "Author.assignedAuthor.representedOrganization.addr",
        "comment" : "The representedOrganization, if present, MAY contain zero or more [0..*] addr (CONF:1098-31481).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      }
    ]
  }
}

```
