# Advance Directive Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advance Directive Observation**

## Logical Model: Advance Directive Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AdvanceDirectiveObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.48:2025-05-01 | |

 
The Advance Directive Observation template is nested within the Advance Directive Existence Observation, which indicates whether the individual has any advance directive documents. Each Advance Directive Observation template provides details about one type of advance directive document and may also include information about the document’s author, as well as any individuals who discussed and verified its contents with the patient or their designated healthcare agent. 
The Advance Directive Observation template also can be nested within an Intervention Act to serve as documentation explaining why an intervention was planned/performed or not. 

**Usages:**

* Use this Logical Model Profile: [Advance Directive Existence Observation](StructureDefinition-AdvanceDirectiveExistenceObservation.md), [Advance Directive Organizer (deprecated)](StructureDefinition-AdvanceDirectiveOrganizer.md) and [Intervention Act](StructureDefinition-InterventionAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AdvanceDirectiveObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AdvanceDirectiveObservation.csv), [Excel](StructureDefinition-AdvanceDirectiveObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdvanceDirectiveObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.48:2025-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AdvanceDirectiveObservation",
  "title" : "Advance Directive Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Advance Directive Observation template is nested within the Advance Directive Existence Observation, which indicates whether the individual has any advance directive documents. Each Advance Directive Observation template provides details about one type of advance directive document and may also include information about the document’s author, as well as any individuals who discussed and verified its contents with the patient or their designated healthcare agent.\n\nThe Advance Directive Observation template also can be nested within an Intervention Act to serve as documentation explaining why an intervention was planned/performed or not.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          },
          {
            "key" : "should-informant",
            "severity" : "warning",
            "human" : "SHOULD contain informant",
            "expression" : "informant.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:advance-directive-obs",
        "path" : "Observation.templateId",
        "sliceName" : "advance-directive-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:advance-directive-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.48"
      },
      {
        "id" : "Observation.templateId:advance-directive-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2025-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id.",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Advance Directive",
        "constraint" : [
          {
            "key" : "should-translation",
            "severity" : "warning",
            "human" : "SHOULD contain translation",
            "expression" : "translation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "min" : 1,
        "patternCode" : "75320-2"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.code.translation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.code.translation",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Advance Directive Type",
        "comment" : "This code SHOULD contain zero or more [0..*] translation, which SHOULD be selected from ValueSet Advance Directives Categories urn:oid:2.16.840.1.113883.11.20.9.69.4.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.69.4"
        }
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "min" : 1,
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-8652).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1198-19082).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime.",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.low",
        "path" : "Observation.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low.",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.high",
        "path" : "Observation.effectiveTime.high",
        "short" : "If the Advance Directive does not have a specified ending time, use a nullFlavor of *NA*.\nIf the ending time is unknown, use a nullFlavor of *UNK*.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] high.",
        "min" : 1
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1115.41"
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Observation.informant",
        "path" : "Observation.informant",
        "short" : "SHOULD contain informant",
        "condition" : ["should-informant"]
      },
      {
        "id" : "Observation.participant",
        "path" : "Observation.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.participant:verifier",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.participant",
        "sliceName" : "verifier",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Verifier - The participant \"VRF\" represents the clinician(s) who verified the patient advance directive.",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-8662) such that it",
        "min" : 0,
        "max" : "*",
        "constraint" : [
          {
            "key" : "should-time",
            "severity" : "warning",
            "human" : "SHOULD contain time",
            "expression" : "time.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.participant:verifier.templateId",
        "path" : "Observation.participant.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.participant:verifier.templateId:primary",
        "path" : "Observation.participant.templateId",
        "sliceName" : "primary",
        "comment" : "SHALL contain exactly one [1..1] templateId (CONF:1198-8664) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.participant:verifier.templateId:primary.root",
        "path" : "Observation.participant.templateId.root",
        "comment" : "SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.10.20.1.58\" (CONF:1198-10486).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.58"
      },
      {
        "id" : "Observation.participant:verifier.templateId:primary.extension",
        "path" : "Observation.participant.templateId.extension",
        "comment" : "SHALL not contain [0..0] extension",
        "max" : "0"
      },
      {
        "id" : "Observation.participant:verifier.typeCode",
        "path" : "Observation.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"VRF\" Verifier (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8663).",
        "fixedCode" : "VRF"
      },
      {
        "id" : "Observation.participant:verifier.time",
        "path" : "Observation.participant.time",
        "comment" : "SHOULD contain zero or one [0..1] time (CONF:1198-8665).",
        "constraint" : [
          {
            "key" : "value-only",
            "severity" : "error",
            "human" : "Interval fields SHALL NOT be present",
            "expression" : "(low | high | width | center).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.participant:verifier.time.value",
        "path" : "Observation.participant.time.value",
        "short" : "value should be used instead of low/high"
      },
      {
        "id" : "Observation.participant:verifier.participantRole",
        "path" : "Observation.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:1198-8825).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.participant:verifier.participantRole.code",
        "path" : "Observation.participant.participantRole.code",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1198-28446).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "Observation.participant:verifier.participantRole.sdtcSpecialty",
        "path" : "Observation.participant.participantRole.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Observation.participant:verifier.participantRole.addr",
        "path" : "Observation.participant.participantRole.addr",
        "comment" : "This participantRole MAY contain zero or more [0..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:1198-28451).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Observation.participant:verifier.participantRole.playingEntity",
        "path" : "Observation.participant.participantRole.playingEntity",
        "comment" : "This participantRole SHALL contain exactly one [1..1] playingEntity (CONF:1198-28428).",
        "min" : 1
      },
      {
        "id" : "Observation.participant:verifier.participantRole.playingEntity.name",
        "path" : "Observation.participant.participantRole.playingEntity.name",
        "comment" : "The playingEntity SHALL contain exactly one [1..1] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:1198-28454).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "Observation.participant:healthcareAgent",
        "path" : "Observation.participant",
        "sliceName" : "healthcareAgent",
        "short" : "This custodian (CST) participant identifies a legal representative for healthcare decision-making. Examples of such  individuals are called health care agents, substitute decision makers and/or health care proxies.  Only record a healthcare agent who is acting in that capacitiy and participating in carae decision-making during the documented care encounter.",
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1198-8667) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.participant:healthcareAgent.typeCode",
        "path" : "Observation.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CST\" Custodian (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1198-8668).",
        "fixedCode" : "CST"
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole",
        "path" : "Observation.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:1198-8669).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          },
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.classCode",
        "path" : "Observation.participant.participantRole.classCode",
        "comment" : "This participantRole SHALL contain exactly one [1..1] @classCode=\"AGNT\" Agent (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 STATIC) (CONF:1198-8670).",
        "min" : 1,
        "fixedCode" : "AGNT"
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.code",
        "path" : "Observation.participant.participantRole.code",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Agent or Proxy Choices urn:oid:2.16.840.1.113762.1.4.1046.35 DYNAMIC (CONF:1198-28440).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1046.35"
        }
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.sdtcSpecialty",
        "path" : "Observation.participant.participantRole.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.addr",
        "path" : "Observation.participant.participantRole.addr",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:1198-8671).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.telecom",
        "path" : "Observation.participant.participantRole.telecom",
        "comment" : "This participantRole SHOULD contain zero or more [0..*] telecom (CONF:1198-8672)."
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.playingEntity",
        "path" : "Observation.participant.participantRole.playingEntity",
        "comment" : "This participantRole SHALL contain exactly one [1..1] playingEntity (CONF:1198-8824).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.playingEntity.code",
        "path" : "Observation.participant.participantRole.playingEntity.code",
        "comment" : "This playingEntity SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Personal and Legal Relationship RoleType urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "Observation.participant:healthcareAgent.participantRole.playingEntity.name",
        "path" : "Observation.participant.participantRole.playingEntity.name",
        "short" : "The name of the healthcare agent.",
        "comment" : "This playingEntity SHALL contain exactly one [1..1] name (CONF:1198-8673).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.reference",
        "path" : "Observation.reference",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.reference:reference1",
        "path" : "Observation.reference",
        "sliceName" : "reference1",
        "comment" : "SHOULD contain at least one [1..*] reference (CONF:1198-8692) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Observation.reference:reference1.typeCode",
        "path" : "Observation.reference.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-8694).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.reference:reference1.externalDocument",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.reference.externalDocument",
        "short" : "𝗨𝗦𝗖𝗗𝗜: External Document",
        "comment" : "SHALL contain exactly one [1..1] externalDocument (CONF:1198-8693).",
        "min" : 1
      },
      {
        "id" : "Observation.reference:reference1.externalDocument.id",
        "path" : "Observation.reference.externalDocument.id",
        "comment" : "This externalDocument SHALL contain at least one [1..*] id (CONF:1198-8695).",
        "min" : 1
      },
      {
        "id" : "Observation.reference:reference1.externalDocument.code",
        "path" : "Observation.reference.externalDocument.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1115.41"
        }
      },
      {
        "id" : "Observation.reference:reference1.externalDocument.text",
        "path" : "Observation.reference.externalDocument.text",
        "comment" : "This externalDocument MAY contain zero or one [0..1] text (CONF:1198-8696)."
      },
      {
        "id" : "Observation.reference:reference1.externalDocument.text.reference",
        "path" : "Observation.reference.externalDocument.text.reference",
        "short" : "The URL of a referenced advance directive document **MAY** be present, and **SHALL** be represented in Observation/reference/ExternalDocument/text/reference (CONF:1198-8698).",
        "comment" : "The text, if present, MAY contain zero or one [0..1] reference (CONF:1198-8697).",
        "constraint" : [
          {
            "key" : "1198-8699",
            "severity" : "warning",
            "human" : "If a URL is referenced, then it **SHOULD** have a corresponding linkHTML element in narrative block (CONF:1198-8699).",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          }
        ]
      },
      {
        "id" : "Observation.reference:reference1.externalDocument.sdtcAuthor",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "author"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.reference.externalDocument.sdtcAuthor",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Author"
      }
    ]
  }
}

```
