# Progress Note Complete Header Example - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Progress Note Complete Header Example**

## Example Binary: Progress Note Complete Header Example

This content is an example of the [Progress Note](StructureDefinition-ProgressNote.md) Logical Model and is not a FHIR Resource

```

<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<?xml-stylesheet type="text/xsl" href="CDA.xsl"?>
<!--
 Title:        Progress Note
 Based on:     C-CDA_R2_Progress_Note.xml

 Updated for C-CDA R3.0 with a focus on header elements
  - required/suggested sections are populated with nullFlavor="NI"
	  to demonstrate WHICH sections should be included, but they
		all contain "No information" as this is an example of the header
  
 ********************************************************
 Disclaimer: This sample file contains representative data elements to represent a Progress Note. 
 The file depicts a fictional character's health data. Any resemblance to a real person is coincidental. 
 To illustrate as many data elements as possible, the clinical scenario may not be plausible. 
 The data in this sample file is not intended to represent real patients, people or clinical events. 
 This sample is designed to be used in conjunction with the C-CDA Clinical Notes Implementation Guide.
 ********************************************************
 -->
<ClinicalDocument xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc">
	<!-- ** CDA Header ** -->
	<realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- US General Header Template -->
	<templateId root="2.16.840.1.113883.10.20.22.1.1" extension="2024-05-01"/>
	<!-- Progress Note Template  -->
	<templateId root="2.16.840.1.113883.10.20.22.1.9" extension="2024-05-01"/>
	<id extension="999022" root="2.16.840.1.113883.19"/>
	<sdtc:category code="11506-3" displayName="Progress note" codeSystem="2.16.840.1.113883.6.1"/>
	<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="11506-3" displayName="Progress note"/>
	<title>Progress Note</title>
	<effectiveTime value="20050329171504-0500"/>
	<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
	<languageCode code="en-US"/>
	<setId extension="111199021" root="2.16.840.1.113883.19"/>
	<versionNumber value="1"/>
	<recordTarget>
		<patientRole>
			<!-- Fake ID using HL7 example OID. -->
			<id extension="12345" root="2.16.840.1.113883.19"/>
			<!-- Fake Social Security Number using the actual SSN OID. -->
			<id extension="111-00-1234" root="2.16.840.1.113883.4.1"/>
			<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
			<addr use="HP">
				<streetAddressLine>17 Daws Rd.</streetAddressLine>
				<city>Blue Bell</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
				<country>US</country>
			</addr>
			<telecom value="tel:(781)555-1212" use="HP"/>
			<!-- HP is "primary home" from HL7 AddressUse 2.16.840.1.113883.5.1119 -->
			<patient>
				<name use="L">
					<!-- L is "Legal" from HL7 EntityNameUse 2.16.840.1.113883.5.45 -->
					<prefix>Mr.</prefix>
					<given>Adam</given>
					<given qualifier="CL">Frankie</given>
					<!-- CL is "Call me" from HL7 EntityNamePartQualifier 2.16.840.1.113883.5.43 -->
					<family>Everyman</family>
				</name>
				<administrativeGenderCode code="M" codeSystem="2.16.840.1.113883.5.1" displayName="Male"/>
				<birthTime value="19541125"/>
				<maritalStatusCode code="M" displayName="Married" codeSystem="2.16.840.1.113883.5.2" codeSystemName="MaritalStatusCode"/>
				<religiousAffiliationCode code="1013" displayName="Christian (non-Catholic, non-specific)" codeSystemName="HL7 Religious Affiliation" codeSystem="2.16.840.1.113883.5.1076"/>
				<raceCode code="2106-3" displayName="White" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<ethnicGroupCode code="2186-5" displayName="Not Hispanic or Latino" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<guardian>
					<code code="GRFTH" displayName="Grandfather" codeSystem="2.16.840.1.113883.5.111" codeSystemName="HL7 Role code"/>
					<addr use="HP">
						<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
						<streetAddressLine>17 Daws Rd.</streetAddressLine>
						<city>Blue Bell</city>
						<state>MA</state>
						<postalCode>02368</postalCode>
						<country>US</country>
						<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
					</addr>
					<telecom value="tel:(781)555-1212" use="HP"/>
					<guardianPerson>
						<name>
							<given>Ralph</given>
							<family>Relative</family>
						</name>
					</guardianPerson>
				</guardian>
				<birthplace>
					<place>
						<addr>
							<state>MA</state>
							<postalCode>02368</postalCode>
							<country>USA</country>
						</addr>
					</place>
				</birthplace>
				<languageCommunication>
					<languageCode code="fr"/>
					<modeCode code="RWR" displayName="Received Written" codeSystem="2.16.840.1.113883.5.60" codeSystemName="LanguageAbilityMode"/>
					<preferenceInd value="true"/>
				</languageCommunication>
			</patient>
			<providerOrganization>
				<!-- Organizations SHOULD have an NPI; this is a real root; fake extension -->
				<id root="2.16.840.1.113883.4.6" extension="111122223333"/>
				<name>Good Health Clinic</name>
				<telecom use="WP" value="tel:(781)555-1212"/>
				<addr use="WP">
					<streetAddressLine>21 North Ave</streetAddressLine>
					<city>Burlington</city>
					<state>MA</state>
					<postalCode>02368</postalCode>
					<country>USA</country>
				</addr>
			</providerOrganization>
		</patientRole>
	</recordTarget>
	<author>
		<time value="20050329224411+0500"/>
		<assignedAuthor>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<code code="200000000X" codeSystem="2.16.840.1.113883.6.101" displayName="Allopathic &amp; Osteopathic Physicians"/>
			<addr use="WP">
				<streetAddressLine>21 North Ave.</streetAddressLine>
				<city>Burlington</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<country>USA</country>
			</addr>
			<telecom use="WP" value="tel:(555)555-1003"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedAuthor>
	</author>
	<dataEnterer>
		<assignedEntity>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>21 North Ave.</streetAddressLine>
				<city>Burlington</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<country>USA</country>
			</addr>
			<telecom use="WP" value="tel:(555)555-1003"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</dataEnterer>
	<informant>
		<assignedEntity>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>21 North Ave.</streetAddressLine>
				<city>Burlington</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<country>USA</country>
			</addr>
			<telecom value="tel:(555)555-1003"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</informant>
	<informant>
		<relatedEntity classCode="PRS">
			<!-- classCode PRS represents a person with personal relationship with the patient. -->
			<code code="SPS" displayName="SPOUSE" codeSystem="2.16.840.1.113883.1.11.19563" codeSystemName="Personal Relationship Role Type Value Set"/>
			<relatedPerson>
				<name>
					<given>Rose</given>
					<family>Everyman</family>
				</name>
			</relatedPerson>
		</relatedEntity>
	</informant>
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id extension="444444444" root="2.16.840.1.113883.4.6"/>
				<name>Good Health Clinic</name>
				<telecom value="tel:(555)555-1212" use="WP"/>
				<addr use="WP">
					<streetAddressLine>17 Daws Rd.</streetAddressLine>
					<city>Blue Bell</city>
					<state>MA</state>
					<postalCode>02368</postalCode>
					<country>USA</country>
				</addr>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>
	<informationRecipient>
		<intendedRecipient>
			<informationRecipient>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</informationRecipient>
			<receivedOrganization>
				<name>Good Health Clinic</name>
			</receivedOrganization>
		</intendedRecipient>
	</informationRecipient>
	<legalAuthenticator>
		<time value="20050329224411+0500"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="444444444" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>21 North Ave.</streetAddressLine>
				<city>Burlington</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<country>USA</country>
			</addr>
			<telecom use="WP" value="tel:(555)555-1003"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</legalAuthenticator>
	<authenticator>
		<time value="20050329224411+0500"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="444444444" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>21 North Ave.</streetAddressLine>
				<city>Burlington</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<country>USA</country>
			</addr>
			<telecom use="WP" value="tel:(555)555-1003"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</authenticator>
	<participant typeCode="IND">
		<associatedEntity classCode="NOK">
			<code code="MTH" codeSystem="2.16.840.1.113883.5.111"/>
			<addr use="WP">
				<streetAddressLine>17 Daws Rd.</streetAddressLine>
				<city>Blue Bell</city>
				<state>MA</state>
				<postalCode>02368</postalCode>
				<country>USA</country>
			</addr>
			<telecom value="tel:(999)555-1212" use="WP"/>
			<associatedPerson>
				<name>
					<prefix>Mrs.</prefix>
					<given>Abigail</given>
					<family>Ruth</family>
				</name>
			</associatedPerson>
		</associatedEntity>
	</participant>
	<inFulfillmentOf typeCode="FLFS">
		<order classCode="ACT" moodCode="RQO">
			<id root="2.16.840.1.113883.19" extension="12345-67890"/>
		</order>
	</inFulfillmentOf>
	<documentationOf typeCode="DOC">
		<serviceEvent classCode="PCPR">
			<templateId root="2.16.840.1.113883.10.20.21.3.1"/>
			<effectiveTime>
				<low value="201006011035-0500"/>
				<high value="201009152200-0500"/>
			</effectiveTime>
			<performer typeCode="PRF">
				<functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88" codeSystemName="ParticipationFunction" displayName="Primary Care Provider">
					<originalText>Primary Care Provider</originalText>
				</functionCode>
				<time>
					<low value="200207161035-0500"/>
					<high value="200709152200-0500"/>
				</time>
				<assignedEntity>
					<id extension="555555555" root="2.16.840.1.113883.4.6"/>
					<code code="207R00000X" codeSystem="2.16.840.1.113883.6.101" displayName="Internal Medicine Physician"/>
					<addr/>
					<telecom value="tel:+1-301-975-3251" use="HP"/>
					<assignedPerson>
						<name>
							<prefix>Dr.</prefix>
							<given>Pseudo</given>
							<family>Physician-1</family>
						</name>
					</assignedPerson>
					<representedOrganization>
						<id root="2.16.840.1.113883.3.72.5"/>
						<name>NIST HL7 Test Laboratory</name>
						<telecom nullFlavor="UNK"/>
						<addr nullFlavor="UNK"/>
					</representedOrganization>
				</assignedEntity>
			</performer>
			<performer typeCode="PRF">
				<functionCode code="PP" displayName="Primary Care Provider" codeSystem="2.16.840.1.113883.12.443" codeSystemName="Provider Role">
					<originalText>Primary Care Provider</originalText>
				</functionCode>
				<time>
					<low value="200207161035-0500"/>
					<high value="200709152200-0500"/>
				</time>
				<assignedEntity>
					<id extension="666666666" root="2.16.840.1.113883.4.6"/>
					<id extension="PseudoMD-3" root="2.16.840.1.113883.19"/>
					<code code="207R00000X" codeSystem="2.16.840.1.113883.6.101" displayName="Internal Medicine Physician"/>
					<addr/>
					<telecom value="tel:+1-301-975-3251" use="HP"/>
					<assignedPerson>
						<name>
							<prefix>Dr.</prefix>
							<given>Pseudo</given>
							<family>Physician-3</family>
						</name>
					</assignedPerson>
					<representedOrganization>
						<id root="2.16.840.1.113883.19.123"/>
						<name>HL7 Test Laboratory</name>
						<telecom nullFlavor="UNK"/>
						<addr nullFlavor="UNK"/>
					</representedOrganization>
				</assignedEntity>
			</performer>
		</serviceEvent>
	</documentationOf>
	<componentOf>
		<encompassingEncounter>
			<id extension="9937012" root="2.16.840.1.113883.19"/>
			<code codeSystem="2.16.840.1.113883.6.12" codeSystemName="CPT-4" code="99213" />
			<effectiveTime>
				<low value="200503291035-0500"/>
				<high value="200503292200-0500"/>
			</effectiveTime>
			<location>
				<healthCareFacility>
					<id root="2.16.540.1.113883.19.2"/>
				</healthCareFacility>
			</location>
		</encompassingEncounter>
	</componentOf>
	<component>
    <!-- All sections are set to nullFlavor / text = No information, 
        as this is a header example, not a complete body example -->
		<structuredBody>
			<!-- Assessment & Plan (or Assessment Section + Plan Section -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.9" extension="2014-06-09" />
					<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="51847-2" displayName="Evaluation + Plan note" />
					<title>ASSESSMENT AND PLAN</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section>
				  <!-- Notes Section -->
				  <templateId root="2.16.840.1.113883.10.20.22.2.65" extension="2026-05-01"/>
				  <code code="11488-4" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Consult note"/>
				  <title>Consultation Notes</title>
				  <text>
				    <list>
				      <item ID="ConsultNote1">
				        <paragraph>Dr. Specialist - September 8, 2016</paragraph>
				        <paragraph>Evaluated patient due to symptoms of...</paragraph>
				      </item>
				    </list>
				  </text>
				  <!-- Note Activity entry -->
				  <entry>
				    <act classCode="ACT" moodCode="EVN">
				      <templateId root="2.16.840.1.113883.10.20.22.4.202" extension="2026-05-01"/>
				      <code code="34109-9" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Note">
				        <translation code="28570-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Procedure note" />
				      </code>
				      <text>
				        <reference value="#ConsultNote1" />
				      </text>
				      <statusCode code="completed"/>
				      <!-- Clinically-relevant time of the note -->
				      <effectiveTime value="20140203" />
				      <!-- Author Participation -->
				      <author>
				        <templateId root="2.16.840.1.113883.10.20.22.4.119" />
				        <!-- Time note was actually written -->
				        <time value="20140204083215-0500" />
				        <assignedAuthor>
				          <id root="20cf14fb-b65c-4c8c-a54d-b0cca834c18c" />
							    <addr use="WP">
							      <streetAddressLine>1001 Hospital Lane</streetAddressLine>
							      <city>Ann Arbor</city>
							      <state>MI</state>
							      <postalCode>99999</postalCode>
							      <country>US</country>
							    </addr>
							    <telecom value="tel:(999)555-1212" />
				          <assignedPerson>
				            <name>Dr. Physician</name>
				          </assignedPerson>
				        </assignedAuthor>
				      </author>
				    </act>
				  </entry>
				</section>
			</component>
		</structuredBody>
	</component>
</ClinicalDocument>

```

