# Patient Generated Document informationRecipient Example - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Generated Document informationRecipient Example**

## Example Binary: Patient Generated Document informationRecipient Example

This content is an example of the [US Realm Header for Patient Generated Document](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md) Logical Model and is not a FHIR Resource

```

<ClinicalDocument xmlns="urn:hl7-org:v3">
  <realmCode code="US" />
  <typeId extension="POCD_HD000040" root="2.16.840.1.113883.1.3" />
  <templateId root="2.16.840.1.113883.10.20.22.1.1" extension="2024-05-01" />
  <templateId root="2.16.840.1.113883.10.20.29.1" extension="2024-05-01" />
  <id root="2c1e0e12-b0ae-4456-a526-c11d5e69e77c" />
  <code code="68831-7" displayName="Discharge summary note" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" />
  <title>Patient Discharge Summary</title>
  <effectiveTime value="201308151030-0800" />
  <confidentialityCode code="N" displayName="normal" codeSystem="2.16.840.1.113883.5.25" codeSystemName="Confidentiality" />
  <languageCode code="en-US" />

  <recordTarget>
    <patientRole>
      <id extension="444222222" root="2.16.840.1.113883.4.1"/>
			<!-- Example Social Security Number using the actual SSN OID. -->
			<addr use="HP">
				<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
				<streetAddressLine>2222 Home Street</streetAddressLine>
				<city>Beaverton</city>
				<state>OR</state>
				<postalCode>97867</postalCode>
				<country>US</country>
				<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
			</addr>
			<telecom value="tel:+1(555)555-2003" use="HP"/>
			<!-- HP is "primary home" from HL7 AddressUse 2.16.840.1.113883.5.1119 -->
      <patient>
				<name use="L">
					<given>Adam</given>
					<family>Everyman</family>
				</name>
				<administrativeGenderCode code="M" displayName="Male" codeSystem="2.16.840.1.113883.5.1" codeSystemName="AdministrativeGender"/>
				<birthTime value="19750501"/>
				<religiousAffiliationCode code="1013" displayName="Christian (non-Catholic, non-specific)" codeSystem="2.16.840.1.113883.5.1076" codeSystemName="HL7 Religious Affiliation"/>
        <raceCode code="2106-3" displayName="White" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
        <ethnicGroupCode code="2186-5" displayName="Not Hispanic or Latino" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<birthplace>
					<place>
						<addr use="H">
							<streetAddressLine>4444 Home Street</streetAddressLine>
							<city>Beaverton</city>
							<state>OR</state>
							<postalCode>97867</postalCode>
							<country>US</country>
						</addr>
					</place>
				</birthplace>
				<languageCommunication>
					<languageCode code="en"/>
					<!-- "en" is ISO 639-1 alpha-2 code for "English" -->
					<modeCode code="ESP" displayName="Expressed spoken" codeSystem="2.16.840.1.113883.5.60" codeSystemName="LanguageAbilityMode"/>
					<proficiencyLevelCode code="G" displayName="Good" codeSystem="2.16.840.1.113883.5.61" codeSystemName="LanguageAbilityProficiency"/>
					<!-- Patient's preferred language -->
					<preferenceInd value="true"/>
				</languageCommunication>
			</patient>
    </patientRole>
  </recordTarget>
  <author>
		<time value="201308151030-0800"/>
		<assignedAuthor>
			<id extension="5555555555" root="2.16.840.1.113883.4.6"/>
			<code code="207QA0505X" displayName="Adult Medicine Physician" codeSystem="2.16.840.1.113883.6.101" codeSystemName="Healthcare Provider Taxonomy (HIPAA)"/>
			<addr use="WP">
				<streetAddressLine>1004 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)555-1004"/>
			<assignedPerson>
				<name>
					<given>Patricia</given>
					<given qualifier="CL">Patty</given>
					<family>Primary</family>
					<suffix qualifier="AC">M.D.</suffix>
				</name>
			</assignedPerson>
		</assignedAuthor>
	</author>
  <custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id extension="321CX" root="2.16.840.1.113883.4.6"/>
				<name>Good Health HIE</name>
				<telecom use="WP" value="tel:+1(555)555-1009"/>
				<addr use="WP">
					<streetAddressLine>1009 Healthcare Drive </streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>
  <!-- The document is intended for multiple recipients, Adam himself and his PCP physician. -->
  <informationRecipient>
    <intendedRecipient>
      <!-- Identifier based on the person's Direct Address which is a secure and trusted mechanism for identifying 
          a person discretely. The root of the id is the OID of the HISP Assigning Authority for the Direct Address-->
      <id extension="adameveryman@direct.sampleHISP.com" root="2.16.123.123.12345.1234" />
      <informationRecipient>
        <name>
          <given>Adam</given>
          <family>Everyman</family>
        </name>
      </informationRecipient>
      <receivedOrganization>
        <!-- id using HL7 example OID. -->
        <id extension="999.3" root="2.16.840.1.113883.19" />
        <name>MyPersonalHealthRecord.Com</name>
      </receivedOrganization>
    </intendedRecipient>
  </informationRecipient>
  <informationRecipient>
    <intendedRecipient>
      <!-- Unique/Trusted id using HL7 example OID. -->
      <id extension="999.4" root="2.16.840.1.113883.19" />
      <!-- The physician's NPI number -->
      <id extension="1122334455" root="2.16.840.1.113883.4.6" />
      <!-- The physician's Direct Address -->
      <!-- Identifier based on the person's Direct Address which is a secure and trusted mechanism for identifying 
          a person discretely. The root of the id is the OID of the HISP Assigning Authority for the Direct Address-->
      <id extension="DrP@direct.sampleHISP2.com" root="2.16.123.123.12345.4321" />
      <telecom use="WP" value="tel:(781)555-1212" />
      <telecom use="WP" value="mailto:DrP@direct.sampleHISP2.com" />
      <informationRecipient>
        <name>
          <prefix>Dr.</prefix>
          <given>Patricia</given>
          <family>Primary</family>
        </name>
      </informationRecipient>
      <receivedOrganization>
        <!-- Unique/Trusted id using HL7 example OID. -->
        <id extension="999.2" root="2.16.840.1.113883.19" />
        <!-- NPI for the organization -->
        <id extension="1234567890" root="2.16.840.1.113883.4.6" />
        <name>Good Health Internal Medicine</name>
        <telecom use="WP" value="tel:(781)555-1212" />
        <addr>
          <streetAddressLine>100 Health Drive</streetAddressLine>
          <city>Boston</city>
          <state>MA</state>
          <postalCode>02368</postalCode>
          <country>USA</country>
        </addr>
      </receivedOrganization>
    </intendedRecipient>
  </informationRecipient>
  <legalAuthenticator>
		<time value="20130801223615-0800"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="555555555" root="2.16.840.1.113883.4.6"/>
			<code code="207QA0505X" displayName="Adult Medicine Physician" codeSystem="2.16.840.1.113883.6.101" codeSystemName="Healthcare Provider Taxonomy (HIPAA)"/>
			<addr>
				<streetAddressLine>1004 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)-1004"/>
			<assignedPerson>
				<name>
					<given>Patricia</given>
					<given qualifier="CL">Patty</given>
					<family>Primary</family>
					<suffix qualifier="AC">M.D.</suffix>
				</name>
			</assignedPerson>
		</assignedEntity>
	</legalAuthenticator>
  <component>
    <structuredBody>
      <component>
        <section>
          <!-- Individual Body Section Contents --> 
        </section>
      </component>
    </structuredBody>
  </component>
</ClinicalDocument>
```

