# USCDI - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* **USCDI**

## USCDI

The C-CDA templates were designed to meet the 2015 Edition certification criterion for Consolidated CDA Creation 170.315(g)(6). They were created for each item in the [2015 Edition Common Clinical Data Set (CCDS)](https://www.healthit.gov/sites/default/files/ccds_reference_document_v1_1.pdf). The C-CDA templates on this page contain requirements up to and including [U.S. Core Data for Interoperability (USCDI) v5](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi). Consolidated CDA is based on community input and used for USCDI ONC certification.

Note that:

* USCDI Data Classes and Element names may not be the same as the C-CDA template names and element names.
* Not every USCDI Data Class and Element is mapped to a single template.
* Many C-CDA elements do not map to a USCDI Data Class or Element because C-CDA usage is broader than certification and because additional C-CDA elements are required to make CDA implementable.

ONC's USCDI and Consolidated CDA are complementary initiatives, with USCDI defining high-level data requirements and Consolidated CDA providing detailed templates for meeting those requirements. Mapping between them is necessary for achieving interoperability and consistency in healthcare data exchange within the United States. Consolidated CDA is broader than USCDI and therefore, to make USCDI implementable in CDA, interpretation of USCDI is necessary. USCDI data classes and element names may not be the same as the Consolidated CDA template and element names.

Updates to C-CDA depend upon community input and we encourage our audience to submit questions and feedback to C-CDA specifications by clicking on the **Propose a change** link in the footer of every page. In addition, we encourage our audience to request any necessary clarifications to USCDI through the [USCDI ONDEC process](https://www.healthit.gov/isa/ONDEC) that helps inform future updates to C-CDA.

Here is the roadmap for [USCDI support in C-CDA](https://confluence.hl7.org/spaces/USR/pages/345082630/2025+C-CDA+Version+Support).

| | | |
| :--- | :--- | :--- |
| v6 | [C-CDA STU 5.0](https://hl7.org/cda/us/ccda/5.0.0/) |   |
| v5 | [C-CDA STU 4.0](https://hl7.org/cda/us/ccda/4.0.0/) |   |
| v4 | [C-CDA STU 3.0](https://hl7.org/cda/us/ccda/3.0.0/) | Jan 2028 (proposed) |
| v3 | [C-CDA R2.1](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=492)and[C-CDA Companion Guide Release 4.1](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=447) | Jan 2026 |
| v2 | [C-CDA R2.1](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=492)and[C-CDA Companion Guide Release 3](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=447) |   |
| v1 | [C-CDA R2.1](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=492)and[C-CDA Companion Guide Release 2](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=447) |   |

The table below lists the C-CDA templates used for the corresponding USCDI Data elements. It is a mapping between USCDI data elements and C-CDA Templates and C-CDA elements. Implementers seeking ONC certification **SHALL** interpret elements marked as **USCDI** as elements to be supported. All **SHALL** and **USCDI** elements are in scope for ONC Health IT Certification.

US Core Data for Interoperability (USCDI)

| | | |
| :--- | :--- | :--- |
|     •Substance (Medication) | [Allergy - Intolerance Observation](StructureDefinition-AllergyIntoleranceObservation.md) |  |
|     •Substance (Drug Class) | [Allergy - Intolerance Observation](StructureDefinition-AllergyIntoleranceObservation.md) |  |
|     •Substance (Non-Medication) | [Allergy - Intolerance Observation](StructureDefinition-AllergyIntoleranceObservation.md) |  |
|     •Reaction | [Allergy - Intolerance Observation](StructureDefinition-AllergyIntoleranceObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Care Plan | [Care Plan Act](StructureDefinition-CarePlanAct.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Name | [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md) |  |
|     •Identifier | [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md) |  |
|     •Location | [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md) |  |
|     •Telecom | [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md) |  |
|     •Role | [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Consultation Note | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •Discharge Summary Note | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •History & Physical | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •Imaging Narrative | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •Procedure Note | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •Progress Note | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •Operative Note | [Note Activity](StructureDefinition-NoteActivity.md) |  |
|     •Emergency Department Note | [Note Activity](StructureDefinition-NoteActivity.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Clinical Test | [Result Organizer](StructureDefinition-ResultOrganizer.md)[Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Clinical Test Result/Report | [Result Observation](StructureDefinition-ResultObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Diagnostic Imaging Test | [Result Organizer](StructureDefinition-ResultOrganizer.md) |  |
|     •Diagnostic Imaging Result/Report | [Result Observation](StructureDefinition-ResultObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Identifier | [Encounter Activity](StructureDefinition-EncounterActivity.md) |  |
|     •Type | [Encounter Activity](StructureDefinition-EncounterActivity.md) |  |
|     •Diagnosis | [Encounter Diagnosis](StructureDefinition-EncounterDiagnosis.md)[Hospital Discharge Diagnosis](StructureDefinition-HospitalDischargeDiagnosis.md)[Problem Observation](StructureDefinition-ProblemObservation.md) |  |
|     •Time | [Encounter Activity](StructureDefinition-EncounterActivity.md) |  |
|     •Location | [Encounter Activity](StructureDefinition-EncounterActivity.md) |  |
|     •Disposition | [Encounter Activity](StructureDefinition-EncounterActivity.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Identifier | [Service Delivery Location](StructureDefinition-ServiceDeliveryLocation.md) |  |
|     •Type | [Service Delivery Location](StructureDefinition-ServiceDeliveryLocation.md) |  |
|     •Name | [Service Delivery Location](StructureDefinition-ServiceDeliveryLocation.md) |  |
|     •Address | [Service Delivery Location](StructureDefinition-ServiceDeliveryLocation.md)[US Realm Header](StructureDefinition-USRealmHeader.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Family Health History | [Family History Section](StructureDefinition-FamilyHistorySection.md)[Family History Organizer](StructureDefinition-FamilyHistoryOrganizer.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Patient Goals | [Goal Observation](StructureDefinition-GoalObservation.md) |  |
|     •SDOH Goals | [Goal Observation](StructureDefinition-GoalObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Treatment Intervention Preference | [Treatment Intervention Preference](StructureDefinition-TreatmentInterventionPreference.md) |  |
|     •Care Experience Preference | [Care Experience Preference](StructureDefinition-CareExperiencePreference.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Coverage Status | [Coverage Activity](StructureDefinition-CoverageActivity.md) |  |
|     •Coverage Type | [Policy Activity](StructureDefinition-PolicyActivity.md) |  |
|     •Relationship to Subscriber | [Policy Activity](StructureDefinition-PolicyActivity.md) |  |
|     •Member Identifier | [Policy Activity](StructureDefinition-PolicyActivity.md) |  |
|     •Subscriber Identifier | [Policy Activity](StructureDefinition-PolicyActivity.md) |  |
|     •Group Identifier | [Policy Activity](StructureDefinition-PolicyActivity.md) |  |
|     •Payer Identifier | [Policy Activity](StructureDefinition-PolicyActivity.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Health Concerns | [Health Concern Act](StructureDefinition-HealthConcernAct.md) |  |
|     •Functional Status | [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md)[Assessment Scale Supporting Observation](StructureDefinition-AssessmentScaleSupportingObservation.md)[Functional Status Observation](StructureDefinition-FunctionalStatusObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Disability Status | [Disability Status Observation](StructureDefinition-DisabilityStatusObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Mental/Cognitive Status | [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md)[Assessment Scale Supporting Observation](StructureDefinition-AssessmentScaleSupportingObservation.md)[Mental Status Observation](StructureDefinition-MentalStatusObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Pregnancy Status | [Pregnancy Status Observation](StructureDefinition-PregnancyStatusObservation.md)[Pregnancy Intention in Next Year](StructureDefinition-PregnancyIntentionInNextYear.md) |  |
|     •Alcohol Use | [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md)[Assessment Scale Supporting Observation](StructureDefinition-AssessmentScaleSupportingObservation.md)[Social History Observation](StructureDefinition-SocialHistoryObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Substance Use | [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md)[Assessment Scale Supporting Observation](StructureDefinition-AssessmentScaleSupportingObservation.md)[Social History Observation](StructureDefinition-SocialHistoryObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Physical Activity | [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •SDOH Assessment | [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |
|     •Smoking Status | [Smoking Status](StructureDefinition-SmokingStatus.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Immunizations | [Immunization Activity](StructureDefinition-ImmunizationActivity.md) |  |
|     •Lot Number | [Immunization Medication Information](StructureDefinition-ImmunizationMedicationInformation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Tests | [Result Organizer](StructureDefinition-ResultOrganizer.md)[Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Values/Results | [Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Specimen Type | [Result Organizer](StructureDefinition-ResultOrganizer.md) |  |
|     •Result Status | [Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Result Unit of Measure | [Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Result Reference Range | [Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Result Interpretation | [Result Observation](StructureDefinition-ResultObservation.md) |  |
|     •Specimen Identifier | [Result Organizer](StructureDefinition-ResultOrganizer.md) |  |
|     •Specimen Source Site | [Specimen Collection Procedure](StructureDefinition-SpecimenCollectionProcedure.md) |  |
|     •Specimen Condition Acceptability | [Specimen Condition Observation](StructureDefinition-SpecimenConditionObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Unique Device Identifier | [UDI Organizer](StructureDefinition-UDIOrganizer.md)[Product Instance](StructureDefinition-ProductInstance.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Medications | [Medication Activity](StructureDefinition-MedicationActivity.md) |  |
|     •Dose | [Medication Activity](StructureDefinition-MedicationActivity.md) |  |
|     •Dose Unit of Measure | [Medication Activity](StructureDefinition-MedicationActivity.md) |  |
|     •Route of Administration | [Medication Activity](StructureDefinition-MedicationActivity.md) |  |
|     •Indication | [Medication Activity](StructureDefinition-MedicationActivity.md)[Indication](StructureDefinition-Indication.md) |  |
|     •Route of Administration | [Medication Activity](StructureDefinition-MedicationActivity.md) |  |
|     •Medication Instructions | [Medication Free Text Sig](StructureDefinition-MedicationFreeTextSig.md) |  |
|     •Medication Adherence | [Medication Adherence](StructureDefinition-MedicationAdherence.md) |  |
|     •Fill Status | [Medication Dispense](StructureDefinition-MedicationDispense.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Advance Directive Observation | [Advance Directive Existence Observation](StructureDefinition-AdvanceDirectiveExistenceObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Medication Order | [Planned Medication Activity](StructureDefinition-PlannedMedicationActivity.md) |  |
|     •Laboratory Order | [Planned Procedure](StructureDefinition-PlannedProcedure.md) |  |
|     •Diagnostic Imaging Order | [Planned Procedure](StructureDefinition-PlannedProcedure.md) |  |
|     •Clinical Test Order | [Planned Procedure](StructureDefinition-PlannedProcedure.md) |  |
|     •Procedure Order | [Planned Procedure](StructureDefinition-PlannedProcedure.md) |  |
|     •Portable Medical Order | [Advance Directives Section](StructureDefinition-AdvanceDirectivesSection.md)[Advance Directive Existence Observation](StructureDefinition-AdvanceDirectiveExistenceObservation.md)[Advance Directive Observation](StructureDefinition-AdvanceDirectiveObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •First Name | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Last Name | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Previous Name | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Middle Name (including middle initial) | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Suffix | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Sex | [US Realm Header](StructureDefinition-USRealmHeader.md)[Sex Observation](StructureDefinition-SexObservation.md) |  |
|     •Date of Birth | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Date of Death | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Race | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Ethnicity | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Tribal Affiliation | [Tribal Affiliation Observation](StructureDefinition-TribalAffiliationObservation.md) |  |
|     •Preferred Language | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Interpreter Needed | [Interpreter Needed Observation](StructureDefinition-InterpreterNeededObservation.md) |  |
|     •Address | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Previous Address | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Email | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Phone Number | [US Realm Header](StructureDefinition-USRealmHeader.md) |  |
|     •Related Person's Name | [Related Person Relationship and Name Participant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md) |  |
|     •Related Person's Relationship | [Related Person Relationship and Name Participant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md) |  |
|     •Occupation | [Basic Occupation Observation](StructureDefinition-BasicOccupationObservation.md) |  |
|     •Occupation Industry | [Basic Industry Observation](StructureDefinition-BasicIndustryObservation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Assessment and Plan of Treatment | [Assessment Section](StructureDefinition-AssessmentSection.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Date of Resolution | [Problem Observation](StructureDefinition-ProblemObservation.md) |  |
|     •Date of Diagnosis | [Problem Observation](StructureDefinition-ProblemObservation.md)[Date of Diagnosis Act](StructureDefinition-DateOfDiagnosisAct.md) |  |
|     •Date of Onset | [Problem Observation](StructureDefinition-ProblemObservation.md) |  |
|     •SDOH Problems/Health Concerns | [Health Concern Act](StructureDefinition-HealthConcernAct.md)[Problem Observation](StructureDefinition-ProblemObservation.md)[Social History Observation](StructureDefinition-SocialHistoryObservation.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |

| | | |
| :--- | :--- | :--- |
|     •Procedure | [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md) |  |
|     •Performance Time | [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md) |  |
|     •Reason for Referral | [Reason for Referral Section](StructureDefinition-ReasonforReferralSection.md) |  |
|     •SDOH Interventions | [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)[Planned Procedure](StructureDefinition-PlannedProcedure.md) | [See Screening and Assessments Guidance](screeningandassessments.md) |

| | | |
| :--- | :--- | :--- |
|     •Author Time Stamp | [Provenance - Author Participation](StructureDefinition-ProvenanceAuthorParticipation.md) |  |
|     •Author Organization | [Provenance - Author Participation](StructureDefinition-ProvenanceAuthorParticipation.md) |  |
|     •Author | [Provenance - Author Participation](StructureDefinition-ProvenanceAuthorParticipation.md) |  |
|     •Author Role | [Provenance - Author Participation](StructureDefinition-ProvenanceAuthorParticipation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Average Blood Pressure | [Average Blood Pressure Organizer](StructureDefinition-AverageBloodPressureOrganizer.md) |  |
|     •Diastolic blood pressure | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Systolic blood pressure | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Body height | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Body weight | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Heart rate | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Respiratory rate | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Body temperature | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Pulse oximetry | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Inhaled oxygen concentration | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •BMI Percentile (2-20 years old) | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Weight-for-length Percentile (Birth - 36 months) | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |
|     •Occipital Frontal Head Circumference Percentile (Birth - 36 months) | [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) |  |

