# Screening And Assessments - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* **Screening And Assessments**

## Screening And Assessments

Clinicians use various terms such as assessments, scales, surveys, and screenings to describe the tools and processes to collect health-related information for assessing a patient’s health-related matter. C-CDA uses the term Screening and Assessments for the process of recording responses and capturing assertions/determinations resulting from this process and these tools. This page documents how Screening and Assessments are used to identify various problems or health concerns and how C-CDA templates record Screenings and Assessments utilizing Social History Observations, Problem Observations, and Assessment Scale observations and its supporting observation to record complex structured evaluations.

### Assessment Screenings

Assessment Screenings can represent a structured evaluation of risk (e.g., PRAPARE, Hunger Vital Sign, AHC-HRSN screening tool) for any Social Determinants of Health domain such as food, housing, or transportation security. They can also be used for physical health evaluations such as an Apgar score, or Glasgow coma scale. Assessment Screening responses are represented in C-CDA with the [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) together with [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md). The [Social History Observation](StructureDefinition-SocialHistoryObservation.md) is for simple observations made by an individual about a patient's social history status during the course of care. Both can contribute to the identification of SDOH Problems (Conditions) or Observations or can be the reason for Service Requests (Planned Procedures) or Procedures.

[Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) and its contained [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) are designed to represent [LOINC Panels](https://loinc.org/panels/) that are collections of LOINC terms that represent specific sets of information, intended for forms or assessments related to health that are completed by patients and/or providers.

When an Assessment Scale Observation is contained in a Problem Observation, a Social History Observation, a Procedure, or a Planned Procedure instance that is Social Determinant of Health focused, that Assessment scale may contain assessment scale observations that represent question and answer pairs from SDOH screening instruments.

For communicating detailed observations related to an individual’s work information, implementers can consider utilizing the templates in the [C- CDA 2.1 Supplemental Templates for Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522) implementation guide.

SDOH Observations and Survey Screenings and the resultant plans and interventions are foundational towards improving a person's overall health and wellness when confronted with health problems.

### Specific USCDI Data Elements Represented with Assessment Screening

Systems **SHALL** support representing detailed questions and answers from a formal assessment in the [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) together with [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md).

Systems **SHALL** support representing a simple question and answer from a formal assessment in the [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) without contained Assessment Scale Supporting Observations.

Systems **SHALL** support representing a clinical judgement that may be derived from a formal assessment using the [Problem Observation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.707/expansion) at Observation.value or with [Social History Observation](StructureDefinition-SocialHistoryObservation.md) Observation.value.

* When a Problem observation or Social History Observation is recorded based on a structured screening and assessment, the Assessment Scale Observation should be contained in the Problem Observation or Social History Observation or they should refer to the Assessment Scale Observation using the [Entry Reference Template](StructureDefinition-EntryReference.md).

Specific observations, such as Disability Status Observation, includes a USCDI indicator on the Assessment scale observation to formalize this USCDI requirement. The ability for systems to support [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) together with [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md) is a USCDI requirement.

#### Alcohol Use

The [Alcohol Use Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1585/expansion) contains the LOINC Panel Codes for Alcohol Use Disorder Identification Test - Consumption AUDIT-C and PROMIS short form - alcohol - alcohol use 7a - version 1.0. This value set is used with [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) together with [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md) to represent detailed patient questionnaires about alcohol use.

#### Substance Use (Including Alcohol Use)

The [Substance Use](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1015/expansion) is used with [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) without the Assessment Scale Supporting Observation to represent simple question and answer assessement questions such as, "How often do you have a drink containing alcohol" or "How often have you used any prescription medications just for the feeling, more than prescribed or that were not prescribed for you in past 12 months (TAPS)".

The [Drug Misuse](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.707/expansion) value set is used with [Problem Observation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.707/expansion) at Observation.value or with [Social History Observation](StructureDefinition-SocialHistoryObservation.md) at Observation.value to represent conclusions or diagnoses pertaining to drug misuse or abuse.

#### Mental and Cognitive Health

The [Cognitive Health Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.979/expansion) contains LOINC panel Codes that represent Mental or Cognitive health screening assessments, such as FACIT, PROMIS and MoCA. This value set is used with [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) together with [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md) to represent detailed patient questionnaires about assessing mental or cognitive health.

The [Cognitive Function Clinician Interpretation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1015/expansion) value set is used with [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) without the Assessment Scale Supporting Observation to represent simple question and answer assessement questions. Examples are "Cognitive Function Interpretation", that may have a text answer of clinician's assessment and "Memory/recall ability during assessment period" that may have answers such as the ability to recall the current season or the where the person is.

The [Mental Status Observation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.1/expansion) value set is used with [Mental Status Observation](StructureDefinition-MentalStatusObservation.md) to represent an observation about mental status that can come from a broad range of subjective and objective information such as Assessment and Screening tools.

#### Functional Status

The [Functional Status Related Questionnaire Panel Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1586/expansion) contains LOINC panel codes that represent functional status questionnaire LOINC panel codes This value set is used with [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) together with [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md) to represent detailed patient questionnaires about functional status.

The [Functional Status Observation](StructureDefinition-FunctionalStatusObservation.md) may be used to represent an observation about mental status that can come from a broad range of subjective and objective information such as what may be derived from Assessment and Screening tools.

#### Physical Activity

The [Physical Activity Level](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1068/expansion) value set is used with [Assessment Scale observation](StructureDefinition-AssessmentScaleObservation.md) without the Assessment Scale Supporting Observation to represent simple question and answer assessement questions such as, "Kinds of physical activity you usually performed while on the job this last year" or "Days per week of moderate to vigorous physical activity".

Assessment and Planning Process SDOH example
### Social Determinant of Health Vocabulary Design Notes

#### Value Sets Developed by the Gravity Project

For the SDOH Clinical Care HL7 Implementation Guide, the Gravity project has defined the following value sets across specific social risk factor domains for problems/health concerns, goals, procedures, service requests and health screening assessments:

* [Social Determinants of Health Conditions Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.788/expansion)
* [Social Determinants of Health Procedures Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.789/expansion)
* [Social Determinants of Health Goals Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.71/expansion)
* [Social Determinants of Health Service Requests Value Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.790/expansion) (Used in the Planned Procedure Template)
* [Social Determinants of Health Screening Assessments And Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.206/expansion)

The Figure below illustrates how the Gravity value sets are grouped for use in the C- CDA Problem Observation template.

Example of SDOH Grouping Value set in VSAC (Conditions)
#### Other SDOH Value Sets Available for Use

The following value sets are stewarded by the HL7 Patient Care Work Group and were built for the [Multiple Chronic Care Implementation Guide](https://build.fhir.org/ig/HL7/fhir-us-mcc/) for use in the Care Planning process, but they could be used with [Assessment Scale observations](StructureDefinition-AssessmentScaleObservation.md) without contained Assessment Scale Supporting Observations or [Assessment Scale Supporting observations](StructureDefinition-AssessmentScaleSupportingObservation.md) at Observation.code.

| | | | |
| :--- | :--- | :--- | :--- |
| **Value Set Name and VSAC Link** | **Value Set Clinical Focus** | **OID** | **Profile Element** |
| [Caregiver Availability](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1058/expansion) | This set of values addresses terms representing an observation of caregiver availability. | 2.16.840.1.113762.1.4.1222.1058 | Observation.code |
| [Caregiver Characteristics](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1057/expansion) | This set of values addresses terms representing an observation of caregiver characteristics. | 2.16.840.1.113762.1.4.1222.1057 | Observation.code |
| [Criminal Justice Involvement or Incarceration History](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1082/expansion) | This set of values addresses terms representing an observation of criminal justice involvement or incarceration history. | 2.16.840.1.113762.1.4.1222.1082 | Observation.code |
| [Current or Former Occupation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1048/expansion) | This set of values addresses terms representing an observation of current or former occupation. | 2.16.840.1.113762.1.4.1222.1048 | Observation.code |
| [Dependents in Home](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1065/expansion) | This set of values addresses terms representing an observation of the number of dependents in home. | 2.16.840.1.113762.1.4.1222.1065 | Observation.code |
| [English Proficiency](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1030/expansion) | This set of values addresses terms representing an observation of English proficiency. | 2.16.840.1.113762.1.4.1222.1030 | Observation.code |
| [Experiences of Discrimination](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1080/expansion) | This set of values addresses terms representing an observation of an experiences of discrimination. | 2.16.840.1.113762.1.4.1222.1080 | Observation.code |
| [Exposure to Environmental Hazards](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1075/expansion) | This set of values addresses terms representing an observation of exposure to environmental hazards. | 2.16.840.1.113762.1.4.1222.1075 | Observation.code |
| [Immigration Status](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1083/expansion) | This set of values addresses terms representing an observation of immigration status or citizenship. | 2.16.840.1.113762.1.4.1222.1083 | Observation.code |
| [Income Level](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1053/expansion) | This set of values addresses terms representing an observation of an individual or household income level. | 2.16.840.1.113762.1.4.1222.1053 | Observation.code |
| [Leisure Activity Engagement](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1069/expansion) | This set of values addresses terms representing an observation of engagement in leisure activities. | 2.16.840.1.113762.1.4.1222.1069 | Observation.code |
| [Living Situation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1060/expansion) | This set of values addresses terms representing an observation of a patient's living situation/living arrangements. | 2.16.840.1.113762.1.4.1222.1060 | Observation.code |
| [Marital or Spousal Status](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1064/expansion) | This set of values addresses terms representing an observation of marital or spousal status. | 2.16.840.1.113762.1.4.1222.1064 | Observation.code |
| [Neglect](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1042/expansion) | This set of values addresses terms representing an observation of neglect. | 2.16.840.1.113762.1.4.1222.1042 | Observation.code |
| [Physical Activity Level](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1068/expansion) | This set of values addresses terms representing an observation of physical activity level. | 2.16.840.1.113762.1.4.1222.1068 | Observation.code |
| [Unsafe Neighborhood](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1076/expansion) | This set of values addresses terms representing an observation that a patient lives in an unsafe neighborhood. | 2.16.840.1.113762.1.4.1222.1076 | Observation.code |
| [Work Productivity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1222.1050/expansion) | This set of values addresses terms representing an observation of work productivity. | 2.16.840.1.113762.1.4.1222.1050 | Observation.code |

