# IG Home Page - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* **IG Home Page**

## IG Home Page

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/ImplementationGuide/hl7.cda.us.ccda | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:CCDA |

### Introduction

This Consolidated Clinical Document Architecture (C-CDA) guide, in conjunction with the HL7 CDA Release 2 (CDA R2) standard, is to be used for implementing the following CDA documents and header constraints for clinical notes.

Header Constraints:

* [US Realm Header](StructureDefinition-USRealmHeader.md)
* [Patient Generated Document (US Realm Header)](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md)

Document Types:

* [Care Plan](StructureDefinition-CarePlan.md)
* [Consultation Note](StructureDefinition-ConsultationNote.md)
* [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md)
* [Discharge Summary](StructureDefinition-DischargeSummary.md)
* [History and Physical (H&P)](StructureDefinition-HistoryandPhysical.md)
* [Operative Note](StructureDefinition-OperativeNote.md)
* [Procedure Note](StructureDefinition-ProcedureNote.md)
* [Progress Note](StructureDefinition-ProgressNote.md)
* [Referral Note](StructureDefinition-ReferralNote.md)
* [Transfer Summary](StructureDefinition-TransferSummary.md)
* [Unstructured Document](StructureDefinition-UnstructuredDocument.md)

Section templates, which help organize content within a document, and entry templates, that represent discrete computable data within sections, are defined in this implementation Guide.

The [Artifact Index page](artifacts.md) lists the C-CDA Templates that have been defined for this IG.

The Guidance pages provide USCDI guidance, call out key information from the underlying CDA standard, provide learnings gleaned from vendors and CDA Implementation-a-thons, and include other improvements added since C-CDA’s inception in 2011. The Guidance was drawn from C-CDA 2.1 Introduction (Volume 1) Sept 2022 Errata and C-CDA 2.1 Companion Guide R4.1 June 2023 Publication and edited to be appropriate for this StructureDefinition publication and has been added to with new versions.

### Background

Consolidated CDA (C-CDA) is a library of CDA templates developed by HL7. It leveraged prior CDA implementation guides developed under the HL7 Health Story Project, Integrating the Healthcare Enterprise (IHE), and the Health Information Technology Standards Panel (HITSP). It harmonized and consolidated the templates into the C-CDA guide. The C-CDA guide was developed within the ONC’s Standards and Interoperability (S&I) Framework to provide a definitive set of harmonized CDA templates for the US Realm.

Since 2017, separate C-CDA Companion Guides were developed to provide supplemental implementer guidance and new templates, initially to meet Meaningful Use criteria, and then with designs and guidance for the USCDI annual data element releases. The C-CDA 2.1 guide has had only errata releases since 2015 and no new design.

### This Project

The latest C-CDA release consolidates prior specifications and guidance documents, incorporates enhancement requests, and introduces updated design and implementation guidance aligned with the current USCDI version. Future updates are planned annually to reflect new USCDI releases and respond to community feedback and implementation experience.

The guide represents C-CDA templates using HL7 FHIR StructureDefinition. It is built upon the underlying [CDA standard’s structures defined as Logical Models in CDA 2.0 StructureDefinition](http://hl7.org/cda/stds/core). These FHIR Logical models are abstract data structures which have been instantiated into physical CDA templates to be implemented in CDA data exchange. As such, it adheres to the [CDA Release 2.0 standard](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=7) and remains a CDA-based Implementation Guide (IG).

 This is a C-CDA specification that uses FHIR R5 StructureDefinitions and ElementDefinitions to define its templates. It does not use any of the FHIR R5 resources nor any of the FHIR R5 General-Purpose Datatypes. Thus it is based on FHIR R5 but not in a way that FHIR Implementation Guides would be based by profiling FHIR resources. It is important and relevant to declare the version of FHIR structures that are being used for toolsmiths and others using those structures. Further, the specification is generated with the FHIR IG Publisher tooling. Although the tooling allows for JSON and XML representations of structures, at this time, only XML is allowed for CDA documents. 

### Acknowledgements

This C-CDA guide was developed and produced through the efforts of Health Level Seven (HL7).

The editors appreciate the support and sponsorship of the HL7 Structured Documents Working Group (SDWG), the HL7 Patient Care Work Group, the HL7 Cross Group Projects Work Group, the CDA Management Group, HL7’s Chief Standards Development Officer, and all volunteers and staff associated with the creation of this Implementation Guide. Much appreciated are the many individual authors from those work groups who contributed to the design and build of C-CDA and CDA Implementation Guides since 2007. This guide would not have been possible without the support of the [Office of the National Coordinator](https://www.healthit.gov), and the [Federal Electronic Health Record Modernization (FEHRM)](https://www.fehrm.gov).

### C-CDA Primary Authors

| | | |
| :--- | :--- | :--- |
| Name | Organization | Email |
| Jean Duteau | Dogwood Health Consulting | jean.duteau@dogwoodhealthconsulting.com |
| Benjamin Flessner | Availity | benjamin.flessner@availity.com |
| Brett Marquard | Wave One Associates | brett@waveoneassociates.com |
| Gay Dolin | Namaste Informatics | gdolin@NamasteInformatics.com |
| Rosemary Hofstede | Dogwood Health Consulting | rosemary@duteaudesign.com |



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.cda.us.ccda",
  "url" : "http://hl7.org/cda/us/ccda/ImplementationGuide/hl7.cda.us.ccda",
  "version" : "5.0.0-ballot",
  "name" : "CCDA",
  "title" : "Consolidated CDA (C-CDA)",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "packageId" : "hl7.cda.us.ccda",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    },
    {
      "id" : "cda",
      "uri" : "http://hl7.org/cda/stds/core/ImplementationGuide/hl7.cda.uv.core",
      "packageId" : "hl7.cda.uv.core",
      "version" : "2.0.2-sd"
    },
    {
      "id" : "vsac",
      "uri" : "http://fhir.org/packages/us.nlm.vsac/ImplementationGuide/us.nlm.vsac",
      "packageId" : "us.nlm.vsac",
      "version" : "0.24.0"
    },
    {
      "id" : "phinvads",
      "uri" : "https://phinvads.cdc.gov/vads/fhir/ImplementationGuide/us.cdc.phinvads",
      "packageId" : "us.cdc.phinvads",
      "version" : "0.12.0"
    },
    {
      "id" : "uscore",
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "9.0.0-ballot"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.8.0"
      }
    ],
    "grouping" : [
      {
        "id" : "document",
        "name" : "Document Templates",
        "description" : "Document-level templates describe the purpose and rules for constructing a conforming CDA document. Document templates include constraints on the CDA header and indicate contained section-level templates.\n\nEach document-level template contains the following information:\n* Scope and intended use of the document type\n* Description and explanatory narrative\n* Template metadata (e.g., templateId)\n* Header constraints (e.g., document type, template id, participants)\n* Required and optional section-level templates"
      },
      {
        "id" : "section",
        "name" : "Section Templates",
        "description" : "This chapter contains the section-level templates referenced by one or more of the document types of this consolidated guide. These templates describe the purpose of each section and the section-level constraints.\n\nSection-level templates are always included in a document. One and only one of each section type is allowed in a given document instance. Please see the document context tables to determine the sections that are contained in a given document type. Please see the conformance verb in the conformance statements to determine if it is required (SHALL), strongly recommended (SHOULD), or optional (MAY).\n\nEach section-level template contains the following:\n* Template metadata (e.g., templateId, etc.)\n* Description and explanatory narrative\n* LOINC section code\n* Section title\n* Requirements for a text element\n* Entry-level template names and Ids for referenced templates (required and optional)\n\nNarrative Text\n\nThe text element within the section stores the narrative to be rendered, as described in the CDA R2 specification, and is referred to as the CDA narrative block.\n\nThe content model of the CDA narrative block schema is handcrafted to meet requirements of human readability and rendering. The schema is registered as a MIME type (text/x-hl7-text+xml), which is the fixed media type for the text element.\n\nAs noted in the CDA R2 specification, the document originator is responsible for ensuring that the narrative block contains the complete, human readable, attested content of the section. Structured entries support computer processing and computation and are not a replacement for the attestable, human-readable content of the CDA narrative block. The special case of structured entries with an entry relationship of \"DRIV\" (is derived from) indicates to the receiving application that the source of the narrative block is the structured entries, and that the contents of the two are clinically equivalent.\n\nFor all CDA documents—even when a report consisting entirely of structured entries is transformed into CDA—the encoding application must ensure that the authenticated content (narrative plus multimedia) is a faithful and complete rendering of the clinical content of the structured source data. As a general guideline, a generated narrative block should include the same human readable content that would be available to users viewing that content in the originating system. Although content formatting in the narrative block need not be identical to that in the originating system, the narrative block should use elements from the CDA narrative block schema to provide sufficient formatting to support human readability when rendered according to the rules defined in Section Narrative Block (§ 4.3.5 ) of the CDA R2 specification.\n\nBy definition, a receiving application cannot assume that all clinical content in a section (i.e., in the narrative block and multimedia) is contained in the structured entries unless the entries in the section have an entry relationship of \"DRIV\".\n\nAdditional specification information for the CDA narrative block can be found in the CDA R2 specification in sections 1.2.1, 1.2.3, 1.3, 1.3.1, 1.3.2, 4.3.4.2, and 6."
      },
      {
        "id" : "entry",
        "name" : "Entry Templates",
        "description" : "This chapter describes the clinical statement entry templates used within the sections of the document types of this consolidated guide. Entry templates contain constraints that are required for conformance.\n\nEntry-level templates are always in sections.\n\nEach entry-level template description contains the following information:\n* Key template metadata (e.g., template identifier, etc.)\n* Description and explanatory narrative.\n* Required CDA acts, participants and vocabularies.\n* Optional CDA acts, participants and vocabularies.\r\nSeveral entry-level templates require an effectiveTime:\n\nThe effectiveTime of an observation is the time interval over which the observation is known to be true. The low and high values should be as precise as possible, but no more precise than known. While CDA has multiple mechanisms to record this time interval (e.g., by low and high values, low and width, high and width, or center point and width), this guide constrains most to use only the low/high form. The low value is the earliest point for which the condition is known to have existed. The high value, when present, indicates the time at which the observation was no longer known to be true. The full description of effectiveTime and time intervals is contained in the CDA R2 normative edition.\n\nProvenance in entry templates:\n\nIn this version of Consolidated CDA (C-CDA), we have added a \"SHOULD\" Author constraint on several entry-level templates. Authorship and Author timestamps must be explicitly asserted in these cases, unless the values propagated from the document header hold true.\n\nID in entry templates:\n\nEntry-level templates may also describe an id element, which is an identifier for that entry. This id may be referenced within the document, or by the system receiving the document. The id assigned must be globally unique."
      },
      {
        "id" : "other",
        "name" : "Participation & Other Templates",
        "description" : "The participation and other templates chapter contains templates for CDA participations (e.g., author, performer), and other fielded items (e.g., address, name) that cannot stand on their own without being nested in another template."
      },
      {
        "id" : "deprecated",
        "name" : "Deprecated Templates",
        "description" : "Deprecated templates are not prohibited from use, but their status as deprecated is a signal to implementers that the template may be permanently retired (terminated) in the future."
      },
      {
        "id" : "examples",
        "name" : "C-CDA Template Examples",
        "description" : "These examples show how the C-CDA logical model templates are constructed."
      },
      {
        "id" : "terminology",
        "name" : "C-CDA Internal Terminology",
        "description" : "Code Systems and Value Sets that are defined in this guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ActivitiesSection",
          "display" : "Activities Section"
        },
        "name" : "Activities Section",
        "description" : "This template represents Activities.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdmissionDiagnosisSection",
          "display" : "Admission Diagnosis Section"
        },
        "name" : "Admission Diagnosis Section",
        "description" : "This section contains a narrative description of the problems or diagnoses identified by the clinician at the time of the patient's admission.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdmissionMedication",
          "display" : "Admission Medication"
        },
        "name" : "Admission Medication",
        "description" : "This template represents the medications taken by the patient prior to and at the time of admission.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdmissionMedicationsSectionEntriesOptional",
          "display" : "Admission Medications Section (entries optional)"
        },
        "name" : "Admission Medications Section (entries optional)",
        "description" : "The section contains the medications taken by the patient prior to and at the time of admission to the facility.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdvanceDirectiveObservation",
          "display" : "Advance Directive Observation"
        },
        "name" : "Advance Directive Observation",
        "description" : "The Advance Directive Observation template is nested within the Advance Directive Existence Observation, which indicates whether the individual has any advance directive documents.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdvanceDirectiveExistenceObservation",
          "display" : "Advance Directive Existence Observation"
        },
        "name" : "Advance Directive Existence Observation",
        "description" : "This observation represents a simple observation indicating whether a person has any advance directive documents.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdvanceDirectiveOrganizer",
          "display" : "Advance Directive Organizer"
        },
        "name" : "Advance Directive Organizer",
        "description" : "The Advance Directive Organizer includes information about who verified the content available in each advance healthcare directive source document or other verified source documentation.",
        "groupingId" : "deprecated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdvanceDirectivesSection",
          "display" : "Advance Directives Section"
        },
        "name" : "Advance Directives Section",
        "description" : "This section contains details about the patient’s advance healthcare directives, including references to supporting documents such as Living Wills, Healthcare Power of Attorney, Personal Advance Care Plans, DNR Orders, and Portable Medical Orders.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AgeObservation",
          "display" : "Age Observation"
        },
        "name" : "Age Observation",
        "description" : "This Age Observation represents the subject's precise age at onset of an event or observation.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AgeRangeObservation",
          "display" : "Age Range Observation"
        },
        "name" : "Age Range Observation",
        "description" : "This Age Range Observation captures an estimated age range when the subject's exact age is unknown.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AllergiesAndIntolerancesSection",
          "display" : "Allergies and Intolerances Section"
        },
        "name" : "Allergies and Intolerances Section",
        "description" : "This section lists and describes any medication allergies, adverse reactions, idiosyncratic reactions, anaphylaxis/anaphylactoid reactions to food items, and metabolic variations or adverse reactions/allergies to other substances (such as latex, iodine, tape adhesives).",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AllergyIntoleranceObservation",
          "display" : "Allergy - Intolerance Observation"
        },
        "name" : "Allergy - Intolerance Observation",
        "description" : "This template reflects a discrete observation about a patient's allergy or intolerance.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AllergyConcernAct",
          "display" : "Allergy Concern Act"
        },
        "name" : "Allergy Concern Act",
        "description" : "This template reflects an ongoing concern on behalf of the provider that placed the allergy on a patient's allergy list.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AllergyStatusObservation",
          "display" : "Allergy Status Observation"
        },
        "name" : "Allergy Status Observation",
        "description" : "This template represents the clinical status attributed to the allergy or intolerance.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AnesthesiaSection",
          "display" : "Anesthesia Section"
        },
        "name" : "Anesthesia Section",
        "description" : "The Anesthesia Section records the type of anesthesia (e.g., general or local) and may state the actual agent used.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AssessmentandPlanSection",
          "display" : "Assessment and Plan Section"
        },
        "name" : "Assessment and Plan Section",
        "description" : "This section represents the clinician's conclusions and working assumptions that will guide treatment of the patient.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AssessmentScaleObservation",
          "display" : "Assessment Scale Observation"
        },
        "name" : "Assessment Scale Observation",
        "description" : "An assessment scale is a collection of observations that together can yield a calculated or non-calculated summary evaluation of a one or more conditions.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AssessmentScaleSupportingObservation",
          "display" : "Assessment Scale Supporting Observation"
        },
        "name" : "Assessment Scale Supporting Observation",
        "description" : "An Assessment Scale Supporting Observation represents the components of a scale used in an Assessment Scale Observation.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AssessmentSection",
          "display" : "Assessment Section"
        },
        "name" : "Assessment Section",
        "description" : "The Assessment Section (also referred to as \\\"impression\\\" or \\\"diagnoses\\\" outside of the context of CDA) represents the clinician's conclusions and working assumptions that will guide treatment of the patient.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AuthorParticipation",
          "display" : "Author Participation"
        },
        "name" : "Author Participation",
        "description" : "This template represents the Author Participation (including the author timestamp).",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AuthorizationActivity",
          "display" : "Authorization Activity"
        },
        "name" : "Authorization Activity",
        "description" : "An Authorization Activity represents authorizations or pre-authorizations currently active for the patient for the particular payer.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AverageBloodPressureOrganizer",
          "display" : "Average Blood Pressure Organizer"
        },
        "name" : "Average Blood Pressure Organizer",
        "description" : "This template represents a single instance of an Average Blood Pressure reading.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BasicIndustryObservation",
          "display" : "Basic Industry Observation"
        },
        "name" : "Basic Industry Observation",
        "description" : "This template represents a simple observation about the type of business that compensates for work or assigns work to an unpaid worker or volunteer (e.g., US Army, cement manufacturing, children and youth services).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BasicOccupationObservation",
          "display" : "Basic Occupation Observation"
        },
        "name" : "Basic Occupation Observation",
        "description" : "This template represents a simple observation about the type of work (e.g., infantry, business analyst, social worker) of a person.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BirthSexObservation",
          "display" : "Birth Sex Observation"
        },
        "name" : "Birth Sex Observation",
        "description" : "This observation represents the sex of the patient at birth.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BrandNameObservation",
          "display" : "Brand Name Observation"
        },
        "name" : "Brand Name Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Brand Name.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareExperiencePreference",
          "display" : "Care Experience Preference"
        },
        "name" : "Care Experience Preference",
        "description" : "This Care Experience Preference template represents a person's care preferences for their care and treatment.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CarePlan",
          "display" : "Care Plan"
        },
        "name" : "Care Plan",
        "description" : "A Care Plan is a consensus-driven dynamic plan that represents a patient's and Care Team Member's prioritized concerns, goals, and planned interventions.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CarePlanAct",
          "display" : "Care Plan Act"
        },
        "name" : "Care Plan Act",
        "description" : "The Care Plan Act represents a snapshot in time of a dynamic, consensus-driven plan that has captured a patient's and care team members' prioritized concerns, goals, and planned interventions.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeamMemberAct",
          "display" : "Care Team Member Act"
        },
        "name" : "Care Team Member Act",
        "description" : "This template is used to represent a member of the care team.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeamMemberScheduleObservation",
          "display" : "Care Team Member Schedule Observation"
        },
        "name" : "Care Team Member Schedule Observation",
        "description" : "This template represents the schedule of when the care team member participates on the care team.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeamOrganizer",
          "display" : "Care Team Organizer"
        },
        "name" : "Care Team Organizer",
        "description" : "This organizer template contains information about a single care team.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeamTypeObservation",
          "display" : "Care Team Type Observation"
        },
        "name" : "Care Team Type Observation",
        "description" : "This template is used to express the care team type.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeamsSection",
          "display" : "Care Teams Section"
        },
        "name" : "Care Teams Section",
        "description" : "The Care Teams Section is used to share historical and current Care Team information.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CaregiverCharacteristics",
          "display" : "Caregiver Characteristics"
        },
        "name" : "Caregiver Characteristics",
        "description" : "This clinical statement represents a caregiver's willingness to provide care and the abilities of that caregiver to provide assistance to a patient in relation to a specific need.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CatalogNumberObservation",
          "display" : "Catalog Number Observation"
        },
        "name" : "Catalog Number Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Catalog Number.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CharacteristicsofHomeEnvironment",
          "display" : "Characteristics of Home Environment"
        },
        "name" : "Characteristics of Home Environment",
        "description" : "This template represents the patient's home environment including, but not limited to, type of residence (trailer, single family home, assisted living), living arrangement (e.g., alone, with parents), and housing status (e.g., evicted, homeless, home owner).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ChiefComplaintandReasonforVisitSection",
          "display" : "Chief Complaint and Reason for Visit Section"
        },
        "name" : "Chief Complaint and Reason for Visit Section",
        "description" : "This section records the patient's chief complaint (the patient's own description) and/or the reason for the patient's visit (the provider's description of the reason for visit).",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ChiefComplaintSection",
          "display" : "Chief Complaint Section"
        },
        "name" : "Chief Complaint Section",
        "description" : "This section records the patient's chief complaint (the patient's own description).",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CommentActivity",
          "display" : "Comment Activity"
        },
        "name" : "Comment Activity",
        "description" : "Comments are free text data that cannot otherwise be recorded using data elements already defined by this specification.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CompanyNameObservation",
          "display" : "Company Name Observation"
        },
        "name" : "Company Name Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Company Name.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ComplicationsSection",
          "display" : "Complications Section"
        },
        "name" : "Complications Section",
        "description" : "This section contains problems that occurred during or around the time of a procedure.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ConsultationNote",
          "display" : "Consultation Note"
        },
        "name" : "Consultation Note",
        "description" : "The Consultation Note is generated by a request from a clinician for an opinion or advice from another clinician.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ContinuityofCareDocumentCCD",
          "display" : "Continuity of Care Document (CCD)"
        },
        "name" : "Continuity of Care Document (CCD)",
        "description" : "The Continuity of Care Document (CCD) represents a core data set of the most relevant administrative, demographic, and clinical information facts about a patient's healthcare, covering one or more healthcare encounters.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CourseofCareSection",
          "display" : "Course of Care Section"
        },
        "name" : "Course of Care Section",
        "description" : "The Course of Care section describes what happened during the course of an encounter.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CoverageActivity",
          "display" : "Coverage Activity"
        },
        "name" : "Coverage Activity",
        "description" : "A Coverage Activity groups the policy and authorization acts within a Payers Section to order the payment sources.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CriticalityObservation",
          "display" : "Criticality Observation"
        },
        "name" : "Criticality Observation",
        "description" : "This observation represents the gravity of the potential risk for future life-threatening adverse reactions when exposed to a substance known to cause an adverse reaction in that individual.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CulturalandReligiousObservation",
          "display" : "Cultural and Religious Observation"
        },
        "name" : "Cultural and Religious Observation",
        "description" : "This template represents a patient's spiritual, religious, and cultural belief practices, such as a kosher diet or fasting ritual.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DateOfDiagnosisAct",
          "display" : "Date of Diagnosis Act"
        },
        "name" : "Date of Diagnosis Act",
        "description" : "This template represents the earliest date of diagnosis, which is the date of first determination by a qualified professional of the presence of a problem or condition affecting a patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DeceasedObservation",
          "display" : "Deceased Observation"
        },
        "name" : "Deceased Observation",
        "description" : "This template represents the observation that a patient has died.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DeviceIdentifierObservation",
          "display" : "Device Identifier Observation"
        },
        "name" : "Device Identifier Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Device Identifier (also known as the \"Primary DI Number\") for a medical device marketed in the US.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DisabilityStatusObservation",
          "display" : "Disability Status Observation"
        },
        "name" : "Disability Status Observation",
        "description" : "This template represents an assessment of patients perception of their physical, cognitive, intellectual, or psychiatric disabilities.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DischargeDiagnosisSection",
          "display" : "Discharge Diagnosis Section"
        },
        "name" : "Discharge Diagnosis Section",
        "description" : "This template represents problems or diagnoses present at the time of discharge which occurred during the hospitalization.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DischargeMedication",
          "display" : "Discharge Medication"
        },
        "name" : "Discharge Medication",
        "description" : "This template represents medications that the patient is intended to take (or stop) after discharge.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DischargeMedicationsSection",
          "display" : "Discharge Medications Section"
        },
        "name" : "Discharge Medications Section",
        "description" : "This section contains the medications the patient is intended to take or stop after discharge.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DischargeSummary",
          "display" : "Discharge Summary"
        },
        "name" : "Discharge Summary",
        "description" : "The Discharge Summary is a document which synopsizes a patient's admission to a hospital, LTPAC provider, or other setting.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DistinctIdentificationCodeObservation",
          "display" : "Distinct Identification Code Observation"
        },
        "name" : "Distinct Identification Code Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Distinct Identification Code for an HCT/P product regulated as a device as cited in 21 CFR 1271.290(c).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DrugMonitoringAct",
          "display" : "Drug Monitoring Act"
        },
        "name" : "Drug Monitoring Act",
        "description" : "This template represents the act of monitoring the patient's medication and includes a participation to record the person responsible for monitoring the medication.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DrugVehicle",
          "display" : "Drug Vehicle"
        },
        "name" : "Drug Vehicle",
        "description" : "This template represents the vehicle (e.g., saline, dextrose) for administering a medication.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EncounterActivity",
          "display" : "Encounter Activity"
        },
        "name" : "Encounter Activity",
        "description" : "This clinical statement describes an interaction between a patient and clinician.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EncounterDiagnosis",
          "display" : "Encounter Diagnosis"
        },
        "name" : "Encounter Diagnosis",
        "description" : "This template wraps relevant problems or diagnoses at the close of a visit or that need to be followed after the visit.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EncountersSection",
          "display" : "Encounters Section"
        },
        "name" : "Encounters Section",
        "description" : "This section lists and describes any healthcare encounters pertinent to the patient's current health status or historical health history.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EntryReference",
          "display" : "Entry Reference"
        },
        "name" : "Entry Reference",
        "description" : "This template represents the act of referencing another entry in the same CDA document instance.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EstimatedDateofDelivery",
          "display" : "Estimated Date of Delivery"
        },
        "name" : "Estimated Date of Delivery",
        "description" : "This clinical statement represents the anticipated date when a woman will give birth.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ExpirationDateObservation",
          "display" : "Expiration Date Observation"
        },
        "name" : "Expiration Date Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Expiration Date of the device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ExternalDocumentReference",
          "display" : "External Document Reference"
        },
        "name" : "External Document Reference",
        "description" : "Where it is necessary to reference an external clinical document, the External Document Reference template can be used to reference this external document.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FamilyHistoryDeathObservation",
          "display" : "Family History Death Observation"
        },
        "name" : "Family History Death Observation",
        "description" : "This clinical statement records whether the family member is deceased.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FamilyHistoryObservation",
          "display" : "Family History Observation"
        },
        "name" : "Family History Observation",
        "description" : "Family History Observations related to a particular family member are contained within a Family History Organizer.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FamilyHistoryOrganizer",
          "display" : "Family History Organizer"
        },
        "name" : "Family History Organizer",
        "description" : "The Family History Organizer associates a set of observations with a family member.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FamilyHistorySection",
          "display" : "Family History Section"
        },
        "name" : "Family History Section",
        "description" : "This section contains data defining the patient's genetic relatives in terms of possible or relevant health risk factors that have a potential impact on the patient's healthcare risk profile.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FunctionalStatusObservation",
          "display" : "Functional Status Observation"
        },
        "name" : "Functional Status Observation",
        "description" : "This template represents the patient's physical function (e.g., mobility status, instrumental activities of daily living, self-care status) and problems that limit function (dyspnea, dysphagia).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FunctionalStatusOrganizer",
          "display" : "Functional Status Organizer"
        },
        "name" : "Functional Status Organizer",
        "description" : "This template groups related functional status observations into categories (e.g., mobility, self-care).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/FunctionalStatusSection",
          "display" : "Functional Status Section"
        },
        "name" : "Functional Status Section",
        "description" : "The Functional Status Section contains observations and assessments of a patient's physical abilities.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GenderIdentityObservation",
          "display" : "Gender Identity Observation"
        },
        "name" : "Gender Identity Observation",
        "description" : "This observation represents the gender identity of the patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GeneralStatusSection",
          "display" : "General Status Section"
        },
        "name" : "General Status Section",
        "description" : "The General Status section describes general observations and readily observable attributes of the patient, including affect and demeanor, apparent age compared to actual age, gender, ethnicity, nutritional status based on appearance, body build and habitus (e.g., muscular, cachectic, obese), developmental or other deformities, gait and mobility, personal hygiene, evidence of distress, and voice quality and speech.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GoalObservation",
          "display" : "Goal Observation"
        },
        "name" : "Goal Observation",
        "description" : "This template represents a patient health goal.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GoalsSection",
          "display" : "Goals Section"
        },
        "name" : "Goals Section",
        "description" : "This template represents patient Goals.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HandoffCommunicationParticipants",
          "display" : "Handoff Communication Participants"
        },
        "name" : "Handoff Communication Participants",
        "description" : "This template represents the sender (author) and receivers (participants) of a handoff communication in a plan of treatment.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HealthConcernAct",
          "display" : "Health Concern Act"
        },
        "name" : "Health Concern Act",
        "description" : "This template represents a health concern.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HealthConcernsSection",
          "display" : "Health Concerns Section"
        },
        "name" : "Health Concerns Section",
        "description" : "This section contains data describing an interest or worry about a health state or process that could possibly require attention, intervention, or management.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HealthStatusObservation",
          "display" : "Health Status Observation"
        },
        "name" : "Health Status Observation",
        "description" : "This template represents information about the overall health status of the patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HighestPressureUlcerStage",
          "display" : "Highest Pressure Ulcer Stage"
        },
        "name" : "Highest Pressure Ulcer Stage",
        "description" : "This observation contains a description of the wound tissue of the most severe or highest staged pressure ulcer observed on a patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HistoryandPhysical",
          "display" : "History and Physical"
        },
        "name" : "History and Physical",
        "description" : "A History and Physical (H&P) note is a medical report that documents the current and past conditions of the patient.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HistoryofPresentIllnessSection",
          "display" : "History of Present Illness Section"
        },
        "name" : "History of Present Illness Section",
        "description" : "The History of Present Illness section describes the history related to the reason for the encounter.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalAdmissionDiagnosis",
          "display" : "Hospital Admission Diagnosis"
        },
        "name" : "Hospital Admission Diagnosis",
        "description" : "This template represents problems or diagnoses identified by the clinician at the time of the patient's admission.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalConsultationsSection",
          "display" : "Hospital Consultations Section"
        },
        "name" : "Hospital Consultations Section",
        "description" : "The Hospital Consultations Section records consultations that occurred during the admission.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalCourseSection",
          "display" : "Hospital Course Section"
        },
        "name" : "Hospital Course Section",
        "description" : "The Hospital Course Section describes the sequence of events from admission to discharge in a hospital facility.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargeDiagnosis",
          "display" : "Hospital Discharge Diagnosis"
        },
        "name" : "Hospital Discharge Diagnosis",
        "description" : "This template represents problems or diagnoses present at the time of discharge which occurred during the hospitalization or need to be monitored after hospitalization.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargeInstructionsSection",
          "display" : "Hospital Discharge Instructions Section"
        },
        "name" : "Hospital Discharge Instructions Section",
        "description" : "The Hospital Discharge Instructions Section records instructions at discharge.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargePhysicalSection",
          "display" : "Hospital Discharge Physical Section"
        },
        "name" : "Hospital Discharge Physical Section",
        "description" : "The Hospital Discharge Physical Section records a narrative description of the patient's physical findings.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargeStudiesSummarySection",
          "display" : "Hospital Discharge Studies Summary Section"
        },
        "name" : "Hospital Discharge Studies Summary Section",
        "description" : "This section records the results of observations generated by laboratories, imaging procedures, and other procedures.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImmunizationActivity",
          "display" : "Immunization Activity"
        },
        "name" : "Immunization Activity",
        "description" : "An Immunization Activity describes immunization substance administrations that have actually occurred or are intended to occur.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImmunizationMedicationInformation",
          "display" : "Immunization Medication Information"
        },
        "name" : "Immunization Medication Information",
        "description" : "The Immunization Medication Information represents product information about the immunization substance.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImmunizationNotGivenReason",
          "display" : "Immunization Not Given Reason"
        },
        "name" : "Immunization Not Given Reason",
        "description" : "The Immunization Not Given Reason documents the rationale for the patient declining an immunization.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImmunizationsSection",
          "display" : "Immunizations Section"
        },
        "name" : "Immunizations Section",
        "description" : "The Immunizations Section defines a patient's current immunization status and pertinent immunization history.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ImplantableDeviceStatusObservation",
          "display" : "Implantable Device Status Observation"
        },
        "name" : "Implantable Device Status Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to augment the parsed data from the a Unique Device Identifier (UDI).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Indication",
          "display" : "Indication"
        },
        "name" : "Indication",
        "description" : "This template represents the rationale for an action such as an encounter, a medication administration, or a procedure.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/IndividualPronounObservation",
          "display" : "Individual Pronoun Observation"
        },
        "name" : "Individual Pronoun Observation",
        "description" : "The Individual Personal Pronoun Observation represents words specified by a person to replace their name when referring to them in speech, clinical notes, and written instructions.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/InstructionActivity",
          "display" : "Instruction Activity"
        },
        "name" : "Instruction Activity",
        "description" : "The Instruction template is used to record instructions intended to be given to the patient.",
        "groupingId" : "deprecated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/InstructionObservation",
          "display" : "Instruction Observation"
        },
        "name" : "Instruction Observation",
        "description" : "The Instruction observation template can be used in several ways, such as to record patient instructions within a Medication Activity or to record fill instructions within a supply order.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/InstructionsSection",
          "display" : "Instructions Section"
        },
        "name" : "Instructions Section",
        "description" : "The Instructions Section records instructions given to a patient.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/InterpreterNeededObservation",
          "display" : "Interpreter Needed Observation"
        },
        "name" : "Interpreter Needed Observation",
        "description" : "The interpreter needed observation represents an indication of whether a person needs language interpretation services.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/InterventionAct",
          "display" : "Intervention Act"
        },
        "name" : "Intervention Act",
        "description" : "This template represents an Intervention Act.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LatexSafetyObservation",
          "display" : "Latex Safety Observation"
        },
        "name" : "Latex Safety Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Latex Safety Status of the patient's medical device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LongitudinalCareWoundObservation",
          "display" : "Longitudinal Care Wound Observation"
        },
        "name" : "Longitudinal Care Wound Observation",
        "description" : "This template represents acquired or surgical wounds and is not intended to encompass all wound types.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LotOrBatchNumberObservation",
          "display" : "Lot or Batch Number Observation"
        },
        "name" : "Lot or Batch Number Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Lot or Batch Number of the device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ManufacturingDateObservation",
          "display" : "Manufacturing Date Observation"
        },
        "name" : "Manufacturing Date Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Manufacturing Date of the device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicalGeneralHistorySection",
          "display" : "Medical (General) History Section"
        },
        "name" : "Medical (General) History Section",
        "description" : "The Medical History Section describes all aspects of the medical history of the patient even if not pertinent to the current procedure, and may include chief complaint, past medical history, social history, family history, surgical or procedure history, medication history, and other history information.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicalEquipmentOrganizer",
          "display" : "Medical Equipment Organizer"
        },
        "name" : "Medical Equipment Organizer",
        "description" : "This template represents a set of current or historical medical devices, supplies, aids and equipment used by the patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicalEquipmentSection",
          "display" : "Medical Equipment Section"
        },
        "name" : "Medical Equipment Section",
        "description" : "This section defines a patient's implanted and external health and medical devices and equipment.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationActivity",
          "display" : "Medication Activity"
        },
        "name" : "Medication Activity",
        "description" : "A Medication Activity describes substance administrations that have actually occurred (e.g., pills ingested or injections given) or are intended to occur (e.g., \"take 2 tablets twice a day for the next 10 days\").",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationAdherence",
          "display" : "Medication Adherence"
        },
        "name" : "Medication Adherence",
        "description" : "This profile represents whether a medication has been consumed according to instructions.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationDispense",
          "display" : "Medication Dispense"
        },
        "name" : "Medication Dispense",
        "description" : "This template records the act of supplying medications (i.e., dispensing).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationFreeTextSig",
          "display" : "Medication Free Text Sig"
        },
        "name" : "Medication Free Text Sig",
        "description" : "The template is available to explicitly identify the free text Sig within each medication.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationInformation",
          "display" : "Medication Information"
        },
        "name" : "Medication Information",
        "description" : "A medication should be recorded as a pre-coordinated ingredient + strength + dose form (e.g., \"metoprolol 25mg tablet\", \"amoxicillin 400mg/5mL suspension\") where possible.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationSupplyOrder",
          "display" : "Medication Supply Order"
        },
        "name" : "Medication Supply Order",
        "description" : "This template records the intent to supply a patient with medications.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationsAdministeredSection",
          "display" : "Medications Administered Section"
        },
        "name" : "Medications Administered Section",
        "description" : "The Medications Administered Section usually resides inside a Procedure Note describing a procedure.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationsSection",
          "display" : "Medications Section"
        },
        "name" : "Medications Section",
        "description" : "The Medications Section contains a patient's current medications and pertinent medication history.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MentalStatusObservation",
          "display" : "Mental Status Observation"
        },
        "name" : "Mental Status Observation",
        "description" : "The Mental Status Observation template represents an observation about mental status that can come from a broad range of subjective and objective information (including measured data) to address those categories described in the Mental Status Section.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MentalStatusOrganizer",
          "display" : "Mental Status Organizer"
        },
        "name" : "Mental Status Organizer",
        "description" : "The Mental Status Organizer template may be used to group related Mental Status Observations (e.g., results of mental tests) and associated Assessment Scale Observations into subcategories and/or groupings by time.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MentalStatusSection",
          "display" : "Mental Status Section"
        },
        "name" : "Mental Status Section",
        "description" : "The Mental Status Section contains observations and evaluations related to a patient's psychological and mental competency and deficits.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ModelNumberObservation",
          "display" : "Model Number Observation"
        },
        "name" : "Model Number Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Model Number associated with the device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MRISafetyObservation",
          "display" : "MRI Safety Observation"
        },
        "name" : "MRI Safety Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the MRI Safety Status of the patient's medical device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NonMedicinalSupplyActivity",
          "display" : "Non-Medicinal Supply Activity"
        },
        "name" : "Non-Medicinal Supply Activity",
        "description" : "This template represents equipment supplied to the patient (e.g., pumps, inhalers, wheelchairs).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NoteActivity",
          "display" : "Note Activity"
        },
        "name" : "Note Activity",
        "description" : "The Note Activity represents a clinical note.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NotesSection",
          "display" : "Notes Section"
        },
        "name" : "Notes Section",
        "description" : "The Notes Section allow for inclusion of clinical documentation which does not fit precisely within any other C-CDA section.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NumberofPressureUlcersObservation",
          "display" : "Number of Pressure Ulcers Observation"
        },
        "name" : "Number of Pressure Ulcers Observation",
        "description" : "This template represents the number of pressure ulcers observed at a particular stage.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NutritionAssessment",
          "display" : "Nutrition Assessment"
        },
        "name" : "Nutrition Assessment",
        "description" : "This template represents the patient's nutrition abilities and habits including intake, diet requirements or diet followed.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NutritionRecommendation",
          "display" : "Nutrition Recommendation"
        },
        "name" : "Nutrition Recommendation",
        "description" : "This template represents nutrition regimens (e.g., fluid restrictions, calorie minimum), interventions (e.g., NPO, nutritional supplements), and procedures (e.g., G-Tube by bolus, TPN by central line).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NutritionSection",
          "display" : "Nutrition Section"
        },
        "name" : "Nutrition Section",
        "description" : "The Nutrition Section represents diet and nutrition information including special diet requirements and restrictions (e.g., texture modified diet, liquids only, enteral feeding).",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/NutritionalStatusObservation",
          "display" : "Nutritional Status Observation"
        },
        "name" : "Nutritional Status Observation",
        "description" : "This template describes the overall nutritional status of the patient including findings related to nutritional status.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ObjectiveSection",
          "display" : "Objective Section"
        },
        "name" : "Objective Section",
        "description" : "The Objective Section contains data about the patient gathered through tests, measures, or observations that produce a quantified or categorized result.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OperativeNote",
          "display" : "Operative Note"
        },
        "name" : "Operative Note",
        "description" : "The Operative Note is a frequently used type of procedure note with specific requirements set forth by regulatory agencies.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OperativeNoteFluidsSection",
          "display" : "Operative Note Fluids Section"
        },
        "name" : "Operative Note Fluids Section",
        "description" : "The Operative Note Fluids Section may be used to record fluids administered during the surgical procedure.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OperativeNoteSurgicalProcedureSection",
          "display" : "Operative Note Surgical Procedure Section"
        },
        "name" : "Operative Note Surgical Procedure Section",
        "description" : "The Operative Note Surgical Procedure Section can be used to restate the procedures performed if appropriate for an enterprise workflow.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OutcomeObservation",
          "display" : "Outcome Observation"
        },
        "name" : "Outcome Observation",
        "description" : "This template represents the outcome of care resulting from the interventions used to treat the patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OutcomesSection",
          "display" : "Outcomes Section"
        },
        "name" : "Outcomes Section",
        "description" : "This section represents observations regarding the outcome of care from the interventions used to treat the patient.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PastMedicalHistory",
          "display" : "Past Medical History"
        },
        "name" : "Past Medical History",
        "description" : "This section contains a record of the patient's past complaints, problems, and diagnoses.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PayersSection",
          "display" : "Payers Section"
        },
        "name" : "Payers Section",
        "description" : "The Payers Section contains data on the patient's payers, whether \"third party\" insurance, self-pay, other payer or guarantor, or some combination of payers, and is used to define which entity is the responsible fiduciary for the financial aspects of a patient's care.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PhysicalExamSection",
          "display" : "Physical Exam Section"
        },
        "name" : "Physical Exam Section",
        "description" : "The section includes direct observations made by a clinician.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlanofTreatmentSection",
          "display" : "Plan of Treatment Section"
        },
        "name" : "Plan of Treatment Section",
        "description" : "This section captures planned, pending, active, or completed orders, interventions, encounters, services, and procedures relevant to a patient’s care.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedCoverage",
          "display" : "Planned Coverage"
        },
        "name" : "Planned Coverage",
        "description" : "This template represents the insurance coverage intended to cover an act or procedure.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedEncounter",
          "display" : "Planned Encounter"
        },
        "name" : "Planned Encounter",
        "description" : "This template represents a planned or ordered encounter.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedImmunizationActivity",
          "display" : "Planned Immunization Activity"
        },
        "name" : "Planned Immunization Activity",
        "description" : "This template represents planned immunizations.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedInterventionAct",
          "display" : "Planned Intervention Act"
        },
        "name" : "Planned Intervention Act",
        "description" : "This template represents a Planned Intervention Act.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedMedicationActivity",
          "display" : "Planned Medication Activity"
        },
        "name" : "Planned Medication Activity",
        "description" : "This template represents planned medication activities.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedProcedure",
          "display" : "Planned Procedure"
        },
        "name" : "Planned Procedure",
        "description" : "This template is used to represent ordered procedures for a patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedProcedureSection",
          "display" : "Planned Procedure Section"
        },
        "name" : "Planned Procedure Section",
        "description" : "This section contains the procedure(s) that a clinician planned based on the preoperative assessment.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PlannedSupply",
          "display" : "Planned Supply"
        },
        "name" : "Planned Supply",
        "description" : "This template represents both medicinal and non-medicinal supplies ordered, requested, or intended for the patient (e.g., medication prescription, order for wheelchair).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PolicyActivity",
          "display" : "Policy Activity"
        },
        "name" : "Policy Activity",
        "description" : "A policy activity represents the policy or program providing the coverage.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PostoperativeDiagnosisSection",
          "display" : "Postoperative Diagnosis Section"
        },
        "name" : "Postoperative Diagnosis Section",
        "description" : "The Postoperative Diagnosis Section records the diagnosis or diagnoses discovered or confirmed during the surgery.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PostprocedureDiagnosis",
          "display" : "Postprocedure Diagnosis"
        },
        "name" : "Postprocedure Diagnosis",
        "description" : "This template represents the diagnosis or diagnoses discovered or confirmed during the procedure.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PostprocedureDiagnosisSection",
          "display" : "Postprocedure Diagnosis Section"
        },
        "name" : "Postprocedure Diagnosis Section",
        "description" : "The Postprocedure Diagnosis Section records the diagnosis or diagnoses discovered or confirmed during the procedure.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PreconditionforSubstanceAdministration",
          "display" : "Precondition for Substance Administration"
        },
        "name" : "Precondition for Substance Administration",
        "description" : "A criterion for administration can be used to record that the medication is to be administered only when the associated criteria are met.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PregnancyIntentionInNextYear",
          "display" : "Pregnancy Intention in Next Year"
        },
        "name" : "Pregnancy Intention in Next Year",
        "description" : "This template represents a patient's reported intention or desire in the next year to either become pregnant or prevent a future pregnancy.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PregnancyStatusObservation",
          "display" : "Pregnancy Status Observation"
        },
        "name" : "Pregnancy Status Observation",
        "description" : "This clinical statement meets the requirements of the US Core Data for Interoperability (USCDI) Pregnancy Status Data Element.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PreoperativeDiagnosis",
          "display" : "Preoperative Diagnosis"
        },
        "name" : "Preoperative Diagnosis",
        "description" : "This template represents the surgical diagnosis or diagnoses assigned to the patient before the surgical procedure and is the reason for the surgery.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PreoperativeDiagnosisSection",
          "display" : "Preoperative Diagnosis Section"
        },
        "name" : "Preoperative Diagnosis Section",
        "description" : "The Preoperative Diagnosis Section records the surgical diagnoses assigned to the patient before the surgical procedure which are the reason for the surgery.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PriorityPreference",
          "display" : "Priority Preference"
        },
        "name" : "Priority Preference",
        "description" : "This template represents priority preferences chosen by a patient or a care provider.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProblemConcernAct",
          "display" : "Problem Concern Act"
        },
        "name" : "Problem Concern Act",
        "description" : "This template reflects an ongoing concern on behalf of the provider that placed the concern on a patient's problem list.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProblemObservation",
          "display" : "Problem Observation"
        },
        "name" : "Problem Observation",
        "description" : "This template reflects a discrete observation about a patient's problem.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProblemSection",
          "display" : "Problem Section"
        },
        "name" : "Problem Section",
        "description" : "This section lists and describes all relevant clinical problems at the time the document is generated.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProblemStatus",
          "display" : "Problem Status"
        },
        "name" : "Problem Status",
        "description" : "The Problem Status records the clinical status attributed to the problem.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureActivityProcedure",
          "display" : "Procedure Activity Procedure"
        },
        "name" : "Procedure Activity Procedure",
        "description" : "This template is used to represent the details of current and historical procedures performed on or for a patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureDescriptionSection",
          "display" : "Procedure Description Section"
        },
        "name" : "Procedure Description Section",
        "description" : "The Procedure Description section records the particulars of the procedure and may include procedure site preparation, surgical site preparation, pertinent details related to sedation/anesthesia, pertinent details related to measurements and markings, procedure times, medications administered, estimated blood loss, specimens removed, implants, instrumentation, sponge counts, tissue manipulation, wound closure, sutures used, vital signs and other monitoring data.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureDispositionSection",
          "display" : "Procedure Disposition Section"
        },
        "name" : "Procedure Disposition Section",
        "description" : "The Procedure Disposition Section records the status and condition of the patient at the completion of the procedure or surgery.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureEstimatedBloodLossSection",
          "display" : "Procedure Estimated Blood Loss Section"
        },
        "name" : "Procedure Estimated Blood Loss Section",
        "description" : "The Procedure Estimated Blood Loss Section may be a subsection of another section such as the Procedure Description Section.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureFindingsSection",
          "display" : "Procedure Findings Section"
        },
        "name" : "Procedure Findings Section",
        "description" : "The Procedure Findings Section records clinically significant observations confirmed or discovered during a procedure or surgery.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureImplantsSection",
          "display" : "Procedure Implants Section"
        },
        "name" : "Procedure Implants Section",
        "description" : "The Procedure Implants Section records any materials placed during the procedure including stents, tubes, and drains.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureIndicationsSection",
          "display" : "Procedure Indications Section"
        },
        "name" : "Procedure Indications Section",
        "description" : "This section contains the reason(s) for the procedure or surgery.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureNote",
          "display" : "Procedure Note"
        },
        "name" : "Procedure Note",
        "description" : "A Procedure Note encompasses many types of non-operative procedures including interventional cardiology, gastrointestinal endoscopy, osteopathic manipulation, and many other specialty fields.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProcedureSpecimensTakenSection",
          "display" : "Procedure Specimens Taken Section"
        },
        "name" : "Procedure Specimens Taken Section",
        "description" : "The Procedure Specimens Taken Section records the tissues, objects, or samples taken from the patient during the procedure including biopsies, aspiration fluid, or other samples sent for pathological analysis.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProceduresSection",
          "display" : "Procedures Section"
        },
        "name" : "Procedures Section",
        "description" : "This section describes all historical or current interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient at the time the document is generated.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProductInstance",
          "display" : "Product Instance"
        },
        "name" : "Product Instance",
        "description" : "This clinical statement represents a particular device that was placed in a patient or used as part of a procedure or other act.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PrognosisObservation",
          "display" : "Prognosis Observation"
        },
        "name" : "Prognosis Observation",
        "description" : "This template represents the patient's prognosis, which must be associated with a problem observation.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProgressNote",
          "display" : "Progress Note"
        },
        "name" : "Progress Note",
        "description" : "This template represents a patient's clinical status during a hospitalization, outpatient visit, treatment with a LTPAC provider, or other healthcare encounter.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProgressTowardGoalObservation",
          "display" : "Progress Toward Goal Observation"
        },
        "name" : "Progress Toward Goal Observation",
        "description" : "This template represents a patient's progress toward a goal.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProvenanceAssemblerParticipation",
          "display" : "Provenance - Assembler Participation"
        },
        "name" : "Provenance - Assembler Participation",
        "description" : "This template represents the organization that supported generation of a CDA document.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ProvenanceAuthorParticipation",
          "display" : "Provenance - Author Participation"
        },
        "name" : "Provenance - Author Participation",
        "description" : "This template represents the key information to record Provenance in an Author Participation.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ReactionObservation",
          "display" : "Reaction Observation"
        },
        "name" : "Reaction Observation",
        "description" : "This clinical statement represents the response to an undesired symptom, finding, etc.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Reason",
          "display" : "Reason"
        },
        "name" : "Reason",
        "description" : "This template describes the thought process or justification for an action or for not performing an action.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ReasonforReferralSection",
          "display" : "Reason for Referral Section"
        },
        "name" : "Reason for Referral Section",
        "description" : "This section describes the clinical reason why a provider is sending a patient to another provider for care.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ReasonforVisitSection",
          "display" : "Reason for Visit Section"
        },
        "name" : "Reason for Visit Section",
        "description" : "This section records the patient's reason for the patient's visit (as documented by the provider).",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ReferralAct",
          "display" : "Referral Act"
        },
        "name" : "Referral Act",
        "description" : "This template represents the type of referral (e.g., for dental care, to a specialist, for aging problems) and represents whether the referral is for full care or shared care.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ReferralNote",
          "display" : "Referral Note"
        },
        "name" : "Referral Note",
        "description" : "A Referral Note communicates pertinent information from a provider who is requesting services of another provider of clinical or non-clinical services.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RelatedPersonRelationshipAndNameParticipant",
          "display" : "Related Person Relationship and Name Participant"
        },
        "name" : "Related Person Relationship and Name Participant",
        "description" : "This template represents a generic participant person that has a relationship to the patient.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ResultObservation",
          "display" : "Result Observation"
        },
        "name" : "Result Observation",
        "description" : "This template represents the results of a laboratory, radiology, or other study performed on a patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ResultOrganizer",
          "display" : "Result Organizer"
        },
        "name" : "Result Organizer",
        "description" : "This template provides a mechanism for grouping result observations.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ResultsSection",
          "display" : "Results Section"
        },
        "name" : "Results Section",
        "description" : "The Results Section contains observations of results generated by laboratories, imaging procedures, and other procedures.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ReviewofSystemsSection",
          "display" : "Review of Systems Section"
        },
        "name" : "Review of Systems Section",
        "description" : "The Review of Systems Section contains a relevant collection of symptoms and functions systematically gathered by a clinician.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RiskConcernAct",
          "display" : "Risk Concern Act"
        },
        "name" : "Risk Concern Act",
        "description" : "This template represents a risk concern.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SectionTimeRangeObservation",
          "display" : "Section Time Range Observation"
        },
        "name" : "Section Time Range Observation",
        "description" : "This observation represents the date and time range of the information contained in a section.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SelfCareActivitiesADLandIADL",
          "display" : "Self-Care Activities (ADL and IADL)"
        },
        "name" : "Self-Care Activities (ADL and IADL)",
        "description" : "This template represents a patient's daily self-care ability.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SensoryStatus",
          "display" : "Sensory Status"
        },
        "name" : "Sensory Status",
        "description" : "This template represents a patient's sensory or speech ability.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SerialNumberObservation",
          "display" : "Serial Number Observation"
        },
        "name" : "Serial Number Observation",
        "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Serial Number of the device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ServiceDeliveryLocation",
          "display" : "Service Delivery Location"
        },
        "name" : "Service Delivery Location",
        "description" : "This clinical statement represents the physical place of available services or resources.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SeverityObservation",
          "display" : "Severity Observation"
        },
        "name" : "Severity Observation",
        "description" : "This clinical statement represents the gravity of the problem, such as allergy or reaction, in terms of its actual or potential impact on the patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SexObservation",
          "display" : "Sex Observation"
        },
        "name" : "Sex Observation",
        "description" : "USCDI includes a data element for Sex, intended to support the exchange of a recorded sex value.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SexParameterForClinicalUseObservation",
          "display" : "Sex Parameter For Clinical Use Observation"
        },
        "name" : "Sex Parameter For Clinical Use Observation",
        "description" : "The Sex Parameter for Clinical Use (SPCU) observation is a clinical classification indicating which sex-related information is needed to evaluate how a patient's body may respond or has responded to treatments or diagnostic tests.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SexualOrientationObservation",
          "display" : "Sexual Orientation Observation"
        },
        "name" : "Sexual Orientation Observation",
        "description" : "This observation represents the sexual orientation of the patient.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SmokingStatus",
          "display" : "Smoking Status"
        },
        "name" : "Smoking Status",
        "description" : "This template represents a patient's smoking status.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SmokingStatusMeaningfulUse",
          "display" : "Smoking Status - Meaningful Use"
        },
        "name" : "Smoking Status - Meaningful Use",
        "description" : "This template represents the current smoking status of the patient as specified in Meaningful Use (MU) Stage 2 requirements.",
        "groupingId" : "deprecated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SocialHistoryObservation",
          "display" : "Social History Observation"
        },
        "name" : "Social History Observation",
        "description" : "This template represents a patient's job (occupation and industry), lifestyle, and environmental health risk factors.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SocialHistorySection",
          "display" : "Social History Section"
        },
        "name" : "Social History Section",
        "description" : "This section contains social history data that influence a patient's physical, psychological or emotional health (e.g., smoking status, pregnancy).",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SpecimenCollectionProcedure",
          "display" : "Specimen Collection Procedure"
        },
        "name" : "Specimen Collection Procedure",
        "description" : "This template represents clinical information about the specimen including when it was collected, the type and source of specimen, as well as related observations regarding the specimen.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SpecimenConditionObservation",
          "display" : "Specimen Condition Observation"
        },
        "name" : "Specimen Condition Observation",
        "description" : "This template captures the condition or state of the specimen as identified by the laboratory upon receipt or during processing—such as hemolysis, clotting, or contamination.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubjectiveSection",
          "display" : "Subjective Section"
        },
        "name" : "Subjective Section",
        "description" : "The Subjective Section describes in a narrative format the patient's current condition and/or interval changes as reported by the patient or by the patient's guardian or another informant.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubstanceAdministeredAct",
          "display" : "Substance Administered Act"
        },
        "name" : "Substance Administered Act",
        "description" : "This template represents the administration course in a series.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation",
          "display" : "Substance or Device Allergy - Intolerance Observation"
        },
        "name" : "Substance or Device Allergy - Intolerance Observation",
        "description" : "This template reflects a discrete observation about a patient's allergy or intolerance to a substance or device.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SurgicalDrainsSection",
          "display" : "Surgical Drains Section"
        },
        "name" : "Surgical Drains Section",
        "description" : "The Surgical Drains Section may be used to record drains placed during the surgical procedure.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TobaccoUse",
          "display" : "Tobacco Use"
        },
        "name" : "Tobacco Use",
        "description" : "This template represents a patient's tobacco use.",
        "groupingId" : "deprecated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TransferSummary",
          "display" : "Transfer Summary"
        },
        "name" : "Transfer Summary",
        "description" : "The Transfer Summary standardizes critical information for exchange of information between providers of care when a patient moves between health care settings.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TreatmentInterventionPreference",
          "display" : "Treatment Intervention Preference"
        },
        "name" : "Treatment Intervention Preference",
        "description" : "This Treatment Intervention Preference template represents personal health goals, preferences, and priorities for medical treatments or interventions in the event of a future health scenario where a person is unable to make medical decisions because of a serious illness or injury.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TribalAffiliationObservation",
          "display" : "Tribal Affiliation Observation"
        },
        "name" : "Tribal Affiliation Observation",
        "description" : "This template represents the tribe or band that an individual associates with, within the United States.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/UDIOrganizer",
          "display" : "UDI Organizer"
        },
        "name" : "UDI Organizer",
        "description" : "This template is nested within an entryRelationship of either a [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.html) or a [Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.html).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/UnstructuredDocument",
          "display" : "Unstructured Document"
        },
        "name" : "Unstructured Document",
        "description" : "An Unstructured Document (UD) document type can (1) include unstructured content, such as a graphic, directly in a text element with a mediaType attribute, or (2) reference a single document file, such as a word-processing document using a text/reference element.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmAddress",
          "display" : "US Realm Address"
        },
        "name" : "US Realm Address",
        "description" : "Reusable address template, for use in US Realm documents.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmDateTimeInterval",
          "display" : "US Realm Date and Time (Interval)"
        },
        "name" : "US Realm Date and Time - Interval",
        "description" : "The US Realm Clinical Document Date and Time datatype flavor records date and time information.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmDateTime",
          "display" : "US Realm Date and Time (Point in Time)"
        },
        "name" : "US Realm Date and Time - Point in Time",
        "description" : "The US Realm Clinical Document Date and Time datatype flavor records date and time information.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmHeader",
          "display" : "US Realm Header"
        },
        "name" : "US Realm Header",
        "description" : "This template defines constraints that represent common administrative and demographic concepts for US Realm CDA documents.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmHeaderforPatientGeneratedDocument",
          "display" : "US Realm Header for Patient Generated Document"
        },
        "name" : "US Realm Header for Patient Generated Document",
        "description" : "This template focuses on the patient or related person in the roles of author and other participants and is designed to be used in conjunction with the US Realm Header.",
        "groupingId" : "document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmPatientNamePTNUSFIELDED",
          "display" : "US Realm Patient Name (PTN.US.FIELDED)"
        },
        "name" : "US Realm Patient Name (PTN.US.FIELDED)",
        "description" : "The US Realm Patient Name datatype flavor is a set of reusable constraints that can be used for the patient or any other person.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/USRealmPersonNamePNUSFIELDED",
          "display" : "US Realm Person Name (PN.US.FIELDED)"
        },
        "name" : "US Realm Person Name (PN.US.FIELDED)",
        "description" : "The US Realm Clinical Document Person Name datatype flavor is a set of reusable constraints that can be used for Persons.",
        "groupingId" : "other"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/VitalSignObservation",
          "display" : "Vital Sign Observation"
        },
        "name" : "Vital Sign Observation",
        "description" : "This template represents measurement of common vital signs.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/VitalSignsOrganizer",
          "display" : "Vital Signs Organizer"
        },
        "name" : "Vital Signs Organizer",
        "description" : "This template provides a mechanism for grouping vital signs (e.g., grouping systolic blood pressure and diastolic blood pressure).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/VitalSignsSection",
          "display" : "Vital Signs Section"
        },
        "name" : "Vital Signs Section",
        "description" : "The Vital Signs Section contains relevant vital signs for the context and use case of the document type, such as blood pressure (including average blood pressure), heart rate, respiratory rate, height, weight, body mass index, head circumference, pulse oximetry, temperature, and body surface area.",
        "groupingId" : "section"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/WoundCharacteristic",
          "display" : "Wound Characteristic"
        },
        "name" : "Wound Characteristic",
        "description" : "This template represents characteristics of a wound (e.g., integrity of suture line, odor, erythema).",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/WoundMeasurementObservation",
          "display" : "Wound Measurement Observation"
        },
        "name" : "Wound Measurement Observation",
        "description" : "This template represents the Wound Measurement Observations of wound width, depth and length.",
        "groupingId" : "entry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/allergy-to-food-egg"
        },
        "name" : "Example of Allergy Intolerance to Food Egg",
        "description" : "Example of an allergy to egg",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionDiagnosisSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/admission-diagnosis-section-example",
          "display" : "admission-diagnosis-section-example"
        },
        "name" : "Admission Diagnosis Section Example",
        "description" : "Admission Diagnosis Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionDiagnosisSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionMedication"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/admission-medication-example",
          "display" : "admission-medication-example"
        },
        "name" : "Admission Medication example",
        "description" : "Admission Medication example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionMedication"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/advance-directive-existence-observation-example"
        },
        "name" : "Advance Directive Existence Observation Example",
        "description" : "Advance Directive Existence Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/advance-directive-observation-example"
        },
        "name" : "Advance Directive Observation Example",
        "description" : "Advance Directive Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/advance-directives-section-example"
        },
        "name" : "Advance Directives Section Example",
        "description" : "Advance Directives Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AgeObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/age-observation-example"
        },
        "name" : "Age Observation Example",
        "description" : "Age Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AgeObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/allergies-and-intolerances-section-example"
        },
        "name" : "Allergies and Intolerances Section Example",
        "description" : "Allergies and Intolerances Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyConcernAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/allergy-concern-act-example"
        },
        "name" : "Allergy Concern Act Example",
        "description" : "Allergy Concern Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyConcernAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/allergy-intolerance-observation-medication-example"
        },
        "name" : "Allergy Intolerance Observation Medication Example",
        "description" : "Allergy Intolerance Observation Medication example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/allergy-intolerance-observation-drugclass-example"
        },
        "name" : "Allergy Intolerance Observation Drug Class Example",
        "description" : "Allergy Intolerance Observation Drug Class example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/allergy-intolerance-observation-nonmedication-example"
        },
        "name" : "Allergy Intolerance Observation Non-Medication Example",
        "description" : "Allergy Intolerance Observation Non-Medication example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AnesthesiaSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/anesthesia-section-example"
        },
        "name" : "Anesthesia Section Example",
        "description" : "Anesthesia Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AnesthesiaSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/assessment-and-plan-section-example"
        },
        "name" : "Assessment and Plan Section Example",
        "description" : "Assessment and Plan Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/assessment-scale-observation-example"
        },
        "name" : "Assessment Scale Observation Example",
        "description" : "Assessment Scale Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleSupportingObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/assessment-scale-supporting-observation-example"
        },
        "name" : "Assessment Scale Supporting Observation Example",
        "description" : "Assessment Scale Supporting Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleSupportingObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/assessment-section-example"
        },
        "name" : "Assessment Section Example",
        "description" : "Assessment Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/new-author-participant-example"
        },
        "name" : "Author Participation Example",
        "description" : "Author Participation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/authorization-activity-example"
        },
        "name" : "Authorization Activity Example",
        "description" : "Authorization Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorizationActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/BasicIndustryObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/basic-industry-observation-example"
        },
        "name" : "Basic Industry Observation Example",
        "description" : "Basic Industry Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/BasicIndustryObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/BasicOccupationObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/basic-occupation-observation-example"
        },
        "name" : "Basic Occupation Observation Example",
        "description" : "Basic Occupation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/BasicOccupationObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/BirthSexObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/birth-sex-example"
        },
        "name" : "Birth Sex Observation Example",
        "description" : "Birth Sex Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/BirthSexObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/BirthSexObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/birth-sex-example-nullflavor"
        },
        "name" : "Birth Sex Observation Example with Null Flavor",
        "description" : "Birth Sex Observation example with Null Flavor",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/BirthSexObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/BrandNameObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/brand-name-observation-example"
        },
        "name" : "Brand Name Observation Example",
        "description" : "Brand Name Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/BrandNameObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-plan-caregiver-participant-example"
        },
        "name" : "Care Plan Caregiver participant Example",
        "description" : "Care Plan Caregiver participant example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Authenticator"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-plan-patient-authenticator-example"
        },
        "name" : "Care Plan Patient authenticator Example",
        "description" : "Care Plan Patient authenticator example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Performer1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-plan-performer-example"
        },
        "name" : "Care Plan performer Example",
        "description" : "Care Plan performer example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/RelatedDocument"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-plan-relateddocument-example"
        },
        "name" : "Care Plan relatedDocument Example",
        "description" : "Care Plan relatedDocument example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-plan-review-example"
        },
        "name" : "Care Plan Review Example",
        "description" : "Care Plan Review example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-plan-complete-example"
        },
        "name" : "Care Plan Complete Header Example",
        "description" : "Demonstrates most of the Care Plan header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlan"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-team-member-act-example"
        },
        "name" : "Care Team Member Act Example",
        "description" : "Care Team Member Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberScheduleObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-team-member-schedule-observation-example"
        },
        "name" : "Care Team Member Schedule Observation Example",
        "description" : "Care Team Member Schedule Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamMemberScheduleObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-team-organizer-example"
        },
        "name" : "Care Team Organizer Example",
        "description" : "Care Team Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-teams-section-example"
        },
        "name" : "Care Teams Section Example",
        "description" : "Care Teams Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamTypeObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/care-team-type-example"
        },
        "name" : "Care Team Type Observation Example",
        "description" : "Care Team Type Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CareTeamTypeObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CatalogNumberObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/catalog-number-observation-example"
        },
        "name" : "Catalog Number Observation Example",
        "description" : "Catalog Number Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CatalogNumberObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/caregiver-characteristics-example"
        },
        "name" : "Caregiver Characteristics Example",
        "description" : "Caregiver Characteristics example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CharacteristicsofHomeEnvironment"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/characteristics-of-home-environment-example"
        },
        "name" : "Characteristics of Home Environment Example",
        "description" : "Characteristics of Home Environment example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CharacteristicsofHomeEnvironment"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/chief-complaint-and-reason-for-visit-section-example"
        },
        "name" : "Chief Complaint and Reason for Visit Section Example",
        "description" : "Chief Complaint and Reason for Visit Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/chief-complaint-section-example"
        },
        "name" : "Chief Complaint Section Example",
        "description" : "Chief Complaint Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CommentActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/comment-activity-example"
        },
        "name" : "Comment Activity Example",
        "description" : "Comment Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CommentActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CompanyNameObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/company-name-example"
        },
        "name" : "Company Name Observation Example",
        "description" : "Company Name Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CompanyNameObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ComplicationsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/complications-section-example"
        },
        "name" : "Complications Section Example",
        "description" : "Complications Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ComplicationsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/ccd-header-example"
        },
        "name" : "Continuity Of Care Document Complete Header Example",
        "description" : "Demonstrates a fully-valid (but empty) CCD. Nullflavors have been added to all required sections.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Author"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/ccd-author-example"
        },
        "name" : "Continuity Of Care Document Author Example",
        "description" : "Continuity Of Care Document Author example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Performer1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/ccd-performer-example"
        },
        "name" : "Continuity Of Care Document Performer",
        "description" : "Continuity Of Care Document Performer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/DocumentationOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/ccd-serviceevent-example"
        },
        "name" : "Continuity Of Care Document serviceEvent Example",
        "description" : "Continuity Of Care Document serviceEvent example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ContinuityofCareDocumentCCD"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/consultation-note-complete-example"
        },
        "name" : "Consultation Note Complete Header Example",
        "description" : "Demonstrates most of the Consultation Note header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/consultation-note-callback-participant-example"
        },
        "name" : "Consultation Note Callback participant Example",
        "description" : "Consultation Note Callback participant example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/InFulfillmentOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/consultation-note-infulfillmentof-example"
        },
        "name" : "Consultation Note inFulfillmentOf Example",
        "description" : "Consultation Note inFulfillmentOf example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ConsultationNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CourseofCareSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/course-of-care-section-example"
        },
        "name" : "Course of Care Section Example",
        "description" : "Course of Care Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CourseofCareSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CoverageActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/coverage-activity-example"
        },
        "name" : "Coverage Activity Example",
        "description" : "Coverage Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CoverageActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CriticalityObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/criticality-observation-example"
        },
        "name" : "Criticality Observation Example",
        "description" : "Criticality Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CriticalityObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/CulturalandReligiousObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/cultural-and-religious-observation-example"
        },
        "name" : "Cultural and Religious Observation Example",
        "description" : "Cultural and Religious Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/CulturalandReligiousObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/date-of-diagnosis-act-example"
        },
        "name" : "Date of Diagnosis Act Example",
        "description" : "Date of Diagnosis Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DeceasedObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/deceased-observation-example"
        },
        "name" : "Deceased Observation Example",
        "description" : "Deceased Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DeceasedObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DeviceIdentifierObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/device-identifier-observation-example"
        },
        "name" : "Device Identifier Observation Example",
        "description" : "Device Identifier Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DeviceIdentifierObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/diagnosis-reference-example"
        },
        "name" : "Diagnosis Reference Example",
        "description" : "Diagnosis Reference example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DisabilityStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/disability-status-observation-example"
        },
        "name" : "Disability Status Observation Example",
        "description" : "Disability Status Observation Example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DisabilityStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeDiagnosisSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/discharge-diagnosis-section-example"
        },
        "name" : "Discharge Diagnosis Example",
        "description" : "Discharge Diagnosis example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeDiagnosisSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeMedication"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/discharge-medication-example"
        },
        "name" : "Discharge Medication Example",
        "description" : "Discharge Medication example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeMedication"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeMedicationsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/discharge-medications-section-example"
        },
        "name" : "Discharge Medications Section Example",
        "description" : "Discharge Medications Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeMedicationsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/discharge-summary-header-example"
        },
        "name" : "Discharge Summary Complete Header Example",
        "description" : "Demonstrates a fully-valid Discharge Summary. Nullflavors have been added to all required sections.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/ComponentOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/discharge-summary-encompassingencounter-example"
        },
        "name" : "Discharge Summary encompassingEncounter Example",
        "description" : "Discharge Summary (encompassingEncounter) example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DistinctIdentificationCodeObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/distinct-identification-code-observation-example"
        },
        "name" : "Distinct Identification Code Observation Example",
        "description" : "Distinct Identification Code Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DistinctIdentificationCodeObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DrugMonitoringAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/drug-monitoring-act-example"
        },
        "name" : "Drug Monitoring Act Example",
        "description" : "Drug Monitoring Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/DrugMonitoringAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/DrugVehicle"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/drug-vehicle-example"
        },
        "name" : "Drug Vehicle Example",
        "description" : "Drug Vehicle example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/DrugVehicle"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/encounter-activity-example"
        },
        "name" : "Encounter Activity Example",
        "description" : "Encounter Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterDiagnosis"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/encounter-diagnosis-example"
        },
        "name" : "Encounter Diagnosis Example",
        "description" : "Encounter Diagnosis example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterDiagnosis"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/EncountersSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/encounters-section-example"
        },
        "name" : "Encounters Section Example",
        "description" : "Encounters Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/EncountersSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/entry-reference-example"
        },
        "name" : "Entry Reference Example",
        "description" : "Entry Reference example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/EstimatedDateofDelivery"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/estimated-date-of-delivery-example"
        },
        "name" : "Estimated Date of Delivery Example",
        "description" : "Estimated Date of Delivery example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/EstimatedDateofDelivery"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ExpirationDateObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/expiration-date-observation-example"
        },
        "name" : "Expiration Date Observation Example",
        "description" : " example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ExpirationDateObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/external-document-reference-example"
        },
        "name" : "External Document Reference Example",
        "description" : "External Document Reference example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryDeathObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/family-history-death-observation-example"
        },
        "name" : "Family History Death Observation Example",
        "description" : "Family History Death Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryDeathObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/family-history-observation-example"
        },
        "name" : "Family History Observation Example",
        "description" : "Family History Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/family-history-organizer-example"
        },
        "name" : "Family History Organizer Example",
        "description" : "Family History Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/family-history-section-example"
        },
        "name" : "Family History Section Example",
        "description" : "Family History Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/functional-status-observation-example"
        },
        "name" : "Functional Status Observation Example",
        "description" : "Functional Status Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/functional-status-organizer-example"
        },
        "name" : "Functional Status Organizer Example",
        "description" : "Functional Status Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/functional-status-section-example"
        },
        "name" : "Functional Status Section Example",
        "description" : "Functional Status Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/GenderIdentityObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/gender-identity-observation-example"
        },
        "name" : "Gender Identity Observation Example",
        "description" : "Gender Identity Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/GenderIdentityObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/GenderIdentityObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/gender-identity-observation-nullflavor-example"
        },
        "name" : "Gender Identity Observation NullFlavor Example",
        "description" : "Gender Identity Observation example with null flavor",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/GenderIdentityObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/GeneralStatusSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/general-status-section-example"
        },
        "name" : "General Status Section Example",
        "description" : "General Status Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/GeneralStatusSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/GoalObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/goal-observation-example"
        },
        "name" : "Goal Observation Example",
        "description" : "Goal Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/GoalObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/GoalsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/goals-section-example"
        },
        "name" : "Goals Section Example",
        "description" : "Goals Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/GoalsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/handoff-communication-example"
        },
        "name" : "Handoff Communication Participants Example",
        "description" : "Handoff Communication Participants example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/health-concern-act-example"
        },
        "name" : "Health Concern Act Example",
        "description" : "Health Concern Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/health-concerns-section-example"
        },
        "name" : "Health Concerns Section Example",
        "description" : "Health Concerns Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/outcomes-section-example"
        },
        "name" : "Outcomes Section Example",
        "description" : "Outcomes Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OutcomesSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/health-status-observation-example"
        },
        "name" : "Health Status Observation Example",
        "description" : "Health Status Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HealthStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HighestPressureUlcerStage"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/highest-pressure-ulcer-stage-example"
        },
        "name" : "Highest Pressure Ulcer Stage Example",
        "description" : "Highest Pressure Ulcer Stage example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HighestPressureUlcerStage"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/ComponentOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/handp-encompassingencounter-example"
        },
        "name" : "History and Physical Encompassing Encounter Example",
        "description" : "History and Physical Encompassing Encounter example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/history-and-physical-header-example"
        },
        "name" : "History and Physical Complete Header Example",
        "description" : "Demonstrates most of the History and Physical header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/history-of-present-illness-section-example"
        },
        "name" : "History Of Present Illness Example",
        "description" : "History of Present Illness example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalAdmissionDiagnosis"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-admission-diagnosis-example"
        },
        "name" : "Hospital Admission Diagnosis Example",
        "description" : "Hospital Admission Diagnosis example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalAdmissionDiagnosis"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalConsultationsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-consultations-section-example"
        },
        "name" : "Hospital Consultations Section Example",
        "description" : "Hospital Consultations Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalConsultationsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalCourseSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-course-section-example"
        },
        "name" : "Hospital Course Section Example",
        "description" : "Hospital Course Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalCourseSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeDiagnosis"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-discharge-diagnosis-example"
        },
        "name" : "Hospital Discharge Diagnosis Example",
        "description" : "Hospital Discharge Diagnosis example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeDiagnosis"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeInstructionsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-discharge-instructions-section-example"
        },
        "name" : "Hospital Discharge Instructions Section Example",
        "description" : "Hospital Discharge Instructions Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeInstructionsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargePhysicalSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-discharge-physical-section-example"
        },
        "name" : "Hospital Discharge Physical Section Example",
        "description" : "Hospital Discharge Physical Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargePhysicalSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeStudiesSummarySection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/hospital-discharge-studies-summary-section-example"
        },
        "name" : "Hospital Discharge Studies Summary Section Example",
        "description" : "Hospital Discharge Studies Summary Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeStudiesSummarySection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/immunization-activity-example"
        },
        "name" : "Immunization Activity Example",
        "description" : "Immunization Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/immunization-medication-information-example"
        },
        "name" : "Immunization Medication Information Example",
        "description" : "Immunization Medication Information example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationNotGivenReason"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/immunization-notgiven-reason-example"
        },
        "name" : "Immunization Not Given Reason Example",
        "description" : "Immunization Not Given Reason example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationNotGivenReason"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/immunizations-section-example"
        },
        "name" : "Immunizations Section Example",
        "description" : "Immunizations Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImplantableDeviceStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/implantable-device-status-observation-example"
        },
        "name" : "Implantable Device Status Observation Example",
        "description" : "Implantable Device Status Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ImplantableDeviceStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Entry"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/indication-example"
        },
        "name" : "Indication Example",
        "description" : "Indication example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/instructions-section-example"
        },
        "name" : "Instructions Section Example",
        "description" : "Instructions Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/instruction-example"
        },
        "name" : "Instruction Example",
        "description" : "Instruction example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/intervention-act-moodcodeint-example"
        },
        "name" : "Intervention Act Example",
        "description" : "Intervention Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/LatexSafetyObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/latex-safety-observation-example"
        },
        "name" : "Latex Safety Observation Example",
        "description" : "Latex Safety Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/LatexSafetyObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/longitudinal-care-wound-observation-example"
        },
        "name" : "Longitudinal Care Wound Observation Example",
        "description" : "Longitudinal Care Wound Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/LotOrBatchNumberObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/lot-or-batch-number-observation-example"
        },
        "name" : "Lot or Batch Number Observation Example",
        "description" : "Lot or Batch Number Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/LotOrBatchNumberObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ManufacturingDateObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/manufacturing-date-observation-example"
        },
        "name" : "Manufacturing Date Observation Example",
        "description" : "Manufacturing Date Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ManufacturingDateObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medical-equipment-organizer-example"
        },
        "name" : "Medical Equipment Organizer Example",
        "description" : "Medical Equipment Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medical-equipment-section-example"
        },
        "name" : "Medical Equipment Section Example",
        "description" : "Medical Equipment Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicalEquipmentSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-activity-example"
        },
        "name" : "Medication Activity Example",
        "description" : "Medication Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationAdherence"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-adherence-example"
        },
        "name" : "Medication Adherence Example",
        "description" : "Medication Adherence example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationAdherence"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationAdherence"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-adherence-nullflavor-example"
        },
        "name" : "Medication Adherence NullFlavor Example",
        "description" : "Medication Adherence example with null flavor",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationAdherence"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-dispense-example"
        },
        "name" : "Medication Dispense Example",
        "description" : "Medication Dispense example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-free-text-sig-example"
        },
        "name" : "Medication Free Text Sig Example",
        "description" : "Medication Free Text Sig example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-information-example"
        },
        "name" : "Medication Information Example",
        "description" : "Medication Information example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medication-supply-order-example"
        },
        "name" : "Medication Supply Order Example",
        "description" : "Medication Supply Order example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsAdministeredSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medications-administered-section-example"
        },
        "name" : "Medications Administered Section Example",
        "description" : "Medications Administered Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsAdministeredSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/medications-section-example"
        },
        "name" : "Medications Section Example",
        "description" : "Medications Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/mental-status-observation-example"
        },
        "name" : "Mental Status Observation Example",
        "description" : "Mental Status Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/mental-status-organizer-example"
        },
        "name" : "Mental Status Organizer Example",
        "description" : "Mental Status Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/mental-status-section-example"
        },
        "name" : "Mental Status Section Example",
        "description" : "Mental Status Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ModelNumberObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/model-number-observation-example"
        },
        "name" : "Model Number Observation Example",
        "description" : "Model Number Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ModelNumberObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MRISafetyObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/mri-safety-observation-example"
        },
        "name" : "MRI Safety Observation Example",
        "description" : "MRI Safety Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MRISafetyObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/no-known-medications-example"
        },
        "name" : "No Known Medications Example",
        "description" : "No Known Medications example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/no-known-problems-section-example"
        },
        "name" : "No Known Problem Section Example",
        "description" : "No Known Problem Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/NonMedicinalSupplyActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/non-medicinal-supply-activity-example"
        },
        "name" : "Non-Medicinal Supply Activity Example",
        "description" : "Non-Medicinal Supply Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NonMedicinalSupplyActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/note-activity-as-entryrelationship-to-ccda-entry-example"
        },
        "name" : "Note Activity Entry Relationship Example",
        "description" : "Note Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/note-activity-as-standalone-entry-example"
        },
        "name" : "Note Activity Standalone Example",
        "description" : "Note Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/NonXMLBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nonxmlbody-example-with-compressed-content"
        },
        "name" : "nonXML Body Example with Compressed Content",
        "description" : "nonXMLBody Example with Compressed Content",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/UnstructuredDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/NonXMLBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nonxmlbody-example-with-embedded-content"
        },
        "name" : "nonXML Body Example with Embedded Content",
        "description" : "nonXMLBody Example with Embedded Content",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/UnstructuredDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/NonXMLBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nonxmlbody-example-with-referenced-content"
        },
        "name" : "nonXML Body Example with Referenced Content",
        "description" : "nonXMLBody Example with Referenced Content",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/UnstructuredDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/NumberofPressureUlcersObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/number-of-pressure-ulcers-observation-example"
        },
        "name" : "Number of Pressure Ulcers Observation Example",
        "description" : "Number of Pressure Ulcers Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NumberofPressureUlcersObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionAssessment"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nutrition-assessment-example"
        },
        "name" : "Nutrition Assessment Example",
        "description" : "Nutrition Assessment example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionAssessment"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nutrition-recommendation-example"
        },
        "name" : "Nutrition Recommendation Example",
        "description" : "Nutrition Recommendation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nutrition-section-example"
        },
        "name" : "Nutrition Section Example",
        "description" : "Nutrition Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionalStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/nutritional-status-observation-example"
        },
        "name" : "Nutritional Status Observation Example",
        "description" : "Nutritional Status Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionalStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ObjectiveSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/objective-section-example"
        },
        "name" : "Objective Section Example",
        "description" : "Objective Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ObjectiveSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/operative-note-header-example"
        },
        "name" : "Operative Note Complete Header Example",
        "description" : "Demonstrates most of the Operative Note header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Performer1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/operative-note-performer-example"
        },
        "name" : "Operative Note performer Example",
        "description" : "Operative Note performer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/ServiceEvent"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/operative-note-serviceevent-example"
        },
        "name" : "Operative Note serviceEvent Example",
        "description" : "Operative Note serviceEvent example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNoteFluidsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/operative-note-fluids-section-example"
        },
        "name" : "Operative Note Fluids Section Example",
        "description" : "Operative Note Fluids Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNoteFluidsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNoteSurgicalProcedureSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/operative-note-surgical-procedure-section-example"
        },
        "name" : "Operative Note Surgical Procedure Section Example",
        "description" : "Operative Note Surgical Procedure Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OperativeNoteSurgicalProcedureSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/OutcomeObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/outcome-observation-example"
        },
        "name" : "Outcome Observation Example",
        "description" : "Outcome Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/OutcomeObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/past-medical-history-example"
        },
        "name" : "Past Medical History Example",
        "description" : "Past Medical History example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Authenticator"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-authenticator-example"
        },
        "name" : "Patient Generated Document authenticator",
        "description" : "Patient Generated Document authenticator example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Author"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-author-device-example"
        },
        "name" : "Patient Generated Document author device Example",
        "description" : "Patient Generated Document author device example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Author"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-author-example"
        },
        "name" : "Patient Generated Document author",
        "description" : "Patient Generated Document author example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Custodian"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-custodian-example"
        },
        "name" : "Patient Generated Document custodian Example",
        "description" : "PPatient Generated Document custodian example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/DataEnterer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-dataenterer-example"
        },
        "name" : "Patient Generated Document dataEnterer",
        "description" : "Patient Generated Document dataEnterer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Informant"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-informant-example-informant"
        },
        "name" : "Patient Generated Document informant Example informant",
        "description" : "Patient Generated Document informant Example informant",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Informant"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-informant-relent-example"
        },
        "name" : "Patient Generated Document informant RelEnt Example",
        "description" : "Patient Generated Document informant RelEnt example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/InformationRecipient"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-informationrecipient"
        },
        "name" : "Patient Generated Document informationRecipient Example",
        "description" : "Patient Generated Document informationRecipient example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/InFulfillmentOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-infulfillmentof-example"
        },
        "name" : "Patient Generated Document inFulfillmentOf Example",
        "description" : "Patient Generated Document inFulfillmentOf example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/LegalAuthenticator"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-legalauthenticator-example"
        },
        "name" : "Patient Generated Document legalAuthenticator Example",
        "description" : "PPatient Generated Document legalAuthenticator example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-participant-example"
        },
        "name" : "Patient Generated Document participant Example",
        "description" : "Patient Generated Document participant example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/RecordTarget"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/patient-generated-document-recordtarget-example"
        },
        "name" : "Patient Generated Document recordTarget",
        "description" : "Patient Generated Document recordTarget example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeaderforPatientGeneratedDocument"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/referral-act-example"
        },
        "name" : "Referral Act Example",
        "description" : "Referral Act example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/ReferralAct"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PayersSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/payers-section-example"
        },
        "name" : "Payers Section Example",
        "description" : "Payers Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PayersSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/physical-exam-section-example"
        },
        "name" : "Physical Exam Section Example",
        "description" : "Physical Exam Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/plan-of-treatment-section-example"
        },
        "name" : "Plan of Treatment Section Example",
        "description" : "Plan of Treatment Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-coverage-example"
        },
        "name" : "Planned Coverage Example",
        "description" : "Planned Coverage example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-encounter-example"
        },
        "name" : "Planned Encounter Example",
        "description" : "Planned Encounter example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-immunization-activity"
        },
        "name" : "Planned Immunization Activity Example",
        "description" : "Planned Immunization Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-intervention-act-example"
        },
        "name" : "Planned Intervention Activity Example",
        "description" : "Planned Intervention Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedMedicationActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-medication-activity-example"
        },
        "name" : "Planned Medication Activity Example",
        "description" : "Planned Medication Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedMedicationActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedureSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-procedure-section-example"
        },
        "name" : "Planned Procedure Section Example",
        "description" : "Planned Procedure Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedureSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-procedure-example"
        },
        "name" : "Planned Procedure Example",
        "description" : "Planned Procedure example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/planned-supply-example"
        },
        "name" : "Planned Supply Example",
        "description" : "Planned Supply example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/policy-activity-example"
        },
        "name" : "Policy Activity Example",
        "description" : "Policy Activity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PolicyActivity"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PostoperativeDiagnosisSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/postoperative-diagnosis-section-example"
        },
        "name" : "Postoperative Diagnosis Section Example",
        "description" : "Postoperative Diagnosis Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PostoperativeDiagnosisSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosis"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/postprocedure-diagnosis-example"
        },
        "name" : "Postprocedure Diagnosis Example",
        "description" : "Postprocedure Diagnosis example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosis"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosisSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/postprocedure-diagnosis-section-example"
        },
        "name" : "Postprocedure Diagnosis Section Example",
        "description" : "Postprocedure Diagnosis Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosisSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/precondition-for-substance-administration-example"
        },
        "name" : "Precondition for Substance Administration Example",
        "description" : "Precondition for Substance Administration example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyIntentionInNextYear"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/pregnancy-intention-in-next-year-example"
        },
        "name" : "Pregnancy Intention in Next Year Example",
        "description" : "Pregnancy Intention in Next Year example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyIntentionInNextYear"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyStatusObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/pregnancy-status-observation-example"
        },
        "name" : "Pregnancy Status Observation Example",
        "description" : "Pregnancy Status Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyStatusObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosisSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/preoperative-diagnosis-section-example"
        },
        "name" : "Preoperative Diagnosis Section Example",
        "description" : "Preoperative Diagnosis Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosisSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosis"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/preoperative-diagnosis-example"
        },
        "name" : "Preoperative Diagnosis Example",
        "description" : "Preoperative Diagnosis example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosis"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/priority-preference-example"
        },
        "name" : "Priority Preference Example",
        "description" : "Priority Preference example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/problem-concern-act-example"
        },
        "name" : "Problem Concern Act Example",
        "description" : "Problem Concern Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/problem-observation-example"
        },
        "name" : "Problem Observation Example",
        "description" : "Problem Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/problem-observation-postcoordsnomed-example"
        },
        "name" : "Problem Observation with Post-Coordinated SNOMED Example",
        "description" : "Problem Observation with Post-Coordinated SNOMED example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/problem-section-example"
        },
        "name" : "Problem Section Example",
        "description" : "Problem Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-note-header-example"
        },
        "name" : "Procedure Note Complete Header Example",
        "description" : "Demonstrates most of the Procedure Note header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Performer1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-note-performer-example"
        },
        "name" : "Procedure Note performer Example",
        "description" : "Procedure Note performer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/DocumentationOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-note-serviceevent-example"
        },
        "name" : "Procedure Note serviceEvent Example",
        "description" : "Procedure Note serviceEvent example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-activity-procedure-example"
        },
        "name" : "Procedure Activity Procedure Example",
        "description" : "Procedure Activity Procedure example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureActivityProcedure"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDescriptionSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-description-section-example"
        },
        "name" : "Procedure Description Section Example",
        "description" : "Procedure Description Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDescriptionSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDispositionSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-disposition-section-example"
        },
        "name" : "Procedure Disposition Section Example",
        "description" : "Procedure Disposition Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureDispositionSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureEstimatedBloodLossSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-estimated-blood-loss-section-example"
        },
        "name" : "Procedure Estimated Blood Loss Section Example",
        "description" : "Procedure Estimated Blood Loss Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureEstimatedBloodLossSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureFindingsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-findings-section-example"
        },
        "name" : "Procedure Findings Section Example",
        "description" : "Procedure Findings Section dexample",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureFindingsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureImplantsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-implants-section-example"
        },
        "name" : "Procedure Implants Section Example",
        "description" : "Procedure Implants Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureImplantsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureIndicationsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-indications-section-example"
        },
        "name" : "Procedure Indications Section Example",
        "description" : "Procedure Indications Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureIndicationsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureSpecimensTakenSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedure-specimens-taken-section-example"
        },
        "name" : "Procedure Specimens Taken Section Example",
        "description" : "Procedure Specimens Taken Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProcedureSpecimensTakenSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/procedures-section-example"
        },
        "name" : "Procedures Section Example",
        "description" : "Procedures Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/product-instance-example"
        },
        "name" : "Product Instance Example",
        "description" : "Product Instance example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PrognosisObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/prognosis-coded-example"
        },
        "name" : "Prognosis Coded Example",
        "description" : "Prognosis Coded example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PrognosisObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/PrognosisObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/prognosis-free-text-example"
        },
        "name" : "Prognosis Free Text Example",
        "description" : "Prognosis Free Text example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/PrognosisObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressNote"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/progress-note-header-example"
        },
        "name" : "Progress Note Complete Header Example",
        "description" : "Demonstrates most of the Progress Note header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/ComponentOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/progress-note-encompassingencounter-example"
        },
        "name" : "Progress Note encompassingEncounter Example",
        "description" : "Progress Note encompassingEncounter example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/DocumentationOf"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/progress-note-serviceevent-example"
        },
        "name" : "Progress Note serviceEvent Example",
        "description" : "Progress Note serviceEvent example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/progress-toward-goal-observation-example"
        },
        "name" : "Progress Toward Goal Observation Example",
        "description" : "Progress Toward Goal Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProgressTowardGoalObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAssemblerParticipation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/provenance-assembler-participation-example"
        },
        "name" : "Provenance - Assembler Participation Example",
        "description" : "Provenance - Assembler Participation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAssemblerParticipation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/StructuredBody"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/provenance-author-participation-example"
        },
        "name" : "Provenance - Author Participation Example",
        "description" : "Provenance - Author Participation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/reaction-observation-example"
        },
        "name" : "Reaction Observation Example",
        "description" : "Reaction Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/Reason"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/reason-example"
        },
        "name" : "Reason Example",
        "description" : "Reason example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Reason"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforReferralSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/reason-for-referral-section-example"
        },
        "name" : "Reason For Referral",
        "description" : "Reason For Referral example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforReferralSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/reason-for-visit-section-example"
        },
        "name" : "Reason for Visit Section Example",
        "description" : "Reason for Visit Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/referral-note-header-example"
        },
        "name" : "Referral Note Complete Header Example",
        "description" : "Demonstrates most of the Referral Note header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/referral-note-callback-contact-example"
        },
        "name" : "Referral Note Callback Contact Example",
        "description" : "Referral Note Callback Contact example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/referral-note-caregiver-example"
        },
        "name" : "Referral Note Caregiver",
        "description" : "Referral Note Caregiver example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/InformationRecipient"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/referral-note-informationrecipient-example"
        },
        "name" : "Referral Note informationRecipient Example",
        "description" : "Referral Note informationRecipient example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReferralNote"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/related-person-relationship-and-name-example"
        },
        "name" : "Related Person Relationship and Name Participant Example",
        "description" : "Related Person Relationship and Name Participant example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/result-observation-example"
        },
        "name" : "Result Observation Example",
        "description" : "Result Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/result-organizer-example"
        },
        "name" : "Result Organizer Example",
        "description" : "Result Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/results-section-example"
        },
        "name" : "Results Section Example",
        "description" : "Results Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/review-of-systems-section-example"
        },
        "name" : "Review Of Systems Section Example",
        "description" : "Review of Systems Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/risk-concern-act-example"
        },
        "name" : "Risk Concern Act Example",
        "description" : "Risk Concern Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SelfCareActivitiesADLandIADL"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/self-care-activities-adl-and-iadl-example"
        },
        "name" : "Self-Care Activities ADL and IADL Example",
        "description" : "Self-Care Activities (ADL and IADL) example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SelfCareActivitiesADLandIADL"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/sensory-and-speech-status-example"
        },
        "name" : "Sensory Status Example",
        "description" : "Sensory Status example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/serial-number-observation-example"
        },
        "name" : "Serial Number Observation Example",
        "description" : "Serial Number Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/service-delivery-location-example"
        },
        "name" : "Service Delivery Location Example",
        "description" : "Service Delivery Location example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SeverityObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/severity-observation-example"
        },
        "name" : "Severity Observation Example",
        "description" : "Severity Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SeverityObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/sex-observation-example"
        },
        "name" : "Sex Observation Example",
        "description" : "Sex Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SexObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/sex-observation-nullflavor-example"
        },
        "name" : "Sex Observation Null Flavor Example",
        "description" : "Sexu Observation example with nullflavor code",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SexObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexualOrientationObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/sexual-orientation-observation-example"
        },
        "name" : "Sexual Orientation Observation Example",
        "description" : "Sexual Orientation Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SexualOrientationObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SexualOrientationObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/sexual-orientation-observation-nullflavor-example"
        },
        "name" : "Sexual Orientation Observation Null Flavor Example",
        "description" : "Sexual Orientation Observation example with nullflavor code",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SexualOrientationObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/smoking-status-coded-example"
        },
        "name" : "Smoking Status Coded Example",
        "description" : "Smoking Status Coded example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/smoking-status-quantity-example"
        },
        "name" : "Smoking Status Quantity Example",
        "description" : "Smoking Status Quantity example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatusMeaningfulUse"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/smoking-status-meaningful-use-example"
        },
        "name" : "Smoking Status Meaningful Use Example",
        "description" : "Smoking Status - Meaningful Use example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatusMeaningfulUse"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/specimen-collection-procedure-example"
        },
        "name" : "Specimen Collection Procedure Example",
        "description" : "Specimen Collection Procedure example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenCollectionProcedure"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenConditionObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/specimen-condition-observation-example"
        },
        "name" : "Specimen Condition Observation Example",
        "description" : "Specimen Condition Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SpecimenConditionObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/social-history-section-example"
        },
        "name" : "Social History Section Example",
        "description" : "Social History Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubjectiveSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/subjective-section-example"
        },
        "name" : "Subjective Section Example",
        "description" : "Subjective Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SubjectiveSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceAdministeredAct"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/substance-administered-act-example"
        },
        "name" : "Substance Administered Act Example",
        "description" : "Substance Administered Act example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceAdministeredAct"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/SurgicalDrainsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/surgical-drains-section-example"
        },
        "name" : "Surgical Drains Section Example",
        "description" : "Surgical Drains Section example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/SurgicalDrainsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/TobaccoUse"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/tobacco-use-example"
        },
        "name" : "Tobacco Use Example",
        "description" : "Tobacco Use example",
        "isExample" : true,
        "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/TobaccoUse"],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/transfer-summary-header-example"
        },
        "name" : "Transfer Summary Complete Header Example",
        "description" : "Demonstrates most of the Transfer Summary header requirements. Body sections are empty with nullFlavors.",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/transfer-summary-callback-contact-example"
        },
        "name" : "Transfer Summary Callback Contact Example",
        "description" : "Transfer Summary Callback Contact example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/transfer-summary-participant-support-example"
        },
        "name" : "Transfer Summary participant (Support) Example",
        "description" : "Transfer Summary participant (Support) example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/TransferSummary"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/TribalAffiliationObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/tribal-affiliation-example"
        },
        "name" : "Tribal Affiliation Observation Example",
        "description" : "Tribal Affiliation Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/TribalAffiliationObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/udi-organizer-example"
        },
        "name" : "UDI Organizer Example",
        "description" : "UDI Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/us-realm-address-example"
        },
        "name" : "US Realm Address Example",
        "description" : "US Realm Address example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/us-realm-date-and-time-example"
        },
        "name" : "US Realm Date and Time Example",
        "description" : "US Realm Date and Time example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/us-realm-date-and-time-ivl-example"
        },
        "name" : "US Realm Date and Time Interval Example",
        "description" : "US Realm Date and Time Interval example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/us-realm-header-race-translation-example"
        },
        "name" : "US Realm Header Race Translation Example",
        "description" : "Demonstrates the use of translation elements to associated detailed race codes with race categories",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/us-realm-header-example"
        },
        "name" : "US Realm Header Example",
        "description" : "US Realm Header example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/us-realm-person-name-example"
        },
        "name" : "US Realm Person Name Example",
        "description" : "US Realm Person Name example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/vital-sign-observation-example"
        },
        "name" : "Vital Sign Observation Example",
        "description" : "Vital Sign Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/average-bp-example"
        },
        "name" : "Average Blood Pressure Organizer Example",
        "description" : "Example of average blood pressure",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/AverageBloodPressureOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsOrganizer"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/vital-signs-organizer-example"
        },
        "name" : "Vital Signs Organizer Example",
        "description" : "Vital Signs Organizer example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsOrganizer"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/vital-signs-section-example"
        },
        "name" : "Vital Signs Section Example",
        "description" : "Vital Signs Section example - including Average Blood Pressure",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/WoundCharacteristic"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/wound-characteristic-example"
        },
        "name" : "Wound Characteristic Example",
        "description" : "Wound Characteristic example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/WoundCharacteristic"
        ],
        "groupingId" : "examples"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/xml"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/cda/us/ccda/StructureDefinition/WoundMeasurementObservation"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/wound-measurement-observation-example"
        },
        "name" : "Wound Measurement Observation Example",
        "description" : "Wound Measurement Observation example",
        "isExample" : true,
        "profile" : [
          "http://hl7.org/cda/us/ccda/StructureDefinition/WoundMeasurementObservation"
        ],
        "groupingId" : "examples"
      }
    ],
    "page" : {
      "sourceUrl" : "index.html",
      "name" : "index.html",
      "title" : "IG Home Page",
      "generation" : "markdown",
      "page" : [
        {
          "sourceUrl" : "uscdi.html",
          "name" : "uscdi.html",
          "title" : "USCDI",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "generalguidance.html",
          "name" : "generalguidance.html",
          "title" : "General Guidance",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "screeningandassessments.html",
          "name" : "screeningandassessments.html",
          "title" : "Screening And Assessments",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "supportingguidance.html",
          "name" : "supportingguidance.html",
          "title" : "Supporting Guidance",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "validation.html",
          "name" : "validation.html",
          "title" : "Validation",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "provenance.html",
          "name" : "provenance.html",
          "title" : "Provenance in C-CDA",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "howtoread.html",
          "name" : "howtoread.html",
          "title" : "How To Read",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "terminology.html",
          "name" : "terminology.html",
          "title" : "Terminology",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "changes.html",
          "name" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "templateids.html",
          "name" : "templateids.html",
          "title" : "Template IDs",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "STU5 Ballot 1"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "version-comparison-master"
        },
        "value" : "4.0.0"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-expansion-params"
        },
        "value" : "../exp-params.json"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2019+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "logged-when-scanning"
        },
        "value" : "false"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "jira-code"
        },
        "value" : "ccda"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "value-set-limit"
        },
        "value" : "1000"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "parent-template-id"
        },
        "value" : "2.16.840.1.113883.10.20.22"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "http://hl7.org/cda/us/ccda/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludettl"
        },
        "value" : "true"
      }
    ]
  }
}

```
