# Artifacts Summary - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Document Templates 

Document-level templates describe the purpose and rules for constructing a conforming CDA document. Document templates include constraints on the CDA header and indicate contained section-level templates.

Each document-level template contains the following information:

* Scope and intended use of the document type
* Description and explanatory narrative
* Template metadata (e.g., templateId)
* Header constraints (e.g., document type, template id, participants)
* Required and optional section-level templates

| | |
| :--- | :--- |
| [Care Plan](StructureDefinition-CarePlan.md) | A Care Plan is a consensus-driven dynamic plan that represents a patient's and Care Team Member's prioritized concerns, goals, and planned interventions. |
| [Consultation Note](StructureDefinition-ConsultationNote.md) | The Consultation Note is generated by a request from a clinician for an opinion or advice from another clinician. |
| [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md) | The Continuity of Care Document (CCD) represents a core data set of the most relevant administrative, demographic, and clinical information facts about a patient's healthcare, covering one or more healthcare encounters. |
| [Discharge Summary](StructureDefinition-DischargeSummary.md) | The Discharge Summary is a document which synopsizes a patient's admission to a hospital, LTPAC provider, or other setting. |
| [History and Physical](StructureDefinition-HistoryandPhysical.md) | A History and Physical (H&P) note is a medical report that documents the current and past conditions of the patient. |
| [Operative Note](StructureDefinition-OperativeNote.md) | The Operative Note is a frequently used type of procedure note with specific requirements set forth by regulatory agencies. |
| [Procedure Note](StructureDefinition-ProcedureNote.md) | A Procedure Note encompasses many types of non-operative procedures including interventional cardiology, gastrointestinal endoscopy, osteopathic manipulation, and many other specialty fields. |
| [Progress Note](StructureDefinition-ProgressNote.md) | This template represents a patient's clinical status during a hospitalization, outpatient visit, treatment with a LTPAC provider, or other healthcare encounter. |
| [Referral Note](StructureDefinition-ReferralNote.md) | A Referral Note communicates pertinent information from a provider who is requesting services of another provider of clinical or non-clinical services. |
| [Transfer Summary](StructureDefinition-TransferSummary.md) | The Transfer Summary standardizes critical information for exchange of information between providers of care when a patient moves between health care settings. |
| [Unstructured Document](StructureDefinition-UnstructuredDocument.md) | An Unstructured Document (UD) document type can (1) include unstructured content, such as a graphic, directly in a text element with a mediaType attribute, or (2) reference a single document file, such as a word-processing document using a text/reference element. |
| [US Realm Header](StructureDefinition-USRealmHeader.md) | This template defines constraints that represent common administrative and demographic concepts for US Realm CDA documents. |
| [US Realm Header for Patient Generated Document](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md) | This template focuses on the patient or related person in the roles of author and other participants and is designed to be used in conjunction with the US Realm Header. |

### Section Templates 

This chapter contains the section-level templates referenced by one or more of the document types of this consolidated guide. These templates describe the purpose of each section and the section-level constraints.

Section-level templates are always included in a document. One and only one of each section type is allowed in a given document instance. Please see the document context tables to determine the sections that are contained in a given document type. Please see the conformance verb in the conformance statements to determine if it is required (SHALL), strongly recommended (SHOULD), or optional (MAY).

Each section-level template contains the following:

* Template metadata (e.g., templateId, etc.)
* Description and explanatory narrative
* LOINC section code
* Section title
* Requirements for a text element
* Entry-level template names and Ids for referenced templates (required and optional)

Narrative Text

The text element within the section stores the narrative to be rendered, as described in the CDA R2 specification, and is referred to as the CDA narrative block.

The content model of the CDA narrative block schema is handcrafted to meet requirements of human readability and rendering. The schema is registered as a MIME type (text/x-hl7-text+xml), which is the fixed media type for the text element.

As noted in the CDA R2 specification, the document originator is responsible for ensuring that the narrative block contains the complete, human readable, attested content of the section. Structured entries support computer processing and computation and are not a replacement for the attestable, human-readable content of the CDA narrative block. The special case of structured entries with an entry relationship of "DRIV" (is derived from) indicates to the receiving application that the source of the narrative block is the structured entries, and that the contents of the two are clinically equivalent.

For all CDA documents—even when a report consisting entirely of structured entries is transformed into CDA—the encoding application must ensure that the authenticated content (narrative plus multimedia) is a faithful and complete rendering of the clinical content of the structured source data. As a general guideline, a generated narrative block should include the same human readable content that would be available to users viewing that content in the originating system. Although content formatting in the narrative block need not be identical to that in the originating system, the narrative block should use elements from the CDA narrative block schema to provide sufficient formatting to support human readability when rendered according to the rules defined in Section Narrative Block (§ 4.3.5 ) of the CDA R2 specification.

By definition, a receiving application cannot assume that all clinical content in a section (i.e., in the narrative block and multimedia) is contained in the structured entries unless the entries in the section have an entry relationship of "DRIV".

Additional specification information for the CDA narrative block can be found in the CDA R2 specification in sections 1.2.1, 1.2.3, 1.3, 1.3.1, 1.3.2, 4.3.4.2, and 6.

| | |
| :--- | :--- |
| [Activities Section](StructureDefinition-ActivitiesSection.md) | This template represents Activities. |
| [Admission Diagnosis Section](StructureDefinition-AdmissionDiagnosisSection.md) | This section contains a narrative description of the problems or diagnoses identified by the clinician at the time of the patient's admission. |
| [Admission Medications Section (entries optional)](StructureDefinition-AdmissionMedicationsSectionEntriesOptional.md) | The section contains the medications taken by the patient prior to and at the time of admission to the facility. |
| [Advance Directives Section](StructureDefinition-AdvanceDirectivesSection.md) | This section contains details about the patient’s advance healthcare directives, including references to supporting documents such as Living Wills, Healthcare Power of Attorney, Personal Advance Care Plans, DNR Orders, and Portable Medical Orders. |
| [Allergies and Intolerances Section](StructureDefinition-AllergiesAndIntolerancesSection.md) | This section lists and describes any medication allergies, adverse reactions, idiosyncratic reactions, anaphylaxis/anaphylactoid reactions to food items, and metabolic variations or adverse reactions/allergies to other substances (such as latex, iodine, tape adhesives). |
| [Anesthesia Section](StructureDefinition-AnesthesiaSection.md) | The Anesthesia Section records the type of anesthesia (e.g., general or local) and may state the actual agent used. |
| [Assessment and Plan Section](StructureDefinition-AssessmentandPlanSection.md) | This section represents the clinician's conclusions and working assumptions that will guide treatment of the patient. |
| [Assessment Section](StructureDefinition-AssessmentSection.md) | The Assessment Section (also referred to as "impression" or "diagnoses" outside of the context of CDA) represents the clinician's conclusions and working assumptions that will guide treatment of the patient. |
| [Care Teams Section](StructureDefinition-CareTeamsSection.md) | The Care Teams Section is used to share historical and current Care Team information. |
| [Chief Complaint and Reason for Visit Section](StructureDefinition-ChiefComplaintandReasonforVisitSection.md) | This section records the patient's chief complaint (the patient's own description) and/or the reason for the patient's visit (the provider's description of the reason for visit). |
| [Chief Complaint Section](StructureDefinition-ChiefComplaintSection.md) | This section records the patient's chief complaint (the patient's own description). |
| [Complications Section](StructureDefinition-ComplicationsSection.md) | This section contains problems that occurred during or around the time of a procedure. |
| [Course of Care Section](StructureDefinition-CourseofCareSection.md) | The Course of Care section describes what happened during the course of an encounter. |
| [Discharge Diagnosis Section](StructureDefinition-DischargeDiagnosisSection.md) | This template represents problems or diagnoses present at the time of discharge which occurred during the hospitalization. |
| [Discharge Medications Section](StructureDefinition-DischargeMedicationsSection.md) | This section contains the medications the patient is intended to take or stop after discharge. |
| [Encounters Section](StructureDefinition-EncountersSection.md) | This section lists and describes any healthcare encounters pertinent to the patient's current health status or historical health history. |
| [Family History Section](StructureDefinition-FamilyHistorySection.md) | This section contains data defining the patient's genetic relatives in terms of possible or relevant health risk factors that have a potential impact on the patient's healthcare risk profile. |
| [Functional Status Section](StructureDefinition-FunctionalStatusSection.md) | The Functional Status Section contains observations and assessments of a patient's physical abilities. |
| [General Status Section](StructureDefinition-GeneralStatusSection.md) | The General Status section describes general observations and readily observable attributes of the patient, including affect and demeanor, apparent age compared to actual age, gender, ethnicity, nutritional status based on appearance, body build and habitus (e.g., muscular, cachectic, obese), developmental or other deformities, gait and mobility, personal hygiene, evidence of distress, and voice quality and speech. |
| [Goals Section](StructureDefinition-GoalsSection.md) | This template represents patient Goals. |
| [Health Concerns Section](StructureDefinition-HealthConcernsSection.md) | This section contains data describing an interest or worry about a health state or process that could possibly require attention, intervention, or management. |
| [History of Present Illness Section](StructureDefinition-HistoryofPresentIllnessSection.md) | The History of Present Illness section describes the history related to the reason for the encounter. |
| [Hospital Consultations Section](StructureDefinition-HospitalConsultationsSection.md) | The Hospital Consultations Section records consultations that occurred during the admission. |
| [Hospital Course Section](StructureDefinition-HospitalCourseSection.md) | The Hospital Course Section describes the sequence of events from admission to discharge in a hospital facility. |
| [Hospital Discharge Instructions Section](StructureDefinition-HospitalDischargeInstructionsSection.md) | The Hospital Discharge Instructions Section records instructions at discharge. |
| [Hospital Discharge Physical Section](StructureDefinition-HospitalDischargePhysicalSection.md) | The Hospital Discharge Physical Section records a narrative description of the patient's physical findings. |
| [Hospital Discharge Studies Summary Section](StructureDefinition-HospitalDischargeStudiesSummarySection.md) | This section records the results of observations generated by laboratories, imaging procedures, and other procedures. |
| [Immunizations Section](StructureDefinition-ImmunizationsSection.md) | The Immunizations Section defines a patient's current immunization status and pertinent immunization history. |
| [Instructions Section](StructureDefinition-InstructionsSection.md) | The Instructions Section records instructions given to a patient. |
| [Medical (General) History Section](StructureDefinition-MedicalGeneralHistorySection.md) | The Medical History Section describes all aspects of the medical history of the patient even if not pertinent to the current procedure, and may include chief complaint, past medical history, social history, family history, surgical or procedure history, medication history, and other history information. |
| [Medical Equipment Section](StructureDefinition-MedicalEquipmentSection.md) | This section defines a patient's implanted and external health and medical devices and equipment. |
| [Medications Administered Section](StructureDefinition-MedicationsAdministeredSection.md) | The Medications Administered Section usually resides inside a Procedure Note describing a procedure. |
| [Medications Section](StructureDefinition-MedicationsSection.md) | The Medications Section contains a patient's current medications and pertinent medication history. |
| [Mental Status Section](StructureDefinition-MentalStatusSection.md) | The Mental Status Section contains observations and evaluations related to a patient's psychological and mental competency and deficits. |
| [Notes Section](StructureDefinition-NotesSection.md) | The Notes Section allow for inclusion of clinical documentation which does not fit precisely within any other C-CDA section. |
| [Nutrition Section](StructureDefinition-NutritionSection.md) | The Nutrition Section represents diet and nutrition information including special diet requirements and restrictions (e.g., texture modified diet, liquids only, enteral feeding). |
| [Objective Section](StructureDefinition-ObjectiveSection.md) | The Objective Section contains data about the patient gathered through tests, measures, or observations that produce a quantified or categorized result. |
| [Operative Note Fluids Section](StructureDefinition-OperativeNoteFluidsSection.md) | The Operative Note Fluids Section may be used to record fluids administered during the surgical procedure. |
| [Operative Note Surgical Procedure Section](StructureDefinition-OperativeNoteSurgicalProcedureSection.md) | The Operative Note Surgical Procedure Section can be used to restate the procedures performed if appropriate for an enterprise workflow. |
| [Outcomes Section](StructureDefinition-OutcomesSection.md) | This section represents observations regarding the outcome of care from the interventions used to treat the patient. |
| [Past Medical History](StructureDefinition-PastMedicalHistory.md) | This section contains a record of the patient's past complaints, problems, and diagnoses. |
| [Payers Section](StructureDefinition-PayersSection.md) | The Payers Section contains data on the patient's payers, whether "third party" insurance, self-pay, other payer or guarantor, or some combination of payers, and is used to define which entity is the responsible fiduciary for the financial aspects of a patient's care. |
| [Physical Exam Section](StructureDefinition-PhysicalExamSection.md) | The section includes direct observations made by a clinician. |
| [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md) | This section captures planned, pending, active, or completed orders, interventions, encounters, services, and procedures relevant to a patient’s care. |
| [Planned Procedure Section](StructureDefinition-PlannedProcedureSection.md) | This section contains the procedure(s) that a clinician planned based on the preoperative assessment. |
| [Postoperative Diagnosis Section](StructureDefinition-PostoperativeDiagnosisSection.md) | The Postoperative Diagnosis Section records the diagnosis or diagnoses discovered or confirmed during the surgery. |
| [Postprocedure Diagnosis Section](StructureDefinition-PostprocedureDiagnosisSection.md) | The Postprocedure Diagnosis Section records the diagnosis or diagnoses discovered or confirmed during the procedure. |
| [Preoperative Diagnosis Section](StructureDefinition-PreoperativeDiagnosisSection.md) | The Preoperative Diagnosis Section records the surgical diagnoses assigned to the patient before the surgical procedure which are the reason for the surgery. |
| [Problem Section](StructureDefinition-ProblemSection.md) | This section lists and describes all relevant clinical problems at the time the document is generated. |
| [Procedure Description Section](StructureDefinition-ProcedureDescriptionSection.md) | The Procedure Description section records the particulars of the procedure and may include procedure site preparation, surgical site preparation, pertinent details related to sedation/anesthesia, pertinent details related to measurements and markings, procedure times, medications administered, estimated blood loss, specimens removed, implants, instrumentation, sponge counts, tissue manipulation, wound closure, sutures used, vital signs and other monitoring data. |
| [Procedure Disposition Section](StructureDefinition-ProcedureDispositionSection.md) | The Procedure Disposition Section records the status and condition of the patient at the completion of the procedure or surgery. |
| [Procedure Estimated Blood Loss Section](StructureDefinition-ProcedureEstimatedBloodLossSection.md) | The Procedure Estimated Blood Loss Section may be a subsection of another section such as the Procedure Description Section. |
| [Procedure Findings Section](StructureDefinition-ProcedureFindingsSection.md) | The Procedure Findings Section records clinically significant observations confirmed or discovered during a procedure or surgery. |
| [Procedure Implants Section](StructureDefinition-ProcedureImplantsSection.md) | The Procedure Implants Section records any materials placed during the procedure including stents, tubes, and drains. |
| [Procedure Indications Section](StructureDefinition-ProcedureIndicationsSection.md) | This section contains the reason(s) for the procedure or surgery. |
| [Procedure Specimens Taken Section](StructureDefinition-ProcedureSpecimensTakenSection.md) | The Procedure Specimens Taken Section records the tissues, objects, or samples taken from the patient during the procedure including biopsies, aspiration fluid, or other samples sent for pathological analysis. |
| [Procedures Section](StructureDefinition-ProceduresSection.md) | This section describes all historical or current interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient at the time the document is generated. |
| [Reason for Referral Section](StructureDefinition-ReasonforReferralSection.md) | This section describes the clinical reason why a provider is sending a patient to another provider for care. |
| [Reason for Visit Section](StructureDefinition-ReasonforVisitSection.md) | This section records the patient's reason for the patient's visit (as documented by the provider). |
| [Results Section](StructureDefinition-ResultsSection.md) | The Results Section contains observations of results generated by laboratories, imaging procedures, and other procedures. |
| [Review of Systems Section](StructureDefinition-ReviewofSystemsSection.md) | The Review of Systems Section contains a relevant collection of symptoms and functions systematically gathered by a clinician. |
| [Social History Section](StructureDefinition-SocialHistorySection.md) | This section contains social history data that influence a patient's physical, psychological or emotional health (e.g., smoking status, pregnancy). |
| [Subjective Section](StructureDefinition-SubjectiveSection.md) | The Subjective Section describes in a narrative format the patient's current condition and/or interval changes as reported by the patient or by the patient's guardian or another informant. |
| [Surgical Drains Section](StructureDefinition-SurgicalDrainsSection.md) | The Surgical Drains Section may be used to record drains placed during the surgical procedure. |
| [Vital Signs Section](StructureDefinition-VitalSignsSection.md) | The Vital Signs Section contains relevant vital signs for the context and use case of the document type, such as blood pressure (including average blood pressure), heart rate, respiratory rate, height, weight, body mass index, head circumference, pulse oximetry, temperature, and body surface area. |

### Entry Templates 

This chapter describes the clinical statement entry templates used within the sections of the document types of this consolidated guide. Entry templates contain constraints that are required for conformance.

Entry-level templates are always in sections.

Each entry-level template description contains the following information:

* Key template metadata (e.g., template identifier, etc.)
* Description and explanatory narrative.
* Required CDA acts, participants and vocabularies.
* Optional CDA acts, participants and vocabularies. Several entry-level templates require an effectiveTime:

The effectiveTime of an observation is the time interval over which the observation is known to be true. The low and high values should be as precise as possible, but no more precise than known. While CDA has multiple mechanisms to record this time interval (e.g., by low and high values, low and width, high and width, or center point and width), this guide constrains most to use only the low/high form. The low value is the earliest point for which the condition is known to have existed. The high value, when present, indicates the time at which the observation was no longer known to be true. The full description of effectiveTime and time intervals is contained in the CDA R2 normative edition.

Provenance in entry templates:

In this version of Consolidated CDA (C-CDA), we have added a "SHOULD" Author constraint on several entry-level templates. Authorship and Author timestamps must be explicitly asserted in these cases, unless the values propagated from the document header hold true.

ID in entry templates:

Entry-level templates may also describe an id element, which is an identifier for that entry. This id may be referenced within the document, or by the system receiving the document. The id assigned must be globally unique.

| | |
| :--- | :--- |
| [Admission Medication](StructureDefinition-AdmissionMedication.md) | This template represents the medications taken by the patient prior to and at the time of admission. |
| [Advance Directive Observation](StructureDefinition-AdvanceDirectiveObservation.md) | The Advance Directive Observation template is nested within the Advance Directive Existence Observation, which indicates whether the individual has any advance directive documents. |
| [Advance Directive Existence Observation](StructureDefinition-AdvanceDirectiveExistenceObservation.md) | This observation represents a simple observation indicating whether a person has any advance directive documents. |
| [Age Observation](StructureDefinition-AgeObservation.md) | This Age Observation represents the subject's precise age at onset of an event or observation. |
| [Age Range Observation](StructureDefinition-AgeRangeObservation.md) | This Age Range Observation captures an estimated age range when the subject's exact age is unknown. |
| [Allergy - Intolerance Observation](StructureDefinition-AllergyIntoleranceObservation.md) | This template reflects a discrete observation about a patient's allergy or intolerance. |
| [Allergy Concern Act](StructureDefinition-AllergyConcernAct.md) | This template reflects an ongoing concern on behalf of the provider that placed the allergy on a patient's allergy list. |
| [Allergy Status Observation](StructureDefinition-AllergyStatusObservation.md) | This template represents the clinical status attributed to the allergy or intolerance. |
| [Assessment Scale Observation](StructureDefinition-AssessmentScaleObservation.md) | An assessment scale is a collection of observations that together can yield a calculated or non-calculated summary evaluation of a one or more conditions. |
| [Assessment Scale Supporting Observation](StructureDefinition-AssessmentScaleSupportingObservation.md) | An Assessment Scale Supporting Observation represents the components of a scale used in an Assessment Scale Observation. |
| [Authorization Activity](StructureDefinition-AuthorizationActivity.md) | An Authorization Activity represents authorizations or pre-authorizations currently active for the patient for the particular payer. |
| [Average Blood Pressure Organizer](StructureDefinition-AverageBloodPressureOrganizer.md) | This template represents a single instance of an Average Blood Pressure reading. |
| [Basic Industry Observation](StructureDefinition-BasicIndustryObservation.md) | This template represents a simple observation about the type of business that compensates for work or assigns work to an unpaid worker or volunteer (e.g., US Army, cement manufacturing, children and youth services). |
| [Basic Occupation Observation](StructureDefinition-BasicOccupationObservation.md) | This template represents a simple observation about the type of work (e.g., infantry, business analyst, social worker) of a person. |
| [Birth Sex Observation](StructureDefinition-BirthSexObservation.md) | This observation represents the sex of the patient at birth. |
| [Brand Name Observation](StructureDefinition-BrandNameObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Brand Name. |
| [Care Experience Preference](StructureDefinition-CareExperiencePreference.md) | This Care Experience Preference template represents a person's care preferences for their care and treatment. |
| [Care Plan Act](StructureDefinition-CarePlanAct.md) | The Care Plan Act represents a snapshot in time of a dynamic, consensus-driven plan that has captured a patient's and care team members' prioritized concerns, goals, and planned interventions. |
| [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md) | This template is used to represent a member of the care team. |
| [Care Team Member Schedule Observation](StructureDefinition-CareTeamMemberScheduleObservation.md) | This template represents the schedule of when the care team member participates on the care team. |
| [Care Team Organizer](StructureDefinition-CareTeamOrganizer.md) | This organizer template contains information about a single care team. |
| [Care Team Type Observation](StructureDefinition-CareTeamTypeObservation.md) | This template is used to express the care team type. |
| [Caregiver Characteristics](StructureDefinition-CaregiverCharacteristics.md) | This clinical statement represents a caregiver's willingness to provide care and the abilities of that caregiver to provide assistance to a patient in relation to a specific need. |
| [Catalog Number Observation](StructureDefinition-CatalogNumberObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Catalog Number. |
| [Characteristics of Home Environment](StructureDefinition-CharacteristicsofHomeEnvironment.md) | This template represents the patient's home environment including, but not limited to, type of residence (trailer, single family home, assisted living), living arrangement (e.g., alone, with parents), and housing status (e.g., evicted, homeless, home owner). |
| [Comment Activity](StructureDefinition-CommentActivity.md) | Comments are free text data that cannot otherwise be recorded using data elements already defined by this specification. |
| [Company Name Observation](StructureDefinition-CompanyNameObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Company Name. |
| [Coverage Activity](StructureDefinition-CoverageActivity.md) | A Coverage Activity groups the policy and authorization acts within a Payers Section to order the payment sources. |
| [Criticality Observation](StructureDefinition-CriticalityObservation.md) | This observation represents the gravity of the potential risk for future life-threatening adverse reactions when exposed to a substance known to cause an adverse reaction in that individual. |
| [Cultural and Religious Observation](StructureDefinition-CulturalandReligiousObservation.md) | This template represents a patient's spiritual, religious, and cultural belief practices, such as a kosher diet or fasting ritual. |
| [Date of Diagnosis Act](StructureDefinition-DateOfDiagnosisAct.md) | This template represents the earliest date of diagnosis, which is the date of first determination by a qualified professional of the presence of a problem or condition affecting a patient. |
| [Deceased Observation](StructureDefinition-DeceasedObservation.md) | This template represents the observation that a patient has died. |
| [Device Identifier Observation](StructureDefinition-DeviceIdentifierObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Device Identifier (also known as the "Primary DI Number") for a medical device marketed in the US. |
| [Disability Status Observation](StructureDefinition-DisabilityStatusObservation.md) | This template represents an assessment of patients perception of their physical, cognitive, intellectual, or psychiatric disabilities. |
| [Discharge Medication](StructureDefinition-DischargeMedication.md) | This template represents medications that the patient is intended to take (or stop) after discharge. |
| [Distinct Identification Code Observation](StructureDefinition-DistinctIdentificationCodeObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Distinct Identification Code for an HCT/P product regulated as a device as cited in 21 CFR 1271.290(c). |
| [Drug Monitoring Act](StructureDefinition-DrugMonitoringAct.md) | This template represents the act of monitoring the patient's medication and includes a participation to record the person responsible for monitoring the medication. |
| [Drug Vehicle](StructureDefinition-DrugVehicle.md) | This template represents the vehicle (e.g., saline, dextrose) for administering a medication. |
| [Encounter Activity](StructureDefinition-EncounterActivity.md) | This clinical statement describes an interaction between a patient and clinician. |
| [Encounter Diagnosis](StructureDefinition-EncounterDiagnosis.md) | This template wraps relevant problems or diagnoses at the close of a visit or that need to be followed after the visit. |
| [Entry Reference](StructureDefinition-EntryReference.md) | This template represents the act of referencing another entry in the same CDA document instance. |
| [Estimated Date of Delivery](StructureDefinition-EstimatedDateofDelivery.md) | This clinical statement represents the anticipated date when a woman will give birth. |
| [Expiration Date Observation](StructureDefinition-ExpirationDateObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Expiration Date of the device. |
| [External Document Reference](StructureDefinition-ExternalDocumentReference.md) | Where it is necessary to reference an external clinical document, the External Document Reference template can be used to reference this external document. |
| [Family History Death Observation](StructureDefinition-FamilyHistoryDeathObservation.md) | This clinical statement records whether the family member is deceased. |
| [Family History Observation](StructureDefinition-FamilyHistoryObservation.md) | Family History Observations related to a particular family member are contained within a Family History Organizer. |
| [Family History Organizer](StructureDefinition-FamilyHistoryOrganizer.md) | The Family History Organizer associates a set of observations with a family member. |
| [Functional Status Observation](StructureDefinition-FunctionalStatusObservation.md) | This template represents the patient's physical function (e.g., mobility status, instrumental activities of daily living, self-care status) and problems that limit function (dyspnea, dysphagia). |
| [Functional Status Organizer](StructureDefinition-FunctionalStatusOrganizer.md) | This template groups related functional status observations into categories (e.g., mobility, self-care). |
| [Gender Identity Observation](StructureDefinition-GenderIdentityObservation.md) | This observation represents the gender identity of the patient. |
| [Goal Observation](StructureDefinition-GoalObservation.md) | This template represents a patient health goal. |
| [Handoff Communication Participants](StructureDefinition-HandoffCommunicationParticipants.md) | This template represents the sender (author) and receivers (participants) of a handoff communication in a plan of treatment. |
| [Health Concern Act](StructureDefinition-HealthConcernAct.md) | This template represents a health concern. |
| [Health Status Observation](StructureDefinition-HealthStatusObservation.md) | This template represents information about the overall health status of the patient. |
| [Highest Pressure Ulcer Stage](StructureDefinition-HighestPressureUlcerStage.md) | This observation contains a description of the wound tissue of the most severe or highest staged pressure ulcer observed on a patient. |
| [Hospital Admission Diagnosis](StructureDefinition-HospitalAdmissionDiagnosis.md) | This template represents problems or diagnoses identified by the clinician at the time of the patient's admission. |
| [Hospital Discharge Diagnosis](StructureDefinition-HospitalDischargeDiagnosis.md) | This template represents problems or diagnoses present at the time of discharge which occurred during the hospitalization or need to be monitored after hospitalization. |
| [Immunization Activity](StructureDefinition-ImmunizationActivity.md) | An Immunization Activity describes immunization substance administrations that have actually occurred or are intended to occur. |
| [Immunization Medication Information](StructureDefinition-ImmunizationMedicationInformation.md) | The Immunization Medication Information represents product information about the immunization substance. |
| [Immunization Not Given Reason](StructureDefinition-ImmunizationNotGivenReason.md) | The Immunization Not Given Reason documents the rationale for the patient declining an immunization. |
| [Implantable Device Status Observation](StructureDefinition-ImplantableDeviceStatusObservation.md) | This template is intended to be used in addition to the Product Instance template to augment the parsed data from the a Unique Device Identifier (UDI). |
| [Indication](StructureDefinition-Indication.md) | This template represents the rationale for an action such as an encounter, a medication administration, or a procedure. |
| [Individual Pronoun Observation](StructureDefinition-IndividualPronounObservation.md) | The Individual Personal Pronoun Observation represents words specified by a person to replace their name when referring to them in speech, clinical notes, and written instructions. |
| [Instruction Observation](StructureDefinition-InstructionObservation.md) | The Instruction observation template can be used in several ways, such as to record patient instructions within a Medication Activity or to record fill instructions within a supply order. |
| [Interpreter Needed Observation](StructureDefinition-InterpreterNeededObservation.md) | The interpreter needed observation represents an indication of whether a person needs language interpretation services. |
| [Intervention Act](StructureDefinition-InterventionAct.md) | This template represents an Intervention Act. |
| [Latex Safety Observation](StructureDefinition-LatexSafetyObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Latex Safety Status of the patient's medical device. |
| [Longitudinal Care Wound Observation](StructureDefinition-LongitudinalCareWoundObservation.md) | This template represents acquired or surgical wounds and is not intended to encompass all wound types. |
| [Lot or Batch Number Observation](StructureDefinition-LotOrBatchNumberObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Lot or Batch Number of the device. |
| [Manufacturing Date Observation](StructureDefinition-ManufacturingDateObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Manufacturing Date of the device. |
| [Medical Equipment Organizer](StructureDefinition-MedicalEquipmentOrganizer.md) | This template represents a set of current or historical medical devices, supplies, aids and equipment used by the patient. |
| [Medication Activity](StructureDefinition-MedicationActivity.md) | A Medication Activity describes substance administrations that have actually occurred (e.g., pills ingested or injections given) or are intended to occur (e.g., "take 2 tablets twice a day for the next 10 days"). |
| [Medication Adherence](StructureDefinition-MedicationAdherence.md) | This profile represents whether a medication has been consumed according to instructions. |
| [Medication Dispense](StructureDefinition-MedicationDispense.md) | This template records the act of supplying medications (i.e., dispensing). |
| [Medication Free Text Sig](StructureDefinition-MedicationFreeTextSig.md) | The template is available to explicitly identify the free text Sig within each medication. |
| [Medication Information](StructureDefinition-MedicationInformation.md) | A medication should be recorded as a pre-coordinated ingredient + strength + dose form (e.g., "metoprolol 25mg tablet", "amoxicillin 400mg/5mL suspension") where possible. |
| [Medication Supply Order](StructureDefinition-MedicationSupplyOrder.md) | This template records the intent to supply a patient with medications. |
| [Mental Status Observation](StructureDefinition-MentalStatusObservation.md) | The Mental Status Observation template represents an observation about mental status that can come from a broad range of subjective and objective information (including measured data) to address those categories described in the Mental Status Section. |
| [Mental Status Organizer](StructureDefinition-MentalStatusOrganizer.md) | The Mental Status Organizer template may be used to group related Mental Status Observations (e.g., results of mental tests) and associated Assessment Scale Observations into subcategories and/or groupings by time. |
| [Model Number Observation](StructureDefinition-ModelNumberObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Model Number associated with the device. |
| [MRI Safety Observation](StructureDefinition-MRISafetyObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the MRI Safety Status of the patient's medical device. |
| [Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.md) | This template represents equipment supplied to the patient (e.g., pumps, inhalers, wheelchairs). |
| [Note Activity](StructureDefinition-NoteActivity.md) | The Note Activity represents a clinical note. |
| [Number of Pressure Ulcers Observation](StructureDefinition-NumberofPressureUlcersObservation.md) | This template represents the number of pressure ulcers observed at a particular stage. |
| [Nutrition Assessment](StructureDefinition-NutritionAssessment.md) | This template represents the patient's nutrition abilities and habits including intake, diet requirements or diet followed. |
| [Nutrition Recommendation](StructureDefinition-NutritionRecommendation.md) | This template represents nutrition regimens (e.g., fluid restrictions, calorie minimum), interventions (e.g., NPO, nutritional supplements), and procedures (e.g., G-Tube by bolus, TPN by central line). |
| [Nutritional Status Observation](StructureDefinition-NutritionalStatusObservation.md) | This template describes the overall nutritional status of the patient including findings related to nutritional status. |
| [Outcome Observation](StructureDefinition-OutcomeObservation.md) | This template represents the outcome of care resulting from the interventions used to treat the patient. |
| [Planned Coverage](StructureDefinition-PlannedCoverage.md) | This template represents the insurance coverage intended to cover an act or procedure. |
| [Planned Encounter](StructureDefinition-PlannedEncounter.md) | This template represents a planned or ordered encounter. |
| [Planned Immunization Activity](StructureDefinition-PlannedImmunizationActivity.md) | This template represents planned immunizations. |
| [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md) | This template represents a Planned Intervention Act. |
| [Planned Medication Activity](StructureDefinition-PlannedMedicationActivity.md) | This template represents planned medication activities. |
| [Planned Procedure](StructureDefinition-PlannedProcedure.md) | This template is used to represent ordered procedures for a patient. |
| [Planned Supply](StructureDefinition-PlannedSupply.md) | This template represents both medicinal and non-medicinal supplies ordered, requested, or intended for the patient (e.g., medication prescription, order for wheelchair). |
| [Policy Activity](StructureDefinition-PolicyActivity.md) | A policy activity represents the policy or program providing the coverage. |
| [Postprocedure Diagnosis](StructureDefinition-PostprocedureDiagnosis.md) | This template represents the diagnosis or diagnoses discovered or confirmed during the procedure. |
| [Precondition for Substance Administration](StructureDefinition-PreconditionforSubstanceAdministration.md) | A criterion for administration can be used to record that the medication is to be administered only when the associated criteria are met. |
| [Pregnancy Intention in Next Year](StructureDefinition-PregnancyIntentionInNextYear.md) | This template represents a patient's reported intention or desire in the next year to either become pregnant or prevent a future pregnancy. |
| [Pregnancy Status Observation](StructureDefinition-PregnancyStatusObservation.md) | This clinical statement meets the requirements of the US Core Data for Interoperability (USCDI) Pregnancy Status Data Element. |
| [Preoperative Diagnosis](StructureDefinition-PreoperativeDiagnosis.md) | This template represents the surgical diagnosis or diagnoses assigned to the patient before the surgical procedure and is the reason for the surgery. |
| [Priority Preference](StructureDefinition-PriorityPreference.md) | This template represents priority preferences chosen by a patient or a care provider. |
| [Problem Concern Act](StructureDefinition-ProblemConcernAct.md) | This template reflects an ongoing concern on behalf of the provider that placed the concern on a patient's problem list. |
| [Problem Observation](StructureDefinition-ProblemObservation.md) | This template reflects a discrete observation about a patient's problem. |
| [Problem Status](StructureDefinition-ProblemStatus.md) | The Problem Status records the clinical status attributed to the problem. |
| [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md) | This template is used to represent the details of current and historical procedures performed on or for a patient. |
| [Product Instance](StructureDefinition-ProductInstance.md) | This clinical statement represents a particular device that was placed in a patient or used as part of a procedure or other act. |
| [Prognosis Observation](StructureDefinition-PrognosisObservation.md) | This template represents the patient's prognosis, which must be associated with a problem observation. |
| [Progress Toward Goal Observation](StructureDefinition-ProgressTowardGoalObservation.md) | This template represents a patient's progress toward a goal. |
| [Reaction Observation](StructureDefinition-ReactionObservation.md) | This clinical statement represents the response to an undesired symptom, finding, etc. |
| [Reason](StructureDefinition-Reason.md) | This template describes the thought process or justification for an action or for not performing an action. |
| [Referral Act](StructureDefinition-ReferralAct.md) | This template represents the type of referral (e.g., for dental care, to a specialist, for aging problems) and represents whether the referral is for full care or shared care. |
| [Result Observation](StructureDefinition-ResultObservation.md) | This template represents the results of a laboratory, radiology, or other study performed on a patient. |
| [Result Organizer](StructureDefinition-ResultOrganizer.md) | This template provides a mechanism for grouping result observations. |
| [Risk Concern Act](StructureDefinition-RiskConcernAct.md) | This template represents a risk concern. |
| [Section Time Range Observation](StructureDefinition-SectionTimeRangeObservation.md) | This observation represents the date and time range of the information contained in a section. |
| [Self-Care Activities (ADL and IADL)](StructureDefinition-SelfCareActivitiesADLandIADL.md) | This template represents a patient's daily self-care ability. |
| [Sensory Status](StructureDefinition-SensoryStatus.md) | This template represents a patient's sensory or speech ability. |
| [Serial Number Observation](StructureDefinition-SerialNumberObservation.md) | This template is intended to be used in addition to the Product Instance template to exchange the Serial Number of the device. |
| [Service Delivery Location](StructureDefinition-ServiceDeliveryLocation.md) | This clinical statement represents the physical place of available services or resources. |
| [Severity Observation](StructureDefinition-SeverityObservation.md) | This clinical statement represents the gravity of the problem, such as allergy or reaction, in terms of its actual or potential impact on the patient. |
| [Sex Observation](StructureDefinition-SexObservation.md) | USCDI includes a data element for Sex, intended to support the exchange of a recorded sex value. |
| [Sex Parameter For Clinical Use Observation](StructureDefinition-SexParameterForClinicalUseObservation.md) | The Sex Parameter for Clinical Use (SPCU) observation is a clinical classification indicating which sex-related information is needed to evaluate how a patient's body may respond or has responded to treatments or diagnostic tests. |
| [Sexual Orientation Observation](StructureDefinition-SexualOrientationObservation.md) | This observation represents the sexual orientation of the patient. |
| [Smoking Status](StructureDefinition-SmokingStatus.md) | This template represents a patient's smoking status. |
| [Social History Observation](StructureDefinition-SocialHistoryObservation.md) | This template represents a patient's job (occupation and industry), lifestyle, and environmental health risk factors. |
| [Specimen Collection Procedure](StructureDefinition-SpecimenCollectionProcedure.md) | This template represents clinical information about the specimen including when it was collected, the type and source of specimen, as well as related observations regarding the specimen. |
| [Specimen Condition Observation](StructureDefinition-SpecimenConditionObservation.md) | This template captures the condition or state of the specimen as identified by the laboratory upon receipt or during processing—such as hemolysis, clotting, or contamination. |
| [Substance Administered Act](StructureDefinition-SubstanceAdministeredAct.md) | This template represents the administration course in a series. |
| [Substance or Device Allergy - Intolerance Observation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md) | This template reflects a discrete observation about a patient's allergy or intolerance to a substance or device. |
| [Treatment Intervention Preference](StructureDefinition-TreatmentInterventionPreference.md) | This Treatment Intervention Preference template represents personal health goals, preferences, and priorities for medical treatments or interventions in the event of a future health scenario where a person is unable to make medical decisions because of a serious illness or injury. |
| [Tribal Affiliation Observation](StructureDefinition-TribalAffiliationObservation.md) | This template represents the tribe or band that an individual associates with, within the United States. |
| [UDI Organizer](StructureDefinition-UDIOrganizer.md) | This template is nested within an entryRelationship of either a[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)or a[Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.md). |
| [Vital Sign Observation](StructureDefinition-VitalSignObservation.md) | This template represents measurement of common vital signs. |
| [Vital Signs Organizer](StructureDefinition-VitalSignsOrganizer.md) | This template provides a mechanism for grouping vital signs (e.g., grouping systolic blood pressure and diastolic blood pressure). |
| [Wound Characteristic](StructureDefinition-WoundCharacteristic.md) | This template represents characteristics of a wound (e.g., integrity of suture line, odor, erythema). |
| [Wound Measurement Observation](StructureDefinition-WoundMeasurementObservation.md) | This template represents the Wound Measurement Observations of wound width, depth and length. |

### Participation & Other Templates 

The participation and other templates chapter contains templates for CDA participations (e.g., author, performer), and other fielded items (e.g., address, name) that cannot stand on their own without being nested in another template.

| | |
| :--- | :--- |
| [Author Participation](StructureDefinition-AuthorParticipation.md) | This template represents the Author Participation (including the author timestamp). |
| [Provenance - Assembler Participation](StructureDefinition-ProvenanceAssemblerParticipation.md) | This template represents the organization that supported generation of a CDA document. |
| [Provenance - Author Participation](StructureDefinition-ProvenanceAuthorParticipation.md) | This template represents the key information to record Provenance in an Author Participation. |
| [Related Person Relationship and Name Participant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md) | This template represents a generic participant person that has a relationship to the patient. |
| [US Realm Address](StructureDefinition-USRealmAddress.md) | Reusable address template, for use in US Realm documents. |
| [US Realm Date and Time - Interval](StructureDefinition-USRealmDateTimeInterval.md) | The US Realm Clinical Document Date and Time datatype flavor records date and time information. |
| [US Realm Date and Time - Point in Time](StructureDefinition-USRealmDateTime.md) | The US Realm Clinical Document Date and Time datatype flavor records date and time information. |
| [US Realm Patient Name (PTN.US.FIELDED)](StructureDefinition-USRealmPatientNamePTNUSFIELDED.md) | The US Realm Patient Name datatype flavor is a set of reusable constraints that can be used for the patient or any other person. |
| [US Realm Person Name (PN.US.FIELDED)](StructureDefinition-USRealmPersonNamePNUSFIELDED.md) | The US Realm Clinical Document Person Name datatype flavor is a set of reusable constraints that can be used for Persons. |

### Deprecated Templates 

Deprecated templates are not prohibited from use, but their status as deprecated is a signal to implementers that the template may be permanently retired (terminated) in the future.

| | |
| :--- | :--- |
| [Advance Directive Organizer](StructureDefinition-AdvanceDirectiveOrganizer.md) | The Advance Directive Organizer includes information about who verified the content available in each advance healthcare directive source document or other verified source documentation. |
| [Instruction Activity](StructureDefinition-InstructionActivity.md) | The Instruction template is used to record instructions intended to be given to the patient. |
| [Smoking Status - Meaningful Use](StructureDefinition-SmokingStatusMeaningfulUse.md) | This template represents the current smoking status of the patient as specified in Meaningful Use (MU) Stage 2 requirements. |
| [Tobacco Use](StructureDefinition-TobaccoUse.md) | This template represents a patient's tobacco use. |

### C-CDA Template Examples 

These examples show how the C-CDA logical model templates are constructed.

| | |
| :--- | :--- |
| [Example of Allergy Intolerance to Food Egg](Binary-allergy-to-food-egg.md) | Example of an allergy to egg |
| [Admission Diagnosis Section Example](Binary-admission-diagnosis-section-example.md) | Admission Diagnosis Section example |
| [Admission Medication example](Binary-admission-medication-example.md) | Admission Medication example |
| [Advance Directive Existence Observation Example](Binary-advance-directive-existence-observation-example.md) | Advance Directive Existence Observation example |
| [Advance Directive Observation Example](Binary-advance-directive-observation-example.md) | Advance Directive Observation example |
| [Advance Directives Section Example](Binary-advance-directives-section-example.md) | Advance Directives Section example |
| [Age Observation Example](Binary-age-observation-example.md) | Age Observation example |
| [Allergies and Intolerances Section Example](Binary-allergies-and-intolerances-section-example.md) | Allergies and Intolerances Section example |
| [Allergy Concern Act Example](Binary-allergy-concern-act-example.md) | Allergy Concern Act example |
| [Allergy Intolerance Observation Medication Example](Binary-allergy-intolerance-observation-medication-example.md) | Allergy Intolerance Observation Medication example |
| [Allergy Intolerance Observation Drug Class Example](Binary-allergy-intolerance-observation-drugclass-example.md) | Allergy Intolerance Observation Drug Class example |
| [Allergy Intolerance Observation Non-Medication Example](Binary-allergy-intolerance-observation-nonmedication-example.md) | Allergy Intolerance Observation Non-Medication example |
| [Anesthesia Section Example](Binary-anesthesia-section-example.md) | Anesthesia Section example |
| [Assessment and Plan Section Example](Binary-assessment-and-plan-section-example.md) | Assessment and Plan Section example |
| [Assessment Scale Observation Example](Binary-assessment-scale-observation-example.md) | Assessment Scale Observation example |
| [Assessment Scale Supporting Observation Example](Binary-assessment-scale-supporting-observation-example.md) | Assessment Scale Supporting Observation example |
| [Assessment Section Example](Binary-assessment-section-example.md) | Assessment Section example |
| [Author Participation Example](Binary-new-author-participant-example.md) | Author Participation example |
| [Authorization Activity Example](Binary-authorization-activity-example.md) | Authorization Activity example |
| [Basic Industry Observation Example](Binary-basic-industry-observation-example.md) | Basic Industry Observation example |
| [Basic Occupation Observation Example](Binary-basic-occupation-observation-example.md) | Basic Occupation example |
| [Birth Sex Observation Example](Binary-birth-sex-example.md) | Birth Sex Observation example |
| [Birth Sex Observation Example with Null Flavor](Binary-birth-sex-example-nullflavor.md) | Birth Sex Observation example with Null Flavor |
| [Brand Name Observation Example](Binary-brand-name-observation-example.md) | Brand Name Observation example |
| [Care Plan Caregiver participant Example](Binary-care-plan-caregiver-participant-example.md) | Care Plan Caregiver participant example |
| [Care Plan Patient authenticator Example](Binary-care-plan-patient-authenticator-example.md) | Care Plan Patient authenticator example |
| [Care Plan performer Example](Binary-care-plan-performer-example.md) | Care Plan performer example |
| [Care Plan relatedDocument Example](Binary-care-plan-relateddocument-example.md) | Care Plan relatedDocument example |
| [Care Plan Review Example](Binary-care-plan-review-example.md) | Care Plan Review example |
| [Care Plan Complete Header Example](Binary-care-plan-complete-example.md) | Demonstrates most of the Care Plan header requirements. Body sections are empty with nullFlavors. |
| [Care Team Member Act Example](Binary-care-team-member-act-example.md) | Care Team Member Act example |
| [Care Team Member Schedule Observation Example](Binary-care-team-member-schedule-observation-example.md) | Care Team Member Schedule Observation example |
| [Care Team Organizer Example](Binary-care-team-organizer-example.md) | Care Team Organizer example |
| [Care Teams Section Example](Binary-care-teams-section-example.md) | Care Teams Section example |
| [Care Team Type Observation Example](Binary-care-team-type-example.md) | Care Team Type Observation example |
| [Catalog Number Observation Example](Binary-catalog-number-observation-example.md) | Catalog Number Observation example |
| [Caregiver Characteristics Example](Binary-caregiver-characteristics-example.md) | Caregiver Characteristics example |
| [Characteristics of Home Environment Example](Binary-characteristics-of-home-environment-example.md) | Characteristics of Home Environment example |
| [Chief Complaint and Reason for Visit Section Example](Binary-chief-complaint-and-reason-for-visit-section-example.md) | Chief Complaint and Reason for Visit Section example |
| [Chief Complaint Section Example](Binary-chief-complaint-section-example.md) | Chief Complaint Section example |
| [Comment Activity Example](Binary-comment-activity-example.md) | Comment Activity example |
| [Company Name Observation Example](Binary-company-name-example.md) | Company Name Observation example |
| [Complications Section Example](Binary-complications-section-example.md) | Complications Section example |
| [Continuity Of Care Document Complete Header Example](Binary-ccd-header-example.md) | Demonstrates a fully-valid (but empty) CCD. Nullflavors have been added to all required sections. |
| [Continuity Of Care Document Author Example](Binary-ccd-author-example.md) | Continuity Of Care Document Author example |
| [Continuity Of Care Document Performer](Binary-ccd-performer-example.md) | Continuity Of Care Document Performer example |
| [Continuity Of Care Document serviceEvent Example](Binary-ccd-serviceevent-example.md) | Continuity Of Care Document serviceEvent example |
| [Consultation Note Complete Header Example](Binary-consultation-note-complete-example.md) | Demonstrates most of the Consultation Note header requirements. Body sections are empty with nullFlavors. |
| [Consultation Note Callback participant Example](Binary-consultation-note-callback-participant-example.md) | Consultation Note Callback participant example |
| [Consultation Note inFulfillmentOf Example](Binary-consultation-note-infulfillmentof-example.md) | Consultation Note inFulfillmentOf example |
| [Course of Care Section Example](Binary-course-of-care-section-example.md) | Course of Care Section example |
| [Coverage Activity Example](Binary-coverage-activity-example.md) | Coverage Activity example |
| [Criticality Observation Example](Binary-criticality-observation-example.md) | Criticality Observation example |
| [Cultural and Religious Observation Example](Binary-cultural-and-religious-observation-example.md) | Cultural and Religious Observation example |
| [Date of Diagnosis Act Example](Binary-date-of-diagnosis-act-example.md) | Date of Diagnosis Act example |
| [Deceased Observation Example](Binary-deceased-observation-example.md) | Deceased Observation example |
| [Device Identifier Observation Example](Binary-device-identifier-observation-example.md) | Device Identifier Observation example |
| [Diagnosis Reference Example](Binary-diagnosis-reference-example.md) | Diagnosis Reference example |
| [Disability Status Observation Example](Binary-disability-status-observation-example.md) | Disability Status Observation Example |
| [Discharge Diagnosis Example](Binary-discharge-diagnosis-section-example.md) | Discharge Diagnosis example |
| [Discharge Medication Example](Binary-discharge-medication-example.md) | Discharge Medication example |
| [Discharge Medications Section Example](Binary-discharge-medications-section-example.md) | Discharge Medications Section example |
| [Discharge Summary Complete Header Example](Binary-discharge-summary-header-example.md) | Demonstrates a fully-valid Discharge Summary. Nullflavors have been added to all required sections. |
| [Discharge Summary encompassingEncounter Example](Binary-discharge-summary-encompassingencounter-example.md) | Discharge Summary (encompassingEncounter) example |
| [Distinct Identification Code Observation Example](Binary-distinct-identification-code-observation-example.md) | Distinct Identification Code Observation example |
| [Drug Monitoring Act Example](Binary-drug-monitoring-act-example.md) | Drug Monitoring Act example |
| [Drug Vehicle Example](Binary-drug-vehicle-example.md) | Drug Vehicle example |
| [Encounter Activity Example](Binary-encounter-activity-example.md) | Encounter Activity example |
| [Encounter Diagnosis Example](Binary-encounter-diagnosis-example.md) | Encounter Diagnosis example |
| [Encounters Section Example](Binary-encounters-section-example.md) | Encounters Section example |
| [Entry Reference Example](Binary-entry-reference-example.md) | Entry Reference example |
| [Estimated Date of Delivery Example](Binary-estimated-date-of-delivery-example.md) | Estimated Date of Delivery example |
| [Expiration Date Observation Example](Binary-expiration-date-observation-example.md) | example |
| [External Document Reference Example](Binary-external-document-reference-example.md) | External Document Reference example |
| [Family History Death Observation Example](Binary-family-history-death-observation-example.md) | Family History Death Observation example |
| [Family History Observation Example](Binary-family-history-observation-example.md) | Family History Observation example |
| [Family History Organizer Example](Binary-family-history-organizer-example.md) | Family History Organizer example |
| [Family History Section Example](Binary-family-history-section-example.md) | Family History Section example |
| [Functional Status Observation Example](Binary-functional-status-observation-example.md) | Functional Status Observation example |
| [Functional Status Organizer Example](Binary-functional-status-organizer-example.md) | Functional Status Organizer example |
| [Functional Status Section Example](Binary-functional-status-section-example.md) | Functional Status Section example |
| [Gender Identity Observation Example](Binary-gender-identity-observation-example.md) | Gender Identity Observation example |
| [Gender Identity Observation NullFlavor Example](Binary-gender-identity-observation-nullflavor-example.md) | Gender Identity Observation example with null flavor |
| [General Status Section Example](Binary-general-status-section-example.md) | General Status Section example |
| [Goal Observation Example](Binary-goal-observation-example.md) | Goal Observation example |
| [Goals Section Example](Binary-goals-section-example.md) | Goals Section example |
| [Handoff Communication Participants Example](Binary-handoff-communication-example.md) | Handoff Communication Participants example |
| [Health Concern Act Example](Binary-health-concern-act-example.md) | Health Concern Act example |
| [Health Concerns Section Example](Binary-health-concerns-section-example.md) | Health Concerns Section example |
| [Outcomes Section Example](Binary-outcomes-section-example.md) | Outcomes Section example |
| [Health Status Observation Example](Binary-health-status-observation-example.md) | Health Status Observation example |
| [Highest Pressure Ulcer Stage Example](Binary-highest-pressure-ulcer-stage-example.md) | Highest Pressure Ulcer Stage example |
| [History and Physical Encompassing Encounter Example](Binary-handp-encompassingencounter-example.md) | History and Physical Encompassing Encounter example |
| [History and Physical Complete Header Example](Binary-history-and-physical-header-example.md) | Demonstrates most of the History and Physical header requirements. Body sections are empty with nullFlavors. |
| [History Of Present Illness Example](Binary-history-of-present-illness-section-example.md) | History of Present Illness example |
| [Hospital Admission Diagnosis Example](Binary-hospital-admission-diagnosis-example.md) | Hospital Admission Diagnosis example |
| [Hospital Consultations Section Example](Binary-hospital-consultations-section-example.md) | Hospital Consultations Section example |
| [Hospital Course Section Example](Binary-hospital-course-section-example.md) | Hospital Course Section example |
| [Hospital Discharge Diagnosis Example](Binary-hospital-discharge-diagnosis-example.md) | Hospital Discharge Diagnosis example |
| [Hospital Discharge Instructions Section Example](Binary-hospital-discharge-instructions-section-example.md) | Hospital Discharge Instructions Section example |
| [Hospital Discharge Physical Section Example](Binary-hospital-discharge-physical-section-example.md) | Hospital Discharge Physical Section example |
| [Hospital Discharge Studies Summary Section Example](Binary-hospital-discharge-studies-summary-section-example.md) | Hospital Discharge Studies Summary Section example |
| [Immunization Activity Example](Binary-immunization-activity-example.md) | Immunization Activity example |
| [Immunization Medication Information Example](Binary-immunization-medication-information-example.md) | Immunization Medication Information example |
| [Immunization Not Given Reason Example](Binary-immunization-notgiven-reason-example.md) | Immunization Not Given Reason example |
| [Immunizations Section Example](Binary-immunizations-section-example.md) | Immunizations Section example |
| [Implantable Device Status Observation Example](Binary-implantable-device-status-observation-example.md) | Implantable Device Status Observation example |
| [Indication Example](Binary-indication-example.md) | Indication example |
| [Instructions Section Example](Binary-instructions-section-example.md) | Instructions Section example |
| [Instruction Example](Binary-instruction-example.md) | Instruction example |
| [Intervention Act Example](Binary-intervention-act-moodcodeint-example.md) | Intervention Act example |
| [Latex Safety Observation Example](Binary-latex-safety-observation-example.md) | Latex Safety Observation example |
| [Longitudinal Care Wound Observation Example](Binary-longitudinal-care-wound-observation-example.md) | Longitudinal Care Wound Observation example |
| [Lot or Batch Number Observation Example](Binary-lot-or-batch-number-observation-example.md) | Lot or Batch Number Observation example |
| [Manufacturing Date Observation Example](Binary-manufacturing-date-observation-example.md) | Manufacturing Date Observation example |
| [Medical Equipment Organizer Example](Binary-medical-equipment-organizer-example.md) | Medical Equipment Organizer example |
| [Medical Equipment Section Example](Binary-medical-equipment-section-example.md) | Medical Equipment Section example |
| [Medication Activity Example](Binary-medication-activity-example.md) | Medication Activity example |
| [Medication Adherence Example](Binary-medication-adherence-example.md) | Medication Adherence example |
| [Medication Adherence NullFlavor Example](Binary-medication-adherence-nullflavor-example.md) | Medication Adherence example with null flavor |
| [Medication Dispense Example](Binary-medication-dispense-example.md) | Medication Dispense example |
| [Medication Free Text Sig Example](Binary-medication-free-text-sig-example.md) | Medication Free Text Sig example |
| [Medication Information Example](Binary-medication-information-example.md) | Medication Information example |
| [Medication Supply Order Example](Binary-medication-supply-order-example.md) | Medication Supply Order example |
| [Medications Administered Section Example](Binary-medications-administered-section-example.md) | Medications Administered Section example |
| [Medications Section Example](Binary-medications-section-example.md) | Medications Section example |
| [Mental Status Observation Example](Binary-mental-status-observation-example.md) | Mental Status Observation example |
| [Mental Status Organizer Example](Binary-mental-status-organizer-example.md) | Mental Status Organizer example |
| [Mental Status Section Example](Binary-mental-status-section-example.md) | Mental Status Section example |
| [Model Number Observation Example](Binary-model-number-observation-example.md) | Model Number Observation example |
| [MRI Safety Observation Example](Binary-mri-safety-observation-example.md) | MRI Safety Observation example |
| [No Known Medications Example](Binary-no-known-medications-example.md) | No Known Medications example |
| [No Known Problem Section Example](Binary-no-known-problems-section-example.md) | No Known Problem Section example |
| [Non-Medicinal Supply Activity Example](Binary-non-medicinal-supply-activity-example.md) | Non-Medicinal Supply Activity example |
| [Note Activity Entry Relationship Example](Binary-note-activity-as-entryrelationship-to-ccda-entry-example.md) | Note Activity example |
| [Note Activity Standalone Example](Binary-note-activity-as-standalone-entry-example.md) | Note Activity example |
| [nonXML Body Example with Compressed Content](Binary-nonxmlbody-example-with-compressed-content.md) | nonXMLBody Example with Compressed Content |
| [nonXML Body Example with Embedded Content](Binary-nonxmlbody-example-with-embedded-content.md) | nonXMLBody Example with Embedded Content |
| [nonXML Body Example with Referenced Content](Binary-nonxmlbody-example-with-referenced-content.md) | nonXMLBody Example with Referenced Content |
| [Number of Pressure Ulcers Observation Example](Binary-number-of-pressure-ulcers-observation-example.md) | Number of Pressure Ulcers Observation example |
| [Nutrition Assessment Example](Binary-nutrition-assessment-example.md) | Nutrition Assessment example |
| [Nutrition Recommendation Example](Binary-nutrition-recommendation-example.md) | Nutrition Recommendation example |
| [Nutrition Section Example](Binary-nutrition-section-example.md) | Nutrition Section example |
| [Nutritional Status Observation Example](Binary-nutritional-status-observation-example.md) | Nutritional Status Observation example |
| [Objective Section Example](Binary-objective-section-example.md) | Objective Section example |
| [Operative Note Complete Header Example](Binary-operative-note-header-example.md) | Demonstrates most of the Operative Note header requirements. Body sections are empty with nullFlavors. |
| [Operative Note performer Example](Binary-operative-note-performer-example.md) | Operative Note performer example |
| [Operative Note serviceEvent Example](Binary-operative-note-serviceevent-example.md) | Operative Note serviceEvent example |
| [Operative Note Fluids Section Example](Binary-operative-note-fluids-section-example.md) | Operative Note Fluids Section example |
| [Operative Note Surgical Procedure Section Example](Binary-operative-note-surgical-procedure-section-example.md) | Operative Note Surgical Procedure Section example |
| [Outcome Observation Example](Binary-outcome-observation-example.md) | Outcome Observation example |
| [Past Medical History Example](Binary-past-medical-history-example.md) | Past Medical History example |
| [Patient Generated Document authenticator](Binary-patient-generated-document-authenticator-example.md) | Patient Generated Document authenticator example |
| [Patient Generated Document author device Example](Binary-patient-generated-document-author-device-example.md) | Patient Generated Document author device example |
| [Patient Generated Document author](Binary-patient-generated-document-author-example.md) | Patient Generated Document author example |
| [Patient Generated Document custodian Example](Binary-patient-generated-document-custodian-example.md) | PPatient Generated Document custodian example |
| [Patient Generated Document dataEnterer](Binary-patient-generated-document-dataenterer-example.md) | Patient Generated Document dataEnterer example |
| [Patient Generated Document informant Example informant](Binary-patient-generated-document-informant-example-informant.md) | Patient Generated Document informant Example informant |
| [Patient Generated Document informant RelEnt Example](Binary-patient-generated-document-informant-relent-example.md) | Patient Generated Document informant RelEnt example |
| [Patient Generated Document informationRecipient Example](Binary-patient-generated-document-informationrecipient.md) | Patient Generated Document informationRecipient example |
| [Patient Generated Document inFulfillmentOf Example](Binary-patient-generated-document-infulfillmentof-example.md) | Patient Generated Document inFulfillmentOf example |
| [Patient Generated Document legalAuthenticator Example](Binary-patient-generated-document-legalauthenticator-example.md) | PPatient Generated Document legalAuthenticator example |
| [Patient Generated Document participant Example](Binary-patient-generated-document-participant-example.md) | Patient Generated Document participant example |
| [Patient Generated Document recordTarget](Binary-patient-generated-document-recordtarget-example.md) | Patient Generated Document recordTarget example |
| [Referral Act Example](Binary-referral-act-example.md) | Referral Act example |
| [Payers Section Example](Binary-payers-section-example.md) | Payers Section example |
| [Physical Exam Section Example](Binary-physical-exam-section-example.md) | Physical Exam Section example |
| [Plan of Treatment Section Example](Binary-plan-of-treatment-section-example.md) | Plan of Treatment Section example |
| [Planned Coverage Example](Binary-planned-coverage-example.md) | Planned Coverage example |
| [Planned Encounter Example](Binary-planned-encounter-example.md) | Planned Encounter example |
| [Planned Immunization Activity Example](Binary-planned-immunization-activity.md) | Planned Immunization Activity example |
| [Planned Intervention Activity Example](Binary-planned-intervention-act-example.md) | Planned Intervention Activity example |
| [Planned Medication Activity Example](Binary-planned-medication-activity-example.md) | Planned Medication Activity example |
| [Planned Procedure Section Example](Binary-planned-procedure-section-example.md) | Planned Procedure Section example |
| [Planned Procedure Example](Binary-planned-procedure-example.md) | Planned Procedure example |
| [Planned Supply Example](Binary-planned-supply-example.md) | Planned Supply example |
| [Policy Activity Example](Binary-policy-activity-example.md) | Policy Activity example |
| [Postoperative Diagnosis Section Example](Binary-postoperative-diagnosis-section-example.md) | Postoperative Diagnosis Section example |
| [Postprocedure Diagnosis Example](Binary-postprocedure-diagnosis-example.md) | Postprocedure Diagnosis example |
| [Postprocedure Diagnosis Section Example](Binary-postprocedure-diagnosis-section-example.md) | Postprocedure Diagnosis Section example |
| [Precondition for Substance Administration Example](Binary-precondition-for-substance-administration-example.md) | Precondition for Substance Administration example |
| [Pregnancy Intention in Next Year Example](Binary-pregnancy-intention-in-next-year-example.md) | Pregnancy Intention in Next Year example |
| [Pregnancy Status Observation Example](Binary-pregnancy-status-observation-example.md) | Pregnancy Status Observation example |
| [Preoperative Diagnosis Section Example](Binary-preoperative-diagnosis-section-example.md) | Preoperative Diagnosis Section example |
| [Preoperative Diagnosis Example](Binary-preoperative-diagnosis-example.md) | Preoperative Diagnosis example |
| [Priority Preference Example](Binary-priority-preference-example.md) | Priority Preference example |
| [Problem Concern Act Example](Binary-problem-concern-act-example.md) | Problem Concern Act example |
| [Problem Observation Example](Binary-problem-observation-example.md) | Problem Observation example |
| [Problem Observation with Post-Coordinated SNOMED Example](Binary-problem-observation-postcoordsnomed-example.md) | Problem Observation with Post-Coordinated SNOMED example |
| [Problem Section Example](Binary-problem-section-example.md) | Problem Section example |
| [Procedure Note Complete Header Example](Binary-procedure-note-header-example.md) | Demonstrates most of the Procedure Note header requirements. Body sections are empty with nullFlavors. |
| [Procedure Note performer Example](Binary-procedure-note-performer-example.md) | Procedure Note performer example |
| [Procedure Note serviceEvent Example](Binary-procedure-note-serviceevent-example.md) | Procedure Note serviceEvent example |
| [Procedure Activity Procedure Example](Binary-procedure-activity-procedure-example.md) | Procedure Activity Procedure example |
| [Procedure Description Section Example](Binary-procedure-description-section-example.md) | Procedure Description Section example |
| [Procedure Disposition Section Example](Binary-procedure-disposition-section-example.md) | Procedure Disposition Section example |
| [Procedure Estimated Blood Loss Section Example](Binary-procedure-estimated-blood-loss-section-example.md) | Procedure Estimated Blood Loss Section example |
| [Procedure Findings Section Example](Binary-procedure-findings-section-example.md) | Procedure Findings Section dexample |
| [Procedure Implants Section Example](Binary-procedure-implants-section-example.md) | Procedure Implants Section example |
| [Procedure Indications Section Example](Binary-procedure-indications-section-example.md) | Procedure Indications Section example |
| [Procedure Specimens Taken Section Example](Binary-procedure-specimens-taken-section-example.md) | Procedure Specimens Taken Section example |
| [Procedures Section Example](Binary-procedures-section-example.md) | Procedures Section example |
| [Product Instance Example](Binary-product-instance-example.md) | Product Instance example |
| [Prognosis Coded Example](Binary-prognosis-coded-example.md) | Prognosis Coded example |
| [Prognosis Free Text Example](Binary-prognosis-free-text-example.md) | Prognosis Free Text example |
| [Progress Note Complete Header Example](Binary-progress-note-header-example.md) | Demonstrates most of the Progress Note header requirements. Body sections are empty with nullFlavors. |
| [Progress Note encompassingEncounter Example](Binary-progress-note-encompassingencounter-example.md) | Progress Note encompassingEncounter example |
| [Progress Note serviceEvent Example](Binary-progress-note-serviceevent-example.md) | Progress Note serviceEvent example |
| [Progress Toward Goal Observation Example](Binary-progress-toward-goal-observation-example.md) | Progress Toward Goal Observation example |
| [Provenance - Assembler Participation Example](Binary-provenance-assembler-participation-example.md) | Provenance - Assembler Participation example |
| [Provenance - Author Participation Example](Binary-provenance-author-participation-example.md) | Provenance - Author Participation example |
| [Reaction Observation Example](Binary-reaction-observation-example.md) | Reaction Observation example |
| [Reason Example](Binary-reason-example.md) | Reason example |
| [Reason For Referral](Binary-reason-for-referral-section-example.md) | Reason For Referral example |
| [Reason for Visit Section Example](Binary-reason-for-visit-section-example.md) | Reason for Visit Section example |
| [Referral Note Complete Header Example](Binary-referral-note-header-example.md) | Demonstrates most of the Referral Note header requirements. Body sections are empty with nullFlavors. |
| [Referral Note Callback Contact Example](Binary-referral-note-callback-contact-example.md) | Referral Note Callback Contact example |
| [Referral Note Caregiver](Binary-referral-note-caregiver-example.md) | Referral Note Caregiver example |
| [Referral Note informationRecipient Example](Binary-referral-note-informationrecipient-example.md) | Referral Note informationRecipient example |
| [Related Person Relationship and Name Participant Example](Binary-related-person-relationship-and-name-example.md) | Related Person Relationship and Name Participant example |
| [Result Observation Example](Binary-result-observation-example.md) | Result Observation example |
| [Result Organizer Example](Binary-result-organizer-example.md) | Result Organizer example |
| [Results Section Example](Binary-results-section-example.md) | Results Section example |
| [Review Of Systems Section Example](Binary-review-of-systems-section-example.md) | Review of Systems Section example |
| [Risk Concern Act Example](Binary-risk-concern-act-example.md) | Risk Concern Act example |
| [Self-Care Activities ADL and IADL Example](Binary-self-care-activities-adl-and-iadl-example.md) | Self-Care Activities (ADL and IADL) example |
| [Sensory Status Example](Binary-sensory-and-speech-status-example.md) | Sensory Status example |
| [Serial Number Observation Example](Binary-serial-number-observation-example.md) | Serial Number Observation example |
| [Service Delivery Location Example](Binary-service-delivery-location-example.md) | Service Delivery Location example |
| [Severity Observation Example](Binary-severity-observation-example.md) | Severity Observation example |
| [Sex Observation Example](Binary-sex-observation-example.md) | Sex Observation example |
| [Sex Observation Null Flavor Example](Binary-sex-observation-nullflavor-example.md) | Sexu Observation example with nullflavor code |
| [Sexual Orientation Observation Example](Binary-sexual-orientation-observation-example.md) | Sexual Orientation Observation example |
| [Sexual Orientation Observation Null Flavor Example](Binary-sexual-orientation-observation-nullflavor-example.md) | Sexual Orientation Observation example with nullflavor code |
| [Smoking Status Coded Example](Binary-smoking-status-coded-example.md) | Smoking Status Coded example |
| [Smoking Status Quantity Example](Binary-smoking-status-quantity-example.md) | Smoking Status Quantity example |
| [Smoking Status Meaningful Use Example](Binary-smoking-status-meaningful-use-example.md) | Smoking Status - Meaningful Use example |
| [Specimen Collection Procedure Example](Binary-specimen-collection-procedure-example.md) | Specimen Collection Procedure example |
| [Specimen Condition Observation Example](Binary-specimen-condition-observation-example.md) | Specimen Condition Observation example |
| [Social History Section Example](Binary-social-history-section-example.md) | Social History Section example |
| [Subjective Section Example](Binary-subjective-section-example.md) | Subjective Section example |
| [Substance Administered Act Example](Binary-substance-administered-act-example.md) | Substance Administered Act example |
| [Surgical Drains Section Example](Binary-surgical-drains-section-example.md) | Surgical Drains Section example |
| [Tobacco Use Example](Binary-tobacco-use-example.md) | Tobacco Use example |
| [Transfer Summary Complete Header Example](Binary-transfer-summary-header-example.md) | Demonstrates most of the Transfer Summary header requirements. Body sections are empty with nullFlavors. |
| [Transfer Summary Callback Contact Example](Binary-transfer-summary-callback-contact-example.md) | Transfer Summary Callback Contact example |
| [Transfer Summary participant (Support) Example](Binary-transfer-summary-participant-support-example.md) | Transfer Summary participant (Support) example |
| [Tribal Affiliation Observation Example](Binary-tribal-affiliation-example.md) | Tribal Affiliation Observation example |
| [UDI Organizer Example](Binary-udi-organizer-example.md) | UDI Organizer example |
| [US Realm Address Example](Binary-us-realm-address-example.md) | US Realm Address example |
| [US Realm Date and Time Example](Binary-us-realm-date-and-time-example.md) | US Realm Date and Time example |
| [US Realm Date and Time Interval Example](Binary-us-realm-date-and-time-ivl-example.md) | US Realm Date and Time Interval example |
| [US Realm Header Race Translation Example](Binary-us-realm-header-race-translation-example.md) | Demonstrates the use of translation elements to associated detailed race codes with race categories |
| [US Realm Header Example](Binary-us-realm-header-example.md) | US Realm Header example |
| [US Realm Person Name Example](Binary-us-realm-person-name-example.md) | US Realm Person Name example |
| [Vital Sign Observation Example](Binary-vital-sign-observation-example.md) | Vital Sign Observation example |
| [Average Blood Pressure Organizer Example](Binary-average-bp-example.md) | Example of average blood pressure |
| [Vital Signs Organizer Example](Binary-vital-signs-organizer-example.md) | Vital Signs Organizer example |
| [Vital Signs Section Example](Binary-vital-signs-section-example.md) | Vital Signs Section example - including Average Blood Pressure |
| [Wound Characteristic Example](Binary-wound-characteristic-example.md) | Wound Characteristic example |
| [Wound Measurement Observation Example](Binary-wound-measurement-observation-example.md) | Wound Measurement Observation example |

